package jp.co.sra.jun.goodies.calendar;

import java.util.Calendar;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.jun.system.support.JunSystem;
import jp.co.sra.jun.system.support.JunTestExamples;

/**
 * JunCalendarDateIntervalDialogTestExamples class
 * 
 *  @author    Nobuto Matsubara
 *  @created   2003/10/06 (by Nobuto Matsubara)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun472 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunCalendarDateIntervalDialogTestExamples.java,v 8.10 2008/02/20 06:31:12 nisinaka Exp $
 */
public class JunCalendarDateIntervalDialogTestExamples extends JunTestExamples {
	/**
	 * Example1: Call Request().
	 *
	 * @return boolean
	 */
	public static boolean Example1() {
		JunCalendarDateModel[] dates = JunCalendarDateIntervalDialog.Request();
		if (dates != null) {
			System.out.println(dates[0] + ", " + dates[1]);
		}
		return true;
	}

	/**
	 * Example2: Call Request().
	 *
	 * @return boolean
	 */
	public static boolean Example2() {
		JunCalendarDateModel[] answer = JunCalendarDateIntervalDialog.Request_(JunSystem.$String("Select period."));
		if (answer != null) {
			System.out.println(answer[0] + ", " + answer[1]);
		}
		return true;
	}

	/**
	 * Example3: Call Request().
	 *
	 * @return boolean
	 */
	public static boolean Example3() {
		Calendar[] dates = new Calendar[2];
		dates[0] = Calendar.getInstance();
		dates[1] = Calendar.getInstance();
		dates[1].add(Calendar.DATE, 14);
		JunCalendarDateModel[] answer = JunCalendarDateIntervalDialog.Request_initialDates_(JunSystem.$String("Select period."), dates);
		if (answer != null) {
			System.out.println(answer[0] + ", " + answer[1]);
		}
		return true;
	}

	/**
	 * Example4: Call Request().
	 *
	 * @return boolean
	 */
	public static boolean Example4() {
		Calendar[] dates = new Calendar[2];
		dates[0] = Calendar.getInstance();
		dates[1] = Calendar.getInstance();
		dates[1].add(Calendar.DATE, 14);
		StBlockClosure acceptBlock = new StBlockClosure() {
			public Object value_(Object aModel) {
				JunCalendarDateIntervalModel dateIntervalModel = (JunCalendarDateIntervalModel) aModel;
				System.out.println(JunSystem.$String("Accept button was pressed."));
				System.out.println("	" + dateIntervalModel.dates()[0] + ", " + dateIntervalModel.dates()[1]);
				return (Object) Boolean.TRUE;
			}
		};
		StBlockClosure cancelBlock = new StBlockClosure() {
			public Object value_(Object aModel) {
				JunCalendarDateIntervalModel dateIntervalModel = (JunCalendarDateIntervalModel) aModel;
				System.out.println(JunSystem.$String("Cancel button was pressed."));
				System.out.println("	" + dateIntervalModel.dates()[0] + ", " + dateIntervalModel.dates()[1]);
				return (Object) Boolean.TRUE;
			}
		};
		JunCalendarDateModel[] answer = JunCalendarDateIntervalDialog.Request_initialDates_onAccept_onCancel_(JunSystem.$String("Select period."), dates, acceptBlock, cancelBlock);
		if (answer != null) {
			System.out.println(answer[0] + ", " + answer[1]);
		}
		return true;
	}

	/**
	 * Execute all examples.
	 *
	 * @param args an array of command-line argumetns
	 */
	public static void main(java.lang.String[] args) {
		new JunCalendarDateIntervalDialogTestExamples();
	}
}
