package jp.co.sra.jun.goodies.calendar;

import java.awt.Dialog;
import java.util.Calendar;

import jp.co.sra.jun.system.support.JunSystem;
import jp.co.sra.smalltalk.*;

/**
 * JunCalendarDateIntervalDialog class
 * 
 *  @author    Nobuto Matsubara
 *  @created   2003/10/06 (by Nobuto Matsubara)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun472 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunCalendarDateIntervalDialog.java,v 8.12 2008/02/20 06:31:12 nisinaka Exp $
 */
public class JunCalendarDateIntervalDialog extends StSimpleDialog {
	protected JunCalendarDateIntervalModel calendarDateIntervalModel;
	protected StBlockClosure acceptBlock;
	protected StBlockClosure cancelBlock;

	/**
	 * Create a new instance of <code>JunCalendarDateIntervalDialog</code> and initialize it.
	 * 
	 * @category Instance creation
	 */
	public JunCalendarDateIntervalDialog() {
		super();
	}

	/**
	 * JunCalendarDateIntervalDialog.Request()
	 * 
	 * @return JunCalendarDateModel[]
	 * @category Utilities
	 */
	public static JunCalendarDateModel[] Request() {
		return JunCalendarDateIntervalDialog.Request_(null);
	}

	/**
	 * JunCalendarDateIntervalDialog.Request_("Select date.")
	 * 
	 * @param messageString java.lang.String
	 * @return JunCalendarDateModel[]
	 * @category Utilities
	 */
	public static JunCalendarDateModel[] Request_(String messageString) {
		Calendar[] dateArray = { Calendar.getInstance(), Calendar.getInstance() };
		return JunCalendarDateIntervalDialog.Request_initialDates_(messageString, dateArray);
	}

	/**
	 * JunCalendarDateIntervalDialog.Request_initialDate_("Select date.", Calendar.getInstance());
	 * 
	 * @param messageString java.lang.String
	 * @param dateArray java.util.Calendar[]
	 * @return JunCalendarDateModel[]
	 * @category Utilities
	 */
	public static JunCalendarDateModel[] Request_initialDates_(String messageString, Calendar[] dateArray) {
		return JunCalendarDateIntervalDialog.Request_initialDates_onAccept_onCancel_(messageString, dateArray, null, null);
	}

	/**
	 * JunCalendarDateIntervalDialog.Request_initialDate_onAccept_onCancel_(
	 * 	"Select date.",
	 *	Calendar.getInstance(),
	 *	null,
	 *	null)
	 *
	 * @param messageString java.lang.String
	 * @param dateArray java.util.Calendar[]
	 * @param anAcceptBlock StBlockClosure
	 * @param aCancelBlock StBlockClosure
	 * @return JunCalendarDateModel[]
	 * @category Utilities
	 */
	public static JunCalendarDateModel[] Request_initialDates_onAccept_onCancel_(String messageString, Calendar[] dateArray, StBlockClosure anAcceptBlock, StBlockClosure aCancelBlock) {
		JunCalendarDateIntervalDialog calendarDateIntervalDialog = new JunCalendarDateIntervalDialog();
		if (!(dateArray == null)) {
			if (dateArray.length > 1) {
				calendarDateIntervalDialog.calendarDateIntervalModel_(JunCalendarDateIntervalModel.From_to_(dateArray[0], dateArray[dateArray.length - 1]));
			}
		}
		Dialog dialog = calendarDateIntervalDialog.allButOpenDialog();
		if (!(messageString == null)) {
			dialog.setTitle(messageString);
		}
		if (!(anAcceptBlock == null)) {
			calendarDateIntervalDialog.acceptBlock_(anAcceptBlock);
		}
		if (!(aCancelBlock == null)) {
			calendarDateIntervalDialog.cancelBlock_(aCancelBlock);
		}
		_ShowAtMousePoint(dialog);
		if (calendarDateIntervalDialog.accept()._booleanValue()) {
			return calendarDateIntervalDialog.calendarDateIntervalModel().dates();
		} else {
			return null;
		}
	}

	/**
	 * Set an action accept to a block..
	 * @param aBlock StBlockClosure
	 * @category accessing
	 */
	public void acceptBlock_(StBlockClosure aBlock) {
		acceptBlock = aBlock;
	}

	/**
	 * Return a JunCalendarDateIntervalModel instance.
	 * @return JunCalendarDateIntervalModel
	 * @category accessing
	 */
	public JunCalendarDateIntervalModel calendarDateIntervalModel() {
		if (calendarDateIntervalModel == null) {
			calendarDateIntervalModel = new JunCalendarDateIntervalModel();
		}
		return calendarDateIntervalModel;
	}

	/**
	 * Set new insntace of JunCalendarDateIntervalModel.
	 * @param aCalendarDateIntervalModel JunCalendarDateIntervalModel
	 * @category accessing
	 */
	public void calendarDateIntervalModel_(JunCalendarDateIntervalModel aCalendarDateIntervalModel) {
		calendarDateIntervalModel = aCalendarDateIntervalModel;
	}

	/**
	 * Set a calcel action to a block.
	 * @param aBlock StBlockClosure
	 * @category accessing
	 */
	public void cancelBlock_(StBlockClosure aBlock) {
		cancelBlock = aBlock;
	}

	/**
	 * Return result of accept button pressed.
	 * @return boolean
	 * @category actions
	 */
	public Object acceptButtonPressed() {
		if (!(acceptBlock == null)) {
			return acceptBlock.value_(this.calendarDateIntervalModel());
		}
		return new Boolean(true);
	}

	/**
	 * Return result of cancel button pressed.
	 * @return boolean
	 * @category actions
	 */
	public Object cancelButtonPressed() {
		if (!(cancelBlock == null)) {
			return cancelBlock.value_(this.calendarDateIntervalModel());
		}
		return new Boolean(true);
	}

	/**
	 * Answer a default view.
	 *
	 * @return jp.co.sra.smalltalk.StView
	 * @category defaults
	 */
	public StView defaultView() {
		if (GetDefaultViewMode() == VIEW_AWT) {
			return new JunCalendarDateIntervalDialogViewAwt(this);
		} else {
			return new JunCalendarDateIntervalDialogViewSwing(this);
		}
	}

	/**
	 * Initialize the ApplicationModel when created.
	 *
	 * @category initialize-release
	 */
	protected void initialize() {
		super.initialize();

		acceptBlock = null;
		cancelBlock = null;
	}

	/**
	 * Answer a window title.
	 *
	 * @return java.lang.String
	 * @category interface opening
	 */
	protected String windowTitle() {
		return JunSystem.$String("Period (Date) Dialog");
	}
}
