package jp.co.sra.jun.goodies.calendar;

import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;

import jp.co.sra.jun.system.support.JunSystem;
import jp.co.sra.smalltalk.StSimpleDialogViewSwing;
import jp.co.sra.smalltalk.WindowSpecLayout;

/**
 * JunCalendarDateDialogViewSwing class
 * 
 *  @author    Nobuto Matsubara
 *  @created   2003/10/06 (by Nobuto Matsubara)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun472 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunCalendarDateDialogViewSwing.java,v 8.12 2008/02/20 06:31:12 nisinaka Exp $
 */
public class JunCalendarDateDialogViewSwing extends StSimpleDialogViewSwing implements JunCalendarDateDialogView {
	protected JunCalendarDateViewSwing calendarDateView;
	protected JButton acceptButton;
	protected JButton cancelButton;

	/**
	 * Create a new instance of <code>JunCalendarDateDialogViewSwing</code> and initialize it.
	 * 
	 * @param newCalendarDateDialog JunCalendarDateDialog
	 * @category Instance creation
	 */
	public JunCalendarDateDialogViewSwing(JunCalendarDateDialog newCalendarDateDialog) {
		super(newCalendarDateDialog);
	}

	/**
	 * Answer the default dialog.
	 *
	 * @return java.awt.Dialog
	 * @category defaults
	 */
	public Dialog defaultDialog() {
		Dialog aDialog = new Dialog(new Frame(), this.getCalendarDateDialog().windowTitle(), true);
		aDialog.add(this);
		aDialog.pack();
		return aDialog;
	}

	/**
	 * Answer my model as a JunCalendarDateDialog.
	 * @return JunCalendarDateDialog
	 * @category accessing
	 */
	public JunCalendarDateDialog getCalendarDateDialog() {
		return (JunCalendarDateDialog) this.model();
	}

	/**
	 * Answer my accept button.
	 * @return javax.swing.jButton
	 * @category accessing
	 */
	protected JButton acceptButton() {
		if (acceptButton == null) {
			acceptButton = new JButton(JunSystem.$String("Accept"));
			acceptButton.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					if (((Boolean) getCalendarDateDialog().acceptButtonPressed()).booleanValue()) {
						getCalendarDateDialog().accept().value_(true);
					}
				}
			});
		}
		return acceptButton;
	}

	/**
	 * Build this component.
	 * @category interface opening
	 */
	protected void buildComponent() {
		this.setLayout(new WindowSpecLayout());
		this.add(this.calendarDateView(), WindowSpecLayout.Position(0f, 1, 0f, 1, 1f, -102, 1f, -1));
		this.add(this.cancelButton(), WindowSpecLayout.Position(1f, -96, 0f, 56, 1f, -8, 0f, 88));
		this.add(this.acceptButton(), WindowSpecLayout.Position(1f, -96, 0f, 16, 1f, -8, 0f, 48));
		defaultButton = this.acceptButton();
		this.setPreferredSize(new Dimension(400, 200));
	}

	/**
	 * Answer my cancel button.
	 *
	 * @return javax.swing.jButton
	 * @category accessing
	 */
	protected JButton cancelButton() {
		if (cancelButton == null) {
			cancelButton = new JButton(JunSystem.$String("Cancel"));
			cancelButton.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					if (((Boolean) getCalendarDateDialog().cancelButtonPressed()).booleanValue()) {
						getCalendarDateDialog().cancel().value_(true);
					}
				}
			});
		}
		return cancelButton;
	}

	/**
	 * Answer my calendar date view.
	 *
	 * @return JunCalendarDateViewSwing
	 * @category accessing
	 */
	protected JunCalendarDateViewSwing calendarDateView() {
		if (calendarDateView == null) {
			calendarDateView = new JunCalendarDateViewSwing(this.getCalendarDateDialog().calendarDateModel());
		}
		return calendarDateView;
	}
}
