package jp.co.sra.jun.goodies.calendar;

import java.awt.Dialog;
import java.util.Calendar;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StSimpleDialog;
import jp.co.sra.smalltalk.StView;
import jp.co.sra.jun.system.support.JunSystem;

/**
 * JunCalendarDateDialog class
 * 
 *  @author    Nobuto Matsubara
 *  @created   2003/10/06 (by Nobuto Matsubara)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun472 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunCalendarDateDialog.java,v 8.12 2008/02/20 06:31:12 nisinaka Exp $
 */
public class JunCalendarDateDialog extends StSimpleDialog {
	protected JunCalendarDateModel calendarDateModel;
	protected StBlockClosure acceptBlock;
	protected StBlockClosure cancelBlock;

	/**
	 * Create a new instance of <code>JunCalendarDateDialog</code> and initialize it.
	 * 
	 * @category Instance creation
	 */
	public JunCalendarDateDialog() {
		super();
	}

	/**
	 * JunCalendarDateDialog.Request()
	 * @return Calendar
	 * @category Utilities
	 */
	public static Calendar Request() {
		return JunCalendarDateDialog.Request_(null);
	}

	/**
	 * JunCalendarDateDialog.Request_("Select date.")
	 * @param messageString java.lang.String
	 * @return Calendar
	 * @category Utilities
	 */
	public static Calendar Request_(String messageString) {
		return JunCalendarDateDialog.Request_initialDate_(messageString, Calendar.getInstance());
	}

	/**
	 * JunCalendarDateDialog.Request_initialDate_("Select date.", Calendar.getInstance());
	 * @param messageString java.lang.String
	 * @param aDate java.util.Calendar
	 * @return Calendar
	 * @category Utilities
	 */
	public static Calendar Request_initialDate_(String messageString, Calendar aDate) {
		return JunCalendarDateDialog.Request_initialDate_onAccept_onCancel_(messageString, aDate, null, null);
	}

	/**
	 * JunCalendarDateDialog.Request_initialDate_onAccept_onCancel_(
	 * 	"Select date.",
	 *	Calendar.getInstance(),
	 *	null,
	 *	null)
	 * @param messageString java.lang.String
	 * @param aDate java.util.Calendar
	 * @param acceptBlock StBlockClosure
	 * @param cancelBlock StBlockClosure
	 * @return java.util.Calendar
	 * @category Utilities
	 */
	public static Calendar Request_initialDate_onAccept_onCancel_(String messageString, Calendar aDate, StBlockClosure acceptBlock, StBlockClosure cancelBlock) {
		JunCalendarDateDialog calendarDateDialog = new JunCalendarDateDialog();
		if (!(aDate == null)) {
			calendarDateDialog.calendarDateModel_(JunCalendarDateModel.Date_(aDate));
		}
		Dialog dialog = calendarDateDialog.allButOpenDialog();
		if (!(messageString == null)) {
			dialog.setTitle(messageString);
		}
		if (!(acceptBlock == null)) {
			calendarDateDialog.acceptBlock_(acceptBlock);
		}
		if (!(cancelBlock == null)) {
			calendarDateDialog.cancelBlock_(cancelBlock);
		}
		_ShowAtMousePoint(dialog);
		if (calendarDateDialog.accept()._booleanValue()) {
			return calendarDateDialog.calendarDateModel().date();
		} else {
			return null;
		}
	}

	/**
	 * Set an action accept to a block..
	 * @param aBlock StBlockClosure
	 * @category accessing
	 */
	public void acceptBlock_(StBlockClosure aBlock) {
		acceptBlock = aBlock;
	}

	/**
	 * Return a JunCalendarDateModel instance.
	 * @return JunCalendarDateModel
	 * @category accessing
	 */
	public JunCalendarDateModel calendarDateModel() {
		if (calendarDateModel == null) {
			calendarDateModel = new JunCalendarDateModel();
		}
		return calendarDateModel;
	}

	/**
	 * Set new insntace of JunCalendarDateModel.
	 * @param aCalendarDateModel JunCalendarDateModel
	 * @category accessing
	 */
	public void calendarDateModel_(JunCalendarDateModel aCalendarDateModel) {
		calendarDateModel = aCalendarDateModel;
	}

	/**
	 * Set a calcel action to a block.
	 * @param aBlock StBlockClosure
	 * @category accessing
	 */
	public void cancelBlock_(StBlockClosure aBlock) {
		cancelBlock = aBlock;
	}

	/**
	 * Return result of accept button pressed.
	 * @return boolean
	 * @category actions
	 */
	public Object acceptButtonPressed() {
		if (!(acceptBlock == null)) {
			return acceptBlock.value_(this.calendarDateModel());
		}
		return new Boolean(true);
	}

	/**
	 * Return result of cancel button pressed.
	 * @return boolean
	 * @category actions
	 */
	public Object cancelButtonPressed() {
		if (!(cancelBlock == null)) {
			return acceptBlock.value_(this.calendarDateModel());
		}
		return new Boolean(true);
	}

	/**
	 * Answer a default view.
	 *
	 * @return jp.co.sra.smalltalk.StView
	 * @category defaults
	 */
	public StView defaultView() {
		if (GetDefaultViewMode() == VIEW_AWT) {
			return new JunCalendarDateDialogViewAwt(this);
		} else {
			return new JunCalendarDateDialogViewSwing(this);
		}
	}

	/**
	 * Initialize the ApplicationModel when created.
	 *
	 * @category initialize-release
	 */
	protected void initialize() {
		super.initialize();

		acceptBlock = null;
		cancelBlock = null;
	}

	/**
	 * Answer a window title.
	 *
	 * @return java.lang.String
	 * @see jp.co.sra.smalltalk.StSimpleDialog#windowTitle()
	 * @category interface opening
	 */
	protected String windowTitle() {
		return JunSystem.$String("Date Dialog");
	}
}
