package jp.co.sra.jun.goodies.calendar;

import java.util.Calendar;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.jun.system.support.JunSystem;
import jp.co.sra.jun.system.support.JunTestExamples;

/**
 * JunCalendarDateAndTimeIntervalDialogTestExamples class
 * 
 *  @author    Nobuto Matsubara
 *  @created   2003/10/06 (by Nobuto Matsubara)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun472 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunCalendarDateAndTimeIntervalDialogTestExamples.java,v 8.11 2008/02/20 06:31:12 nisinaka Exp $
 */
public class JunCalendarDateAndTimeIntervalDialogTestExamples extends JunTestExamples {
	/**
	 * Example1: Call Request().
	 *
	 * @return boolean
	 */
	public static boolean Example1() {
		JunCalendarDateAndTimeModel[] answer = JunCalendarDateAndTimeIntervalDialog.Request();
		if (answer != null) {
			System.out.println(answer[0] + ", " + answer[1]);
		}
		return true;
	}

	/**
	 * Example2: Call Request().
	 *
	 * @return boolean
	 */
	public static boolean Example2() {
		JunCalendarDateAndTimeModel[] answer = JunCalendarDateAndTimeIntervalDialog.Request_(JunSystem.$String("Select period."));
		if (answer != null) {
			System.out.println(answer[0] + ", " + answer[1]);
		}
		return true;
	}

	/**
	 * Example3: Call Request().
	 *
	 * @return boolean
	 */
	public static boolean Example3() {
		Calendar[] fromDateAndTime = { Calendar.getInstance(), Calendar.getInstance() };
		Calendar[] toDateAndTime = { Calendar.getInstance(), Calendar.getInstance() };
		toDateAndTime[0].add(Calendar.DATE, 7);
		toDateAndTime[1].add(Calendar.SECOND, 60 * 60);
		Calendar[][] dateAndTimes = { fromDateAndTime, toDateAndTime };
		JunCalendarDateAndTimeModel[] answer = JunCalendarDateAndTimeIntervalDialog.Request_initialDatesAndTimes_(JunSystem.$String("Select period."), dateAndTimes);
		if (answer != null) {
			System.out.println(answer[0] + ", " + answer[1]);
		}
		return true;
	}

	/**
	 * Example4: Call Request().
	 *
	 * @return boolean
	 */
	public static boolean Example4() {
		Calendar[] fromDateAndTime = { Calendar.getInstance(), Calendar.getInstance() };
		Calendar[] toDateAndTime = { Calendar.getInstance(), Calendar.getInstance() };
		toDateAndTime[0].add(Calendar.DATE, 7);
		toDateAndTime[1].add(Calendar.SECOND, 60 * 60);
		Calendar[][] dateAndTimes = { fromDateAndTime, toDateAndTime };
		StBlockClosure acceptBlock = new StBlockClosure() {
			public Object value_(Object aModel) {
				JunCalendarDateAndTimeIntervalModel dateAndTimeIntervalModel = (JunCalendarDateAndTimeIntervalModel) aModel;
				System.out.println(JunSystem.$String("Accept button was pressed."));
				System.out.println("	" + dateAndTimeIntervalModel);
				return (Object) Boolean.TRUE;
			}
		};
		StBlockClosure cancelBlock = new StBlockClosure() {
			public Object value_(Object aModel) {
				JunCalendarDateAndTimeIntervalModel dateAndTimeIntervalModel = (JunCalendarDateAndTimeIntervalModel) aModel;
				System.out.println(JunSystem.$String("Cancel button was pressed."));
				System.out.println("	" + dateAndTimeIntervalModel);
				return (Object) Boolean.TRUE;
			}
		};
		JunCalendarDateAndTimeModel[] answer = JunCalendarDateAndTimeIntervalDialog.Request_initialDatesAndTimes_onAccept_onCancel_(JunSystem.$String("Select period."), dateAndTimes, acceptBlock, cancelBlock);
		if (answer != null) {
			System.out.println(answer[0] + ", " + answer[1]);
		}
		return true;
	}

	/**
	 * Execute all examples.
	 *
	 * @param args an array of command-line argumetns
	 */
	public static void main(java.lang.String[] args) {
		new JunCalendarDateAndTimeIntervalDialogTestExamples();
	}
}
