package jp.co.sra.jun.goodies.calendar;

import jp.co.sra.jun.system.support.JunSystem;
import jp.co.sra.smalltalk.StView;

/**
 * JunCalendarClockTime class
 * 
 *  @author    Nobuto Matsubara
 *  @created   2003/10/06 (by Nobuto Matsubara)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun472 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunCalendarClockTime.java,v 8.10 2008/02/20 06:31:12 nisinaka Exp $
 */
public class JunCalendarClockTime extends JunCalendarClockDateAndTime {
	/**
	 * Default view.
	 *
	 * @return jp.co.sra.smalltalk.StView
	 * @category defaults
	 */
	public StView defaultView() {
		JunCalendarClockTimeView aView;
		if (GetDefaultViewMode() == VIEW_AWT) {
			aView = new JunCalendarClockTimeViewAwt(this);
		} else {
			aView = new JunCalendarClockTimeViewSwing(this);
		}
		return aView;
	}

	/**
	 * Return window title.
	 *
	 * @return java.lang.String
	 * @category interface opening
	 */
	protected String windowTitle() {
		return JunSystem.$String("HHMMSS", "Time");
	}
}
