package jp.co.sra.jun.goodies.calendar;

import jp.co.sra.smalltalk.WindowSpecLayout;
import jp.co.sra.jun.system.framework.JunAbstractViewPanel;

/**
 * JunCalendarClockDateViewAwt class
 * 
 *  @author    Nobuto Matsubara
 *  @created   2003/10/06 (by Nobuto Matsubara)
 *  @updated   2004/09/21 (by nisinaka)
 *  @version   699 (with StPL8.9) based on Jun473 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunCalendarClockDateViewAwt.java,v 8.12 2008/02/20 06:31:12 nisinaka Exp $
 */
public class JunCalendarClockDateViewAwt extends JunAbstractViewPanel implements JunCalendarClockDateView {

	protected JunCalendarDateViewAwt dateView;

	/**
	 * Create a new instance of <code>JunCalendarClockDateViewAwt</code> and initialize it.
	 * 
	 * @param aCalendarClockDate JunCalendarClockDate
	 * @category Instance creation
	 */
	public JunCalendarClockDateViewAwt(JunCalendarClockDate aCalendarClockDate) {
		super(aCalendarClockDate);
	}

	/**
	 * Answer my date view.
	 *
	 * @return JunCalendarDateViewAwt
	 * @category defaults
	 */
	public JunCalendarDateViewAwt dateView() {
		if (dateView == null) {
			dateView = new JunCalendarDateViewAwt(this.getModel().calendarDateModel());
		}
		return dateView;
	}

	/**
	 * Get model.
	 *
	 * @return JunCalendarTimeModel
	 * @category accessing
	 */
	public JunCalendarClockDate getModel() {
		return (JunCalendarClockDate) this.model();
	}

	/**
	 * Build this component.
	 * @category interface opening
	 */
	protected void buildComponent() {
		this.setLayout(new WindowSpecLayout());
		this.add(this.dateView(), WindowSpecLayout.Position(0f, 1, 0f, 1, 1f, -1, 1f, -1));
		this.setSize(300, 200);
	}

}
