package jp.co.sra.jun.goodies.calendar;

import java.awt.Dimension;
import jp.co.sra.smalltalk.WindowSpecLayout;
import jp.co.sra.jun.system.framework.JunAbstractViewJPanel;

/**
 * JunCalendarClockDateAndTimeViewSwing class
 * 
 *  @author    Nobuto Matsubara
 *  @created   2003/10/06 (by Nobuto Matsubara)
 *  @updated   2004/09/21 (by nisinaka)
 *  @version   699 (with StPL8.9) based on Jun473 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunCalendarClockDateAndTimeViewSwing.java,v 8.13 2008/02/20 06:31:12 nisinaka Exp $
 */
public class JunCalendarClockDateAndTimeViewSwing extends JunAbstractViewJPanel implements JunCalendarClockDateAndTimeView {

	protected JunCalendarDateViewSwing dateView;
	protected JunCalendarTimeViewSwing timeView;

	/**
	 * Create a new instance of <code>JunCalendarClockDateAndTimeViewSwing</code> and initialize it.
	 * 
	 * @param aCalendarClockDateAndTime JunCalendarClockDateAndTime
	 * @category Instance creation
	 */
	public JunCalendarClockDateAndTimeViewSwing(JunCalendarClockDateAndTime aCalendarClockDateAndTime) {
		super(aCalendarClockDateAndTime);
	}

	/**
	 * Answer my date view.
	 *
	 * @return JunCalendarDateViewSwing
	 * @category accessing
	 */
	public JunCalendarDateViewSwing dateView() {
		if (dateView == null) {
			dateView = new JunCalendarDateViewSwing(this.getModel().calendarDateModel());
		}
		return dateView;
	}

	/**
	 * Answer my time view.
	 *
	 * @return JunCalendarTimeViewSwing
	 * @category accessing
	 */
	public JunCalendarTimeViewSwing timeView() {
		if (timeView == null) {
			timeView = new JunCalendarTimeViewSwing(this.getModel().calendarTimeModel());
		}
		return timeView;
	}

	/**
	 * Get model.
	 *
	 * @return JunCalendarTimeModel
	 * @category accessing
	 */
	public JunCalendarClockDateAndTime getModel() {
		return (JunCalendarClockDateAndTime) this.model();
	}

	/**
	 * Build this component.
	 * @category interface opening
	 */
	protected void buildComponent() {
		this.setLayout(new WindowSpecLayout());
		this.add(this.dateView(), WindowSpecLayout.Position(0f, 1, 0f, 1, 0.67f, 0, 1f, -1));
		this.add(this.timeView(), WindowSpecLayout.Position(0.67f, 0, 0f, 1, 1f, -1, 1f, -1));
		this.setPreferredSize(new Dimension(450, 200));
	}

}
