package jp.co.sra.jun.goodies.button;

import java.awt.Image;

import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StComposedText;
import jp.co.sra.smalltalk.StSymbol;
import jp.co.sra.smalltalk.menu.StCheckBoxMenuItem;
import jp.co.sra.smalltalk.menu.StMenu;
import jp.co.sra.smalltalk.menu.StMenuItem;

import jp.co.sra.jun.goodies.cursors.JunCursors;
import jp.co.sra.jun.system.support.JunTestExamples;

/**
 * JunButtonWithMenuModelTestExamples class
 * 
 *  @author    nisinaka
 *  @created   2006/01/27 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun580 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunButtonWithMenuModelTestExamples.java,v 8.10 2008/02/20 06:31:11 nisinaka Exp $
 */
public class JunButtonWithMenuModelTestExamples extends JunTestExamples {

	/**
	 * Example1: 
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example1() {
		StMenu buttonMenu = ExampleMenu();
		JunButtonWithMenuModel buttonModel = new JunButtonWithMenuModel(false, new StBlockClosure() {
			public Object value_(Object anObject) {
				JunButtonWithMenuModel model = (JunButtonWithMenuModel) anObject;
				model.value_(!model.value());
				return null;
			}
		}, buttonMenu, buttonMenu.atNameKey_($("pencil")));

		buttonModel.open();

		return true;
	}

	/**
	 * Example2: 
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example2() {
		String[] labels = new String[] { "normal", "bounds", "pencil" };
		Image[] labelImages = new Image[] { NormalImage(), BoundsImage(), PencilImage() };
		StSymbol[] values = new StSymbol[] { $("normal"), $("bounds"), $("pencil") };

		JunButtonWithMenuModel buttonModel = new JunButtonWithMenuModel(labels, labelImages, values);

		buttonModel.open();

		return true;
	}

	/**
	 * Example3: 
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example3() {
		String[] labels = new String[] { "normal", "bounds", "pencil" };
		Image[] labelImages = new Image[] { null, null, null };
		StSymbol[] values = new StSymbol[] { $("normal"), $("bounds"), $("pencil") };

		JunButtonWithMenuModel buttonModel = new JunButtonWithMenuModel(labels, labelImages, values);

		buttonModel.open();

		return true;
	}

	/**
	 * Example4: 
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example4() {
		String[] labels = new String[] { "", "", "" };
		Image[] labelImages = new Image[] { new StComposedText("normal").toImage(), new StComposedText("bounds").toImage(), new StComposedText("pencil").toImage() };
		StSymbol[] values = new StSymbol[] { $("normal"), $("bounds"), $("pencil") };

		JunButtonWithMenuModel buttonModel = new JunButtonWithMenuModel(labels, labelImages, values);

		buttonModel.open();

		return true;
	}

	/**
	 * Example5: 
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example5() {
		StMenu buttonMenu = new StMenu();
		buttonMenu.add(new StCheckBoxMenuItem("normal", $("normal"), NormalImage()));
		buttonMenu.addSeparator();
		buttonMenu.add(new StCheckBoxMenuItem("bounds", $("bounds"), BoundsImage()));
		buttonMenu.addSeparator();
		buttonMenu.add(new StCheckBoxMenuItem("pencil", $("pencil"), PencilImage()));

		JunButtonWithMenuModel buttonModel = new JunButtonWithMenuModel(false, new StBlockClosure() {
			public Object value_(Object anObject) {
				JunButtonWithMenuModel model = (JunButtonWithMenuModel) anObject;
				model.value_(!model.value());
				return null;
			}
		}, buttonMenu, buttonMenu.atNameKey_($("pencil")));

		buttonModel.open();

		return true;
	}

	/**
	 * Example6: 
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example6() {
		int size = 11;
		String[] labels = new String[size];
		Float[] values = new Float[size];
		for (int i = 0; i < size; i++) {
			float volume = (float) (10 - i) / 10;
			labels[i] = String.valueOf(volume);
			values[i] = new Float(volume);
		}

		JunButtonWithMenuModel buttonModel = new JunButtonWithMenuModel(labels, new Image[11], values);
		buttonModel.visual_(JunCursors.SpeakerCursorImage());
		buttonModel.visualChanging_(false);
		buttonModel.selectedMenuItemHolder().compute_(new StBlockClosure() {
			public Object value_(Object anObject) {
				StMenuItem aMenuItem = (StMenuItem) anObject;
				System.out.println(aMenuItem.value());
				return null;
			}
		});

		buttonModel.open();

		return true;
	}

	/**
	 * Example7: 
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example7() {
		int size = 11;
		String[] labels = new String[size];
		Float[] values = new Float[size];
		for (int i = 0; i < size; i++) {
			int volume = 100 - i * 10;
			labels[i] = String.valueOf(volume);
			values[i] = new Float((float) volume / 100);
		}
		Image[] labelImages = new Image[] {
				JunCursors.Speaker10CursorImage(),
				JunCursors.Speaker09CursorImage(),
				JunCursors.Speaker08CursorImage(),
				JunCursors.Speaker07CursorImage(),
				JunCursors.Speaker06CursorImage(),
				JunCursors.Speaker05CursorImage(),
				JunCursors.Speaker04CursorImage(),
				JunCursors.Speaker03CursorImage(),
				JunCursors.Speaker02CursorImage(),
				JunCursors.Speaker01CursorImage(),
				JunCursors.Speaker00CursorImage() };

		JunButtonWithMenuModel buttonModel = new JunButtonWithMenuModel(labels, labelImages, values);
		buttonModel.markerDisplaying_(false);
		buttonModel.selectedMenuItemHolder().compute_(new StBlockClosure() {
			public Object value_(Object anObject) {
				StMenuItem aMenuItem = (StMenuItem) anObject;
				System.out.println(aMenuItem.value());
				return null;
			}
		});

		buttonModel.open();

		return true;
	}

	/**
	 * Create an example menu.
	 * 
	 * @return jp.co.sra.smalltalk.menu.StMenu
	 * @category Examples
	 */
	protected static StMenu ExampleMenu() {
		StMenu aMenu = new StMenu();
		aMenu.add(new StCheckBoxMenuItem("normal", $("normal"), NormalImage()));
		aMenu.add(new StCheckBoxMenuItem("bounds", $("bounds"), BoundsImage()));
		aMenu.add(new StCheckBoxMenuItem("pencil", $("pencil"), PencilImage()));
		return aMenu;
	}

	/**
	 * Answer the normal image.
	 * 
	 * @return java.awt.Image
	 * @category Examples
	 */
	protected static Image NormalImage() {
		return JunCursors.NormalCursorImage();
	}

	/**
	 * Answer the bounds image.
	 * 
	 * @return java.awt.Image
	 * @category Examples
	 */
	protected static Image BoundsImage() {
		return JunCursors.BoundsCursorImage();
	}

	/**
	 * Answer the pencil image.
	 * 
	 * @return java.awt.Image
	 * @category Examples
	 */
	protected static Image PencilImage() {
		return JunCursors.PencilCursorImage();
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args an array of command-line arguments
	 * @category Main
	 */
	public static void main(java.lang.String[] args) {
		new JunButtonWithMenuModelTestExamples();
	}

}
