package jp.co.sra.jun.goodies.bulletinboard;

import jp.co.sra.smalltalk.StInputState;

import jp.co.sra.jun.system.framework.JunAbstractController;

/**
 * JunBulletinBoardController class
 * 
 *  @author    nisinaka
 *  @created   2002/11/27 (by nisinaka)
 *  @updated   2004/09/21 (by nisinaka)
 *  @updated   2006/10/13 (by m-asada)
 *  @version   699 (with StPL8.9) based on Jun629 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunBulletinBoardController.java,v 8.13 2008/02/20 06:31:11 nisinaka Exp $
 */
public class JunBulletinBoardController extends JunAbstractController {
	protected boolean bulletinState;
	protected Thread bulletinProcess;

	/**
	 * Create a new instance of <code>JunBulletinBoardController</code> and initialize it.
	 * 
	 * @category Instance creation
	 */
	public JunBulletinBoardController() {
		bulletinState = false;
		bulletinProcess = null;
	}

	/**
	 * Make sure to terminate the process when finalizing.
	 * 
	 * @throws java.lang.Throwable
	 * @see java.lang.Object#finalize()
	 * @category initialize-release
	 */
	protected void finalize() throws Throwable {
		this.terminate();
		super.finalize();
	}

	/**
	 * Resure the process.
	 * 
	 * @category initialize-release
	 */
	protected void resume() {
		bulletinState = true;
		bulletinProcess = new Thread() {
			public void run() {
				try {
					while (bulletinState && view() != null && model().dependents().length > 0) {
						((JunBulletinBoardView) view()).display();
						Thread.yield();
						try {
							Thread.sleep(tickTime());
						} catch (InterruptedException e) {
							bulletinState = false;
						}
					}
				} finally {
					terminate();
				}
			}
		};
		// bulletinProcess.setPriority(Thread.NORM_PRIORITY + 1);
		bulletinProcess.setPriority(Thread.MAX_PRIORITY);
		bulletinProcess.start();
	}

	/**
	 * Terminate the process.
	 * 
	 * @category initialize-release
	 */
	protected void terminate() {
		bulletinState = false;
		Thread.yield();
	}

	/**
	 * Answer the time for ticking the bulletin process.
	 *
	 * @return int
	 * @category private
	 */
	protected int tickTime() {
		int tickTime = 100;
		if (StInputState.Default().button1Down()) {
			tickTime = tickTime / 10;
		}
		if (StInputState.Default().shiftDown()) {
			tickTime = tickTime / 10;
		}
		if (StInputState.Default().altDown()) {
			tickTime = tickTime / 10;
		}
		return tickTime;
	}
}
