package jp.co.sra.jun.goodies.animation;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.Map;

import javax.swing.JLabel;
import javax.swing.SwingUtilities;

import jp.co.sra.smalltalk.DependentEvent;
import jp.co.sra.smalltalk.DependentListener;
import jp.co.sra.smalltalk.StComposedText;
import jp.co.sra.smalltalk.StImage;
import jp.co.sra.smalltalk.StRectangle;
import jp.co.sra.smalltalk.StView;
import jp.co.sra.smalltalk.StViewJPanel;
import jp.co.sra.smalltalk.WindowSpecLayout;

import jp.co.sra.jun.geometry.basic.JunPoint;
import jp.co.sra.jun.goodies.button.JunButtonViewSwing;
import jp.co.sra.jun.goodies.image.support.JunImageAdjuster;
import jp.co.sra.jun.goodies.track.JunTrackSliderViewSwing;
import jp.co.sra.jun.system.framework.JunAbstractViewJPanel;

/**
 * JunCartoonMovieViewSwing class
 * 
 *  @author    Nobuto Matsubara
 *  @created   2004/02/05 (By Nobuto Matsubara)
 *  @updated   2004/09/21 (by nisinaka)
 *  @updated   2005/03/03 (by nisinaka)
 *  @updated   2007/11/05 (by nisinaka)
 *  @version   699 (with StPL8.9) based on Jun697 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunCartoonMovieViewSwing.java,v 8.15 2008/02/20 06:31:11 nisinaka Exp $
 */
public class JunCartoonMovieViewSwing extends JunAbstractViewJPanel implements JunCartoonMovieView {

	protected Map cachedAdjustedImages;

	protected JunButtonViewSwing firstButtonView;
	protected JunButtonViewSwing lastButtonView;
	protected JunButtonViewSwing firstMarkerButtonView;
	protected JunButtonViewSwing lastMarkerButtonView;
	protected JunButtonViewSwing loopButtonView;
	protected JunButtonViewSwing nextButtonView;
	protected JunButtonViewSwing playButtonView;
	protected JunButtonViewSwing previousButtonView;
	protected JunTrackSliderViewSwing sliderView;
	protected JunTrackSliderViewSwing sliderView2;
	protected JLabel progressTextView;

	/**
	 * Build the view of the JunCartoonMovie with a tracker.
	 * 
	 * @param aCartoonMovie jp.co.sra.jun.goodies.animation.JunCartoonMovie
	 * @return jp.co.sra.smalltalk.StView
	 * @category Interface opening
	 */
	public static StView WithTracker(JunCartoonMovie aCartoonMovie) {
		return new StViewJPanel(aCartoonMovie) {

			protected JunCartoonMovieViewSwing cartoonView;

			protected JunCartoonMovieViewSwing cartoonView() {
				if (cartoonView == null) {
					cartoonView = new JunCartoonMovieViewSwing((JunCartoonMovie) this.model());
				}
				return cartoonView;
			}

			protected void buildComponent() {
				this.setLayout(new WindowSpecLayout());
				this.add(this.cartoonView(), WindowSpecLayout.Position(0f, 1, 0f, 1, 1f, -1, 1f, -58));
				this.add(this.cartoonView().progressTextView(), WindowSpecLayout.Position(0f, 1, 1f, -57, 1f, -1, 1f, -39));
				this.add(this.cartoonView().firstButtonView(), WindowSpecLayout.Position(0f, 1, 1f, -19, 0f, 19, 1f, -1));
				this.add(this.cartoonView().lastButtonView(), WindowSpecLayout.Position(0f, 20, 1f, -19, 0f, 38, 1f, -1));
				this.add(this.cartoonView().previousButtonView(), WindowSpecLayout.Position(0f, 39, 1f, -19, 0f, 57, 1f, -1));
				this.add(this.cartoonView().nextButtonView(), WindowSpecLayout.Position(0f, 58, 1f, -19, 0f, 76, 1f, -1));
				this.add(this.cartoonView().sliderView(), WindowSpecLayout.Position(0f, 77, 1f, -19, 1f, -77, 1f, -1));
				this.add(this.cartoonView().sliderView2(), WindowSpecLayout.Position(0f, 1, 1f, -38, 1f, -1, 1f, -20));
				this.add(this.cartoonView().loopButtonView(), WindowSpecLayout.Position(1f, -76, 1f, -19, 1f, -58, 1f, -1));
				this.add(this.cartoonView().playButtonView(), WindowSpecLayout.Position(1f, -57, 1f, -19, 1f, -39, 1f, -1));
				this.add(this.cartoonView().firstMarkerButtonView(), WindowSpecLayout.Position(1f, -38, 1f, -19, 1f, -20, 1f, -1));
				this.add(this.cartoonView().lastMarkerButtonView(), WindowSpecLayout.Position(1f, -19, 1f, -19, 1f, -1, 1f, -1));
				this.setPreferredSize(new Dimension(300, 300));
				this.setLightWeightPopupEnabled(false);
			}

			public void _setupKeyboard(Window aWindow) {
				this.cartoonView()._setupKeyboard(aWindow);
			}
		};
	}

	/**
	 * Build the view of the JunCartoonMovie with a simple tracker.
	 * 
	 * @param aCartoonMovie jp.co.sra.jun.goodies.animation.JunCartoonMovie
	 * @return jp.co.sra.smalltalk.StView
	 * @category Interface opening
	 */
	public static StView WithSimpleTracker(JunCartoonMovie aCartoonMovie) {
		return new StViewJPanel(aCartoonMovie) {

			protected JunCartoonMovieViewSwing cartoonView;

			protected JunCartoonMovieViewSwing cartoonView() {
				if (cartoonView == null) {
					cartoonView = new JunCartoonMovieViewSwing((JunCartoonMovie) this.model());
				}
				return cartoonView;
			}

			protected void buildComponent() {
				this.setLayout(new WindowSpecLayout());
				this.add(this.cartoonView(), WindowSpecLayout.Position(0f, 1, 0f, 1, 1f, -1, 1f, -20));
				this.add(this.cartoonView().previousButtonView(), WindowSpecLayout.Position(0f, 1, 1f, -19, 0f, 19, 1f, -1));
				this.add(this.cartoonView().nextButtonView(), WindowSpecLayout.Position(0f, 20, 1f, -19, 0f, 38, 1f, -1));
				this.add(this.cartoonView().sliderView(), WindowSpecLayout.Position(0f, 39, 1f, -19, 1f, -58, 1f, -1));
				this.add(this.cartoonView().loopButtonView(), WindowSpecLayout.Position(1f, -57, 1f, -19, 1f, -39, 1f, -1));
				this.add(this.cartoonView().playButtonView(), WindowSpecLayout.Position(1f, -38, 1f, -19, 1f, -20, 1f, -1));
				this.setPreferredSize(new Dimension(300, 300));
				this.setLightWeightPopupEnabled(false);
			}

			public void _setupKeyboard(Window aWindow) {
				this.cartoonView()._setupKeyboard(aWindow);
			}
		};
	}

	/**
	 * Create instance and initializing.
	 * 
	 * @param aJunCartoonMovie jp.co.sra.jun.goodies.animation.JunCartoonMovie
	 * @category Instance creation
	 */
	public JunCartoonMovieViewSwing(JunCartoonMovie aJunCartoonMovie) {
		super(aJunCartoonMovie);
	}

	/**
	 * Initialize the receiver.
	 * 
	 * @see jp.co.sra.smalltalk.StViewJPanel#initialize()
	 * @category initialize-release
	 */
	protected void initialize() {
		super.initialize();
		cachedAdjustedImages = null;
		this.backgroundColor_(Color.gray);
	}

	/**
	 * Answer the cached adjusted images.
	 * 
	 * @return java.util.Map
	 * @category accessing
	 */
	protected Map cachedAdjustedImages() {
		if (cachedAdjustedImages == null) {
			cachedAdjustedImages = new HashMap();
		}
		return cachedAdjustedImages;
	}

	/**
	 * Answer my model as JunCartoonMovie.
	 * 
	 * @return jp.co.sra.jun.goodies.animation.JunCartoonMovie
	 * @see jp.co.sra.jun.goodies.animation.JunCartoonMovieView#getCartoonMovie()
	 * @category model accessing
	 */
	public JunCartoonMovie getCartoonMovie() {
		return (JunCartoonMovie) this.model();
	}

	/**
	 * Set bounds.
	 * 
	 * @param x The new x-coordinate of this component.
	 * @param y The new y-coordinate of this component.
	 * @param width The new width-coordinate of this component.
	 * @param height The new height-coordinate of this component.
	 * @see java.awt.Component#setBounds(int, int, int, int)
	 * @category bounds accessing
	 */
	public void setBounds(int x, int y, int width, int height) {
		if (this.getWidth() != width || this.getHeight() != height) {
			cachedAdjustedImages = null;
		}

		super.setBounds(x, y, width, height);
	}

	/**
	 * Answer background color.
	 * 
	 * @return java.awt.Color
	 * @see jp.co.sra.jun.goodies.animation.JunCartoonMovieView#backgroundColor()
	 * @category visual properties
	 */
	public Color backgroundColor() {
		return this.getBackground();
	}

	/**
	 * Set background color.
	 * 
	 * @param colorValue java.awt.Color
	 * @category  visual properties
	 */
	public void backgroundColor_(Color colorValue) {
		this.setBackground(colorValue);
	}

	/**
	 * Answer my first button view.
	 *
	 * @return jp.co.sra.jun.goodies.button.JunButtonViewSwing
	 * @category user interface
	 */
	protected JunButtonViewSwing firstButtonView() {
		if (firstButtonView == null) {
			firstButtonView = new JunButtonViewSwing(this.getCartoonMovie().trackerModel().firstButton());
		}
		return firstButtonView;
	}

	/**
	 * Answer my last button view.
	 *
	 * @return jp.co.sra.jun.goodies.button.JunButtonViewSwing
	 * @category user interface
	 */
	protected JunButtonViewSwing lastButtonView() {
		if (lastButtonView == null) {
			lastButtonView = new JunButtonViewSwing(this.getCartoonMovie().trackerModel().lastButton());
		}
		return lastButtonView;
	}

	/**
	 * Answer my firstMarker button view.
	 *
	 * @return jp.co.sra.jun.goodies.button.JunButtonViewSwing
	 * @category user interface
	 */
	protected JunButtonViewSwing firstMarkerButtonView() {
		if (firstMarkerButtonView == null) {
			firstMarkerButtonView = new JunButtonViewSwing(this.getCartoonMovie().trackerModel().firstMarkerButton());
		}
		return firstMarkerButtonView;
	}

	/**
	 * Answer my lastMarker button view.
	 *
	 * @return jp.co.sra.jun.goodies.button.JunButtonViewSwing
	 * @category user interface
	 */
	protected JunButtonViewSwing lastMarkerButtonView() {
		if (lastMarkerButtonView == null) {
			lastMarkerButtonView = new JunButtonViewSwing(this.getCartoonMovie().trackerModel().lastMarkerButton());
		}
		return lastMarkerButtonView;
	}

	/**
	 * Answer my loop button view.
	 *
	 * @return jp.co.sra.jun.goodies.button.JunButtonViewSwing
	 * @category user interface
	 */
	protected JunButtonViewSwing loopButtonView() {
		if (loopButtonView == null) {
			loopButtonView = new JunButtonViewSwing(this.getCartoonMovie().trackerModel().loopButton());
		}
		return loopButtonView;
	}

	/**
	 * Answer my previous button view.
	 *
	 * @return jp.co.sra.jun.goodies.button.JunButtonViewSwing
	 * @category user interface
	 */
	protected JunButtonViewSwing previousButtonView() {
		if (previousButtonView == null) {
			previousButtonView = new JunButtonViewSwing(this.getCartoonMovie().trackerModel().previousButton());
		}
		return previousButtonView;
	}

	/**
	 * Answer my next button view.
	 *
	 * @return jp.co.sra.jun.goodies.button.JunButtonViewSwing
	 * @category user interface
	 */
	protected JunButtonViewSwing nextButtonView() {
		if (nextButtonView == null) {
			nextButtonView = new JunButtonViewSwing(this.getCartoonMovie().trackerModel().nextButton());
		}
		return nextButtonView;
	}

	/**
	 * Answer my play button view.
	 *
	 * @return jp.co.sra.jun.goodies.button.JunButtonViewSwing
	 * @category user interface
	 */
	protected JunButtonViewSwing playButtonView() {
		if (playButtonView == null) {
			playButtonView = new JunButtonViewSwing(this.getCartoonMovie().trackerModel().playButton());
		}
		return playButtonView;
	}

	/**
	 * Answer my first slider view.
	 *
	 * @return jp.co.sra.jun.goodies.track.JunTrackSliderViewSwing
	 * @category user interface
	 */
	protected JunTrackSliderViewSwing sliderView() {
		if (sliderView == null) {
			sliderView = new JunTrackSliderViewSwing(this.getCartoonMovie().trackerModel());
		}
		return sliderView;
	}

	/**
	 * Answer my second slider view.
	 *
	 * @return jp.co.sra.jun.goodies.track.JunTrackSliderViewSwing
	 * @category user interface
	 */
	protected JunTrackSliderViewSwing sliderView2() {
		if (sliderView2 == null) {
			sliderView2 = new JunTrackSliderViewSwing(this.getCartoonMovie().trackerModel2());
		}
		return sliderView2;
	}

	/**
	 * Answer my progressText view.
	 * 
	 * @return jp.co.sra.jun.goodies.JunDisplayViewSwing
	 * @category user interface
	 */
	protected JLabel progressTextView() {
		if (progressTextView == null) {
			progressTextView = new JLabel((String) this.getCartoonMovie().progressText().value());
			progressTextView.setHorizontalAlignment(JLabel.CENTER);
			progressTextView.setBackground(new Color(0.812477f, 1.0f, 0.624954f));
			this.getCartoonMovie().progressText().addDependentListener(new DependentListener() {
				public void update_(DependentEvent evt) {
					progressTextView.setText((String) getCartoonMovie().progressText().value());
				}
			});
		}
		return progressTextView;
	}

	/**
	 * Displaying an animation.
	 * 
	 * @param aGraphics java.awt.Graphics
	 * @see jp.co.sra.smalltalk.StViewJPanel#displayOn_(java.awt.Graphics)
	 * @category displaying
	 */
	public void displayOn_(Graphics aGraphics) {
		if (this.getCartoonMovie().isEmpty()) {
			return;
		}

		// Display the image.
		StImage anImage = this.getCartoonMovie().imageToDisplay();
		StImage adjustedImage = (StImage) this.cachedAdjustedImages().get(anImage);
		if (adjustedImage == null) {
			if (anImage.bounds().width > this.getBounds().width || anImage.bounds().height > this.getBounds().height) {
				adjustedImage = JunImageAdjuster.AdjustImage_extent_keepAspect_(anImage, this.getSize(), true);
			} else {
				adjustedImage = anImage;
			}
			this.cachedAdjustedImages().put(anImage, adjustedImage);
		}
		Rectangle viewBounds = this.getBounds();
		Rectangle imageBounds = adjustedImage.bounds();
		int x = (viewBounds.x + viewBounds.width / 2) - (imageBounds.x + imageBounds.width / 2);
		int y = (viewBounds.y + viewBounds.height / 2) - (imageBounds.y + imageBounds.height / 2);
		adjustedImage.displayOn_at_(aGraphics, new Point(x, y));

		// Display the name.
		String aString = this.getCartoonMovie().displayName();
		if (aString == null || aString.length() == 0) {
			return;
		}

		StComposedText aComposedText = new StComposedText(aString);
		StRectangle aBox = new StRectangle(aComposedText.bounds());
		StRectangle aRectangle = (new StRectangle(this.getBounds()).insetBy_(1));
		Point aPoint = aBox.align_with_(aBox.bottomLeft(), aRectangle.bottomLeft()).origin();
		Point[] points = JunPoint.NeighborhoodPoints_(aPoint);
		for (int i = 0; i < points.length; ++i) {
			aGraphics.setColor(Color.white);
			aComposedText.displayOn_at_(aGraphics, points[i]);
		}
		aGraphics.setColor(this.getCartoonMovie().defaultDisplayNameColor());
		aComposedText.displayOn_at_(aGraphics, aPoint);
	}

	/**
	 * Update a cartoon view.
	 * 
	 * @param e jp.co.sra.smalltalk.DependentEvent
	 * @see jp.co.sra.smalltalk.StViewJPanel#update_(jp.co.sra.smalltalk.DependentEvent)
	 * @category updating
	 */
	public void update_(DependentEvent e) {
		if (!this.isShowing()) {
			return;
		}
		if (this.getCartoonMovie().isEmpty()) {
			return;
		}
		if (e.getAspect() == $("image")) {
			this.repaint();
			return;
		}

		super.update_(e);
	}

	/**
	 * Set up the keyboard for the view on the window.
	 * 
	 * @param aWindow java.awt.Window
	 * @see jp.co.sra.smalltalk.StView#_setupKeyboard(java.awt.Window)
	 * @category keyboard
	 */
	public void _setupKeyboard(final Window aWindow) {
		this.addKeyListener(this.getCartoonMovie()._keyListener());
		this.progressTextView().addKeyListener(this.getCartoonMovie()._keyListener());
		this.firstButtonView().addKeyListener(this.getCartoonMovie()._keyListener());
		this.lastButtonView().addKeyListener(this.getCartoonMovie()._keyListener());
		this.previousButtonView().addKeyListener(this.getCartoonMovie()._keyListener());
		this.nextButtonView().addKeyListener(this.getCartoonMovie()._keyListener());
		this.sliderView().addKeyListener(this.getCartoonMovie()._keyListener());
		this.sliderView2().addKeyListener(this.getCartoonMovie()._keyListener());
		this.loopButtonView().addKeyListener(this.getCartoonMovie()._keyListener());
		this.playButtonView().addKeyListener(this.getCartoonMovie()._keyListener());
		this.firstMarkerButtonView().addKeyListener(this.getCartoonMovie()._keyListener());
		this.lastMarkerButtonView().addKeyListener(this.getCartoonMovie()._keyListener());

		this.addMouseListener(new MouseAdapter() {
			public void mouseEntered(MouseEvent e) {
				Component focusOwner = aWindow.getFocusOwner();
				if (focusOwner != null && focusOwner != JunCartoonMovieViewSwing.this) {
					JunCartoonMovieViewSwing.this.requestFocus();
				}
			}
		});

		aWindow.addWindowListener(new WindowAdapter() {
			public void windowActivated(WindowEvent e) {
				SwingUtilities.invokeLater(new Runnable() {
					public void run() {
						Component focusOwner = aWindow.getFocusOwner();
						if (focusOwner == null || focusOwner != JunCartoonMovieViewSwing.this) {
							JunCartoonMovieViewSwing.this.requestFocus();
						}
					}
				});
			}
		});
	}

}
