package jp.co.sra.jun.geometry.surfaces;

import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collection;

import jp.co.sra.smalltalk.StApplicationModel;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StColorValue;

import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.basic.JunAngle;
import jp.co.sra.jun.geometry.curves.Jun3dLine;
import jp.co.sra.jun.geometry.transformations.Jun3dTransformation;
import jp.co.sra.jun.goodies.utilities.JunControlUtility;
import jp.co.sra.jun.opengl.display.JunOpenGLDisplayModel;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dCompoundObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dPolyline;
import jp.co.sra.jun.system.support.JunTestExamples;

/**
 * JunPlaneTestExamples class
 * 
 *  @author    nisinaka
 *  @created   1998/11/09 (by nisinaka)
 *  @updated   2007/04/26 (by Mitsuhiro Asada)
 *  @version   699 (with StPL8.9) based on Jun678 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunPlaneTestExamples.java,v 8.12 2008/02/20 06:30:58 nisinaka Exp $
 */
public class JunPlaneTestExamples extends JunTestExamples {
	/**
	 * Example:
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example1() {
		JunPlane aPlane = new JunPlane(new Jun3dPoint(0, 0, 0), new Jun3dPoint(0, 10, 0), new Jun3dPoint(10, 20, 30));
		System.out.println(aPlane.printString());

		return true;
	}

	/**
	 * Example:
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example2() {
		final JunPlane aPlane = new JunPlane(new Jun3dPoint(-2, -2, -2), new Jun3dPoint(0, 2, 0), new Jun3dPoint(2, 0, 0));
		Jun3dPoint viewPoint = new Jun3dPoint(0, 0, 300);
		Jun3dPoint referencePoint = new Jun3dPoint(0, 0, 0);
		Jun3dPoint scalePoint = new Jun3dPoint(40, 40, 40);
		Jun3dPoint offsetPoint = new Jun3dPoint(200, 200, 0);
		final Jun3dTransformation tTr = Jun3dTransformation.Translate_(referencePoint.negated());
		final Jun3dTransformation tS = Jun3dTransformation.Scale_(scalePoint);
		final Jun3dTransformation tP = Jun3dTransformation.Perspective_(viewPoint);
		final Jun3dTransformation tTt = Jun3dTransformation.Translate_(offsetPoint);

		final Canvas aCanvas = new Canvas();
		aCanvas.setBounds(0, 0, 400, 400);
		Frame aFrame = new Frame();
		aFrame.setTitle("Jun3dLine");
		aFrame.setLayout(new BorderLayout());
		aFrame.addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				e.getWindow().dispose();
			}
		});
		aFrame.add(aCanvas);
		aFrame.pack();
		StApplicationModel._ShowAtMousePoint(aFrame);

		new Thread() {
			public void run() {
				final Graphics2D aGraphics = (Graphics2D) aCanvas.getGraphics();
				aGraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
				for (int angle = 0; angle <= 360; angle = angle + 4) {
					Jun3dTransformation tRz = Jun3dTransformation.RotateZ_(JunAngle.FromDeg_(angle));
					Jun3dTransformation tRy = Jun3dTransformation.RotateY_(JunAngle.FromDeg_(angle));
					Jun3dTransformation tRx = Jun3dTransformation.RotateX_(JunAngle.FromDeg_(angle));
					Jun3dTransformation aT = tTr.product_(tS).product_(tRz).product_(tRy).product_(tRx).product_(tP).product_(tTt);
					final Point origin = Jun3dPoint.Zero().transform_(tTt).asPoint();
					final JunPlane object = (JunPlane) aPlane.transform_(aT);
					JunControlUtility.Do_forMilliseconds_(new StBlockClosure() {
						public Object value() {
							aGraphics.clearRect(0, 0, aCanvas.getWidth(), aCanvas.getHeight());
							aGraphics.setColor(Color.blue);
							aGraphics.drawArc(origin.x, origin.y, 2, 2, 0, 360);
							aGraphics.setColor(Color.red);
							Point[][] points = object.asPointArrays();
							for (int i = 0; i < points.length; i++) {
								int[] xPoints = new int[points[i].length];
								int[] yPoints = new int[points[i].length];
								for (int j = 0; j < points[i].length; j++) {
									xPoints[j] = points[i][j].x;
									yPoints[j] = points[i][j].y;
								}
								aGraphics.drawPolyline(xPoints, yPoints, xPoints.length);
							}

							return null;
						}
					}, 100);
				}
			}
		}.start();

		return true;
	}

	/**
	 * Example:
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example3() {
		Jun3dLine aLine = new Jun3dLine(new Jun3dPoint(1, 1, 1), new Jun3dPoint(0.5, 0.5, 0.5));
		Collection lineCollection = new ArrayList();
		int n = 1;
		for (int degrees = 0; degrees <= 360 - 10; degrees = degrees + 10) {
			lineCollection.add(aLine.first().to_(aLine.atT_(0.5 + (n / 36.0 * 0.5))).transform_(Jun3dTransformation.Rotate_around_(JunAngle.FromDeg_(degrees), new Jun3dPoint(0, 0, 0).to_(new Jun3dPoint(1, 1, 2)))));
			n++;
		}
		JunPlane aPlane = new JunPlane(new Jun3dPoint(0, 0, 0), new Jun3dPoint(1, 0, 0), new Jun3dPoint(0, 1, 0));
		Collection planeCollection = new ArrayList();
		for (int degrees = 0; degrees <= 360; degrees = degrees + 5) {
			planeCollection.add(aPlane.transform_(Jun3dTransformation.Rotate_around_(JunAngle.FromDeg_(degrees), new Jun3dPoint(0, 0, 0).to_(new Jun3dPoint(1, 1, 0)))));
		}
		final Jun3dLine[] lines = (Jun3dLine[]) lineCollection.toArray(new Jun3dLine[lineCollection.size()]);
		final JunPlane[] planes = (JunPlane[]) planeCollection.toArray(new JunPlane[planeCollection.size()]);

		JunOpenGLDisplayModel aViewfinder = new JunOpenGLDisplayModel();
		aViewfinder.openIn_(new Rectangle(100, 100, 600, 600));
		for (int i = 0; i < planes.length; i++) {
			final JunPlane eachPlane = planes[i];
			final JunOpenGL3dCompoundObject aBody = new JunOpenGL3dCompoundObject();
			JunControlUtility.Do_forMilliseconds_(new StBlockClosure() {
				public Object value() {
					for (int n = 0; n < lines.length; n++) {
						Jun3dLine eachLine = lines[n];
						Jun3dLine reflectingLine = eachPlane.reflectingLineWithLine_(eachLine);
						aBody.add_(JunOpenGL3dObject.ArrowLine_color_lineWidth_(eachLine, Color.getHSBColor(n / (float) lines.length, 1, 1), 2));
						JunOpenGL3dObject aCircle = JunOpenGL3dObject.CircleBy_radius_upVector_(10, 2.5, eachPlane.normalVector()).translatedBy_(eachPlane.first());
						aCircle.polygonsDo_(new StBlockClosure() {
							public Object value_(Object obj) {
								JunOpenGL3dObject each = (JunOpenGL3dObject) obj;
								each.paint_(StColorValue.VeryLightGray);
								each.halftone_(0.5);
								return null;
							}
						});
						aBody.add_(aCircle);

						Jun3dPoint aPoint;
						if ((aPoint = eachPlane.intersectingPointWithLine_(eachLine)) != null) {
							aBody.add_(new JunOpenGL3dPolyline(new Jun3dPoint[] { eachLine.last(), aPoint }, Color.gray));
						}
						if ((aPoint = eachPlane.intersectingPointWithLine_(reflectingLine)) != null) {
							aBody.add_(new JunOpenGL3dPolyline(new Jun3dPoint[] { aPoint, reflectingLine.first() }, Color.gray));
						}
						aBody.add_(JunOpenGL3dObject.ArrowLine_color_lineWidth_(reflectingLine, Color.getHSBColor(n / (float) lines.length, 1, 1), 2));
					}
					return null;
				}
			}, 25);
			aViewfinder.displayObject_(aBody);
			aViewfinder.resetView();
		}

		return true;
	}

	/**
	 * Starts the application.
	 * 
	 * @param args an array of command-line arguments
	 * @category Main
	 */
	public static void main(java.lang.String[] args) {
		new JunPlaneTestExamples();
	}

	/**
	 * Test case of the method "intersectingPointWithLine_()".
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Test1() {
		JunPlane aPlane = new JunPlane(new Jun3dPoint(-2, -2, 0), new Jun3dPoint(0, 2, 0), new Jun3dPoint(2, 0, 0));
		Jun3dLine aLine = new Jun3dLine(new Jun3dPoint(0, 0, -2), new Jun3dPoint(0, 0, 2));
		Jun3dPoint aPoint = aPlane.intersectingPointWithLine_(aLine);

		return (aPoint.x() == 0) && (aPoint.y() == 0) && (aPoint.z() == 0);
	}

	/**
	 * Test case of the method "intersectingPointWithLine_()".
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Test2() {
		JunPlane aPlane = new JunPlane(new Jun3dPoint(0, 0, 0), new Jun3dPoint(1, 0, 0), new Jun3dPoint(0, 1, 0));
		Jun3dLine aLine = new Jun3dLine(new Jun3dPoint(0, 0, -2), new Jun3dPoint(0, 0, -1));
		Jun3dPoint aPoint = aPlane.intersectingPointWithLine_(aLine);

		return (aPoint.x() == 0) && (aPoint.y() == 0) && (aPoint.z() == 0);
	}

	/**
	 * Test case of the method "normalUnitVector()".
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Test3() {
		JunPlane aPlane = new JunPlane(new Jun3dPoint(-2, -2, 0), new Jun3dPoint(2, 0, 0), new Jun3dPoint(-2, 2, 0));
		Jun3dPoint aPoint = aPlane.normalUnitVector();

		return (aPoint.x() == 0) && (aPoint.y() == 0) && (aPoint.z() == 1);
	}

	/**
	 * Test case of the method "normalUnitVector()".
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Test4() {
		JunPlane aPlane = new JunPlane(new Jun3dPoint(2, 0, 0), new Jun3dPoint(0, 2, 0), new Jun3dPoint(0, 0, 2));
		Jun3dPoint aPoint = aPlane.normalUnitVector();

		return (aPoint.x() == 0.5773502691896258) && (aPoint.y() == 0.5773502691896258) && (aPoint.z() == 0.5773502691896258);
	}

	/**
	 * Test case of the method "angleWithLine_()".
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Test5() {
		JunPlane aPlane = new JunPlane(new Jun3dPoint(-2, -2, 0), new Jun3dPoint(0, 2, 0), new Jun3dPoint(2, 0, 0));
		Jun3dLine aLine = new Jun3dLine(new Jun3dPoint(0, 0, -2), new Jun3dPoint(0, 0, 2));
		JunAngle anAngle = aPlane.angleWithLine_(aLine);

		return anAngle.deg() == -90.0d;
	}

	/**
	 * Test case of the constractor metohd "on:on:on"
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Test6() {
		JunPlane aPlane = new JunPlane(1, 1, 1, 1);
		System.out.println(aPlane.printString());
		aPlane.asJunOpenGL3dObject().showWithUnitAxes();

		return true;
	}

	/**
	 * Test case of the metohd "intersectingLineWithPlane_()"
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Test7() {
		JunPlane plane1 = new JunPlane(new Jun3dPoint(-2, -2, 0), new Jun3dPoint(0, 2, 0), new Jun3dPoint(2, 0, 0));
		JunPlane plane2 = new JunPlane(new Jun3dPoint(0, -2, -2), new Jun3dPoint(0, 2, 0), new Jun3dPoint(0, 0, 2));
		Jun3dLine line = plane1.intersectingLineWithPlane_(plane2);
		System.out.println(line);

		return true;
	}

	/**
	 * Test case of the metohd "intersectingPointWithPlane_wihtPlane_()"
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Test8() {
		JunPlane plane1 = new JunPlane(new Jun3dPoint(-2, -2, -2), new Jun3dPoint(0, 2, 0), new Jun3dPoint(2, 0, 0));
		JunPlane plane2 = new JunPlane(new Jun3dPoint(-2, -2, -2), new Jun3dPoint(0, 2, 0), new Jun3dPoint(0, 0, 2));
		JunPlane plane3 = new JunPlane(new Jun3dPoint(-2, -2, -2), new Jun3dPoint(2, 0, 0), new Jun3dPoint(0, 0, 2));
		Jun3dPoint point = plane1.intersectingPointWithPlane_wihtPlane_(plane2, plane3);
		System.out.println(point);

		return true;
	}
}
