package jp.co.sra.jun.geometry.surfaces;

import java.awt.Color;
import java.awt.Frame;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import jp.co.sra.smalltalk.StBlockClosure;

import jp.co.sra.jun.geometry.abstracts.JunGeometry;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.basic.JunAngle;
import jp.co.sra.jun.geometry.boundaries.Jun3dBoundingBox;
import jp.co.sra.jun.geometry.curves.Jun3dLine;
import jp.co.sra.jun.geometry.curves.Jun3dPolyline;
import jp.co.sra.jun.geometry.support.JunPointsOnPlane;
import jp.co.sra.jun.geometry.transformations.Jun3dTransformation;
import jp.co.sra.jun.goodies.utilities.JunControlUtility;
import jp.co.sra.jun.opengl.display.JunOpenGLDisplayModel;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dCompoundObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dPolygon;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dPolyline;
import jp.co.sra.jun.system.framework.JunApplicationModel;
import jp.co.sra.jun.system.support.JunTestExamples;

/**
 * Jun3dTriangleTestExamples class
 * 
 *  @author    Mitsuhiro Asada
 *  @created   2004/12/21 (by Mitsuhiro Asada)
 *  @updated   2006/10/25 (by nisinaka)
 *  @version   699 (with StPL8.9) based on Jun682 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: Jun3dTriangleTestExamples.java,v 8.13 2008/02/20 06:30:58 nisinaka Exp $
 */
public class Jun3dTriangleTestExamples extends JunTestExamples {
	/**
	 * Example1:
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example1() {
		Jun3dTriangle aTriangle = Jun3dTriangle.On_on_on_(new Jun3dPoint(1, 0, 0), new Jun3dPoint(0, 1, 0), new Jun3dPoint(0, 0, 1));
		System.out.println(aTriangle.printString());
		System.out.println(aTriangle.storeString());
		System.out.println("area:" + aTriangle.area());
		System.out.println("volume:" + aTriangle.volume());
		aTriangle.asJunOpenGL3dObject().showWithUnitAxes();

		return true;
	}

	/**
	 * Example2: 
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example2() {
		Jun3dTriangle aTriangle = new Jun3dPoint(1, 0, 0).triangle_and_(new Jun3dPoint(0, 1, 0), new Jun3dPoint(0, 0, 1));
		JunPlane aPlane = JunPlane.On_normalVector_(new Jun3dPoint(1.0 / 3.0, 1.0 / 3.0, 1.0 / 3.0), new Jun3dPoint(1, 1, 1));
		Map aTable = aTriangle.tableDividedBy_(aPlane);
		JunOpenGL3dCompoundObject compoundObject = new JunOpenGL3dCompoundObject();
		compoundObject.add_(PrivatePlaneBody(aPlane));
		compoundObject.add_(PrivateTableBody(aTable));
		compoundObject.add_(JunOpenGL3dObject.Axes().scaledBy_(1.5));
		compoundObject.showProjectionTable_(PrivateProjectionTable());

		return true;
	}

	/**
	 * Example3: 
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example3() {
		Jun3dTriangle aTriangle = new Jun3dPoint(1, 0, 0).triangle_and_(new Jun3dPoint(0, 1, 0), new Jun3dPoint(0, 0, 1));
		JunPlane aPlane = JunPlane.On_normalVector_(new Jun3dPoint(0, 0.5, 0.5), new Jun3dPoint(0, 1, 1));
		Map aTable = aTriangle.tableDividedBy_(aPlane);
		JunOpenGL3dCompoundObject compoundObject = new JunOpenGL3dCompoundObject();
		compoundObject.add_(PrivatePlaneBody(aPlane));
		compoundObject.add_(PrivateTableBody(aTable));
		compoundObject.add_(JunOpenGL3dObject.Axes().scaledBy_(1.5));
		compoundObject.showProjectionTable_(PrivateProjectionTable());

		return true;
	}

	/**
	 * Example4: 
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example4() {
		Jun3dTriangle aTriangle = new Jun3dPoint(1, 0, 0).triangle_and_(new Jun3dPoint(0, 1, 0), new Jun3dPoint(0, 0, 1));
		JunPlane aPlane = JunPlane.On_normalVector_(new Jun3dPoint(1.0 / 3.0, 1.0 / 3.0, 1.0 / 3.0), new Jun3dPoint(1, -1, 0));
		Map aTable = aTriangle.tableDividedBy_(aPlane);
		JunOpenGL3dCompoundObject compoundObject = new JunOpenGL3dCompoundObject();
		compoundObject.add_(PrivatePlaneBody(aPlane));
		compoundObject.add_(PrivateTableBody(aTable));
		compoundObject.add_(JunOpenGL3dObject.Axes().scaledBy_(1.5));
		compoundObject.showProjectionTable_(PrivateProjectionTable());

		return true;
	}

	/**
	 * Example5: 
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example5() {
		Jun3dTriangle aTriangle = new Jun3dPoint(1, 0, 0).triangle_and_(new Jun3dPoint(0, 1, 0), new Jun3dPoint(0, 0, 1));
		JunPlane aPlane = JunPlane.On_normalVector_(new Jun3dPoint(1.0 / 3.0, 1.0 / 3.0, 1.0 / 3.0), new Jun3dPoint(1, -1, 0)).translatedBy_(new Jun3dPoint(0.2, -0.2, 0));
		Map aTable = aTriangle.tableDividedBy_(aPlane);
		JunOpenGL3dCompoundObject compoundObject = new JunOpenGL3dCompoundObject();
		compoundObject.add_(PrivatePlaneBody(aPlane));
		compoundObject.add_(PrivateTableBody(aTable));
		compoundObject.add_(JunOpenGL3dObject.Axes().scaledBy_(1.5));
		compoundObject.showProjectionTable_(PrivateProjectionTable());

		return true;
	}

	/**
	 * Example6: 
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example6() {
		Jun3dTriangle aTriangle = new Jun3dPoint(1, 0, 0).triangle_and_(new Jun3dPoint(0, 1, 0), new Jun3dPoint(0, 0, 1));
		JunPlane aPlane = JunPlane.On_normalVector_(new Jun3dPoint(1.0 / 3.0, 1.0 / 3.0, 1.0 / 3.0), new Jun3dPoint(1, -1, 0)).translatedBy_(new Jun3dPoint(0.5, -0.5, 0));
		Map aTable = aTriangle.tableDividedBy_(aPlane);
		JunOpenGL3dCompoundObject compoundObject = new JunOpenGL3dCompoundObject();
		compoundObject.add_(PrivatePlaneBody(aPlane));
		compoundObject.add_(PrivateTableBody(aTable));
		compoundObject.add_(JunOpenGL3dObject.Axes().scaledBy_(1.5));
		compoundObject.showProjectionTable_(PrivateProjectionTable());

		return true;
	}

	/**
	 * Example7: 
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example7() {
		Jun3dTriangle aTriangle = new Jun3dPoint(1, 0, 0).triangle_and_(new Jun3dPoint(0, 1, 0), new Jun3dPoint(0, 0, 1));
		JunPlane aPlane = JunPlane.On_normalVector_(new Jun3dPoint(1.0 / 3.0, 1.0 / 3.0, 1.0 / 3.0), new Jun3dPoint(1, -1, 0)).translatedBy_(new Jun3dPoint(-0.5, 0.5, 0));
		Map aTable = aTriangle.tableDividedBy_(aPlane);
		JunOpenGL3dCompoundObject compoundObject = new JunOpenGL3dCompoundObject();
		compoundObject.add_(PrivatePlaneBody(aPlane));
		compoundObject.add_(PrivateTableBody(aTable));
		compoundObject.add_(JunOpenGL3dObject.Axes().scaledBy_(1.5));
		compoundObject.showProjectionTable_(PrivateProjectionTable());

		return true;
	}

	/**
	 * Example8: 
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example8() {
		Jun3dTriangle aTriangle = new Jun3dPoint(1, 0, 0).triangle_and_(new Jun3dPoint(0, 1, 0), new Jun3dPoint(0, 0, 1));
		JunPlane aPlane = JunPlane.On_normalVector_(new Jun3dPoint(1.0 / 3.0, 1.0 / 3.0, 1.0 / 3.0), new Jun3dPoint(1, -1, 0)).translatedBy_(new Jun3dPoint(0.75, -0.75, 0));
		Map aTable = aTriangle.tableDividedBy_(aPlane);
		JunOpenGL3dCompoundObject compoundObject = new JunOpenGL3dCompoundObject();
		compoundObject.add_(PrivatePlaneBody(aPlane));
		compoundObject.add_(PrivateTableBody(aTable));
		compoundObject.add_(JunOpenGL3dObject.Axes().scaledBy_(1.5));
		compoundObject.showProjectionTable_(PrivateProjectionTable());

		return true;
	}

	/**
	 * Example9: 
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example9() {
		Jun3dTriangle aTriangle = new Jun3dPoint(1, 0, 0).triangle_and_(new Jun3dPoint(0, 1, 0), new Jun3dPoint(0, 0, 1));
		JunPlane aPlane = JunPlane.On_normalVector_(new Jun3dPoint(1.0 / 3.0, 1.0 / 3.0, 1.0 / 3.0), new Jun3dPoint(1, -1, 0)).translatedBy_(new Jun3dPoint(-0.75, 0.75, 0));
		Map aTable = aTriangle.tableDividedBy_(aPlane);
		JunOpenGL3dCompoundObject compoundObject = new JunOpenGL3dCompoundObject();
		compoundObject.add_(PrivatePlaneBody(aPlane));
		compoundObject.add_(PrivateTableBody(aTable));
		compoundObject.add_(JunOpenGL3dObject.Axes().scaledBy_(1.5));
		compoundObject.showProjectionTable_(PrivateProjectionTable());

		return true;
	}

	/**
	 * ExampleA: 
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean ExampleA() {
		final Jun3dTriangle aTriangle = new Jun3dTriangle(new Jun3dPoint(1, 0, 0), new Jun3dPoint(0, 1, 0), new Jun3dPoint(0, 0, 1));
		JunOpenGL3dCompoundObject compoundObject = new JunOpenGL3dCompoundObject();
		Map projectionTable = PrivateProjectionTable();
		projectionTable.put($("presentation"), $("hiddenlinePresentation"));
		final JunOpenGLDisplayModel displayModel = compoundObject.showProjectionTable_in_(projectionTable, new Rectangle(100 - 4, 250 - 23, 400 + 8, 400 + 26));

		for (int i = -55; i <= 55; i++) {
			final Double n = new Double(i / 100.0);
			JunControlUtility.Do_forMilliseconds_(new StBlockClosure() {
				public Object value() {
					double x = n.doubleValue();
					JunPlane aPlane = JunPlane.On_normalVector_(new Jun3dPoint(1.0 / 3.0, 1.0 / 3.0, 1.0 / 3.0), new Jun3dPoint(1, -1, 0)).translatedBy_(new Jun3dPoint(x, -x, 0));
					Map aTable = aTriangle.tableDividedBy_(aPlane);
					JunOpenGL3dCompoundObject compoundObject = new JunOpenGL3dCompoundObject();
					compoundObject.add_(PrivatePlaneBody(aPlane));
					compoundObject.add_(PrivateTableBody(aTable));
					compoundObject.add_(JunOpenGL3dObject.Axes().scaledBy_(1.5));
					displayModel.displayObject_(compoundObject);
					displayModel.changed_($("object"));
					return null;
				}
			}, 100);
		}

		return true;
	}

	/**
	 * ExampleB: 
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean ExampleB() {
		final Jun3dTriangle aTriangle = new Jun3dTriangle(new Jun3dPoint(1, 0, 0), new Jun3dPoint(0, 1, 0), new Jun3dPoint(0, 0, 1));
		JunOpenGL3dCompoundObject compoundObject = new JunOpenGL3dCompoundObject();
		Map projectionTable = PrivateProjectionTable();
		projectionTable.put($("presentation"), $("hiddenlinePresentation"));
		final JunOpenGLDisplayModel displayModel = compoundObject.showProjectionTable_in_(projectionTable, new Rectangle(100 - 4, 250 - 23, 400 + 8, 400 + 26));

		for (int i = 0; i <= 360 / 2.5; i++) {
			final Double n = new Double(i * 2.5);
			JunControlUtility.Do_forMilliseconds_(new StBlockClosure() {
				public Object value() {
					JunPlane aPlane = (JunPlane) JunPlane.On_normalVector_(new Jun3dPoint(1.0 / 3.0, 1.0 / 3.0, 1.0 / 3.0), new Jun3dPoint(1, -1, 0)).transform_(
							Jun3dTransformation.Rotate_around_(JunAngle.FromDeg_(n.doubleValue()), new Jun3dLine(new Jun3dPoint(0, 0, 0), new Jun3dPoint(1, 1, 1))));
					Map aTable = aTriangle.tableDividedBy_(aPlane);
					JunOpenGL3dCompoundObject compoundObject = new JunOpenGL3dCompoundObject();
					compoundObject.add_(PrivatePlaneBody(aPlane));
					compoundObject.add_(PrivateTableBody(aTable));
					compoundObject.add_(JunOpenGL3dObject.Axes().scaledBy_(1.5));
					displayModel.displayObject_(compoundObject);
					displayModel.changed_($("object"));
					return null;
				}
			}, 100);
		}

		return true;
	}

	/**
	 * ExampleC: 
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean ExampleC() {
		Jun3dBoundingBox aBox = Jun3dBoundingBox.Origin_corner_(new Jun3dPoint(-0.5, -0.5, -0.5), new Jun3dPoint(0.5, 0.5, 0.5)).translatedBy_(new Jun3dPoint(1.0 / 3.0, 1.0 / 3.0, 1.0 / 3.0));
		final Jun3dTriangle[] arrayOfTriangles = aBox.asArrayOf3dTriangles();
		JunOpenGL3dCompoundObject compoundObject = new JunOpenGL3dCompoundObject();
		Map projectionTable = PrivateProjectionTable();
		final JunOpenGLDisplayModel foreDisplayModel = compoundObject.showProjectionTable_in_(projectionTable, new Rectangle(100 - 4, 250 - 23, 400 + 8, 400 + 26));
		projectionTable = PrivateProjectionTable();
		projectionTable.put($("eyePoint"), ((Jun3dPoint) projectionTable.get($("eyePoint"))).negated());
		final JunOpenGLDisplayModel backDisplayModel = compoundObject.showProjectionTable_in_(projectionTable, new Rectangle(520 - 4, 250 - 23, 400 + 8, 400 + 26));
		JunApplicationModel[] models = new JunApplicationModel[] { foreDisplayModel, backDisplayModel };
		for (int i = 0; i < models.length; i++) {
			models[i].closeTogether_(models);
		}

		for (int i = -55; i <= 55; i++) {
			final Double n = new Double(i / 100.0);
			JunControlUtility.Do_forMilliseconds_(new StBlockClosure() {
				public Object value() {
					double x = n.doubleValue();
					JunPlane aPlane = JunPlane.On_normalVector_(new Jun3dPoint(1.0 / 3.0, 1.0 / 3.0, 1.0 / 3.0), new Jun3dPoint(1, -1, 0)).translatedBy_(new Jun3dPoint(x, -x, 0));
					JunOpenGL3dCompoundObject compoundObject = new JunOpenGL3dCompoundObject();
					for (int i = 0; i < arrayOfTriangles.length; i++) {
						Map aTable = arrayOfTriangles[i].tableDividedBy_(aPlane);
						JunOpenGL3dCompoundObject subCompoundObject = new JunOpenGL3dCompoundObject();
						subCompoundObject.add_(PrivatePlaneBody(aPlane));
						subCompoundObject.add_(PrivateTableBody(aTable));
						subCompoundObject.add_(JunOpenGL3dObject.Axes().scaledBy_(1.5));
						compoundObject.add_(subCompoundObject);
					}

					foreDisplayModel.displayObject_(compoundObject);
					backDisplayModel.displayObject_(compoundObject);
					foreDisplayModel.changed_($("object"));
					backDisplayModel.changed_($("object"));
					return null;
				}
			}, 100);
		}

		return true;
	}

	/**
	 * ExampleD: 
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean ExampleD() {
		Jun3dBoundingBox aBox = Jun3dBoundingBox.Origin_corner_(new Jun3dPoint(-0.5, -0.5, -0.5), new Jun3dPoint(0.5, 0.5, 0.5)).translatedBy_(new Jun3dPoint(1.0 / 3.0, 1.0 / 3.0, 1.0 / 3.0));
		final Jun3dTriangle[] arrayOfTriangles = aBox.asArrayOf3dTriangles();
		JunOpenGL3dCompoundObject compoundObject = new JunOpenGL3dCompoundObject();
		Map projectionTable = PrivateProjectionTable();
		final JunOpenGLDisplayModel foreDisplayModel = compoundObject.showProjectionTable_in_(projectionTable, new Rectangle(100 - 4, 250 - 23, 400 + 8, 400 + 26));
		projectionTable = PrivateProjectionTable();
		projectionTable.put($("eyePoint"), ((Jun3dPoint) projectionTable.get($("eyePoint"))).negated());
		final JunOpenGLDisplayModel backDisplayModel = compoundObject.showProjectionTable_in_(projectionTable, new Rectangle(520 - 4, 250 - 23, 400 + 8, 400 + 26));
		JunApplicationModel[] models = new JunApplicationModel[] { foreDisplayModel, backDisplayModel };
		for (int i = 0; i < models.length; i++) {
			models[i].closeTogether_(models);
		}

		for (int i = 0; i <= 360 / 2.5; i++) {
			final Double n = new Double(i * 2.5);
			JunControlUtility.Do_forMilliseconds_(new StBlockClosure() {
				public Object value() {
					JunPlane aPlane = (JunPlane) JunPlane.On_normalVector_(new Jun3dPoint(1.0 / 3.0, 1.0 / 3.0, 1.0 / 3.0), new Jun3dPoint(1, -1, 0)).transform_(
							Jun3dTransformation.Rotate_around_(JunAngle.FromDeg_(n.doubleValue()), new Jun3dLine(new Jun3dPoint(0, 0, 0), new Jun3dPoint(1, 1, 1))));
					JunOpenGL3dCompoundObject compoundObject = new JunOpenGL3dCompoundObject();
					for (int i = 0; i < arrayOfTriangles.length; i++) {
						Map aTable = arrayOfTriangles[i].tableDividedBy_(aPlane);
						JunOpenGL3dCompoundObject subCompoundObject = new JunOpenGL3dCompoundObject();
						subCompoundObject.add_(PrivatePlaneBody(aPlane));
						subCompoundObject.add_(PrivateTableBody(aTable));
						subCompoundObject.add_(JunOpenGL3dObject.Axes().scaledBy_(1.5));
						compoundObject.add_(subCompoundObject);
					}

					foreDisplayModel.displayObject_(compoundObject);
					backDisplayModel.displayObject_(compoundObject);
					foreDisplayModel.changed_($("object"));
					backDisplayModel.changed_($("object"));
					return null;
				}
			}, 100);
		}

		return true;
	}

	/**
	 * ExampleE: 
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean ExampleE() {
		Jun3dBoundingBox aBox = Jun3dBoundingBox.Origin_corner_(new Jun3dPoint(-0.5, -0.5, -0.5), new Jun3dPoint(0.5, 0.5, 0.5)).translatedBy_(new Jun3dPoint(1.0 / 3.0, 1.0 / 3.0, 1.0 / 3.0));
		final Jun3dTriangle[] arrayOfTriangles = aBox.asArrayOf3dTriangles();
		JunOpenGL3dCompoundObject compoundObject = new JunOpenGL3dCompoundObject();
		Map projectionTable = PrivateProjectionTable();
		projectionTable.put($("presentation"), $("hiddenlinePresentation"));
		final JunOpenGLDisplayModel foreDisplayModel = compoundObject.showProjectionTable_in_(projectionTable, new Rectangle(100 - 4, 250 - 23, 400 + 8, 400 + 26));
		projectionTable = PrivateProjectionTable();
		projectionTable.put($("eyePoint"), ((Jun3dPoint) projectionTable.get($("eyePoint"))).negated());
		projectionTable.put($("presentation"), $("hiddenlinePresentation"));
		final JunOpenGLDisplayModel backDisplayModel = compoundObject.showProjectionTable_in_(projectionTable, new Rectangle(520 - 4, 250 - 23, 400 + 8, 400 + 26));
		JunApplicationModel[] models = new JunApplicationModel[] { foreDisplayModel, backDisplayModel };
		for (int i = 0; i < models.length; i++) {
			models[i].closeTogether_(models);
		}

		for (int i = 0; i <= 360 / 2.5; i++) {
			final Double n = new Double(i * 2.5);
			JunControlUtility.Do_forMilliseconds_(new StBlockClosure() {
				public Object value() {
					JunPlane aPlane = (JunPlane) JunPlane.On_normalVector_(new Jun3dPoint(1.0 / 3.0, 1.0 / 3.0, 1.0 / 3.0), new Jun3dPoint(1, -1, 0)).transform_(
							Jun3dTransformation.Rotate_around_(JunAngle.FromDeg_(n.doubleValue()), new Jun3dLine(new Jun3dPoint(0, 0, 0), new Jun3dPoint(1, 1, 1))));
					JunOpenGL3dCompoundObject compoundObject = new JunOpenGL3dCompoundObject();
					for (int i = 0; i < arrayOfTriangles.length; i++) {
						Map aTable = arrayOfTriangles[i].tableDividedBy_(aPlane);
						JunOpenGL3dCompoundObject subCompoundObject = new JunOpenGL3dCompoundObject();
						subCompoundObject.add_(PrivatePlaneBody(aPlane));
						subCompoundObject.add_(PrivateTableBody(aTable));
						subCompoundObject.add_(JunOpenGL3dObject.Axes().scaledBy_(1.5));
						compoundObject.add_(subCompoundObject);
					}

					foreDisplayModel.displayObject_(compoundObject);
					backDisplayModel.displayObject_(compoundObject);
					foreDisplayModel.changed_($("object"));
					backDisplayModel.changed_($("object"));
					return null;
				}
			}, 100);
		}

		return true;
	}

	/**
	 * ExampleF: 
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean ExampleF() {
		Jun3dBoundingBox aBox = Jun3dBoundingBox.Origin_corner_(new Jun3dPoint(0, 0, 0), new Jun3dPoint(1, 1, 1));
		final Jun3dTriangle[] arrayOfTriangles = aBox.asArrayOf3dTriangles();
		JunOpenGL3dCompoundObject compoundObject = new JunOpenGL3dCompoundObject();
		Map projectionTable = PrivateProjectionTable();
		projectionTable.put($("shading"), $("smoothShading"));
		final JunOpenGLDisplayModel foreDisplayModel = compoundObject.showProjectionTable_in_(projectionTable, new Rectangle(100 - 4, 250 - 23, 300 + 8, 300 + 26));
		projectionTable = PrivateProjectionTable();
		projectionTable.put($("eyePoint"), ((Jun3dPoint) projectionTable.get($("eyePoint"))).negated());
		projectionTable.put($("shading"), $("smoothShading"));
		final JunOpenGLDisplayModel backDisplayModel = compoundObject.showProjectionTable_in_(projectionTable, new Rectangle(420 - 4, 250 - 23, 300 + 8, 300 + 26));
		projectionTable = PrivateProjectionTable();
		projectionTable.put($("shading"), $("smoothShading"));
		final JunOpenGLDisplayModel lineDisplayModel = compoundObject.showProjectionTable_in_(projectionTable, new Rectangle(100 - 4, 590 - 23, 300 + 8, 300 + 26));
		projectionTable = PrivateProjectionTable();
		projectionTable.put($("shading"), $("smoothShading"));
		final JunOpenGLDisplayModel sectDisplayModel = compoundObject.showProjectionTable_in_(projectionTable, new Rectangle(420 - 4, 590 - 23, 300 + 8, 300 + 26));
		foreDisplayModel.displayLightsAllOff();
		backDisplayModel.displayLightsAllOff();
		lineDisplayModel.displayLightsAllOff();
		sectDisplayModel.displayLightsAllOff();
		((Frame) foreDisplayModel.getWindow()).setTitle("Fore");
		((Frame) backDisplayModel.getWindow()).setTitle("Back");
		((Frame) lineDisplayModel.getWindow()).setTitle("Line");
		((Frame) sectDisplayModel.getWindow()).setTitle("Sect");
		JunApplicationModel[] models = new JunApplicationModel[] { foreDisplayModel, backDisplayModel, lineDisplayModel, sectDisplayModel };
		for (int i = 0; i < models.length; i++) {
			models[i].closeTogether_(models);
		}

		for (int i = 0; i <= 180; i += 2) {
			final Double n = new Double(i);
			JunControlUtility.Do_forMilliseconds_(new StBlockClosure() {
				public Object value() {
					ArrayList aList = new ArrayList();
					JunPlane aPlane = (JunPlane) JunPlane.On_normalVector_(new Jun3dPoint(0.5, 0.5, 0.5), new Jun3dPoint(1, -1, 0)).transform_(
							Jun3dTransformation.Rotate_around_(JunAngle.FromDeg_(n.doubleValue()), new Jun3dLine(new Jun3dPoint(0, 0, 0), new Jun3dPoint(1, 1, 1))));
					JunOpenGL3dCompoundObject compoundObject = new JunOpenGL3dCompoundObject();
					for (int i = 0; i < arrayOfTriangles.length; i++) {
						Map aTable = arrayOfTriangles[i].tableDividedBy_(aPlane);
						JunOpenGL3dCompoundObject subCompoundObject = new JunOpenGL3dCompoundObject();
						subCompoundObject.add_(PrivatePlaneBody(aPlane));
						subCompoundObject.add_(PrivateColorBody(aTable));
						subCompoundObject.add_(JunOpenGL3dObject.Axes().scaledBy_(1.5));
						compoundObject.add_(subCompoundObject);
						aList.addAll((Collection) aTable.get($("points")));
					}

					foreDisplayModel.displayObject_(compoundObject);
					backDisplayModel.displayObject_(compoundObject);
					lineDisplayModel.displayObject_(PrivateLineBody(aList));
					sectDisplayModel.displayObject_(PrivateSectBody(aList));
					foreDisplayModel.changed_($("object"));
					backDisplayModel.changed_($("object"));
					lineDisplayModel.changed_($("object"));
					sectDisplayModel.changed_($("object"));
					return null;
				}
			}, 100);
		}

		return true;
	}

	/**
	 * ExampleG: 
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean ExampleG() {
		Jun3dBoundingBox aBox = Jun3dBoundingBox.Origin_corner_(new Jun3dPoint(0, 0, 0), new Jun3dPoint(1, 1, 1));
		final Jun3dTriangle[] arrayOfTriangles = aBox.asArrayOf3dTriangles();
		JunOpenGL3dCompoundObject compoundObject = new JunOpenGL3dCompoundObject();
		Map projectionTable = PrivateProjectionTable();
		projectionTable.put($("shading"), $("smoothShading"));
		final JunOpenGLDisplayModel foreDisplayModel = compoundObject.showProjectionTable_in_(projectionTable, new Rectangle(100 - 4, 250 - 23, 300 + 8, 300 + 26));
		projectionTable = PrivateProjectionTable();
		projectionTable.put($("eyePoint"), ((Jun3dPoint) projectionTable.get($("eyePoint"))).negated());
		projectionTable.put($("shading"), $("smoothShading"));
		final JunOpenGLDisplayModel backDisplayModel = compoundObject.showProjectionTable_in_(projectionTable, new Rectangle(420 - 4, 250 - 23, 300 + 8, 300 + 26));
		projectionTable = PrivateProjectionTable();
		projectionTable.put($("shading"), $("smoothShading"));
		final JunOpenGLDisplayModel lineDisplayModel = compoundObject.showProjectionTable_in_(projectionTable, new Rectangle(100 - 4, 590 - 23, 300 + 8, 300 + 26));
		projectionTable = PrivateProjectionTable();
		projectionTable.put($("shading"), $("smoothShading"));
		projectionTable.put($("sightPoint"), new Jun3dPoint(0.3, 0.3, 0.3));
		projectionTable.put($("eyePoint"), new Jun3dPoint(100, -100, 30));
		projectionTable.put($("upVector"), new Jun3dPoint(0, 0, 1));
		final JunOpenGLDisplayModel sectDisplayModel = compoundObject.showProjectionTable_in_(projectionTable, new Rectangle(420 - 4, 590 - 23, 300 + 8, 300 + 26));
		foreDisplayModel.displayLightsAllOff();
		backDisplayModel.displayLightsAllOff();
		lineDisplayModel.displayLightsAllOff();
		sectDisplayModel.displayLightsAllOff();
		((Frame) foreDisplayModel.getWindow()).setTitle("Fore");
		((Frame) backDisplayModel.getWindow()).setTitle("Back");
		((Frame) lineDisplayModel.getWindow()).setTitle("Line");
		((Frame) sectDisplayModel.getWindow()).setTitle("Sect");
		JunApplicationModel[] models = new JunApplicationModel[] { foreDisplayModel, backDisplayModel, lineDisplayModel, sectDisplayModel };
		for (int i = 0; i < models.length; i++) {
			models[i].closeTogether_(models);
		}

		for (int i = -55; i <= 55; i++) {
			final Double n = new Double(i / 100.0);
			JunControlUtility.Do_forMilliseconds_(new StBlockClosure() {
				public Object value() {
					ArrayList aList = new ArrayList();
					double x = n.doubleValue();
					JunPlane aPlane = JunPlane.On_normalVector_(new Jun3dPoint(0.5, 0.5, 0.5), new Jun3dPoint(1, -1, 0)).translatedBy_(new Jun3dPoint(x, -x, 0));
					JunOpenGL3dCompoundObject compoundObject = new JunOpenGL3dCompoundObject();
					for (int i = 0; i < arrayOfTriangles.length; i++) {
						Map aTable = arrayOfTriangles[i].tableDividedBy_(aPlane);
						JunOpenGL3dCompoundObject subCompoundObject = new JunOpenGL3dCompoundObject();
						subCompoundObject.add_(PrivatePlaneBody(aPlane));
						subCompoundObject.add_(PrivateColorBody(aTable));
						subCompoundObject.add_(JunOpenGL3dObject.Axes().scaledBy_(1.5));
						compoundObject.add_(subCompoundObject);
						aList.addAll((Collection) aTable.get($("points")));
					}

					foreDisplayModel.displayObject_(compoundObject);
					backDisplayModel.displayObject_(compoundObject);
					lineDisplayModel.displayObject_(PrivateLineBody(aList));
					sectDisplayModel.displayObject_(PrivateSectBody(aList));
					foreDisplayModel.changed_($("object"));
					backDisplayModel.changed_($("object"));
					lineDisplayModel.changed_($("object"));
					sectDisplayModel.changed_($("object"));
					return null;
				}
			}, 100);
		}

		return true;
	}

	/**
	 * ExampleH: 
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean ExampleH() {
		/*
		 aTriangle := Jun3dTriangle 
		 on: 1 , 0 , 0
		 on: 0 , 1 , 0
		 on: 0 , 0 , 1.
		 compoundObject := JunOpenGL3dCompoundObject new.
		 compoundObject add: aTriangle asJunOpenGL3dObject.
		 aTriangle threePlanes 
		 do: [:aPlane | compoundObject add: aPlane asJunOpenGL3dObject].
		 compoundObject add: (JunOpenGL3dObject axes scaledBy: 1.2).
		 compoundObject show.
		 ^aTriangle
		 */

		Jun3dTriangle aTriangle = Jun3dTriangle.On_on_on_(new Jun3dPoint(1, 0, 0), new Jun3dPoint(0, 1, 0), new Jun3dPoint(0, 0, 1));
		JunOpenGL3dCompoundObject compoundObject = new JunOpenGL3dCompoundObject();
		compoundObject.add_(aTriangle.asJunOpenGL3dObject());
		JunPlane[] planes = aTriangle.threePlanes();
		for (int i = 0; i < planes.length; i++) {
			compoundObject.add_(planes[i].asJunOpenGL3dObject());
		}
		compoundObject.add_(JunOpenGL3dObject.Axes().scaledBy_(1.2));
		compoundObject.show();

		return true;
	}

	/**
	 * Create a body from the plane.
	 * 
	 * @param aPlane jp.co.sra.jun.geometry.surfaces.JunPlane
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Private 
	 */
	private static JunOpenGL3dObject PrivatePlaneBody(JunPlane aPlane) {
		Jun3dCircle aCircle = new Jun3dCircle(aPlane.p1(), 1, aPlane.normalVector());
		JunOpenGL3dPolygon aPolygon = new JunOpenGL3dPolygon(aCircle.trackPoints());
		aPolygon.paint_(Color.magenta);
		aPolygon.halftone_(0.5);
		return aPolygon;
	}

	/**
	 * Create a body from the table.
	 * 
	 * @param aTable java.util.Map
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Private
	 */
	private static JunOpenGL3dObject PrivateTableBody(Map aTable) {
		JunOpenGL3dCompoundObject compoundObject = new JunOpenGL3dCompoundObject();

		Iterator i = ((List) aTable.get($("positives"))).iterator();
		while (i.hasNext()) {
			compoundObject.add_(((JunGeometry) i.next()).asJunOpenGL3dObjectColor_(Color.cyan));
		}
		i = ((List) aTable.get($("zeros"))).iterator();
		while (i.hasNext()) {
			compoundObject.add_(((JunGeometry) i.next()).asJunOpenGL3dObjectColor_(Color.gray));
		}
		i = ((List) aTable.get($("negatives"))).iterator();
		while (i.hasNext()) {
			compoundObject.add_(((JunGeometry) i.next()).asJunOpenGL3dObjectColor_(Color.yellow));
		}
		i = ((List) aTable.get($("points"))).iterator();
		while (i.hasNext()) {
			compoundObject.add_(((JunGeometry) i.next()).asJunOpenGL3dObjectColor_(Color.black));
		}

		return compoundObject;
	}

	/**
	 * Create a color body from the table.
	 * 
	 * @param aTable java.util.Map
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Private 
	 */
	private static JunOpenGL3dObject PrivateColorBody(Map aTable) {
		JunOpenGL3dCompoundObject compoundObject = new JunOpenGL3dCompoundObject();

		for (Iterator iterator = ((List) aTable.get($("positives"))).iterator(); iterator.hasNext();) {
			Jun3dTriangle aTriangle = (Jun3dTriangle) iterator.next();
			Jun3dPoint[] arrayOfPoints = new Jun3dPoint[] { aTriangle.first(), aTriangle.second(), aTriangle.third() };
			Color[] arrayOfColors = new Color[arrayOfPoints.length];
			for (int i = 0; i < arrayOfColors.length; i++) {
				arrayOfColors[i] = new Color((float) arrayOfPoints[i].x(), (float) arrayOfPoints[i].y(), (float) arrayOfPoints[i].z());
			}
			JunOpenGL3dPolygon aPolygon = new JunOpenGL3dPolygon(arrayOfPoints, arrayOfColors);
			compoundObject.add_(aPolygon);
		}
		for (Iterator iterator = ((List) aTable.get($("zeros"))).iterator(); iterator.hasNext();) {
			compoundObject.add_(((JunGeometry) iterator.next()).asJunOpenGL3dObjectColor_(Color.gray));
		}
		for (Iterator iterator = ((List) aTable.get($("negatives"))).iterator(); iterator.hasNext();) {
			Jun3dTriangle aTriangle = (Jun3dTriangle) iterator.next();
			Jun3dPoint[] arrayOfPoints = new Jun3dPoint[] { aTriangle.first(), aTriangle.second(), aTriangle.third() };
			Color[] arrayOfColors = new Color[arrayOfPoints.length];
			for (int i = 0; i < arrayOfColors.length; i++) {
				arrayOfColors[i] = new Color((float) arrayOfPoints[i].x(), (float) arrayOfPoints[i].y(), (float) arrayOfPoints[i].z());
			}
			JunOpenGL3dPolygon aPolygon = new JunOpenGL3dPolygon(arrayOfPoints, arrayOfColors);
			compoundObject.add_(aPolygon);
		}
		for (Iterator iterator = ((List) aTable.get($("points"))).iterator(); iterator.hasNext();) {
			compoundObject.add_(((JunGeometry) iterator.next()).asJunOpenGL3dObjectColor_(Color.black));
		}

		return compoundObject;
	}

	/**
	 * Create a line body from the collection of points.
	 * 
	 * @param intersectingPoints java.util.Collection
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Private 
	 */
	private static JunOpenGL3dObject PrivateLineBody(Collection intersectingPoints) {
		JunOpenGL3dCompoundObject compoundObject = new JunOpenGL3dCompoundObject();
		if (intersectingPoints.isEmpty() == false) {
			JunPointsOnPlane pointsOnPlane = new JunPointsOnPlane(intersectingPoints);
			Jun3dPoint[] arrayOfPoints = pointsOnPlane.sortedPoints();
			compoundObject.add_(new Jun3dPolyline(arrayOfPoints).asJunOpenGL3dObjectColor_(Color.black));
			for (int i = 0; i < arrayOfPoints.length; i++) {
				Color aColor = Color.getHSBColor((float) i / arrayOfPoints.length, 1, 1);
				compoundObject.add_(arrayOfPoints[i].asJunOpenGL3dObjectColor_(aColor));
			}
		}
		compoundObject.add_(JunOpenGL3dObject.Axes().scaledBy_(1.5));
		return compoundObject;
	}

	/**
	 * Create a sect body from the collection of points.
	 * 
	 * @param intersectingPoints java.util.Collection
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Private 
	 */
	private static JunOpenGL3dObject PrivateSectBody(Collection intersectingPoints) {
		JunOpenGL3dCompoundObject compoundObject = new JunOpenGL3dCompoundObject();
		if (intersectingPoints.isEmpty() == false) {
			JunPointsOnPlane pointsOnPlane = new JunPointsOnPlane(intersectingPoints);
			Jun3dPoint[] arrayOfPoints = pointsOnPlane.sortedPoints();
			Color[] arrayOfColors = new Color[arrayOfPoints.length];
			for (int i = 0; i < arrayOfColors.length; i++) {
				arrayOfColors[i] = new Color((float) arrayOfPoints[i].x(), (float) arrayOfPoints[i].y(), (float) arrayOfPoints[i].z());
			}
			if (arrayOfPoints.length > 2) {
				JunOpenGL3dPolygon aPolygon = new JunOpenGL3dPolygon(arrayOfPoints, arrayOfColors);
				compoundObject.add_(aPolygon);
			} else {
				JunOpenGL3dPolyline aPolyline = new JunOpenGL3dPolyline(arrayOfPoints, arrayOfColors);
				compoundObject.add_(aPolyline);
			}
		}
		compoundObject.add_(JunOpenGL3dObject.Axes().scaledBy_(1.5));
		return compoundObject;
	}

	/**
	 * Create a projection table.
	 * 
	 * @return java.util.Map
	 * @category Private
	 */
	private static Map PrivateProjectionTable() {
		HashMap projectionTable = new HashMap();
		projectionTable.put($("viewFactor"), new Double(10));
		projectionTable.put($("presentation"), $("soldPresentation"));
		projectionTable.put($("eyePoint"), new Jun3dPoint(14.477702891463d, 9.1335346899163d, 5.5654885728598d));
		projectionTable.put($("upVector"), new Jun3dPoint(-0.26322225132661d, -0.1622475126126d, 0.95099410674177d));
		projectionTable.put($("sightPoint"), new Jun3dPoint(0.0, 0.0, 0.0));
		projectionTable.put($("shading"), $("smoothShading"));
		projectionTable.put($("zoomHeight"), new Double(3.5));
		return projectionTable;
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args java.lang.String[]
	 * @category Main
	 */
	public static void main(String[] args) {
		new Jun3dTriangleTestExamples();
	}

}
