package jp.co.sra.jun.geometry.surfaces;

import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.curves.Jun3dPolyline;
import jp.co.sra.jun.system.support.JunTestExamples;

/**
 * Jun3dCircleTestExamples class
 * 
 *  @author    Mitsuhiro Asada
 *  @created   2004/12/21 (by Mitsuhiro Asada)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun610 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: Jun3dCircleTestExamples.java,v 8.10 2008/02/20 06:30:58 nisinaka Exp $
 */
public class Jun3dCircleTestExamples extends JunTestExamples {

	/**
	 * Example1:
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example1() {
		Jun3dCircle aCircle = new Jun3dCircle(new Jun3dPoint(1, 1, 1), 1, new Jun3dPoint(0, 1, 1));
		System.out.println(aCircle.printString());
		System.out.println(aCircle.storeString());
		System.out.println("area: " + aCircle.area());
		System.out.println("volume:" + aCircle.volume());
		aCircle.asJunOpenGL3dObject().showWithUnitAxes();

		return true;
	}

	/**
	 * Test_trackPoints:
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Test_trackPoints() {
		Jun3dPoint centerPoint = new Jun3dPoint(1.0 / 3.0, 1.0 / 3.0, 1.0 / 3.0);
		double radius = centerPoint.distance_(new Jun3dPoint(0, 0, 1));
		Jun3dPoint upVector = new Jun3dPoint(1, 1, 1);
		Jun3dCircle aCircle = new Jun3dCircle(centerPoint, radius, upVector);
		Jun3dPolyline aPolyline = new Jun3dPolyline(aCircle.trackPoints());
		aPolyline.asJunOpenGL3dObject().showWithAxes();

		return true;
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args an array of command-line arguments
	 * @category Main
	 */
	public static void main(String[] args) {
		new Jun3dCircleTestExamples();
	}
}
