package jp.co.sra.jun.geometry.surfaces;

import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.system.support.JunTestExamples;

/**
 * Jun2dCircleTestExamples class
 * 
 *  @author    Mitsuhiro Asada
 *  @created   2004/12/21 (by Mitsuhiro Asada)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun610 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: Jun2dCircleTestExamples.java,v 8.10 2008/02/20 06:30:58 nisinaka Exp $
 */
public class Jun2dCircleTestExamples extends JunTestExamples {
	/**
	 * Example
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example1() {
		Jun2dCircle aCircle = new Jun2dCircle(new Jun2dPoint(1, 1), 1);
		System.out.println(aCircle.printString());
		System.out.println(aCircle.storeString());
		System.out.println("area: " + aCircle.area());
		System.out.println("volume:" + aCircle.volume());
		aCircle.asJunOpenGL3dObject().showWithUnitAxes();

		return true;
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args an array of command-line arguments
	 * @category Main
	 */
	public static void main(String[] args) {
		new Jun2dCircleTestExamples();
	}
}
