package jp.co.sra.jun.geometry.support;

import java.awt.Color;
import java.awt.Frame;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.basic.JunAngle;
import jp.co.sra.jun.geometry.basic.JunPoint;
import jp.co.sra.jun.geometry.transformations.Jun2dTransformation;
import jp.co.sra.jun.geometry.transformations.Jun3dTransformation;
import jp.co.sra.jun.opengl.display.JunOpenGLDisplayModel;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dCompoundObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.system.support.JunTestExamples;

/**
 * JunPointSorterTestExamples class
 * 
 *  @author    Mitsuhiro Asada
 *  @created   2004/12/03 (by Mitsuhiro Asada)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun608 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunPointSorterTestExamples.java,v 8.12 2008/02/20 06:30:58 nisinaka Exp $
 */
public class JunPointSorterTestExamples extends JunTestExamples {
	/**
	 * Example: a Jun2dPoints sorter.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example21() {
		JunPointSorter pointSorter = new JunPointSorter(Example2dPoints());
		StBlockClosure aBlock = new StBlockClosure() {
			public Object value_value_value_(Object obj1, Object obj2, Object obj3) {
				Collection pointCollection = (Collection) obj1;
				String labelString = (String) obj2;
				Rectangle displayBox = (Rectangle) obj3;

				JunOpenGL3dCompoundObject compoundObject = new JunOpenGL3dCompoundObject();
				JunPoint[] _pointCollection = JunPointSorter._AsJunPointArray_(pointCollection);
				for (int aNumber = 0; aNumber < _pointCollection.length; aNumber++) {
					JunPoint aPoint = _pointCollection[aNumber];
					Color colorValue = Color.getHSBColor(aNumber / (float) pointCollection.size(), 1, 1);
					compoundObject.add_(aPoint.asJunOpenGL3dObjectColor_(colorValue));
				}
				compoundObject.add_(JunOpenGL3dObject.XyzArrows().scaledBy_(300));
				Hashtable aDictionary = new Hashtable();
				aDictionary.put($("upVector"), new Jun3dPoint(0, 1, 0));
				aDictionary.put($("zoomHeight"), new Integer(400));
				aDictionary.put($("shading"), $("smoothShading"));
				aDictionary.put($("eyePoint"), new Jun3dPoint(128, 128, 10000));
				aDictionary.put($("viewFactor"), new Integer(10));
				aDictionary.put($("presentation"), $("solidPresentation"));
				aDictionary.put($("sightPoint"), new Jun3dPoint(128, 128, 0));
				JunOpenGLDisplayModel displayModel = compoundObject.showProjectionTable_in_(aDictionary, displayBox);
				// displayModel.useDisplayList_(false);
				((Frame) displayModel.getWindow()).setTitle(labelString);

				return null;
			}
		};
		aBlock.value_value_value_(pointSorter.sourcePoints(), "SourcePoints", new Rectangle(80, 250, 300, 300));
		aBlock.value_value_value_(pointSorter.sortedPoints(), "SortedPoints", new Rectangle(390, 250, 300, 300));

		return true;
	}

	/**
	 * Example: a Jun2dPoints sorter.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example22() {
		JunPointSorter pointSorter = new JunPointSorter(Example2dPoints(), new Jun2dPoint(0, 10000), new Jun2dPoint(1, 0));
		StBlockClosure aBlock = new StBlockClosure() {
			public Object value_value_value_(Object obj1, Object obj2, Object obj3) {
				Collection pointCollection = (Collection) obj1;
				String labelString = (String) obj2;
				Rectangle displayBox = (Rectangle) obj3;

				JunOpenGL3dCompoundObject compoundObject = new JunOpenGL3dCompoundObject();
				JunPoint[] _pointCollection = JunPointSorter._AsJunPointArray_(pointCollection);
				for (int aNumber = 0; aNumber < _pointCollection.length; aNumber++) {
					JunPoint aPoint = _pointCollection[aNumber];
					Color colorValue = Color.getHSBColor(aNumber / (float) pointCollection.size(), 1, 1);
					compoundObject.add_(aPoint.asJunOpenGL3dObjectColor_(colorValue));
				}
				compoundObject.add_(JunOpenGL3dObject.XyzArrows().scaledBy_(300));
				Hashtable aDictionary = new Hashtable();
				aDictionary.put($("upVector"), new Jun3dPoint(0, 1, 0));
				aDictionary.put($("zoomHeight"), new Integer(400));
				aDictionary.put($("shading"), $("smoothShading"));
				aDictionary.put($("eyePoint"), new Jun3dPoint(128, 128, 10000));
				aDictionary.put($("viewFactor"), new Integer(10));
				aDictionary.put($("presentation"), $("solidPresentation"));
				aDictionary.put($("sightPoint"), new Jun3dPoint(128, 128, 0));
				JunOpenGLDisplayModel displayModel = compoundObject.showProjectionTable_in_(aDictionary, displayBox);
				// displayModel.useDisplayList_(false);
				((Frame) displayModel.getWindow()).setTitle(labelString);

				return null;
			}
		};
		aBlock.value_value_value_(pointSorter.sourcePoints(), "SourcePoints", new Rectangle(80, 250, 300, 300));
		aBlock.value_value_value_(pointSorter.sortedPoints(), "SortedPoints", new Rectangle(390, 250, 300, 300));

		return true;
	}

	/**
	 * Example: a Jun2dPoints sorter.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example23() {
		JunPointSorter pointSorter = new JunPointSorter(Example2dPoints(), new Jun3dPoint(0, 0, 10000), new Jun3dPoint(0, 1, 0));
		StBlockClosure aBlock = new StBlockClosure() {
			public Object value_value_value_(Object obj1, Object obj2, Object obj3) {
				Collection pointCollection = (Collection) obj1;
				String labelString = (String) obj2;
				Rectangle displayBox = (Rectangle) obj3;

				JunOpenGL3dCompoundObject compoundObject = new JunOpenGL3dCompoundObject();
				JunPoint[] _pointCollection = JunPointSorter._AsJunPointArray_(pointCollection);
				for (int aNumber = 0; aNumber < _pointCollection.length; aNumber++) {
					JunPoint aPoint = _pointCollection[aNumber];
					Color colorValue = Color.getHSBColor(aNumber / (float) pointCollection.size(), 1, 1);
					compoundObject.add_(aPoint.asJunOpenGL3dObjectColor_(colorValue));
				}
				compoundObject.add_(JunOpenGL3dObject.XyzArrows().scaledBy_(300));
				Hashtable aDictionary = new Hashtable();
				aDictionary.put($("upVector"), new Jun3dPoint(0, 1, 0));
				aDictionary.put($("zoomHeight"), new Integer(400));
				aDictionary.put($("shading"), $("smoothShading"));
				aDictionary.put($("eyePoint"), new Jun3dPoint(128, 128, 10000));
				aDictionary.put($("viewFactor"), new Integer(10));
				aDictionary.put($("presentation"), $("solidPresentation"));
				aDictionary.put($("sightPoint"), new Jun3dPoint(128, 128, 0));
				JunOpenGLDisplayModel displayModel = compoundObject.showProjectionTable_in_(aDictionary, displayBox);
				// displayModel.useDisplayList_(false);
				((Frame) displayModel.getWindow()).setTitle(labelString);

				return null;
			}
		};
		aBlock.value_value_value_(pointSorter.sourcePoints(), "SourcePoints", new Rectangle(80, 250, 300, 300));
		aBlock.value_value_value_(pointSorter.sortedPoints(), "SortedPoints", new Rectangle(390, 250, 300, 300));

		return true;
	}

	/**
	 * Example: collection of a Jun2dPoint.
	 * 
	 * @return java.util.Collection
	 * @category Examples
	 */
	public static Collection Example2dPoints() {
		ArrayList aStream = new ArrayList();
		aStream.add(new Jun2dPoint(115, 142));
		aStream.add(new Jun2dPoint(109, 136));
		aStream.add(new Jun2dPoint(97, 119));
		aStream.add(new Jun2dPoint(92, 111));
		aStream.add(new Jun2dPoint(90, 100));
		aStream.add(new Jun2dPoint(95, 78));
		aStream.add(new Jun2dPoint(102, 64));
		aStream.add(new Jun2dPoint(116, 50));
		aStream.add(new Jun2dPoint(132, 49));
		aStream.add(new Jun2dPoint(142, 55));
		aStream.add(new Jun2dPoint(154, 66));
		aStream.add(new Jun2dPoint(160, 83));
		aStream.add(new Jun2dPoint(160, 99));
		aStream.add(new Jun2dPoint(156, 110));
		aStream.add(new Jun2dPoint(153, 123));
		aStream.add(new Jun2dPoint(152, 131));
		aStream.add(new Jun2dPoint(156, 137));
		aStream.add(new Jun2dPoint(165, 141));
		aStream.add(new Jun2dPoint(180, 144));
		aStream.add(new Jun2dPoint(198, 149));
		aStream.add(new Jun2dPoint(210, 158));
		aStream.add(new Jun2dPoint(215, 168));
		aStream.add(new Jun2dPoint(215, 182));
		aStream.add(new Jun2dPoint(210, 191));
		aStream.add(new Jun2dPoint(199, 194));
		aStream.add(new Jun2dPoint(183, 190));
		aStream.add(new Jun2dPoint(170, 184));
		aStream.add(new Jun2dPoint(162, 183));
		aStream.add(new Jun2dPoint(149, 187));
		aStream.add(new Jun2dPoint(140, 193));
		aStream.add(new Jun2dPoint(132, 199));
		aStream.add(new Jun2dPoint(122, 206));
		aStream.add(new Jun2dPoint(110, 210));
		aStream.add(new Jun2dPoint(96, 210));
		aStream.add(new Jun2dPoint(83, 207));
		aStream.add(new Jun2dPoint(74, 203));
		aStream.add(new Jun2dPoint(71, 195));
		aStream.add(new Jun2dPoint(73, 185));
		aStream.add(new Jun2dPoint(81, 178));
		aStream.add(new Jun2dPoint(94, 173));
		aStream.add(new Jun2dPoint(106, 172));
		aStream.add(new Jun2dPoint(112, 170));
		aStream.add(new Jun2dPoint(117, 169));
		aStream.add(new Jun2dPoint(124, 165));
		aStream.add(new Jun2dPoint(125, 162));
		aStream.add(new Jun2dPoint(125, 159));

		ArrayList anArray = new ArrayList();
		JunPoint[] _aStream = JunPointSorter._AsJunPointArray_(aStream);
		for (int i = 0; i < _aStream.length; i++) {
			Jun2dPoint aPoint = (Jun2dPoint) _aStream[i];
			anArray.add(aPoint.transform_(Jun2dTransformation.Unity()));
		}
		for (int index = 1; index <= anArray.size() / 2; index++) {
			Object temp = anArray.get(index - 1);
			anArray.set(index - 1, anArray.get(index * 2 - 1));
			anArray.set(index * 2 - 1, temp);
		}
		return anArray;
	}

	/**
	 * Example: a Jun2dPoints sorter.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example31() {
		JunPointSorter pointSorter = new JunPointSorter(Example3dPoints());
		StBlockClosure aBlock = new StBlockClosure() {
			public Object value_value_value_(Object obj1, Object obj2, Object obj3) {
				Collection pointCollection = (Collection) obj1;
				String labelString = (String) obj2;
				Rectangle displayBox = (Rectangle) obj3;

				JunOpenGL3dCompoundObject compoundObject = new JunOpenGL3dCompoundObject();
				JunPoint[] _pointCollection = JunPointSorter._AsJunPointArray_(pointCollection);
				for (int aNumber = 0; aNumber < _pointCollection.length; aNumber++) {
					JunPoint aPoint = _pointCollection[aNumber];
					Color colorValue = Color.getHSBColor(aNumber / (float) pointCollection.size(), 1, 1);
					compoundObject.add_(aPoint.asJunOpenGL3dObjectColor_(colorValue));
				}
				compoundObject.add_(JunOpenGL3dObject.XyzArrows().scaledBy_(250));
				Hashtable aDictionary = new Hashtable();
				aDictionary.put($("upVector"), new Jun3dPoint(0, 0, 1));
				aDictionary.put($("zoomHeight"), new Integer(450));
				aDictionary.put($("shading"), $("smoothShading"));
				aDictionary.put($("eyePoint"), new Jun3dPoint(10000, 10000, 10000));
				aDictionary.put($("viewFactor"), new Integer(10));
				aDictionary.put($("presentation"), $("solidPresentation"));
				aDictionary.put($("sightPoint"), new Jun3dPoint(0, 0, 0));
				JunOpenGLDisplayModel displayModel = compoundObject.showProjectionTable_in_(aDictionary, displayBox);
				// displayModel.useDisplayList_(false);
				((Frame) displayModel.getWindow()).setTitle(labelString);

				return null;
			}
		};
		aBlock.value_value_value_(pointSorter.sourcePoints(), "SourcePoints", new Rectangle(80, 250, 300, 300));
		aBlock.value_value_value_(pointSorter.sortedPoints(), "SortedPoints", new Rectangle(390, 250, 300, 300));

		return true;
	}

	/**
	 * Example: a Jun2dPoints sorter.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example32() {
		JunPointSorter pointSorter = new JunPointSorter(Example3dPoints(), new Jun3dPoint(0, 10000, 0), new Jun3dPoint(1, 0, 0));
		StBlockClosure aBlock = new StBlockClosure() {
			public Object value_value_value_(Object obj1, Object obj2, Object obj3) {
				Collection pointCollection = (Collection) obj1;
				String labelString = (String) obj2;
				Rectangle displayBox = (Rectangle) obj3;

				JunOpenGL3dCompoundObject compoundObject = new JunOpenGL3dCompoundObject();
				JunPoint[] _pointCollection = JunPointSorter._AsJunPointArray_(pointCollection);
				for (int aNumber = 0; aNumber < _pointCollection.length; aNumber++) {
					JunPoint aPoint = _pointCollection[aNumber];
					Color colorValue = Color.getHSBColor(aNumber / (float) pointCollection.size(), 1, 1);
					compoundObject.add_(aPoint.asJunOpenGL3dObjectColor_(colorValue));
				}
				compoundObject.add_(JunOpenGL3dObject.XyzArrows().scaledBy_(250));
				Hashtable aDictionary = new Hashtable();
				aDictionary.put($("upVector"), new Jun3dPoint(0, 0, 1));
				aDictionary.put($("zoomHeight"), new Integer(450));
				aDictionary.put($("shading"), $("smoothShading"));
				aDictionary.put($("eyePoint"), new Jun3dPoint(10000, 10000, 10000));
				aDictionary.put($("viewFactor"), new Integer(10));
				aDictionary.put($("presentation"), $("solidPresentation"));
				aDictionary.put($("sightPoint"), new Jun3dPoint(0, 0, 0));
				JunOpenGLDisplayModel displayModel = compoundObject.showProjectionTable_in_(aDictionary, displayBox);
				// displayModel.useDisplayList_(false);
				((Frame) displayModel.getWindow()).setTitle(labelString);

				return null;
			}
		};
		aBlock.value_value_value_(pointSorter.sourcePoints(), "SourcePoints", new Rectangle(80, 250, 300, 300));
		aBlock.value_value_value_(pointSorter.sortedPoints(), "SortedPoints", new Rectangle(390, 250, 300, 300));

		return true;
	}

	/**
	 * Example: a Jun2dPoints sorter.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example33() {
		JunPointSorter pointSorter = new JunPointSorter(Example3dPoints(), new Jun3dPoint(0, 0, 10000), new Jun3dPoint(0, 1, 0));
		StBlockClosure aBlock = new StBlockClosure() {
			public Object value_value_value_(Object obj1, Object obj2, Object obj3) {
				Collection pointCollection = (Collection) obj1;
				String labelString = (String) obj2;
				Rectangle displayBox = (Rectangle) obj3;

				JunOpenGL3dCompoundObject compoundObject = new JunOpenGL3dCompoundObject();
				JunPoint[] _pointCollection = JunPointSorter._AsJunPointArray_(pointCollection);
				for (int aNumber = 0; aNumber < _pointCollection.length; aNumber++) {
					JunPoint aPoint = _pointCollection[aNumber];
					Color colorValue = Color.getHSBColor(aNumber / (float) pointCollection.size(), 1, 1);
					compoundObject.add_(aPoint.asJunOpenGL3dObjectColor_(colorValue));
				}
				compoundObject.add_(JunOpenGL3dObject.XyzArrows().scaledBy_(250));
				Hashtable aDictionary = new Hashtable();
				aDictionary.put($("upVector"), new Jun3dPoint(0, 0, 1));
				aDictionary.put($("zoomHeight"), new Integer(450));
				aDictionary.put($("shading"), $("smoothShading"));
				aDictionary.put($("eyePoint"), new Jun3dPoint(10000, 10000, 10000));
				aDictionary.put($("viewFactor"), new Integer(10));
				aDictionary.put($("presentation"), $("solidPresentation"));
				aDictionary.put($("sightPoint"), new Jun3dPoint(0, 0, 0));
				JunOpenGLDisplayModel displayModel = compoundObject.showProjectionTable_in_(aDictionary, displayBox);
				// displayModel.useDisplayList_(false);
				((Frame) displayModel.getWindow()).setTitle(labelString);

				return null;
			}
		};
		aBlock.value_value_value_(pointSorter.sourcePoints(), "SourcePoints", new Rectangle(80, 250, 300, 300));
		aBlock.value_value_value_(pointSorter.sortedPoints(), "SortedPoints", new Rectangle(390, 250, 300, 300));

		return true;
	}

	/**
	 * Example: collection of a Jun3dPoint.
	 * 
	 * @return java.util.Collection
	 * @category Examples
	 */
	public static Collection Example3dPoints() {
		ArrayList anArray = new ArrayList();
		JunPoint[] points = JunPointSorter._AsJunPointArray_(Example2dPoints());
		for (int i = 0; i < points.length; i++) {
			Jun3dPoint aPoint = Jun3dPoint.Coerce_(points[i]);
			aPoint = aPoint.transform_(Jun3dTransformation.RotateX_(JunAngle.FromDeg_(-45)).product_(Jun3dTransformation.Translate_(new Jun3dPoint(-50, 0, 50))));
			anArray.add(aPoint);
		}
		for (int index = 1; index <= anArray.size() / 2; index++) {
			Object temp = anArray.get(index - 1);
			anArray.set(index - 1, anArray.get(index * 2 - 1));
			anArray.set(index * 2 - 1, temp);
		}
		return anArray;
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args java.lang.String[]
	 * @category Main
	 */
	public static void main(String[] args) {
		new JunPointSorterTestExamples();
	}
}
