package jp.co.sra.jun.geometry.pluralities;

import java.awt.Rectangle;
import java.util.Collection;

/**
 * JunBoundingBoxes class
 * 
 *  @author    Mitsuhiro Asada
 *  @created   2006/04/24 (by Mitsuhiro Asada)
 *  @updated   2007/05/29 (by Mitsuhiro Asada)
 *  @version   699 (with StPL8.9) based on Jun667 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunBoundingBoxes.java,v 8.13 2008/02/20 06:30:57 nisinaka Exp $
 */
public abstract class JunBoundingBoxes extends JunBoundingObjects {
	/**
	 * Answer the default partition size;
	 * 
	 * @return int
	 * @category Defaults
	 */
	public static final int DefaultPartitionSize() {
		return 10;
	}

	/**
	 * Create a new instance of JunBoundingBoxes and initialize it.
	 *
	 * @category Instance creation
	 */
	protected JunBoundingBoxes() {
		super();
	}

	/**
	 * Set my bounding boxes.
	 * 
	 * @param boundingBoxCollection java.util.Collection
	 * @category accessing
	 */
	public void boundingBoxes_(Collection boundingBoxCollection) {
		this.boundingObjects_(boundingBoxCollection);
	}

	/**
	 * Convert to a Rectangle.
	 * 
	 * @return java.awt.Rectangle
	 * @category converting
	 */
	public abstract Rectangle asRectangle();

	/**
	 * Convert to an array of Rectangle.
	 * 
	 * @return java.awt.Rectangle[]
	 * @category converting
	 */
	public abstract Rectangle[] asRectangles();

	/**
	 * Answer true if the receiver is a bounding boxes, otherwise false.
	 * 
	 * @return boolean
	 * @see jp.co.sra.jun.geometry.abstracts.JunGeometry#isBoundingBoxes()
	 * @category testing
	 */
	public boolean isBoundingBoxes() {
		return true;
	}
}
