package jp.co.sra.jun.geometry.pluralities;

import java.util.Collection;

import jp.co.sra.jun.geometry.abstracts.JunGeometry;
import jp.co.sra.jun.geometry.boundaries.Jun3dBoundingBall;
import jp.co.sra.jun.geometry.boundaries.Jun3dBoundingBox;
import jp.co.sra.jun.geometry.surfaces.Jun3dTriangle;
import jp.co.sra.jun.geometry.transformations.Jun3dTransformation;

/**
 * Jun3dTriangles class
 * 
 *  @author    Mitsuhiro Asada
 *  @created   2007/06/05 (by m-asada)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun667 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: Jun3dTriangles.java,v 8.5 2008/02/20 06:30:57 nisinaka Exp $
 */
public class Jun3dTriangles extends JunTriangles {
	/**
	 * Create a new instance of <code>Jun3dTriangles</code> and initialize it.
	 * 
	 * @category Instance creation
	 */
	public Jun3dTriangles() {
		super();
	}

	/**
	 * Create a new instance of <code>Jun3dTriangles</code> and initialize it.
	 * 
	 * @param triangleCollection java.util.Collection
	 * @category Instance creation
	 */
	public Jun3dTriangles(Collection triangleCollection) {
		super(triangleCollection);
	}

	/**
	 * Create a new instance of <code>Jun3dTriangles</code> and initialize it.
	 * 
	 * @param triangleCollection jp.co.sra.jun.geometry.surfaces.Jun3dTriangle[]
	 * @category Instance creation
	 */
	public Jun3dTriangles(Jun3dTriangle[] triangleCollection) {
		super(triangleCollection);
	}

	/**
	 * Answer my current bounding ball.
	 * 
	 * @return jp.co.sra.jun.geometry.boundaries.Jun3dBoundingBall
	 * @category accessing
	 */
	public Jun3dBoundingBall boundingBall() {
		if (this.isEmpty()) {
			return new Jun3dBoundingBall(null);
		}
		Jun3dBoundingBall boundingBall = null;
		JunGeometry[] objects = this.geometries();
		for (int i = 0; i < objects.length; i++) {
			Jun3dTriangle each = (Jun3dTriangle) objects[i];
			if (boundingBall == null) {
				boundingBall = each.boundingBall();
			} else {
				boundingBall = each.boundingBall().merge_(boundingBall);
			}
		}
		return boundingBall;
	}

	/**
	 * Answer my current bounding box.
	 * 
	 * @return jp.co.sra.jun.geometry.boundaries.Jun3dBoundingBox
	 * @category accessing
	 */
	public Jun3dBoundingBox boundingBox() {
		if (this.isEmpty()) {
			return new Jun3dBoundingBox();
		}
		Jun3dBoundingBox boundingBox = null;
		JunGeometry[] objects = this.geometries();
		for (int i = 0; i < objects.length; i++) {
			Jun3dTriangle each = (Jun3dTriangle) objects[i];
			if (boundingBox == null) {
				boundingBox = each.boundingBox();
			} else {
				boundingBox = each.boundingBox().merge_(boundingBox);
			}
		}
		return boundingBox;
	}

	/**
	 * Answer the receiver's triangles.
	 * 
	 * @return jp.co.sra.jun.geometry.surfaces.Jun3dTriangle[]
	 * @category accessing
	 */
	public Jun3dTriangle[] triangles() {
		return (Jun3dTriangle[]) this._geometries().toArray(new Jun3dTriangle[this._geometries().size()]);
	}

	/**
	 * Convert to a <code>Jun2dBoundingBall</code>.
	 * 
	 * @return jp.co.sra.jun.geometry.boundaries.Jun3dBoundingBall
	 * @category converting
	 */
	public Jun3dBoundingBall asBoundingBall() {
		return this.boundingBall();
	}

	/**
	 * Convert to a <code>Jun2dBoundingBox</code>.
	 * 
	 * @return jp.co.sra.jun.geometry.boundaries.Jun3dBoundingBox
	 * @category converting
	 */
	public Jun3dBoundingBox asBoundingBox() {
		return this.boundingBox();
	}

	/**
	 * Answer the receiver's subdivide triangles.
	 * 
	 * @return jp.co.sra.jun.geometry.pluralities.Jun3dTriangles
	 * @category subdividing
	 */
	public Jun3dTriangles subdivide() {
		Jun3dTriangles copy = new Jun3dTriangles();
		Jun3dTriangle[] triangles = this.triangles();
		for (int i = 0; i < triangles.length; i++) {
			copy.addAll_(triangles[i].subdivide().geometries());
		}
		return copy;
	}

	/**
	 * Answer the receiver's subdivide triangles with specified level.
	 * 
	 * @param anInteger int
	 * @return jp.co.sra.jun.geometry.pluralities.Jun3dTriangles
	 * @category subdividing
	 */
	public Jun3dTriangles subdivideLevel_(int anInteger) {
		Jun3dTriangles copy = new Jun3dTriangles();
		Jun3dTriangle[] triangles = this.triangles();
		for (int i = 0; i < triangles.length; i++) {
			copy.addAll_(triangles[i].subdivideLevel_(anInteger).geometries());
		}
		return copy;
	}

	/**
	 * Answer true if the receiver is a 3d geometry element.
	 * 
	 * @return boolean
	 * @see jp.co.sra.jun.geometry.abstracts.JunGeometry#is3d()
	 * @category testing
	 */
	public boolean is3d() {
		return true;
	}

	/**
	 * Apply a transformation 'aTransformation' to the receiver.
	 * 
	 * @return jp.co.sra.jun.geometry.pluralities.Jun3dTriangles
	 * @param aTransformation jp.co.sra.jun.geometry.transformations.Jun3dTransformation
	 * @category transforming
	 */
	public Jun3dTriangles transform_(Jun3dTransformation aTransformation) {
		Jun3dTriangles transformedCopy = new Jun3dTriangles();
		JunGeometry[] geometries = this.geometries();
		for (int i = 0; i < geometries.length; i++) {
			this.add_(geometries[i].transform_(aTransformation));
		}
		return transformedCopy;
	}
}
