package jp.co.sra.jun.geometry.pluralities;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;

import jp.co.sra.smalltalk.StBlockClosure;

import jp.co.sra.jun.geometry.boundaries.Jun3dBoundingBall;
import jp.co.sra.jun.geometry.boundaries.Jun3dBoundingBox;
import jp.co.sra.jun.geometry.boundaries.JunBoundingBox;
import jp.co.sra.jun.geometry.boundaries.JunBoundingObject;
import jp.co.sra.jun.geometry.transformations.Jun3dTransformation;

/**
 * Jun3dBoundingBoxes class
 * 
 *  @author    m-asada
 *  @created   2006/04/24 (by m-asada)
 *  @updated   2007/05/29 (by Mitsuhiro Asada)
 *  @version   699 (with StPL8.9) based on Jun697 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: Jun3dBoundingBoxes.java,v 8.15 2008/02/20 06:30:57 nisinaka Exp $
 */
public class Jun3dBoundingBoxes extends JunBoundingBoxes {
	/**
	 * Create a new instance of <code>Jun3dBoundingBoxes</code> and initialize it.
	 * 
	 * @category Instance creation
	 */
	public Jun3dBoundingBoxes() {
		super();
	}

	/**
	 * Answer my current bounding ball.
	 * 
	 * @return jp.co.sra.jun.geometry.boundaries.Jun3dBoundingBall
	 * @category accessing
	 */
	public Jun3dBoundingBall boundingBall() {
		if (this.isEmpty()) {
			return new Jun3dBoundingBall(null);
		}
		Jun3dBoundingBall boundingBall = null;
		JunBoundingObject[] objects = this.boundingObjects();
		for (int i = 0; i < objects.length; i++) {
			Jun3dBoundingBox each = (Jun3dBoundingBox) objects[i];
			if (boundingBall == null) {
				boundingBall = each.boundingBall();
			} else {
				boundingBall = each.boundingBall().merge_(boundingBall);
			}
		}
		return boundingBall;
	}

	/**
	 * Answer my current bounding box.
	 * 
	 * @return jp.co.sra.jun.geometry.boundaries.Jun3dBoundingBox
	 * @category accessing
	 */
	public Jun3dBoundingBox boundingBox() {
		if (this.isEmpty()) {
			return new Jun3dBoundingBox();
		}
		Jun3dBoundingBox boundingBox = null;
		JunBoundingObject[] objects = this.boundingObjects();
		for (int i = 0; i < objects.length; i++) {
			Jun3dBoundingBox each = (Jun3dBoundingBox) objects[i];
			if (boundingBox == null) {
				boundingBox = each;
			} else {
				boundingBox = each.merge_(boundingBox);
			}
		}
		return boundingBox;
	}

	/**
	 * Answer my bounding boxes.
	 * 
	 * @return jp.co.sra.jun.geometry.boundaries.Jun3dBoundingBox[]
	 * @category accessing
	 */
	public Jun3dBoundingBox[] boundingBoxes() {
		return (Jun3dBoundingBox[]) this._boundingObjects().toArray(new Jun3dBoundingBox[this._boundingObjects().size()]);
	}

	/**
	 * Answer the this volume value.
	 * 
	 * @return double
	 * @see jp.co.sra.jun.geometry.abstracts.JunGeometry#volume()
	 * @category accessing
	 */
	public double volume() {
		double volume = 0.0d;
		JunBoundingObject[] myComponents = this.boundingObjects();
		for (int i = 0; i < myComponents.length; i++) {
			JunBoundingBox boundingBox = (JunBoundingBox) myComponents[i];
			volume = volume + boundingBox.volume();
		}
		return volume;
	}

	/**
	 * Convert to a Jun3dBoundingBall.
	 * 
	 * @return jp.co.sra.jun.geometry.boundaries.Jun3dBoundingBall
	 * @category converting
	 */
	public Jun3dBoundingBall asBoundingBall() {
		return this.boundingBall();
	}

	/**
	 * Convert to a Jun3dBoundingBox.
	 * 
	 * @return jp.co.sra.jun.geometry.boundaries.Jun3dBoundingBox
	 * @category converting
	 */
	public Jun3dBoundingBox asBoundingBox() {
		return this.boundingBox();
	}

	/**
	 * Convert to a Jun3dBoundingBoxes.
	 * 
	 * @return jp.co.sra.jun.geometry.pluralities.Jun3dBoundingBoxes
	 * @category converting
	 */
	public Jun3dBoundingBoxes asBoundingBoxes() {
		Jun3dBoundingBoxes boundingBoxes = new Jun3dBoundingBoxes();
		Collection collection = new ArrayList();
		collection.add(this);
		boundingBoxes.boundingBoxes_(collection);
		return boundingBoxes;
	}

	/**
	 * Convert to a Rectangle.
	 * 
	 * @return java.awt.Rectangle
	 * @see jp.co.sra.jun.geometry.pluralities.JunBoundingBoxes#asRectangle()
	 * @category converting
	 */
	public Rectangle asRectangle() {
		return this.asBoundingBox().asRectangle();
	}

	/**
	 * Convert to an array of Rectangle.
	 * 
	 * @return java.awt.Rectangle[]
	 * @see jp.co.sra.jun.geometry.pluralities.JunBoundingBoxes#asRectangles()
	 * @category converting
	 */
	public Rectangle[] asRectangles() {
		final Collection aCollection = new ArrayList();
		this.do_(new StBlockClosure() {
			public Object value_(Object obj) {
				JunBoundingBox boundingBox = (JunBoundingBox) obj;
				aCollection.add(boundingBox.asRectangle());
				return null;
			}
		});
		return (Rectangle[]) aCollection.toArray(new Rectangle[aCollection.size()]);
	}

	/**
	 * Answer the receiver's complement boxes.
	 * 
	 * @return jp.co.sra.jun.geometry.pluralities.Jun3dBoundingBoxes
	 * @category functions
	 */
	public Jun3dBoundingBoxes complementBoxes() {
		Jun3dBoundingBoxes complementBoxes = this.unionBoxes();
		Jun3dBoundingBox intersectionBox = this.intersectionBox();
		if (intersectionBox == null) {
			return complementBoxes;
		}

		Jun3dBoundingBox[] boundingObjects = complementBoxes.boundingBoxes();
		for (int i = 0; i < boundingObjects.length; i++) {
			if (boundingObjects[i].equals(intersectionBox)) {
				complementBoxes._boundingObjects().remove(boundingObjects[i]);
			}
		}
		complementBoxes = (Jun3dBoundingBoxes) complementBoxes.reject_(new StBlockClosure() {
			public Object value_(Object aBox) {
				return new Boolean(((Jun3dBoundingBox) aBox).isEmpty());
			}
		});
		return complementBoxes;
	}

	/**
	 * Answer the difference boxes.
	 * 
	 * @return jp.co.sra.jun.geometry.pluralities.Jun3dBoundingBoxes
	 * @category functions
	 */
	public Jun3dBoundingBoxes differenceBoxes() {
		if (this.isEmpty()) {
			return (Jun3dBoundingBoxes) this.copy();
		}

		Jun3dBoundingBox[] rectangles = this.boundingBoxes();
		Jun3dBoundingBox firstRectangle = rectangles[0];
		Jun3dBoundingBoxes differenceBoxes = new Jun3dBoundingBoxes();
		differenceBoxes.add_(firstRectangle);
		for (int i = 1; i < rectangles.length; i++) {
			Jun3dBoundingBox aRectangle = rectangles[i];
			Jun3dBoundingBoxes boundingBoxes = new Jun3dBoundingBoxes();
			JunBoundingObject[] myComponents = differenceBoxes.boundingObjects();
			for (int j = 0; j < myComponents.length; j++) {
				Jun3dBoundingBox each = (Jun3dBoundingBox) myComponents[j];
				if (each.intersects_(firstRectangle)) {
					boundingBoxes.addAll_(each.boxesOutside_(aRectangle));
				} else {
					boundingBoxes.add_(each);
				}
			}

			differenceBoxes = boundingBoxes;
		}
		differenceBoxes = (Jun3dBoundingBoxes) differenceBoxes.reject_(new StBlockClosure() {
			public Object value_(Object aBox) {
				return new Boolean(((Jun3dBoundingBox) aBox).isEmpty());
			}
		});
		return differenceBoxes;
	}

	/**
	 * Answer the intersection box.
	 * 
	 * @return jp.co.sra.jun.geometry.boundaries.Jun3dBoundingBox
	 * @category functions
	 */
	public Jun3dBoundingBox intersectionBox() {
		if (this.isEmpty()) {
			return null;
		}
		Jun3dBoundingBox intersectionBox = null;
		JunBoundingObject[] objects = this.boundingObjects();
		for (int i = 0; i < objects.length; i++) {
			Jun3dBoundingBox each = (Jun3dBoundingBox) objects[i];
			if (intersectionBox == null) {
				intersectionBox = each;
			} else {
				if (intersectionBox.intersects_(each)) {
					intersectionBox = intersectionBox.intersect_(each);
				} else {
					return null;
				}
			}
		}
		if (intersectionBox.isEmpty()) {
			return null;
		}
		return intersectionBox;
	}

	/**
	 * Answer the intersection boxes.
	 * 
	 * @return jp.co.sra.jun.geometry.pluralities.Jun3dBoundingBoxes
	 * @category functions
	 */
	public Jun3dBoundingBoxes intersectionBoxes() {
		Jun3dBoundingBox intersectionBox = this.intersectionBox();
		if (intersectionBox == null) {
			return new Jun3dBoundingBoxes();
		}

		Jun3dBoundingBoxes intersectionBoxes = new Jun3dBoundingBoxes();
		intersectionBoxes.add_(intersectionBox);
		return intersectionBoxes;
	}

	/**
	 * Answer the receiver's unify.
	 * 
	 * @return jp.co.sra.jun.geometry.boundaries.Jun3dBoundingBox
	 * @category functions
	 */
	public Jun3dBoundingBox unify() {
		return this.asBoundingBox();
	}

	/**
	 * Answer the receiver's union boxes.
	 * 
	 * @return jp.co.sra.jun.geometry.pluralities.Jun3dBoundingBoxes
	 * @category functions
	 */
	public Jun3dBoundingBoxes unionBoxes() {
		Jun3dBoundingBoxes unionBoxes = new Jun3dBoundingBoxes();
		Jun3dBoundingBox intersectionBox = this.intersectionBox();
		if (intersectionBox == null) {
		} else {
			Jun3dBoundingBox[] tmp = this.boundingBoxes();
			Jun3dBoundingBox[] boxes = new Jun3dBoundingBox[tmp.length + 1];
			for (int i = 0; i < tmp.length; i++) {
				boxes[i] = tmp[i];
			}
			boxes[boxes.length - 1] = intersectionBox;

			for (int i = 0; i < boxes.length; i++) {
				Jun3dBoundingBox aBox = boxes[i];
				Jun3dBoundingBoxes boundingBoxes = new Jun3dBoundingBoxes();
				boundingBoxes.add_(aBox);
				JunBoundingBox[] myComponents = unionBoxes.boundingBoxes();
				for (int j = 0; j < myComponents.length; j++) {
					Jun3dBoundingBox each = (Jun3dBoundingBox) myComponents[j];
					if (each.intersects_(aBox)) {
						boundingBoxes.addAll_(each.boxesOutside_(aBox));
					} else {
						boundingBoxes.add_(each);
					}
				}
				unionBoxes = boundingBoxes;
			}
		}
		unionBoxes = (Jun3dBoundingBoxes) unionBoxes.reject_(new StBlockClosure() {
			public Object value_(Object aBox) {
				return new Boolean(((Jun3dBoundingBox) aBox).isEmpty());
			}
		});
		return unionBoxes;
	}

	/**
	 * Answer the receiver's subdivide bounding boxes.
	 * 
	 * @return jp.co.sra.jun.geometry.pluralities.Jun3dBoundingBoxes
	 * @category subdividing
	 */
	public Jun3dBoundingBoxes subdivide() {
		return this.subdivide8();
	}

	/**
	 * Answer the receiver's subdivide bounding boxes.
	 * 
	 * @return jp.co.sra.jun.geometry.pluralities.Jun3dBoundingBoxes
	 * @category subdividing
	 */
	public Jun3dBoundingBoxes subdivide2() {
		Collection boundingBoxArray = new ArrayList(this.size() * 2);
		for (int n = 0; n < this.size(); n++) {
			Jun3dBoundingBox[] boundingBoxes = this.boundingBox().subdivide2().boundingBoxes();
			boundingBoxArray.add(boundingBoxes[0]);
			boundingBoxArray.add(boundingBoxes[1]);
		}
		Jun3dBoundingBoxes boundingBoxes = new Jun3dBoundingBoxes();
		boundingBoxes.boundingBoxes_(boundingBoxArray);
		return boundingBoxes;
	}

	/**
	 * Answer the receiver's subdivide bounding boxes.
	 * 
	 * @return jp.co.sra.jun.geometry.pluralities.Jun3dBoundingBoxes
	 * @category subdividing
	 */
	public Jun3dBoundingBoxes subdivide8() {
		Collection boundingBoxArray = new ArrayList(this.size() * 8);
		for (int n = 0; n < this.size(); n++) {
			Jun3dBoundingBox[] boundingBoxes = this.boundingBox().subdivide8().boundingBoxes();
			boundingBoxArray.add(boundingBoxes[0]);
			boundingBoxArray.add(boundingBoxes[1]);
			boundingBoxArray.add(boundingBoxes[2]);
			boundingBoxArray.add(boundingBoxes[3]);
			boundingBoxArray.add(boundingBoxes[4]);
			boundingBoxArray.add(boundingBoxes[5]);
			boundingBoxArray.add(boundingBoxes[6]);
			boundingBoxArray.add(boundingBoxes[7]);
		}
		Jun3dBoundingBoxes boundingBoxes = new Jun3dBoundingBoxes();
		boundingBoxes.boundingBoxes_(boundingBoxArray);
		return boundingBoxes;
	}

	/**
	 * Answer the receiver's subdivide bounding boxes with specified level.
	 * 
	 * @param anInteger int
	 * @return jp.co.sra.jun.geometry.pluralities.Jun3dBoundingBoxes
	 * @category subdividing
	 */
	public Jun3dBoundingBoxes subdivideLevel_(int anInteger) {
		Jun3dBoundingBoxes boundingBoxes = this;
		for (int i = 0; i < anInteger; i++) {
			boundingBoxes = boundingBoxes.subdivide();
		}
		return boundingBoxes;
	}

	/**
	 * Answer the receiver's subdivide bounding boxes with specified level.
	 * 
	 * @param anInteger int
	 * @return jp.co.sra.jun.geometry.pluralities.Jun3dBoundingBoxes
	 * @category subdividing
	 */
	public Jun3dBoundingBoxes subdivide2Level_(int anInteger) {
		Jun3dBoundingBoxes boundingBoxes = this;
		for (int i = 0; i < anInteger; i++) {
			boundingBoxes = boundingBoxes.subdivide2();
		}
		return boundingBoxes;
	}

	/**
	 * Answer true if the receiver is a 3d geometry element.
	 * 
	 * @return boolean
	 * @see jp.co.sra.jun.geometry.abstracts.JunGeometry#is3d()
	 * @category testing
	 */
	public boolean is3d() {
		return true;
	}

	/**
	 * Answer <code>true</code> if the receiver touches the specified bounding object, otherwise <code>false</code>.
	 * 
	 * @param aBoundingObject jp.co.sra.jun.geometry.boundaries.Jun3dBoundingBox
	 * @return boolean
	 * @category testing
	 */
	public boolean touches_(final Jun3dBoundingBox aBoundingObject) {
		return this.detect_ifNone_(new StBlockClosure() {
			public Object value(Object each) {
				return new Boolean(((Jun3dBoundingBox) each).touches_(aBoundingObject));
			}
		}, new StBlockClosure() {
			public Object value(Object each) {
				return null;
			}
		}) != null;
	}

	/**
	 * Apply a transformation 'aTransformation' to the receiver.
	 * 
	 * @return jp.co.sra.jun.geometry.pluralities.Jun3dBoundingBoxes
	 * @param aTransformation jp.co.sra.jun.geometry.transformations.Jun3dTransformation
	 * @category transforming
	 */
	public Jun3dBoundingBoxes transform_(Jun3dTransformation aTransformation) {
		Jun3dBoundingBoxes transformedCopy = new Jun3dBoundingBoxes();
		JunBoundingObject[] boundingObjects = this.boundingObjects();
		for (int i = 0; i < boundingObjects.length; i++) {
			this.add_(boundingObjects[i].transform_(aTransformation));
		}
		return transformedCopy;
	}
}
