package jp.co.sra.jun.geometry.forms;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;

import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StImage;
import jp.co.sra.smalltalk.StInputState;
import jp.co.sra.smalltalk.StOpaqueImage;
import jp.co.sra.smalltalk.StValueHolder;

import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.geometry.boundaries.Jun2dBoundingBox;
import jp.co.sra.jun.goodies.cursors.JunCursors;
import jp.co.sra.jun.goodies.image.framework.JunImageDisplayModel;
import jp.co.sra.jun.goodies.image.support.JunImageProcessor;
import jp.co.sra.jun.goodies.movie.support.JunImagesToMovie;
import jp.co.sra.jun.goodies.utilities.JunControlUtility;
import jp.co.sra.jun.goodies.utilities.JunImageUtility;
import jp.co.sra.jun.system.framework.JunDialog;
import jp.co.sra.jun.system.support.JunTestExamples;

/**
 * JunForm2dRegionTestExamples class
 * 
 *  @author    nisinaka
 *  @created   2005/10/26 (by nisinaka)
 *  @updated   2006/10/31 (by m-asada)
 *  @version   699 (with StPL8.9) based on Jun697 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunForm2dRegionTestExamples.java,v 8.16 2008/02/20 06:30:57 nisinaka Exp $
 */
public class JunForm2dRegionTestExamples extends JunTestExamples {
	/**
	 * Example1: test for the containsPoint
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example1() {
		final JunForm2dRegion formRegion = new JunForm2dRegion(new Jun2dPoint[] { new Jun2dPoint(10, 10), new Jun2dPoint(50, 70), new Jun2dPoint(90, 10), new Jun2dPoint(95, 95), new Jun2dPoint(20, 80), new Jun2dPoint(10, 10) });

		BufferedImage aBufferedImage = JunImageUtility.ImageExtent_displayBlock_(new Dimension(100, 100), new StBlockClosure() {
			public Object value_(Object anObject) {
				Graphics2D aGraphics = (Graphics2D) anObject;
				aGraphics.setColor(Color.blue);
				aGraphics.fill(formRegion.toGeneralPath());
				aGraphics.setColor(Color.black);
				aGraphics.draw(formRegion.toGeneralPath());
				return null;
			}
		});
		Point aPoint = new Point(100, 100);
		final StImage anImage = new StImage(aBufferedImage);
		final JunImageDisplayModel aModel = JunImageDisplayModel.Show_label_at_(anImage, "Region (" + anImage.width() + "@" + anImage.height() + ")", aPoint);

		Thread aThread = new Thread() {
			public void run() {
				StInputState inputState = StInputState.Default();
				for (int y = 0; y < 100; y++) {
					for (int x = 0; x < 100; x++) {
						final int xPoint = x;
						final int yPoint = y;
						JunControlUtility.Do_framesPerSecond_(new StBlockClosure() {
							public Object value() {
								Color aColor = formRegion.containsPoint_(new Jun2dPoint(xPoint, yPoint)) ? Color.green : Color.red;
								anImage.setPixel(xPoint, yPoint, aColor.getRGB());
								aModel.redisplay();
								try {
									Thread.sleep(1);
								} catch (InterruptedException e) {
								}
								return null;
							}
						}, ((inputState.button1Down() || inputState.altDown() || inputState.ctrlDown()) ? 10 : 0));
					}
				}
			}
		};
		aThread.start();

		return true;
	}

	/**
	 * Example2: 
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example2() {
		Collection aCollection = new ArrayList();
		Jun2dPoint marginPoint = new Jun2dPoint(10, 10);
		Point aPoint = new Point(100, 100);
		Jun2dPoint[][] polylines = ExamplePolylines();
		for (int index = 0; index < polylines.length; index++) {
			final JunForm2dRegion formRegion = new JunForm2dRegion(polylines[index]);
			Jun2dPoint displayPoint = Jun2dPoint.Zero().minus_(formRegion.boundingBox().origin()).plus_(marginPoint.multipliedBy_(2));
			formRegion.points_(_TranslatedBy(polylines[index], displayPoint));

			Jun2dPoint extentPoint = formRegion.boundingBox().extent().rounded().plus_(marginPoint.multipliedBy_(4));
			int width = (int) extentPoint.x();
			int height = (int) extentPoint.y();
			BufferedImage aBufferedImage = JunImageUtility.ImageExtent_displayBlock_(new Dimension(width, height), new StBlockClosure() {
				public Object value_(Object anObject) {
					Graphics2D aGraphics = (Graphics2D) anObject;
					aGraphics.setColor(Color.blue);
					aGraphics.fill(formRegion.toGeneralPath());
					aGraphics.setColor(Color.black);
					aGraphics.draw(formRegion.toGeneralPath());
					return null;
				}
			});

			final StImage anImage = new StImage(aBufferedImage);
			final JunImageDisplayModel aModel = JunImageDisplayModel.Show_label_at_(anImage, "Region (" + anImage.width() + "@" + anImage.height() + ")", aPoint);
			aCollection.add(aModel);
			aModel.closeTogether_(aCollection);

			Jun2dBoundingBox aBox = formRegion.boundingBox().expandedBy_(marginPoint);
			final ArrayList points = new ArrayList();
			for (double y = aBox.origin().y(); y <= aBox.corner().y(); y += 5) {
				for (double x = aBox.origin().x(); x <= aBox.corner().x(); x += 5) {
					points.add(new Jun2dPoint(x, y));
				}
			}

			Thread aThread = new Thread() {
				public void run() {
					StInputState inputState = StInputState.Default();
					for (int i = 0; i < points.size(); i++) {
						final int index = i;
						JunControlUtility.Do_framesPerSecond_(new StBlockClosure() {
							public Object value() {
								Graphics aGraphics = null;
								try {
									aGraphics = anImage.image().getGraphics();

									Jun2dPoint xyPoint = (Jun2dPoint) points.get(index);
									Color aColor = formRegion.containsPoint_(xyPoint) ? Color.green : Color.red;
									Rectangle aRectangle = new Rectangle((int) xyPoint.x(), (int) xyPoint.y(), 1, 1);
									aRectangle.grow(1, 1);

									aGraphics.setColor(aColor);
									aGraphics.fillRect(aRectangle.x, aRectangle.y, aRectangle.width, aRectangle.width);
								} finally {
									if (aGraphics != null) {
										aGraphics.dispose();
									}
								}

								aModel.redisplay();
								try {
									Thread.sleep(1);
								} catch (InterruptedException e) {
								}
								return null;
							}
						}, ((inputState.button1Down() || inputState.altDown() || inputState.ctrlDown()) ? 10 : 0));
					}

				}
			};
			aThread.start();

			aPoint.translate(20, 20);
		}

		return true;
	}

	/**
	 * Example3: 
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example3() {
		Collection aCollection = new ArrayList();
		Jun2dPoint marginPoint = new Jun2dPoint(10, 10);
		Point aPoint = new Point(100, 100);
		Jun2dPoint[][] polylines = ExamplePolylines();
		for (int index = 0; index < polylines.length; index++) {
			final JunForm2dRegion formRegion = new JunForm2dRegion(polylines[index]);
			Jun2dPoint displayPoint = Jun2dPoint.Zero().minus_(formRegion.boundingBox().origin()).plus_(marginPoint.multipliedBy_(2));
			formRegion.points_(_TranslatedBy(polylines[index], displayPoint));

			Jun2dPoint extentPoint = formRegion.boundingBox().extent().rounded().plus_(marginPoint.multipliedBy_(4));
			int width = (int) extentPoint.x();
			int height = (int) extentPoint.y();
			BufferedImage aBufferedImage = JunImageUtility.ImageExtent_displayBlock_(new Dimension(width, height), new StBlockClosure() {
				public Object value_(Object anObject) {
					Graphics2D aGraphics = (Graphics2D) anObject;
					aGraphics.setColor(Color.blue);
					aGraphics.fill(formRegion.toGeneralPath());
					aGraphics.setColor(Color.black);
					aGraphics.draw(formRegion.toGeneralPath());
					return null;
				}
			});

			final StImage anImage = new StImage(aBufferedImage);
			final JunImageDisplayModel aModel = JunImageDisplayModel.Show_label_at_(anImage, "Region (" + anImage.width() + "@" + anImage.height() + ")", aPoint);
			aCollection.add(aModel);
			aModel.closeTogether_(aCollection);

			Jun2dBoundingBox aBox = formRegion.boundingBox().expandedBy_(marginPoint);
			Random aRandom = new Random();
			final ArrayList points = new ArrayList();
			for (double y = aBox.origin().y(); y <= aBox.corner().y(); y += 5) {
				for (double x = aBox.origin().x(); x <= aBox.corner().x(); x += 5) {
					double delta = aRandom.nextDouble() * 3 - 1.5;
					points.add(new Jun2dPoint(x + delta, y + delta));
				}
			}
			for (int i = 0; i < points.size(); i++) {
				int j = aRandom.nextInt(points.size());
				Jun2dPoint p = (Jun2dPoint) points.get(i);
				points.set(i, points.get(j));
				points.set(j, p);
			}

			Thread aThread = new Thread() {
				public void run() {
					StInputState inputState = StInputState.Default();
					for (int i = 0; i < points.size(); i++) {
						final int index = i;
						JunControlUtility.Do_framesPerSecond_(new StBlockClosure() {
							public Object value() {
								Graphics aGraphics = null;
								try {
									aGraphics = anImage.image().getGraphics();
									Jun2dPoint xyPoint = (Jun2dPoint) points.get(index);

									Color aColor = formRegion.containsPoint_(xyPoint) ? Color.green : Color.red;
									Rectangle aRectangle = new Rectangle((int) xyPoint.x(), (int) xyPoint.y(), 1, 1);
									aRectangle.grow(1, 1);

									aGraphics.setColor(aColor);
									aGraphics.fillRect(aRectangle.x, aRectangle.y, aRectangle.width, aRectangle.width);
								} finally {
									if (aGraphics != null) {
										aGraphics.dispose();
									}
								}

								aModel.redisplay();
								try {
									Thread.sleep(1);
								} catch (InterruptedException e) {
								}
								return null;
							}
						}, ((inputState.button1Down() || inputState.altDown() || inputState.ctrlDown()) ? 10 : 0));
					}
				}
			};
			aThread.start();

			aPoint.translate(20, 20);
		}

		return true;
	}

	/**
	 * Example4: 
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example4() {
		if (JunDialog.Confirm_($String("Do you want to create a movie file for animation?"), false) == false) {
			return false;
		}

		Collection aCollection = new ArrayList();
		final Jun2dPoint marginPoint = new Jun2dPoint(10, 10);
		Point aPoint = new Point(100, 100);
		Jun2dPoint[][] polylines = ExamplePolylines();
		for (int index = 0; index < polylines.length; index++) {
			final JunForm2dRegion formRegion = new JunForm2dRegion(polylines[index]);
			Jun2dPoint displayPoint = Jun2dPoint.Zero().minus_(formRegion.boundingBox().origin()).plus_(marginPoint.multipliedBy_(2));
			formRegion.points_(_TranslatedBy(polylines[index], displayPoint));

			Jun2dPoint extentPoint = formRegion.boundingBox().extent().rounded().plus_(marginPoint.multipliedBy_(4));
			int width = (int) extentPoint.x();
			int height = (int) extentPoint.y();
			BufferedImage aBufferedImage = JunImageUtility.ImageExtent_displayBlock_(new Dimension(width, height), new StBlockClosure() {
				public Object value_(Object anObject) {
					Graphics2D aGraphics = (Graphics2D) anObject;
					aGraphics.setColor(Color.blue);
					aGraphics.fill(formRegion.toGeneralPath());
					aGraphics.setColor(Color.black);
					aGraphics.draw(formRegion.toGeneralPath());
					return null;
				}
			});

			final StImage anImage = new StImage(aBufferedImage);
			final JunImageDisplayModel aModel = JunImageDisplayModel.Show_label_at_(anImage, "Region (" + anImage.width() + "@" + anImage.height() + ")", aPoint);
			aCollection.add(aModel);
			aModel.closeTogether_(aCollection);
			final int aTick = 50;
			String aString = Integer.toString(index + 1);
			int timesRepeat = 2 - aString.length();
			for (int i = 0; i < timesRepeat; i++) {
				aString = "0" + aString;
			}
			aString = "MonteCarlo_" + aString;

			JunImagesToMovie.File_extent_do_(new File(aString + ".mov"), anImage.bounds().getSize(), new StBlockClosure() {
				public Object value_(Object obj) {
					final JunImagesToMovie imagesToMovie = (JunImagesToMovie) obj;

					Jun2dBoundingBox aBox = formRegion.boundingBox().expandedBy_(marginPoint);
					Random aRandom = new Random();
					final ArrayList points = new ArrayList();
					for (double y = aBox.origin().y(); y <= aBox.corner().y(); y += 10) {
						for (double x = aBox.origin().x(); x <= aBox.corner().x(); x += 10) {
							double delta = aRandom.nextDouble() * 5 - 2.5;
							points.add(new Jun2dPoint(x + delta, y + delta));
						}
					}
					for (int i = 0; i < points.size(); i++) {
						int j = aRandom.nextInt(points.size());
						Jun2dPoint p = (Jun2dPoint) points.get(i);
						points.set(i, points.get(j));
						points.set(j, p);
					}

					for (int i = 0; i < points.size(); i++) {
						Graphics aGraphics = null;
						try {
							aGraphics = anImage.image().getGraphics();
							Jun2dPoint xyPoint = (Jun2dPoint) points.get(i);

							Color aColor = formRegion.containsPoint_(xyPoint) ? Color.green : Color.red;
							Rectangle aRectangle = new Rectangle((int) xyPoint.x(), (int) xyPoint.y(), 1, 1);
							aRectangle.grow(3, 3);

							aGraphics.setColor(aColor);
							aGraphics.fillRect(aRectangle.x, aRectangle.y, aRectangle.width, aRectangle.width);
						} finally {
							if (aGraphics != null) {
								aGraphics.dispose();
							}
						}

						if (i % 10 == 0) {
							aModel.redisplay();
							JunCursors cursor = new JunCursors(JunCursors.WriteCursor());
							try {
								cursor._show();
								imagesToMovie.add_milliseconds_(anImage, aTick);
							} finally {
								cursor._restore();
							}
							try {
								Thread.sleep(1);
							} catch (InterruptedException e) {
							}
						}
					}
					return null;
				}
			});

			aPoint.translate(20, 20);

		}

		return true;
	}

	/**
	 * Example5: 
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example5() {
		Collection aCollection = new ArrayList();
		Jun2dPoint marginPoint = new Jun2dPoint(10, 10);
		Point aPoint = new Point(100, 100);
		Jun2dPoint[][] polylines = ExamplePolylines();
		for (int index = 0; index < polylines.length; index++) {
			final JunForm2dRegion formRegion = new JunForm2dRegion(polylines[index]);
			Jun2dPoint displayPoint = Jun2dPoint.Zero().minus_(formRegion.boundingBox().origin()).plus_(marginPoint.multipliedBy_(2));
			formRegion.points_(_TranslatedBy(polylines[index], displayPoint));

			Jun2dPoint extentPoint = formRegion.boundingBox().extent().rounded().plus_(marginPoint.multipliedBy_(4));
			final int width = (int) extentPoint.x();
			final int height = (int) extentPoint.y();
			BufferedImage aBufferedImage = JunImageUtility.ImageExtent_displayBlock_(new Dimension(width, height), new StBlockClosure() {
				public Object value_(Object anObject) {
					Graphics2D aGraphics = (Graphics2D) anObject;
					GeneralPath path = formRegion.toGeneralPath();
					aGraphics.setStroke(new BasicStroke(2));
					aGraphics.setColor(Color.blue);
					aGraphics.fill(path);

					aGraphics.setColor(Color.red);
					aGraphics.draw(path);
					return null;
				}
			});

			StImage anImage = new StImage(aBufferedImage);
			final JunImageDisplayModel aModel = JunImageDisplayModel.Show_label_at_(anImage, "Region (" + anImage.width() + "@" + anImage.height() + ")", aPoint);
			aCollection.add(aModel);
			aModel.closeTogether_(aCollection);
			final StValueHolder countValue = new StValueHolder(0);

			anImage = JunImageProcessor.MakeThin_interim_(anImage, new StBlockClosure() {
				public Object value_(Object obj) {
					final StImage interimImage = (StImage) obj;
					if (countValue._intValue() % 25 == 0) {
						StInputState inputState = StInputState.Default();
						JunControlUtility.Do_framesPerSecond_(new StBlockClosure() {
							public Object value() {
								BufferedImage image = JunImageUtility.ImageExtent_displayBlock_(new Dimension(width, height), new StBlockClosure() {
									public Object value_(Object anObject) {
										Graphics2D aGraphics = (Graphics2D) anObject;
										GeneralPath path = formRegion.toGeneralPath();
										aGraphics.setStroke(new BasicStroke(2));
										aGraphics.setColor(Color.green);
										aGraphics.fill(path);

										StImage figure = interimImage.convertToPalette_(new IndexColorModel(1, 2, new byte[] { (byte) 255, (byte) 0 }, new byte[] { (byte) 255, (byte) 0 }, new byte[] { (byte) 255, (byte) 255 }));
										StImage shape = new StImage(interimImage.width(), interimImage.height(), StImage.MonoMaskColorModel());
										shape.copy_from_in_rule_(new Rectangle(0, 0, interimImage.width(), interimImage.height()), new Point(0, 0), interimImage, StImage.Over);
										StOpaqueImage opqaueImage = new StOpaqueImage(figure, shape);
										opqaueImage.displayOn_(aGraphics);

										aGraphics.setColor(Color.red);
										aGraphics.draw(path);
										return null;
									}
								});
								aModel.image_(new StImage(image));
								aModel.redisplay();
								return null;
							}
						}, ((inputState.button1Down() || inputState.altDown() || inputState.ctrlDown()) ? 0 : 75));

					}
					countValue.value_(countValue._intValue() + 1);
					return null;
				}
			});
			final StImage drawImage = anImage;
			BufferedImage image = JunImageUtility.ImageExtent_displayBlock_(new Dimension(width, height), new StBlockClosure() {
				public Object value_(Object anObject) {
					Graphics2D aGraphics = (Graphics2D) anObject;
					GeneralPath path = formRegion.toGeneralPath();
					aGraphics.setStroke(new BasicStroke(2));
					aGraphics.setColor(Color.green);
					aGraphics.fill(path);

					StImage figure = drawImage.convertToPalette_(new IndexColorModel(1, 2, new byte[] { (byte) 255, (byte) 0 }, new byte[] { (byte) 255, (byte) 0 }, new byte[] { (byte) 255, (byte) 255 }));
					StImage shape = new StImage(drawImage.width(), drawImage.height(), StImage.MonoMaskColorModel());
					shape.copy_from_in_rule_(new Rectangle(0, 0, drawImage.width(), drawImage.height()), new Point(0, 0), drawImage, StImage.Over);
					StOpaqueImage opqaueImage = new StOpaqueImage(figure, shape);
					opqaueImage.displayOn_(aGraphics);

					aGraphics.setColor(Color.red);
					aGraphics.draw(path);
					return null;
				}
			});
			aModel.image_(new StImage(image));
			aModel.redisplay();
			aPoint.translate(20, 20);
		}

		return true;
	}

	/**
	 * Example6: 
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example6() {
		if (JunDialog.Confirm_($String("Do you want to create a movie file for animation?"), false) == false) {
			return false;
		}

		Collection aCollection = new ArrayList();
		Jun2dPoint marginPoint = new Jun2dPoint(10, 10);
		Point aPoint = new Point(100, 100);
		Jun2dPoint[][] polylines = ExamplePolylines();
		for (int index = 0; index < polylines.length; index++) {
			final JunForm2dRegion formRegion = new JunForm2dRegion(polylines[index]);
			Jun2dPoint displayPoint = Jun2dPoint.Zero().minus_(formRegion.boundingBox().origin()).plus_(marginPoint.multipliedBy_(2));
			formRegion.points_(_TranslatedBy(polylines[index], displayPoint));

			Jun2dPoint extentPoint = formRegion.boundingBox().extent().rounded().plus_(marginPoint.multipliedBy_(4));
			final int width = (int) extentPoint.x();
			final int height = (int) extentPoint.y();
			BufferedImage aBufferedImage = JunImageUtility.ImageExtent_displayBlock_(new Dimension(width, height), new StBlockClosure() {
				public Object value_(Object anObject) {
					Graphics2D aGraphics = (Graphics2D) anObject;
					GeneralPath path = formRegion.toGeneralPath();
					aGraphics.setStroke(new BasicStroke(2));
					aGraphics.setColor(Color.blue);
					aGraphics.fill(path);

					aGraphics.setColor(Color.red);
					aGraphics.draw(path);
					return null;
				}
			});

			final StImage anImage = new StImage(aBufferedImage);
			final JunImageDisplayModel aModel = JunImageDisplayModel.Show_label_at_(anImage, "Region (" + anImage.width() + "@" + anImage.height() + ")", aPoint);
			aCollection.add(aModel);
			aModel.closeTogether_(aCollection);
			final int aTick = 50;
			String aString = Integer.toString(index + 1);
			int timesRepeat = 2 - aString.length();
			for (int i = 0; i < timesRepeat; i++) {
				aString = "0" + aString;
			}
			aString = "Thinning_" + aString;

			JunImagesToMovie.File_extent_do_(new File(aString + ".mov"), anImage.bounds().getSize(), new StBlockClosure() {
				public Object value_(Object obj) {
					final JunImagesToMovie imagesToMovie = (JunImagesToMovie) obj;
					final StValueHolder countValue = new StValueHolder(0);

					final StImage theImage = JunImageProcessor.MakeThin_interim_(anImage, new StBlockClosure() {
						public Object value_(Object obj) {
							final StImage interimImage = (StImage) obj;
							if (countValue._intValue() % 25 == 0) {
								StInputState inputState = StInputState.Default();
								JunControlUtility.Do_framesPerSecond_(new StBlockClosure() {
									public Object value() {
										BufferedImage image = JunImageUtility.ImageExtent_displayBlock_(new Dimension(width, height), new StBlockClosure() {
											public Object value_(Object anObject) {
												Graphics2D aGraphics = (Graphics2D) anObject;
												GeneralPath path = formRegion.toGeneralPath();
												aGraphics.setStroke(new BasicStroke(2));
												aGraphics.setColor(Color.green);
												aGraphics.fill(path);

												StImage figure = interimImage.convertToPalette_(new IndexColorModel(1, 2, new byte[] { (byte) 255, (byte) 0 }, new byte[] { (byte) 255, (byte) 0 }, new byte[] { (byte) 255, (byte) 255 }));
												StImage shape = new StImage(interimImage.width(), interimImage.height(), StImage.MonoMaskColorModel());
												shape.copy_from_in_rule_(new Rectangle(0, 0, interimImage.width(), interimImage.height()), new Point(0, 0), interimImage, StImage.Over);
												StOpaqueImage opqaueImage = new StOpaqueImage(figure, shape);
												opqaueImage.displayOn_(aGraphics);

												aGraphics.setColor(Color.red);
												aGraphics.draw(path);
												return null;
											}
										});
										StImage thinImage = new StImage(image);
										aModel.image_(thinImage);
										aModel.redisplay();
										JunCursors cursor = new JunCursors(JunCursors.WriteCursor());
										try {
											cursor._show();
											imagesToMovie.add_milliseconds_(thinImage, aTick);
										} finally {
											cursor._restore();
										}
										return null;
									}
								}, ((inputState.button1Down() || inputState.altDown() || inputState.ctrlDown()) ? 0 : 75));

							}
							countValue.value_(countValue._intValue() + 1);
							return null;
						}
					});
					BufferedImage image = JunImageUtility.ImageExtent_displayBlock_(new Dimension(width, height), new StBlockClosure() {
						public Object value_(Object anObject) {
							Graphics2D aGraphics = (Graphics2D) anObject;
							GeneralPath path = formRegion.toGeneralPath();
							aGraphics.setStroke(new BasicStroke(2));
							aGraphics.setColor(Color.green);
							aGraphics.fill(path);

							StImage figure = theImage.convertToPalette_(new IndexColorModel(1, 2, new byte[] { (byte) 255, (byte) 0 }, new byte[] { (byte) 255, (byte) 0 }, new byte[] { (byte) 255, (byte) 255 }));
							StImage shape = new StImage(theImage.width(), theImage.height(), StImage.MonoMaskColorModel());
							shape.copy_from_in_rule_(new Rectangle(0, 0, theImage.width(), theImage.height()), new Point(0, 0), theImage, StImage.Over);
							StOpaqueImage opqaueImage = new StOpaqueImage(figure, shape);
							opqaueImage.displayOn_(aGraphics);

							aGraphics.setColor(Color.red);
							aGraphics.draw(path);
							return null;
						}
					});
					StImage thinImage = new StImage(image);
					aModel.image_(thinImage);
					aModel.redisplay();
					JunCursors cursor = new JunCursors(JunCursors.WriteCursor());
					try {
						cursor._show();
						imagesToMovie.add_milliseconds_(thinImage, aTick);
					} finally {
						cursor._restore();
					}
					return null;
				}
			});
			aPoint.translate(20, 20);
		}

		return true;
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args an array of command-line arguments
	 * @category Main
	 */
	public static void main(String[] args) {
		new JunForm2dRegionTestExamples();
	}

	/**
	 * Answer the example polylines.
	 * 
	 * @return jp.co.sra.jun.geometry.basic.Jun2dPoint[]
	 * @category Examples
	 */
	protected static Jun2dPoint[][] ExamplePolylines() {
		Jun2dPoint[][] polylines = ExampleOriginalPolylines();
		return new Jun2dPoint[][] { polylines[3], polylines[9] };
	}

	/**
	 * Answer the example original polylines.
	 * 
	 * @return jp.co.sra.jun.geometry.basic.Jun2dPoint[][]
	 * @category Examples
	 */
	protected static Jun2dPoint[][] ExampleOriginalPolylines() {
		Jun2dPoint[][] polylines = new Jun2dPoint[11][];
		polylines[0] = _ScaledBy(ExamplePolyline1(), new Jun2dPoint(2, 2));
		polylines[1] = _ScaledBy(ExamplePolyline2(), new Jun2dPoint(2, 2));
		polylines[2] = _ScaledBy(ExamplePolyline3(), new Jun2dPoint(2, 2));
		polylines[3] = _ScaledBy(ExamplePolyline4(), new Jun2dPoint(2, 2));
		polylines[4] = _ScaledBy(ExamplePolyline5(), new Jun2dPoint(2, 2));
		polylines[5] = _ScaledBy(ExamplePolyline6(), new Jun2dPoint(2, 2));
		polylines[6] = _ScaledBy(ExamplePolyline7(), new Jun2dPoint(2, 2));
		polylines[7] = _ScaledBy(ExamplePolyline8(), new Jun2dPoint(2, 2));
		polylines[8] = _ScaledBy(ExamplePolyline9(), new Jun2dPoint(2, 2));
		polylines[9] = _ScaledBy(ExamplePolylineA(), new Jun2dPoint(2, 2));
		polylines[10] = _ScaledBy(ExamplePolylineB(), new Jun2dPoint(2, 2));
		return polylines;
	}

	/**
	 * Answer the example polyline 1.
	 * 
	 * @return jp.co.sra.jun.geometry.basic.Jun2dPoint[]
	 * @category Examples
	 */
	protected static Jun2dPoint[] ExamplePolyline1() {
		return new Jun2dPoint[] {
				new Jun2dPoint(80, 96),
				new Jun2dPoint(79, 96),
				new Jun2dPoint(74, 93),
				new Jun2dPoint(68, 90),
				new Jun2dPoint(63, 85),
				new Jun2dPoint(59, 78),
				new Jun2dPoint(58, 71),
				new Jun2dPoint(60, 63),
				new Jun2dPoint(64, 54),
				new Jun2dPoint(68, 48),
				new Jun2dPoint(73, 44),
				new Jun2dPoint(80, 39),
				new Jun2dPoint(89, 37),
				new Jun2dPoint(98, 36),
				new Jun2dPoint(104, 37),
				new Jun2dPoint(109, 38),
				new Jun2dPoint(115, 42),
				new Jun2dPoint(121, 47),
				new Jun2dPoint(126, 53),
				new Jun2dPoint(129, 58),
				new Jun2dPoint(131, 66),
				new Jun2dPoint(131, 72),
				new Jun2dPoint(131, 78),
				new Jun2dPoint(131, 82),
				new Jun2dPoint(131, 86),
				new Jun2dPoint(131, 89),
				new Jun2dPoint(131, 92),
				new Jun2dPoint(131, 99),
				new Jun2dPoint(132, 103),
				new Jun2dPoint(134, 107),
				new Jun2dPoint(139, 111),
				new Jun2dPoint(141, 112),
				new Jun2dPoint(146, 115),
				new Jun2dPoint(154, 120),
				new Jun2dPoint(162, 126),
				new Jun2dPoint(170, 131),
				new Jun2dPoint(178, 138),
				new Jun2dPoint(185, 146),
				new Jun2dPoint(191, 154),
				new Jun2dPoint(196, 164),
				new Jun2dPoint(200, 173),
				new Jun2dPoint(201, 183),
				new Jun2dPoint(202, 191),
				new Jun2dPoint(201, 197),
				new Jun2dPoint(199, 204),
				new Jun2dPoint(196, 210),
				new Jun2dPoint(191, 215),
				new Jun2dPoint(183, 220),
				new Jun2dPoint(176, 222),
				new Jun2dPoint(167, 222),
				new Jun2dPoint(155, 217),
				new Jun2dPoint(145, 210),
				new Jun2dPoint(136, 202),
				new Jun2dPoint(127, 191),
				new Jun2dPoint(124, 181),
				new Jun2dPoint(122, 172),
				new Jun2dPoint(122, 162),
				new Jun2dPoint(122, 153),
				new Jun2dPoint(122, 129),
				new Jun2dPoint(121, 120),
				new Jun2dPoint(118, 110),
				new Jun2dPoint(115, 104),
				new Jun2dPoint(113, 102),
				new Jun2dPoint(111, 101),
				new Jun2dPoint(109, 100),
				new Jun2dPoint(106, 100),
				new Jun2dPoint(104, 100),
				new Jun2dPoint(102, 100),
				new Jun2dPoint(99, 99),
				new Jun2dPoint(97, 99),
				new Jun2dPoint(94, 99),
				new Jun2dPoint(92, 99),
				new Jun2dPoint(90, 98),
				new Jun2dPoint(80, 96) };
	}

	/**
	 * Answer the example polyline 2.
	 * 
	 * @return jp.co.sra.jun.geometry.basic.Jun2dPoint[]
	 * @category Examples
	 */
	protected static Jun2dPoint[] ExamplePolyline2() {
		return new Jun2dPoint[] {
				new Jun2dPoint(124, 99),
				new Jun2dPoint(119, 100),
				new Jun2dPoint(108, 103),
				new Jun2dPoint(98, 106),
				new Jun2dPoint(84, 110),
				new Jun2dPoint(72, 111),
				new Jun2dPoint(62, 111),
				new Jun2dPoint(55, 107),
				new Jun2dPoint(52, 100),
				new Jun2dPoint(53, 88),
				new Jun2dPoint(57, 78),
				new Jun2dPoint(67, 66),
				new Jun2dPoint(80, 60),
				new Jun2dPoint(94, 57),
				new Jun2dPoint(117, 57),
				new Jun2dPoint(138, 62),
				new Jun2dPoint(150, 67),
				new Jun2dPoint(177, 111),
				new Jun2dPoint(176, 131),
				new Jun2dPoint(169, 147),
				new Jun2dPoint(162, 157),
				new Jun2dPoint(146, 168),
				new Jun2dPoint(135, 173),
				new Jun2dPoint(123, 175),
				new Jun2dPoint(108, 170),
				new Jun2dPoint(103, 165),
				new Jun2dPoint(98, 157),
				new Jun2dPoint(101, 146),
				new Jun2dPoint(113, 136),
				new Jun2dPoint(122, 131),
				new Jun2dPoint(134, 124),
				new Jun2dPoint(141, 118),
				new Jun2dPoint(145, 113),
				new Jun2dPoint(147, 105),
				new Jun2dPoint(144, 99),
				new Jun2dPoint(140, 95),
				new Jun2dPoint(128, 90),
				new Jun2dPoint(118, 87),
				new Jun2dPoint(112, 87),
				new Jun2dPoint(103, 87),
				new Jun2dPoint(92, 88),
				new Jun2dPoint(82, 90),
				new Jun2dPoint(77, 92),
				new Jun2dPoint(75, 94),
				new Jun2dPoint(74, 95),
				new Jun2dPoint(72, 97),
				new Jun2dPoint(72, 98),
				new Jun2dPoint(124, 99) };
	}

	/**
	 * Answer the example polyline 3.
	 * 
	 * @return jp.co.sra.jun.geometry.basic.Jun2dPoint[]
	 * @category Examples
	 */
	protected static Jun2dPoint[] ExamplePolyline3() {
		return new Jun2dPoint[] {
				new Jun2dPoint(64, 91),
				new Jun2dPoint(65, 89),
				new Jun2dPoint(73, 84),
				new Jun2dPoint(81, 80),
				new Jun2dPoint(90, 77),
				new Jun2dPoint(100, 77),
				new Jun2dPoint(109, 78),
				new Jun2dPoint(118, 83),
				new Jun2dPoint(124, 89),
				new Jun2dPoint(129, 94),
				new Jun2dPoint(136, 103),
				new Jun2dPoint(143, 110),
				new Jun2dPoint(149, 116),
				new Jun2dPoint(155, 120),
				new Jun2dPoint(162, 125),
				new Jun2dPoint(170, 129),
				new Jun2dPoint(178, 131),
				new Jun2dPoint(185, 132),
				new Jun2dPoint(198, 135),
				new Jun2dPoint(211, 137),
				new Jun2dPoint(214, 137),
				new Jun2dPoint(212, 137),
				new Jun2dPoint(208, 137),
				new Jun2dPoint(199, 137),
				new Jun2dPoint(191, 137),
				new Jun2dPoint(180, 137),
				new Jun2dPoint(169, 135),
				new Jun2dPoint(162, 133),
				new Jun2dPoint(155, 132),
				new Jun2dPoint(147, 130),
				new Jun2dPoint(140, 127),
				new Jun2dPoint(136, 125),
				new Jun2dPoint(131, 122),
				new Jun2dPoint(125, 118),
				new Jun2dPoint(121, 113),
				new Jun2dPoint(115, 109),
				new Jun2dPoint(111, 107),
				new Jun2dPoint(102, 104),
				new Jun2dPoint(85, 98),
				new Jun2dPoint(83, 97),
				new Jun2dPoint(82, 97),
				new Jun2dPoint(78, 96),
				new Jun2dPoint(64, 91) };
	}

	/**
	 * Answer the example polyline 4.
	 * 
	 * @return jp.co.sra.jun.geometry.basic.Jun2dPoint[]
	 * @category Examples
	 */
	protected static Jun2dPoint[] ExamplePolyline4() {
		return new Jun2dPoint[] {
				new Jun2dPoint(115, 142),
				new Jun2dPoint(109, 136),
				new Jun2dPoint(97, 119),
				new Jun2dPoint(92, 111),
				new Jun2dPoint(90, 100),
				new Jun2dPoint(95, 78),
				new Jun2dPoint(102, 64),
				new Jun2dPoint(116, 50),
				new Jun2dPoint(132, 49),
				new Jun2dPoint(142, 55),
				new Jun2dPoint(154, 66),
				new Jun2dPoint(160, 83),
				new Jun2dPoint(160, 99),
				new Jun2dPoint(156, 110),
				new Jun2dPoint(153, 123),
				new Jun2dPoint(152, 131),
				new Jun2dPoint(156, 137),
				new Jun2dPoint(165, 141),
				new Jun2dPoint(180, 144),
				new Jun2dPoint(198, 149),
				new Jun2dPoint(210, 158),
				new Jun2dPoint(215, 168),
				new Jun2dPoint(215, 182),
				new Jun2dPoint(210, 191),
				new Jun2dPoint(199, 194),
				new Jun2dPoint(183, 190),
				new Jun2dPoint(170, 184),
				new Jun2dPoint(162, 183),
				new Jun2dPoint(149, 187),
				new Jun2dPoint(140, 193),
				new Jun2dPoint(132, 199),
				new Jun2dPoint(122, 206),
				new Jun2dPoint(110, 210),
				new Jun2dPoint(96, 210),
				new Jun2dPoint(83, 207),
				new Jun2dPoint(74, 203),
				new Jun2dPoint(71, 195),
				new Jun2dPoint(73, 185),
				new Jun2dPoint(81, 178),
				new Jun2dPoint(94, 173),
				new Jun2dPoint(106, 172),
				new Jun2dPoint(112, 170),
				new Jun2dPoint(117, 169),
				new Jun2dPoint(124, 165),
				new Jun2dPoint(125, 162),
				new Jun2dPoint(125, 159),
				new Jun2dPoint(115, 142) };
	}

	/**
	 * Answer the example polyline 5.
	 * 
	 * @return jp.co.sra.jun.geometry.basic.Jun2dPoint[]
	 * @category Examples
	 */
	protected static Jun2dPoint[] ExamplePolyline5() {
		return new Jun2dPoint[] {
				new Jun2dPoint(69, 119),
				new Jun2dPoint(67, 116),
				new Jun2dPoint(61, 107),
				new Jun2dPoint(54, 90),
				new Jun2dPoint(54, 75),
				new Jun2dPoint(59, 62),
				new Jun2dPoint(73, 49),
				new Jun2dPoint(91, 40),
				new Jun2dPoint(112, 34),
				new Jun2dPoint(140, 33),
				new Jun2dPoint(162, 38),
				new Jun2dPoint(181, 49),
				new Jun2dPoint(192, 60),
				new Jun2dPoint(200, 77),
				new Jun2dPoint(201, 90),
				new Jun2dPoint(200, 102),
				new Jun2dPoint(190, 116),
				new Jun2dPoint(177, 127),
				new Jun2dPoint(167, 133),
				new Jun2dPoint(150, 139),
				new Jun2dPoint(133, 142),
				new Jun2dPoint(123, 142),
				new Jun2dPoint(112, 141),
				new Jun2dPoint(101, 142),
				new Jun2dPoint(90, 145),
				new Jun2dPoint(86, 149),
				new Jun2dPoint(82, 160),
				new Jun2dPoint(79, 167),
				new Jun2dPoint(75, 177),
				new Jun2dPoint(71, 190),
				new Jun2dPoint(67, 198),
				new Jun2dPoint(63, 206),
				new Jun2dPoint(59, 212),
				new Jun2dPoint(54, 216),
				new Jun2dPoint(51, 217),
				new Jun2dPoint(49, 216),
				new Jun2dPoint(48, 211),
				new Jun2dPoint(48, 202),
				new Jun2dPoint(50, 194),
				new Jun2dPoint(52, 186),
				new Jun2dPoint(56, 176),
				new Jun2dPoint(58, 173),
				new Jun2dPoint(61, 168),
				new Jun2dPoint(64, 161),
				new Jun2dPoint(67, 155),
				new Jun2dPoint(70, 148),
				new Jun2dPoint(71, 142),
				new Jun2dPoint(72, 138),
				new Jun2dPoint(73, 135),
				new Jun2dPoint(73, 133),
				new Jun2dPoint(73, 132),
				new Jun2dPoint(69, 119) };
	}

	/**
	 * Answer the example polyline 6.
	 * 
	 * @return jp.co.sra.jun.geometry.basic.Jun2dPoint[]
	 * @category Examples
	 */
	protected static Jun2dPoint[] ExamplePolyline6() {
		return new Jun2dPoint[] {
				new Jun2dPoint(43, 168),
				new Jun2dPoint(45, 166),
				new Jun2dPoint(66, 145),
				new Jun2dPoint(90, 120),
				new Jun2dPoint(118, 94),
				new Jun2dPoint(135, 77),
				new Jun2dPoint(150, 66),
				new Jun2dPoint(154, 63),
				new Jun2dPoint(155, 63),
				new Jun2dPoint(153, 73),
				new Jun2dPoint(155, 105),
				new Jun2dPoint(161, 127),
				new Jun2dPoint(169, 160),
				new Jun2dPoint(175, 180),
				new Jun2dPoint(178, 199),
				new Jun2dPoint(181, 214),
				new Jun2dPoint(180, 218),
				new Jun2dPoint(171, 216),
				new Jun2dPoint(141, 207),
				new Jun2dPoint(127, 202),
				new Jun2dPoint(115, 198),
				new Jun2dPoint(99, 195),
				new Jun2dPoint(90, 194),
				new Jun2dPoint(81, 193),
				new Jun2dPoint(43, 168) };
	}

	/**
	 * Answer the example polyline 7.
	 * 
	 * @return jp.co.sra.jun.geometry.basic.Jun2dPoint[]
	 * @category Examples
	 */
	protected static Jun2dPoint[] ExamplePolyline7() {
		return new Jun2dPoint[] { new Jun2dPoint(50, 50), new Jun2dPoint(-50, 50), new Jun2dPoint(-50, -50), new Jun2dPoint(50, -50), new Jun2dPoint(50, 50) };
	}

	/**
	 * Answer the example polyline 8.
	 * 
	 * @return jp.co.sra.jun.geometry.basic.Jun2dPoint[]
	 * @category Examples
	 */
	protected static Jun2dPoint[] ExamplePolyline8() {
		return new Jun2dPoint[] { new Jun2dPoint(0, 50), new Jun2dPoint(-50, 0), new Jun2dPoint(0, -50), new Jun2dPoint(50, 0), new Jun2dPoint(0, 50) };
	}

	/**
	 * Answer the example polyline 2.
	 * 
	 * @return jp.co.sra.jun.geometry.basic.Jun2dPoint[]
	 * @category Examples
	 */
	protected static Jun2dPoint[] ExamplePolyline9() {
		return new Jun2dPoint[] {
				new Jun2dPoint(-63, 11),
				new Jun2dPoint(-83, 3),
				new Jun2dPoint(-96, -12),
				new Jun2dPoint(-99, -29),
				new Jun2dPoint(-95, -48),
				new Jun2dPoint(-82, -66),
				new Jun2dPoint(-59, -80),
				new Jun2dPoint(-35, -86),
				new Jun2dPoint(-11, -83),
				new Jun2dPoint(15, -61),
				new Jun2dPoint(21, -49),
				new Jun2dPoint(21, -28),
				new Jun2dPoint(24, -6),
				new Jun2dPoint(32, 13),
				new Jun2dPoint(40, 21),
				new Jun2dPoint(60, 23),
				new Jun2dPoint(72, 19),
				new Jun2dPoint(82, 18),
				new Jun2dPoint(94, 30),
				new Jun2dPoint(104, 48),
				new Jun2dPoint(105, 65),
				new Jun2dPoint(96, 86),
				new Jun2dPoint(81, 99),
				new Jun2dPoint(63, 104),
				new Jun2dPoint(45, 101),
				new Jun2dPoint(31, 93),
				new Jun2dPoint(15, 79),
				new Jun2dPoint(-3, 65),
				new Jun2dPoint(-21, 62),
				new Jun2dPoint(-35, 69),
				new Jun2dPoint(-48, 79),
				new Jun2dPoint(-62, 87),
				new Jun2dPoint(-78, 90),
				new Jun2dPoint(-91, 82),
				new Jun2dPoint(-94, 72),
				new Jun2dPoint(-92, 59),
				new Jun2dPoint(-80, 50),
				new Jun2dPoint(-61, 48),
				new Jun2dPoint(-42, 50),
				new Jun2dPoint(-31, 50),
				new Jun2dPoint(-16, 44),
				new Jun2dPoint(-9, 36),
				new Jun2dPoint(-13, 21),
				new Jun2dPoint(-23, 19),
				new Jun2dPoint(-40, 21),
				new Jun2dPoint(-49, 26),
				new Jun2dPoint(-59, 30),
				new Jun2dPoint(-72, 32),
				new Jun2dPoint(-82, 31),
				new Jun2dPoint(-73, 21),
				new Jun2dPoint(-61, 20),
				new Jun2dPoint(-63, 11) };
	}

	/**
	 * Answer the example polyline A.
	 * 
	 * @return jp.co.sra.jun.geometry.basic.Jun2dPoint[]
	 * @category Examples
	 */
	protected static Jun2dPoint[] ExamplePolylineA() {
		Jun2dPoint[] points = new Jun2dPoint[] {
				new Jun2dPoint(148.54944165028d, 0.0d),
				new Jun2dPoint(122.7275437144d, 9.6588671647162d),
				new Jun2dPoint(124.17509361861d, 19.667402705031d),
				new Jun2dPoint(166.36379087294d, 39.94041246864d),
				new Jun2dPoint(130.06872649937d, 42.261891103576d),
				new Jun2dPoint(113.7711688798d, 47.125561157053d),
				new Jun2dPoint(83.313008081892d, 42.450097891659d),
				new Jun2dPoint(97.16930430929d, 59.545426263742d),
				new Jun2dPoint(91.823464597923d, 66.713652099185d),
				new Jun2dPoint(94.254364410556d, 80.500832163691d),
				new Jun2dPoint(113.14745466108d, 113.14745466108d),
				new Jun2dPoint(64.449267234635d, 75.460396577943d),
				new Jun2dPoint(95.237566696975d, 131.08326495138d),
				new Jun2dPoint(100.13814769035d, 163.41060525445d),
				new Jun2dPoint(60.94069111526d, 119.60284059555d),
				new Jun2dPoint(60.751068264924d, 146.66605293383d),
				new Jun2dPoint(54.708236392496d, 168.37463849308d),
				new Jun2dPoint(19.561652292333d, 81.480145795844d),
				new Jun2dPoint(18.235372496518d, 115.13361072056d),
				new Jun2dPoint(10.652216215256d, 135.34924012504d),
				new Jun2dPoint(6.4082259415831e-15, 104.65772811942d),
				new Jun2dPoint(-7.0111911860156d, 89.085630653977d),
				new Jun2dPoint(-21.722095535327d, 137.14791358809d),
				new Jun2dPoint(-38.514655304288d, 160.42508488406d),
				new Jun2dPoint(-56.374997676534d, 173.50440225736d),
				new Jun2dPoint(-72.23444062254d, 174.38936622137d),
				new Jun2dPoint(-74.620081537196d, 146.45015594655d),
				new Jun2dPoint(-100.59148757093d, 164.15038870341d),
				new Jun2dPoint(-58.394079084752d, 80.372554714817d),
				new Jun2dPoint(-112.88830180337d, 132.17521918565d),
				new Jun2dPoint(-62.073197562641d, 62.073197562641d),
				new Jun2dPoint(-72.944501021608d, 62.300489433325d),
				new Jun2dPoint(-158.408564736d, 115.09055908099d),
				new Jun2dPoint(-108.98368008065d, 66.785285047813d),
				new Jun2dPoint(-84.85915124303d, 43.23789718082d),
				new Jun2dPoint(-151.68986453557d, 62.831999165171d),
				new Jun2dPoint(-136.61307300666d, 44.388278182768d),
				new Jun2dPoint(-180.31926396433d, 43.290825130796d),
				new Jun2dPoint(-182.01175567735d, 28.827830055443d),
				new Jun2dPoint(-137.28245432342d, 10.804363472326d),
				new Jun2dPoint(-146.13044946753d, 1.7895227690485e-14),
				new Jun2dPoint(-172.28359633569d, -13.559013089502d),
				new Jun2dPoint(-161.86933002915d, -25.637583242375d),
				new Jun2dPoint(-163.67144789599d, -39.294038107714d),
				new Jun2dPoint(-93.16408800243d, -30.270847173565d),
				new Jun2dPoint(-80.830110086781d, -33.480927846055d),
				new Jun2dPoint(-119.81124929354d, -61.04688065078d),
				new Jun2dPoint(-84.666282193731d, -51.883564457196d),
				new Jun2dPoint(-149.87052048841d, -108.88730682913d),
				new Jun2dPoint(-74.85688568014d, -63.933820233354d),
				new Jun2dPoint(-90.409302836324d, -90.409302836324d),
				new Jun2dPoint(-120.36293249952d, -140.9268872931d),
				new Jun2dPoint(-97.311584545913d, -133.9379056214d),
				new Jun2dPoint(-97.229042696316d, -158.6633773619d),
				new Jun2dPoint(-48.724356516052d, -95.626933972381d),
				new Jun2dPoint(-50.721287344981d, -122.45201980928d),
				new Jun2dPoint(-27.149221981482d, -83.556713539523d),
				new Jun2dPoint(-33.207851796644d, -138.32065745376d),
				new Jun2dPoint(-13.697534906321d, -86.482831762098d),
				new Jun2dPoint(-14.003377191852d, -177.92977759755d),
				new Jun2dPoint(-3.169760770874e-14, -172.55943843942d),
				new Jun2dPoint(13.354320130248d, -169.68272568736d),
				new Jun2dPoint(21.070035481877d, -133.03096843796d),
				new Jun2dPoint(30.844501786732d, -128.47659620083d),
				new Jun2dPoint(28.275428734929d, -87.022821524063d),
				new Jun2dPoint(63.007960233942d, -152.11467213425d),
				new Jun2dPoint(57.321170878882d, -112.49913215475d),
				new Jun2dPoint(49.058024418109d, -80.055419913896d),
				new Jun2dPoint(98.716981343266d, -135.87226836436d),
				new Jun2dPoint(124.49559699594d, -145.76561572561d),
				new Jun2dPoint(78.669150464264d, -78.669150464264d),
				new Jun2dPoint(72.701272448186d, -62.092752606613d),
				new Jun2dPoint(142.86573366585d, -103.79803130293d),
				new Jun2dPoint(109.90414796646d, -67.349348493694d),
				new Jun2dPoint(169.36264382871d, -86.294577224389d),
				new Jun2dPoint(92.890951910073d, -38.476692102899d),
				new Jun2dPoint(174.57294459818d, -56.722188129325d),
				new Jun2dPoint(141.22683272491d, -33.905562749412d),
				new Jun2dPoint(152.66988280879d, -24.180533943083d),
				new Jun2dPoint(123.01254333334d, -9.6812971211708d) };

		Jun2dPoint[] polyline = new Jun2dPoint[points.length];
		for (int i = 0; i < polyline.length; i++) {
			polyline[i] = points[i].scaledBy_(0.5d);
		}
		return polyline;
	}

	/**
	 * Answer the example polyline B.
	 * 
	 * @return jp.co.sra.jun.geometry.basic.Jun2dPoint[]
	 * @category Examples
	 */
	protected static Jun2dPoint[] ExamplePolylineB() {
		Random aRandom = new Random();
		double maxRadius = 100.0d;

		Jun2dPoint[] polyline = new Jun2dPoint[80];
		for (int i = 0; i < polyline.length; i++) {
			double angle = Math.PI * i / 40;
			double radius = (aRandom.nextDouble() * 0.6 + 0.4) * maxRadius;
			polyline[i] = new Jun2dPoint(Math.cos(angle) * radius, Math.sin(angle) * radius);
		}
		return polyline;
	}

	/**
	 * Translate the entire points.
	 * 
	 * @param points jp.co.sra.jun.geometry.basic.Jun2dPoint[]
	 * @param aPoint jp.co.sra.jun.geometry.basic.Jun2dPoint
	 * @return jp.co.sra.jun.geometry.basic.Jun2dPoint[]
	 * @category Private
	 */
	protected static Jun2dPoint[] _TranslatedBy(Jun2dPoint[] points, Jun2dPoint aPoint) {
		Jun2dPoint[] scaledPoints = new Jun2dPoint[points.length];
		for (int i = 0; i < scaledPoints.length; i++) {
			scaledPoints[i] = points[i].translatedBy_(aPoint);
		}
		return scaledPoints;
	}

	/**
	 * Scale the entire points.
	 * 
	 * @param points jp.co.sra.jun.geometry.basic.Jun2dPoint[]
	 * @param aPoint jp.co.sra.jun.geometry.basic.Jun2dPoint
	 * @return jp.co.sra.jun.geometry.basic.Jun2dPoint[]
	 * @category Private
	 */
	protected static Jun2dPoint[] _ScaledBy(Jun2dPoint[] points, Jun2dPoint aPoint) {
		Jun2dPoint[] scaledPoints = new Jun2dPoint[points.length];
		for (int i = 0; i < scaledPoints.length; i++) {
			scaledPoints[i] = points[i].scaledBy_(aPoint);
		}
		return scaledPoints;
	}
}
