package jp.co.sra.jun.geometry.forms;

import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.geometry.surfaces.Jun2dTriangle;

/**
 * JunAbstractFormTriangulation class
 * 
 *  @author    Mitsuhiro Asada
 *  @created   2007/06/11 (by m-asada)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunAbstractFormTriangulation.java,v 8.5 2008/02/20 06:30:57 nisinaka Exp $
 */
public abstract class JunAbstractFormTriangulation extends JunForm2dRegion {
	/**
	 * Create a new instance of <code>JunAbstractFormTriangulation</code> and initialize it.
	 * 
	 * @category Instance creation
	 */
	public JunAbstractFormTriangulation() {
		super();
	}

	/**
	 * Create a new instance of <code>JunAbstractFormTriangulation</code> and initialize it.
	 * 
	 * @param points
	 * @category Instance creation
	 */
	public JunAbstractFormTriangulation(Jun2dPoint[] points) {
		super(points);
	}

	/**
	 * Answer the receiver's current triangles.
	 * 
	 * @return jp.co.sra.jun.geometry.surfaces.Jun2dTriangle[]
	 * @category accessing
	 */
	public abstract Jun2dTriangle[] triangles();
}
