package jp.co.sra.jun.geometry.boundaries;

import java.awt.Color;
import java.awt.Rectangle;

import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.pluralities.Jun3dBoundingBoxes;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dCompoundObject;
import jp.co.sra.jun.system.support.JunTestExamples;

/**
 * Jun3dBoundingBoxTestExamples class
 * 
 *  @author    nisinaka
 *  @created   1998/10/05 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun582 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: Jun3dBoundingBoxTestExamples.java,v 8.12 2008/02/20 06:30:55 nisinaka Exp $
 */
public class Jun3dBoundingBoxTestExamples extends JunTestExamples {
	/**
	 * Example1: 
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example1() {
		Jun3dBoundingBoxes boundingBoxes = new Jun3dBoundingBoxes();
		boundingBoxes.add_(Jun3dBoundingBox.Origin_corner_(new Jun3dPoint(51, 33, 0), new Jun3dPoint(195, 147, 80)));
		boundingBoxes.add_(Jun3dBoundingBox.Origin_corner_(new Jun3dPoint(93, 45, 20), new Jun3dPoint(237, 159, 100)));
		boundingBoxes.add_(Jun3dBoundingBox.Origin_corner_(new Jun3dPoint(129, 69, 40), new Jun3dPoint(273, 183, 120)));
		boundingBoxes.add_(Jun3dBoundingBox.Origin_corner_(new Jun3dPoint(81, 111, 60), new Jun3dPoint(225, 225, 140)));

		JunOpenGL3dCompoundObject compoundObject = new JunOpenGL3dCompoundObject();
		compoundObject.add_(boundingBoxes.asJunOpenGL3dObjectColor_alpha_(Color.cyan, 0.5f));
		compoundObject.add_(boundingBoxes.intersectionBoxes().asJunOpenGL3dObjectColor_alpha_(Color.magenta, 0.25f).translatedBy_(new Jun3dPoint(0, 0, 200)));
		compoundObject.add_(boundingBoxes.unionBoxes().asJunOpenGL3dObjectColor_alpha_(Color.magenta, 0.25f).translatedBy_(new Jun3dPoint(0, 0, 400)));
		compoundObject.add_(boundingBoxes.complementBoxes().asJunOpenGL3dObjectColor_alpha_(Color.magenta, 0.25f).translatedBy_(new Jun3dPoint(0, 0, 600)));
		compoundObject.add_(boundingBoxes.differenceBoxes().asJunOpenGL3dObjectColor_alpha_(Color.magenta, 0.25f).translatedBy_(new Jun3dPoint(0, 0, 800)));

		compoundObject.showIn_(new Rectangle(200, 200, 280, 500));

		return true;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean _Example1() {
		Jun3dPoint originPoint = new Jun3dPoint(0, 0, 0);
		Jun3dPoint cornerPoint = new Jun3dPoint(100, 100, 100);
		Jun3dBoundingBox aBoundingBox = Jun3dBoundingBox.Origin_corner_(originPoint, cornerPoint);
		System.out.println(aBoundingBox.printString());

		return true;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean _Example2() {
		Jun3dPoint aPoint1 = new Jun3dPoint(0, 100, 0);
		Jun3dPoint aPoint2 = new Jun3dPoint(100, 0, 100);
		Jun3dBoundingBox aBoundingBox = Jun3dBoundingBox.Vertex_vertex_(aPoint1, aPoint2);
		System.out.println(aBoundingBox.printString());

		return true;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean _Example3() {
		Jun3dPoint aPoint1 = new Jun3dPoint(0, 100, 0);
		Jun3dPoint aPoint2 = new Jun3dPoint(100, 0, 100);
		Jun3dBoundingBox aBoundingBox = Jun3dBoundingBox.Vertex_vertex_(aPoint1, aPoint2);
		System.out.println(aBoundingBox.expandedBy_(10).printString());

		return true;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean _Example4() {
		Jun3dPoint aPoint1 = new Jun3dPoint(0, 100, 0);
		Jun3dPoint aPoint2 = new Jun3dPoint(100, 0, 100);
		Jun3dBoundingBox aBoundingBox = Jun3dBoundingBox.Vertex_vertex_(aPoint1, aPoint2);
		System.out.println(aBoundingBox.insetBy_(10).printString());

		return true;
	}

	/**
	 * Example: for subdivide.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean _ExampleSubdivide() {
		new Jun3dPoint(0, 0, 0).box_(new Jun3dPoint(1, 1, 1)).subdivide().showWithUnitArrows().wireframePresentation();
		new Jun3dPoint(0, 0, 0).box_(new Jun3dPoint(1, 1, 1)).subdivide2().showWithUnitArrows().wireframePresentation();
		new Jun3dPoint(0, 0, 0).box_(new Jun3dPoint(1, 0.9, 0.9)).subdivide2().showWithUnitArrows().wireframePresentation();
		new Jun3dPoint(0, 0, 0).box_(new Jun3dPoint(0.9, 1, 0.9)).subdivide2().showWithUnitArrows().wireframePresentation();
		new Jun3dPoint(0, 0, 0).box_(new Jun3dPoint(0.9, 0.9, 1)).subdivide2().showWithUnitArrows().wireframePresentation();

		return true;
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args java.lang.String[]
	 * @category Main
	 */
	public static void main(String[] args) throws Exception {
		new Jun3dBoundingBoxTestExamples();
	}
}
