package jp.co.sra.jun.geometry.boundaries;

import java.awt.Color;
import java.util.Random;
import java.util.Vector;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.boundaries.Jun3dBoundingBall;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dCompoundObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dVertex;
import jp.co.sra.jun.opengl.texture.JunOpenGLStipple;
import jp.co.sra.jun.system.support.JunTestExamples;

/**
 * Jun3dBoundingBallTestExamples class
 * 
 *  @author    NISHIHARA Satoshi
 *  @created   2000/01/24 (by NISHIHARA Satoshi)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: Jun3dBoundingBallTestExamples.java,v 8.11 2008/02/20 06:30:55 nisinaka Exp $
 */
public class Jun3dBoundingBallTestExamples extends JunTestExamples {
	/**
	 * Example1
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example1() {
		Jun3dPoint[] points = new Jun3dPoint[20];
		Random randomStream = new Random();
		for (int i = 0; i < points.length; i++) {
			Jun3dPoint point = new Jun3dPoint(randomStream.nextDouble(), randomStream.nextDouble(), randomStream.nextDouble());
			points[i] = point;
		}
		Jun3dBoundingBall boundingBall = new Jun3dBoundingBall(points);
		Vector aCollection = new Vector(points.length);
		for (int i = 0; i < points.length; i++) {
			JunOpenGL3dVertex aJunOpenGL3dVertex = JunOpenGL3dVertex.Point_(points[i]);
			aJunOpenGL3dVertex.size_(4);
			aJunOpenGL3dVertex.paint_(Color.black);
			aCollection.addElement(aJunOpenGL3dVertex);
		}
		JunOpenGL3dCompoundObject openGLObject = new JunOpenGL3dCompoundObject(aCollection);
		JunOpenGL3dCompoundObject openGLBall = (JunOpenGL3dCompoundObject) JunOpenGL3dObject.Globe_radius_center_(15, boundingBall.radius(), boundingBall.center());
		openGLBall.paint_(Color.blue);

		JunOpenGLStipple stipple = JunOpenGLStipple.Halftone_(0.25);
		for (int each = 0; each < openGLBall.components().length; each++) {
			openGLBall.components()[each].stipple_(stipple);
		}
		openGLObject.add_(openGLBall);
		openGLObject.show();

		return true;
	}

	/**
	 * Example2
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example2() {
		Jun3dPoint[] points = Jun3dBoundingBallTestExamples.SamplePointCollection();
		Jun3dBoundingBall boundingBall = new Jun3dBoundingBall(points);
		Vector aCollection = new Vector(points.length);
		for (int i = 0; i < points.length; i++) {
			JunOpenGL3dVertex aJunOpenGL3dVertex = JunOpenGL3dVertex.Point_(points[i]);
			aJunOpenGL3dVertex.size_(4);
			aJunOpenGL3dVertex.paint_(Color.black);
			aCollection.addElement(aJunOpenGL3dVertex);
		}
		JunOpenGL3dCompoundObject openGLObject = new JunOpenGL3dCompoundObject(aCollection);
		JunOpenGL3dCompoundObject openGLBall = (JunOpenGL3dCompoundObject) JunOpenGL3dObject.Globe_radius_center_(15, boundingBall.radius(), boundingBall.center());
		openGLBall.paint_(Color.blue);

		JunOpenGLStipple stipple = JunOpenGLStipple.Halftone_(0.25);
		for (int each = 0; each < openGLBall.components().length; each++) {
			openGLBall.components()[each].stipple_(stipple);
		}
		openGLObject.add_(openGLBall);
		openGLObject.show();

		return true;
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args java.lang.String[]
	 * @category Main
	 */
	public static void main(String[] args) throws Exception {
		new Jun3dBoundingBallTestExamples();
	}

	/**
	 * Answer the sample point collections.
	 * 
	 * @return Jun3dPoint[] jp.co.sra.jun.geometry.basic.Jun3dPoint[]
	 * @category Examples
	 */
	protected static Jun3dPoint[] SamplePointCollection() {
		Jun3dPoint[] points = new Jun3dPoint[20];
		int index = 0;
		points[index++] = new Jun3dPoint(0.73635985006247d, 0.93891711786756d, 0.048763015410246d);
		points[index++] = new Jun3dPoint(0.9026322365681d, 0.19440233236152d, 0.47509371095377d);
		points[index++] = new Jun3dPoint(0.15286963765098d, 0.49303623490212d, 0.61804248229904d);
		points[index++] = new Jun3dPoint(0.50748021657643d, 0.99808413161183d, 0.78373177842566d);
		points[index++] = new Jun3dPoint(0.41544356518117d, 0.30138275718451d, 0.70685547688463d);
		points[index++] = new Jun3dPoint(0.75431070387339d, 0.42334027488546d, 0.55067888379842d);
		points[index++] = new Jun3dPoint(0.83020408163265d, 0.81293627655144d, 0.90703873386089d);
		points[index++] = new Jun3dPoint(0.37781757601d, 0.34772178259059d, 0.79634319033736d);
		points[index++] = new Jun3dPoint(0.56041649312786d, 0.33381924198251d, 0.66757184506456d);
		points[index++] = new Jun3dPoint(0.96983756768013d, 0.50592253227822d, 0.39827571845065d);
		points[index++] = new Jun3dPoint(0.62648896293211d, 0.027296959600167d, 0.29457725947522d);
		points[index++] = new Jun3dPoint(0.97935027072053d, 0.48977925864223d, 0.091170345689296d);
		points[index++] = new Jun3dPoint(0.90597251145356d, 0.91377759266972d, 0.95132028321533d);
		points[index++] = new Jun3dPoint(0.71247813411079d, 0.74827155351937d, 0.46686380674719d);
		points[index++] = new Jun3dPoint(0.13356101624323d, 0.87081216159933d, 0.65820907955019d);
		points[index++] = new Jun3dPoint(0.33248646397334d, 0.58752186588921d, 0.97433569346106d);
		points[index++] = new Jun3dPoint(0.901091211995d, 0.63309454394002d, 0.29279466888796d);
		points[index++] = new Jun3dPoint(0.85978342357351d, 0.17079550187422d, 0.9197084548105d);
		points[index++] = new Jun3dPoint(0.65754269054561d, 0.79246147438567d, 0.58977092877968d);
		points[index++] = new Jun3dPoint(0.17192003331945d, 0.51850062473969d, 0.46624739691795d);
		return points;
	}
}
