package jp.co.sra.jun.geometry.abstracts;

import jp.co.sra.jun.geometry.curves.JunNurbsCurve;
import jp.co.sra.smalltalk.SmalltalkException;

/**
 * JunCurve class
 * 
 *  @author    nisinaka
 *  @created   1998/09/29 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun508 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunCurve.java,v 8.10 2008/02/20 06:30:54 nisinaka Exp $
 */
public abstract class JunCurve extends JunGeometry {
	/**
	 * Convert the receiver as a nurbs curve.
	 * 
	 * @return JunNurbsCurve
	 * @category converting
	 */
	public JunNurbsCurve asNurbsCurve() {
		throw SmalltalkException.SubclassResponsibility();
	}

	/**
	 * Answer true if this is a kind of Curve geometry object, otherwise false.
	 * 
	 * @return boolean
	 * @category testing
	 */
	public boolean isCurve() {
		return true;
	}
}
