package jp.co.sra.jun.dxf.support;

import java.io.PrintWriter;
import java.io.StringWriter;

import jp.co.sra.smalltalk.StReadStream;

import jp.co.sra.jun.system.support.JunTestExamples;

/**
 * JunDXFParserTestExamples class
 * 
 *  @author    nisinaka
 *  @created   2002/07/11 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunDXFParserTestExamples.java,v 8.11 2008/02/20 06:30:54 nisinaka Exp $
 */
public class JunDXFParserTestExamples extends JunTestExamples {
	/**
	 * DOCUMENT ME!
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example2() {
		JunDXFParser parser = new JunDXFParser();
		parser.on_(new StReadStream(Text2()));
		parser.parse();
		parser.showCAD();

		return true;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean ExampleARC() {
		JunDXFParser parser = new JunDXFParser();
		parser.on_(new StReadStream(TextARC()));
		parser.parse();
		parser.showCAD();

		return true;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean ExampleCIRCLE() {
		JunDXFParser parser = new JunDXFParser();
		parser.on_(new StReadStream(TextCIRCLE()));
		parser.parse();
		parser.showCAD();

		return true;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean ExampleLINE() {
		JunDXFParser parser = new JunDXFParser();
		parser.on_(new StReadStream(TextLINE()));
		parser.parse();
		parser.showCAD();

		return true;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean ExamplePOLYLINE() {
		JunDXFParser parser = new JunDXFParser();
		parser.on_(new StReadStream(TextPOLYLINE()));
		parser.parse();
		parser.showCAD();

		return true;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @param args java.lang.String[]
	 * @category Main
	 */
	public static void main(String[] args) {
		new JunDXFParserTestExamples();
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return boolean
	 * @category Examples
	 */
	protected static boolean Example1() {
		JunDXFParser parser = new JunDXFParser();
		parser.on_(new StReadStream(Text1()));
		parser.parse();
		parser.showCAD();

		return true;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return boolean
	 * @category Examples
	 */
	protected static boolean ExampleDefLine() {
		JunDXFParser parser = new JunDXFParser();
		parser.on_(new StReadStream(TextDefLine()));
		parser.parse();
		parser.showCAD();

		return true;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return java.lang.String
	 * @category Examples
	 */
	protected static String Text1() {
		StringWriter sw = new StringWriter();
		PrintWriter pw = new PrintWriter(sw);
		pw.println("  0");
		pw.println("SECTION");
		pw.println("  2");
		pw.println("HEADER");
		pw.println(" 10");
		pw.println("1.123");
		pw.println(" 20");
		pw.println("2.345");
		pw.println(" 0");
		pw.println("ENDSEC");
		pw.println("  0");
		pw.println("SECTION");
		pw.println("  2");
		pw.println("TABLES");
		pw.println(" 10");
		pw.println("1.0");
		pw.println("  0");
		pw.println("ENDSEC");
		pw.println("  0");
		pw.println("SECTION");
		pw.println("  2");
		pw.println("BLOCKS");
		pw.println(" 10");
		pw.println("1.3");
		pw.println("  0");
		pw.println("ENDSEC");
		pw.println("  0");
		pw.println("SECTION");
		pw.println("  2");
		pw.println("ENTITIES");
		pw.println(" 10");
		pw.println("3.4");
		pw.println("  0");
		pw.println("ENDSEC");
		pw.println("  0");
		pw.println("EOF");

		return sw.toString();
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return java.lang.String
	 * @category Examples
	 */
	protected static String Text2() {
		StringWriter sw = new StringWriter();
		PrintWriter pw = new PrintWriter(sw);
		pw.println("  0");
		pw.println("SECTION");
		pw.println("  2");
		pw.println("HEADER");
		pw.println("  9");
		pw.println("$ACADVER");
		pw.println("  1");
		pw.println("AC1006");
		pw.println("  9");
		pw.println("$CLAYER");
		pw.println("  8");
		pw.println("LAYER-1");
		pw.println("  9");
		pw.println("$EXTMIN");
		pw.println(" 10");
		pw.println("0.000000");
		pw.println(" 20");
		pw.println("0.000000");
		pw.println("  9");
		pw.println("$EXTMAX");
		pw.println(" 10");
		pw.println("12.415473");
		pw.println(" 20");
		pw.println("6.960133");
		pw.println("  9");
		pw.println("$FASTZOOM");
		pw.println(" 70");
		pw.println("0");
		pw.println("  9");
		pw.println("$FILLMODE");
		pw.println(" 70");
		pw.println("1");
		pw.println("  0");
		pw.println("ENDSEC");
		pw.println("  0");
		pw.println("SECTION");
		pw.println("  2");
		pw.println("TABLES");
		pw.println("  0");
		pw.println("TABLE");
		pw.println("  2");
		pw.println("LTYPE");
		pw.println(" 70");
		pw.println("16");
		pw.println("  0");
		pw.println("LTYPE");
		pw.println("  2");
		pw.println("CONTINUOUS");
		pw.println(" 70");
		pw.println("64");
		pw.println("  3");
		pw.println("Solid Line");
		pw.println(" 72");
		pw.println("65");
		pw.println(" 73");
		pw.println("0");
		pw.println(" 40");
		pw.println("0.000000");
		pw.println("  0");
		pw.println("LTYPE");
		pw.println("  2");
		pw.println("LTYPE01");
		pw.println(" 70");
		pw.println("64");
		pw.println("  3");
		pw.println("CUSTOM");
		pw.println(" 72");
		pw.println("65");
		pw.println(" 73");
		pw.println("2");
		pw.println(" 40");
		pw.println("0.111111");
		pw.println(" 49");
		pw.println("0.083333");
		pw.println(" 49");
		pw.println("-0.027778");
		pw.println("  0");
		pw.println("LTYPE");
		pw.println("  2");
		pw.println("LTYPE02");
		pw.println(" 70");
		pw.println("64");
		pw.println("  3");
		pw.println("CUSTOM");
		pw.println(" 72");
		pw.println("65");
		pw.println(" 73");
		pw.println("2");
		pw.println(" 40");
		pw.println("0.194444");
		pw.println(" 49");
		pw.println("0.166667");
		pw.println(" 49");
		pw.println("-0.027778");
		pw.println("  0");
		pw.println("LTYPE");
		pw.println("  2");
		pw.println("LTYPE03");
		pw.println(" 70");
		pw.println("64");
		pw.println("  3");
		pw.println("CUSTOM");
		pw.println(" 72");
		pw.println("65");
		pw.println(" 73");
		pw.println("2");
		pw.println(" 40");
		pw.println("0.375000");
		pw.println(" 49");
		pw.println("0.333333");
		pw.println(" 49");
		pw.println("-0.041667");
		pw.println("  0");
		pw.println("LTYPE");
		pw.println("  2");
		pw.println("LTYPE04");
		pw.println(" 70");
		pw.println("64");
		pw.println("  3");
		pw.println("CUSTOM");
		pw.println(" 72");
		pw.println("65");
		pw.println(" 73");
		pw.println("2");
		pw.println(" 40");
		pw.println("0.722222");
		pw.println(" 49");
		pw.println("0.666667");
		pw.println(" 49");
		pw.println("-0.055556");
		pw.println("  0");
		pw.println("LTYPE");
		pw.println("  2");
		pw.println("LTYPE05");
		pw.println(" 70");
		pw.println("64");
		pw.println("  3");
		pw.println("CUSTOM");
		pw.println(" 72");
		pw.println("65");
		pw.println(" 73");
		pw.println("4");
		pw.println(" 40");
		pw.println("0.152778");
		pw.println(" 49");
		pw.println("0.083333");
		pw.println(" 49");
		pw.println("-0.027778");
		pw.println(" 49");
		pw.println("0.013889");
		pw.println(" 49");
		pw.println("-0.027778");
		pw.println("  0");
		pw.println("LTYPE");
		pw.println("  2");
		pw.println("LTYPE06");
		pw.println(" 70");
		pw.println("64");
		pw.println("  3");
		pw.println("CUSTOM");
		pw.println(" 72");
		pw.println("65");
		pw.println(" 73");
		pw.println("4");
		pw.println(" 40");
		pw.println("0.236111");
		pw.println(" 49");
		pw.println("0.166667");
		pw.println(" 49");
		pw.println("-0.027778");
		pw.println(" 49");
		pw.println("0.013889");
		pw.println(" 49");
		pw.println("-0.027778");
		pw.println("  0");
		pw.println("LTYPE");
		pw.println("  2");
		pw.println("LTYPE07");
		pw.println(" 70");
		pw.println("64");
		pw.println("  3");
		pw.println("CUSTOM");
		pw.println(" 72");
		pw.println("65");
		pw.println(" 73");
		pw.println("4");
		pw.println(" 40");
		pw.println("0.444444");
		pw.println(" 49");
		pw.println("0.333333");
		pw.println(" 49");
		pw.println("-0.041667");
		pw.println(" 49");
		pw.println("0.027778");
		pw.println(" 49");
		pw.println("-0.041667");
		pw.println("  0");
		pw.println("LTYPE");
		pw.println("  2");
		pw.println("LTYPE08");
		pw.println(" 70");
		pw.println("64");
		pw.println("  3");
		pw.println("CUSTOM");
		pw.println(" 72");
		pw.println("65");
		pw.println(" 73");
		pw.println("4");
		pw.println(" 40");
		pw.println("0.805556");
		pw.println(" 49");
		pw.println("0.666667");
		pw.println(" 49");
		pw.println("-0.055556");
		pw.println(" 49");
		pw.println("0.027778");
		pw.println(" 49");
		pw.println("-0.055556");
		pw.println("  0");
		pw.println("LTYPE");
		pw.println("  2");
		pw.println("LTYPE09");
		pw.println(" 70");
		pw.println("64");
		pw.println("  3");
		pw.println("CUSTOM");
		pw.println(" 72");
		pw.println("65");
		pw.println(" 73");
		pw.println("6");
		pw.println(" 40");
		pw.println("0.194444");
		pw.println(" 49");
		pw.println("0.083333");
		pw.println(" 49");
		pw.println("-0.027778");
		pw.println(" 49");
		pw.println("0.013889");
		pw.println(" 49");
		pw.println("-0.027778");
		pw.println(" 49");
		pw.println("0.013889");
		pw.println(" 49");
		pw.println("-0.027778");
		pw.println("  0");
		pw.println("LTYPE");
		pw.println("  2");
		pw.println("LTYPE10");
		pw.println(" 70");
		pw.println("64");
		pw.println("  3");
		pw.println("CUSTOM");
		pw.println(" 72");
		pw.println("65");
		pw.println(" 73");
		pw.println("6");
		pw.println(" 40");
		pw.println("0.277778");
		pw.println(" 49");
		pw.println("0.166667");
		pw.println(" 49");
		pw.println("-0.027778");
		pw.println(" 49");
		pw.println("0.013889");
		pw.println(" 49");
		pw.println("-0.027778");
		pw.println(" 49");
		pw.println("0.013889");
		pw.println(" 49");
		pw.println("-0.027778");
		pw.println("  0");
		pw.println("LTYPE");
		pw.println("  2");
		pw.println("LTYPE11");
		pw.println(" 70");
		pw.println("64");
		pw.println("  3");
		pw.println("CUSTOM");
		pw.println(" 72");
		pw.println("65");
		pw.println(" 73");
		pw.println("6");
		pw.println(" 40");
		pw.println("0.500000");
		pw.println(" 49");
		pw.println("0.333333");
		pw.println(" 49");
		pw.println("-0.041667");
		pw.println(" 49");
		pw.println("0.027778");
		pw.println(" 49");
		pw.println("-0.027778");
		pw.println(" 49");
		pw.println("0.027778");
		pw.println(" 49");
		pw.println("-0.041667");
		pw.println("  0");
		pw.println("LTYPE");
		pw.println("  2");
		pw.println("LTYPE12");
		pw.println(" 70");
		pw.println("64");
		pw.println("  3");
		pw.println("CUSTOM");
		pw.println(" 72");
		pw.println("65");
		pw.println(" 73");
		pw.println("6");
		pw.println(" 40");
		pw.println("0.861111");
		pw.println(" 49");
		pw.println("0.666667");
		pw.println(" 49");
		pw.println("-0.055556");
		pw.println(" 49");
		pw.println("0.027778");
		pw.println(" 49");
		pw.println("-0.027778");
		pw.println(" 49");
		pw.println("0.027778");
		pw.println(" 49");
		pw.println("-0.055556");
		pw.println("  0");
		pw.println("LTYPE");
		pw.println("  2");
		pw.println("LTYPE13");
		pw.println(" 70");
		pw.println("64");
		pw.println("  3");
		pw.println("CUSTOM");
		pw.println(" 72");
		pw.println("65");
		pw.println(" 73");
		pw.println("8");
		pw.println(" 40");
		pw.println("0.319444");
		pw.println(" 49");
		pw.println("0.166667");
		pw.println(" 49");
		pw.println("-0.027778");
		pw.println(" 49");
		pw.println("0.013889");
		pw.println(" 49");
		pw.println("-0.027778");
		pw.println(" 49");
		pw.println("0.013889");
		pw.println(" 49");
		pw.println("-0.027778");
		pw.println(" 49");
		pw.println("0.013889");
		pw.println(" 49");
		pw.println("-0.027778");
		pw.println("  0");
		pw.println("LTYPE");
		pw.println("  2");
		pw.println("LTYPE14");
		pw.println(" 70");
		pw.println("64");
		pw.println("  3");
		pw.println("CUSTOM");
		pw.println(" 72");
		pw.println("65");
		pw.println(" 73");
		pw.println("8");
		pw.println(" 40");
		pw.println("0.555556");
		pw.println(" 49");
		pw.println("0.333333");
		pw.println(" 49");
		pw.println("-0.041667");
		pw.println(" 49");
		pw.println("0.027778");
		pw.println(" 49");
		pw.println("-0.027778");
		pw.println(" 49");
		pw.println("0.027778");
		pw.println(" 49");
		pw.println("-0.027778");
		pw.println(" 49");
		pw.println("0.027778");
		pw.println(" 49");
		pw.println("-0.041667");
		pw.println("  0");
		pw.println("LTYPE");
		pw.println("  2");
		pw.println("LTYPE15");
		pw.println(" 70");
		pw.println("64");
		pw.println("  3");
		pw.println("CUSTOM");
		pw.println(" 72");
		pw.println("65");
		pw.println(" 73");
		pw.println("8");
		pw.println(" 40");
		pw.println("0.944444");
		pw.println(" 49");
		pw.println("0.666667");
		pw.println(" 49");
		pw.println("-0.055556");
		pw.println(" 49");
		pw.println("0.027778");
		pw.println(" 49");
		pw.println("-0.041667");
		pw.println(" 49");
		pw.println("0.027778");
		pw.println(" 49");
		pw.println("-0.041667");
		pw.println(" 49");
		pw.println("0.027778");
		pw.println(" 49");
		pw.println("-0.055556");
		pw.println("  0");
		pw.println("ENDTAB");
		pw.println("  0");
		pw.println("TABLE");
		pw.println("  2");
		pw.println("LAYER");
		pw.println(" 70");
		pw.println("2");
		pw.println("  0");
		pw.println("LAYER");
		pw.println("  2");
		pw.println("LAYER-1");
		pw.println(" 70");
		pw.println("0");
		pw.println(" 62");
		pw.println("7");
		pw.println("  6");
		pw.println("CONTINUOUS");
		pw.println("  0");
		pw.println("LAYER");
		pw.println("  2");
		pw.println("LAYER-2");
		pw.println(" 70");
		pw.println("0");
		pw.println(" 62");
		pw.println("7");
		pw.println("  6");
		pw.println("CONTINUOUS");
		pw.println("  0");
		pw.println("ENDTAB");
		pw.println("  0");
		pw.println("ENDSEC");
		pw.println("  0");
		pw.println("SECTION");
		pw.println("  2");
		pw.println("BLOCKS");
		pw.println("  0");
		pw.println("ENDSEC");
		pw.println("  0");
		pw.println("SECTION");
		pw.println("  2");
		pw.println("ENTITIES");
		pw.println("  0");
		pw.println("POLYLINE");
		pw.println("  8");
		pw.println("LAYER-2");
		pw.println(" 66");
		pw.println("  1");
		pw.println("210");
		pw.println("  0");
		pw.println("220");
		pw.println("  0");
		pw.println("230");
		pw.println("  1");
		pw.println(" 70");
		pw.println("  0");
		pw.println(" 62");
		pw.println("  0");
		pw.println("  0");
		pw.println("VERTEX");
		pw.println("  8");
		pw.println("LAYER-2");
		pw.println(" 10");
		pw.println("0.434028");
		pw.println(" 20");
		pw.println("2.013898");
		pw.println(" 30");
		pw.println("0.000000");
		pw.println("  0");
		pw.println("VERTEX");
		pw.println("  8");
		pw.println("LAYER-2");
		pw.println(" 10");
		pw.println("0.610805");
		pw.println(" 20");
		pw.println("2.190675");
		pw.println(" 30");
		pw.println("0.000000");
		pw.println("  0");
		pw.println("VERTEX");
		pw.println("  8");
		pw.println("LAYER-2");
		pw.println(" 10");
		pw.println("0.787582");
		pw.println(" 20");
		pw.println("2.013898");
		pw.println(" 30");
		pw.println("0.000000");
		pw.println("  0");
		pw.println("VERTEX");
		pw.println("  8");
		pw.println("LAYER-2");
		pw.println(" 10");
		pw.println("0.610805");
		pw.println(" 20");
		pw.println("1.837121");
		pw.println(" 30");
		pw.println("0.000000");
		pw.println("  0");
		pw.println("SEQEND");
		pw.println("  8");
		pw.println("LAYER-2");
		pw.println("  0");
		pw.println("POLYLINE");
		pw.println("  8");
		pw.println("LAYER-2");
		pw.println(" 66");
		pw.println("  1");
		pw.println(" 70");
		pw.println("  1");
		pw.println(" 62");
		pw.println("  0");
		pw.println("  0");
		pw.println("VERTEX");
		pw.println("  8");
		pw.println("LAYER-2");
		pw.println(" 10");
		pw.println("0.607639");
		pw.println(" 20");
		pw.println("1.840287");
		pw.println(" 30");
		pw.println("0.000000");
		pw.println("  0");
		pw.println("VERTEX");
		pw.println("  8");
		pw.println("LAYER-2");
		pw.println(" 10");
		pw.println("0.784416");
		pw.println(" 20");
		pw.println("2.017064");
		pw.println(" 30");
		pw.println("0.000000");
		pw.println("  0");
		pw.println("VERTEX");
		pw.println("  8");
		pw.println("LAYER-2");
		pw.println(" 10");
		pw.println("0.961193");
		pw.println(" 20");
		pw.println("1.840287");
		pw.println(" 30");
		pw.println("0.000000");
		pw.println("  0");
		pw.println("VERTEX");
		pw.println("  8");
		pw.println("LAYER-2");
		pw.println(" 10");
		pw.println("0.784416");
		pw.println(" 20");
		pw.println("1.663510");
		pw.println(" 30");
		pw.println("0.000000");
		pw.println("  0");
		pw.println("SEQEND");
		pw.println("  8");
		pw.println("LAYER-2");
		pw.println("  0");
		pw.println("ENDSEC");
		pw.println("  0");
		pw.println("EOF");

		return sw.toString();
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return java.lang.String
	 * @category Examples
	 */
	protected static String TextARC() {
		StringWriter sw = new StringWriter();
		PrintWriter pw = new PrintWriter(sw);
		pw.println("   0");
		pw.println("SECTION");
		pw.println("  2");
		pw.println("ENTITIES");
		pw.println("  0");
		pw.println("ARC");
		pw.println("  5");
		pw.println("73");
		pw.println("  8");
		pw.println("0");
		pw.println("  6");
		pw.println("CONTINUOUS");
		pw.println(" 62");
		pw.println("     7");
		pw.println(" 10");
		pw.println("0.042566");
		pw.println(" 20");
		pw.println("0.095575");
		pw.println(" 30");
		pw.println("0.0");
		pw.println(" 40");
		pw.println("1.6");
		pw.println(" 50");
		pw.println("90.0");
		pw.println(" 51");
		pw.println("270.0");
		pw.println("  0");
		pw.println("LINE");
		pw.println("  5");
		pw.println("70");
		pw.println("  8");
		pw.println("0");
		pw.println("  6");
		pw.println("CONTINUOUS");
		pw.println(" 62");
		pw.println("     6");
		pw.println(" 10");
		pw.println("-0.0547");
		pw.println(" 20");
		pw.println("-0.0547");
		pw.println(" 30");
		pw.println("0.0");
		pw.println(" 11");
		pw.println("0.0547");
		pw.println(" 21");
		pw.println("0.0547");
		pw.println(" 31");
		pw.println("0.0");
		pw.println("  0");
		pw.println("ENDSEC");
		pw.println("  0");
		pw.println("EOF");

		return sw.toString();
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return java.lang.String
	 * @category Examples
	 */
	protected static String TextCIRCLE() {
		StringWriter sw = new StringWriter();
		PrintWriter pw = new PrintWriter(sw);
		pw.println("   0");
		pw.println("SECTION");
		pw.println("  2");
		pw.println("ENTITIES");
		pw.println("  0");
		pw.println("LINE");
		pw.println("  5");
		pw.println("70");
		pw.println("  8");
		pw.println("0");
		pw.println("  6");
		pw.println("CONTINUOUS");
		pw.println(" 62");
		pw.println("     6");
		pw.println(" 10");
		pw.println("-0.0547");
		pw.println(" 20");
		pw.println("-0.0547");
		pw.println(" 30");
		pw.println("0.0");
		pw.println(" 11");
		pw.println("0.0547");
		pw.println(" 21");
		pw.println("0.0547");
		pw.println(" 31");
		pw.println("0.0");
		pw.println("  0");
		pw.println("CIRCLE");
		pw.println("  5");
		pw.println("72");
		pw.println("  8");
		pw.println("0");
		pw.println(" 62");
		pw.println("     7");
		pw.println(" 10");
		pw.println("0.0");
		pw.println(" 20");
		pw.println("0.0");
		pw.println(" 30");
		pw.println("0.0");
		pw.println(" 40");
		pw.println("1.5");
		pw.println("  0");
		pw.println("ENDSEC");
		pw.println("  0");
		pw.println("EOF");

		return sw.toString();
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return java.lang.String
	 * @category Examples
	 */
	protected static String TextDefLine() {
		StringWriter sw = new StringWriter();
		PrintWriter pw = new PrintWriter(sw);
		pw.println("  0");
		pw.println("SECTION");
		pw.println("  2");
		pw.println("BLOCKS");
		pw.println("  0");
		pw.println("BLOCK");
		pw.println("  8");
		pw.println("0");
		pw.println("  2");
		pw.println("WGV");
		pw.println(" 70");
		pw.println("     0");
		pw.println(" 10");
		pw.println("0.0");
		pw.println(" 20");
		pw.println("0.0");
		pw.println(" 30");
		pw.println("0.0");
		pw.println("  3");
		pw.println("WGV");
		pw.println("  1");
		pw.println("");
		pw.println("  0");
		pw.println("LINE");
		pw.println("  5");
		pw.println("6F");
		pw.println("  8");
		pw.println("0");
		pw.println("  6");
		pw.println("CONTINUOUS");
		pw.println(" 62");
		pw.println("     6");
		pw.println(" 10");
		pw.println("0.0547");
		pw.println(" 20");
		pw.println("-0.0547");
		pw.println(" 30");
		pw.println("0.0");
		pw.println(" 11");
		pw.println("0.0547");
		pw.println(" 21");
		pw.println("0.0547");
		pw.println(" 31");
		pw.println("0.0");
		pw.println("  0");
		pw.println("LINE");
		pw.println("  5");
		pw.println("70");
		pw.println("  8");
		pw.println("0");
		pw.println("  6");
		pw.println("CONTINUOUS");
		pw.println(" 62");
		pw.println("     6");
		pw.println(" 10");
		pw.println("-0.0547");
		pw.println(" 20");
		pw.println("-0.0547");
		pw.println(" 30");
		pw.println("0.0");
		pw.println(" 11");
		pw.println("0.0547");
		pw.println(" 21");
		pw.println("0.0547");
		pw.println(" 31");
		pw.println("0.0");
		pw.println("  0");
		pw.println("LINE");
		pw.println("  5");
		pw.println("71");
		pw.println("  8");
		pw.println("0");
		pw.println("  6");
		pw.println("CONTINUOUS");
		pw.println(" 62");
		pw.println("     6");
		pw.println(" 10");
		pw.println("-0.0547");
		pw.println(" 20");
		pw.println("0.0547");
		pw.println(" 30");
		pw.println("0.0");
		pw.println(" 11");
		pw.println("0.0547");
		pw.println(" 21");
		pw.println("-0.0547");
		pw.println(" 31");
		pw.println("0.0");
		pw.println("  0");
		pw.println("LINE");
		pw.println("  5");
		pw.println("72");
		pw.println("  8");
		pw.println("0");
		pw.println("  6");
		pw.println("CONTINUOUS");
		pw.println(" 62");
		pw.println("     6");
		pw.println(" 10");
		pw.println("-0.0547");
		pw.println(" 20");
		pw.println("-0.0547");
		pw.println(" 30");
		pw.println("0.0");
		pw.println(" 11");
		pw.println("-0.0547");
		pw.println(" 21");
		pw.println("0.0547");
		pw.println(" 31");
		pw.println("0.0");
		pw.println("  0");
		pw.println("ENDBLK");
		pw.println("  0");
		pw.println("ENDSEC");
		pw.println("  0");
		pw.println("EOF");

		return sw.toString();
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return java.lang.String
	 * @category Examples
	 */
	protected static String TextLINE() {
		StringWriter sw = new StringWriter();
		PrintWriter pw = new PrintWriter(sw);
		pw.println("  0");
		pw.println("SECTION");
		pw.println("  2");
		pw.println("ENTITIES");
		pw.println("  0");
		pw.println("LINE");
		pw.println("  5");
		pw.println("6F");
		pw.println("  8");
		pw.println("0");
		pw.println("  6");
		pw.println("CONTINUOUS");
		pw.println(" 62");
		pw.println("     6");
		pw.println(" 10");
		pw.println("0.0547");
		pw.println(" 20");
		pw.println("-0.0547");
		pw.println(" 30");
		pw.println("0.0");
		pw.println(" 11");
		pw.println("0.0547");
		pw.println(" 21");
		pw.println("0.0547");
		pw.println(" 31");
		pw.println("0.0");
		pw.println("  0");
		pw.println("LINE");
		pw.println("  5");
		pw.println("70");
		pw.println("  8");
		pw.println("0");
		pw.println("  6");
		pw.println("CONTINUOUS");
		pw.println(" 62");
		pw.println("     6");
		pw.println(" 10");
		pw.println("-0.0547");
		pw.println(" 20");
		pw.println("-0.0547");
		pw.println(" 30");
		pw.println("0.0");
		pw.println(" 11");
		pw.println("0.0547");
		pw.println(" 21");
		pw.println("0.0547");
		pw.println(" 31");
		pw.println("0.0");
		pw.println("  0");
		pw.println("LINE");
		pw.println("  5");
		pw.println("71");
		pw.println("  8");
		pw.println("0");
		pw.println("  6");
		pw.println("CONTINUOUS");
		pw.println(" 62");
		pw.println("     6");
		pw.println(" 10");
		pw.println("-0.0547");
		pw.println(" 20");
		pw.println("0.0547");
		pw.println(" 30");
		pw.println("0.0");
		pw.println(" 11");
		pw.println("0.0547");
		pw.println(" 21");
		pw.println("-0.0547");
		pw.println(" 31");
		pw.println("0.0");
		pw.println("  0");
		pw.println("LINE");
		pw.println("  5");
		pw.println("72");
		pw.println("  8");
		pw.println("0");
		pw.println("  6");
		pw.println("CONTINUOUS");
		pw.println(" 62");
		pw.println("     6");
		pw.println(" 10");
		pw.println("-0.0547");
		pw.println(" 20");
		pw.println("-0.0547");
		pw.println(" 30");
		pw.println("0.0");
		pw.println(" 11");
		pw.println("-0.0547");
		pw.println(" 21");
		pw.println("0.0547");
		pw.println(" 31");
		pw.println("0.0");
		pw.println("  0");
		pw.println("ENDSEC");
		pw.println("  0");
		pw.println("EOF");

		return sw.toString();
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return java.lang.String
	 * @category Examples
	 */
	protected static String TextPOLYLINE() {
		StringWriter sw = new StringWriter();
		PrintWriter pw = new PrintWriter(sw);
		pw.println("  0");
		pw.println("SECTION");
		pw.println("  2");
		pw.println("ENTITIES");
		pw.println("  0");
		pw.println("POLYLINE");
		pw.println("  5");
		pw.println("66");
		pw.println("  8");
		pw.println("0");
		pw.println(" 66");
		pw.println("     1");
		pw.println(" 10");
		pw.println("0.0");
		pw.println(" 20");
		pw.println("0.0");
		pw.println(" 30");
		pw.println("0.0");
		pw.println("  0");
		pw.println("VERTEX");
		pw.println("  5");
		pw.println("5DDF");
		pw.println("  8");
		pw.println("0");
		pw.println(" 10");
		pw.println("-0.0306");
		pw.println(" 20");
		pw.println("0.0305");
		pw.println(" 30");
		pw.println("0.0");
		pw.println("  0");
		pw.println("VERTEX");
		pw.println("  5");
		pw.println("5DE0");
		pw.println("  8");
		pw.println("0");
		pw.println(" 10");
		pw.println("0.0306");
		pw.println(" 20");
		pw.println("0.0305");
		pw.println(" 30");
		pw.println("0.0");
		pw.println("  0");
		pw.println("VERTEX");
		pw.println("  5");
		pw.println("5DE1");
		pw.println("  8");
		pw.println("0");
		pw.println(" 10");
		pw.println("0.0306");
		pw.println(" 20");
		pw.println("-0.0306");
		pw.println(" 30");
		pw.println("0.0");
		pw.println("  0");
		pw.println("VERTEX");
		pw.println("  5");
		pw.println("5DE2");
		pw.println("  8");
		pw.println("0");
		pw.println(" 10");
		pw.println("-0.0306");
		pw.println(" 20");
		pw.println("-0.0306");
		pw.println(" 30");
		pw.println("0.0");
		pw.println("  0");
		pw.println("VERTEX");
		pw.println("  5");
		pw.println("5DE3");
		pw.println("  8");
		pw.println("0");
		pw.println(" 10");
		pw.println("-0.0306");
		pw.println(" 20");
		pw.println("0.0305");
		pw.println(" 30");
		pw.println("0.0");
		pw.println("  0");
		pw.println("SEQEND");
		pw.println("  5");
		pw.println("5DE4");
		pw.println("  8");
		pw.println("0");
		pw.println("  0");
		pw.println("ENDBLK");
		pw.println("  0");
		pw.println("ENDSEC");
		pw.println("  0");
		pw.println("EOF");

		return sw.toString();
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return java.lang.String
	 * @category Examples
	 */
	protected static String TextTEXT() {
		StringWriter sw = new StringWriter();
		PrintWriter pw = new PrintWriter(sw);
		pw.println("  0");
		pw.println("SECTION");
		pw.println("  2");
		pw.println("ENTITIES");
		pw.println("  0");
		pw.println("POLYLINE");
		pw.println("  5");
		pw.println("66");
		pw.println("  8");
		pw.println("0");
		pw.println(" 66");
		pw.println("     1");
		pw.println(" 10");
		pw.println("0.0");
		pw.println(" 20");
		pw.println("0.0");
		pw.println(" 30");
		pw.println("0.0");
		pw.println("  0");
		pw.println("VERTEX");
		pw.println("  5");
		pw.println("5DDF");
		pw.println("  8");
		pw.println("0");
		pw.println(" 10");
		pw.println("-0.0306");
		pw.println(" 20");
		pw.println("0.0305");
		pw.println(" 30");
		pw.println("0.0");
		pw.println("  0");
		pw.println("VERTEX");
		pw.println("  5");
		pw.println("5DE0");
		pw.println("  8");
		pw.println("0");
		pw.println(" 10");
		pw.println("0.0306");
		pw.println(" 20");
		pw.println("0.0305");
		pw.println(" 30");
		pw.println("0.0");
		pw.println("  0");
		pw.println("VERTEX");
		pw.println("  5");
		pw.println("5DE1");
		pw.println("  8");
		pw.println("0");
		pw.println(" 10");
		pw.println("0.0306");
		pw.println(" 20");
		pw.println("-0.0306");
		pw.println(" 30");
		pw.println("0.0");
		pw.println("  0");
		pw.println("VERTEX");
		pw.println("  5");
		pw.println("5DE2");
		pw.println("  8");
		pw.println("0");
		pw.println(" 10");
		pw.println("-0.0306");
		pw.println(" 20");
		pw.println("-0.0306");
		pw.println(" 30");
		pw.println("0.0");
		pw.println("  0");
		pw.println("VERTEX");
		pw.println("  5");
		pw.println("5DE3");
		pw.println("  8");
		pw.println("0");
		pw.println(" 10");
		pw.println("-0.0306");
		pw.println(" 20");
		pw.println("0.0305");
		pw.println(" 30");
		pw.println("0.0");
		pw.println("  0");
		pw.println("SEQEND");
		pw.println("  5");
		pw.println("5DE4");
		pw.println("  8");
		pw.println("0");
		pw.println("  0");
		pw.println("ENDBLK");
		pw.println("  0");
		pw.println("ENDSEC");
		pw.println("  0");
		pw.println("EOF");

		return sw.toString();
	}
}
