package jp.co.sra.jun.csg.atoms;

import jp.co.sra.jun.csg.abstracts.JunCSG;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.solid.abstracts.JunSolidModel;

/**
 * JunSolidCSG class
 * 
 *  @author    nisinaka
 *  @created   1998/10/19 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunSolidCSG.java,v 8.10 2008/02/20 06:30:53 nisinaka Exp $
 */
public class JunSolidCSG extends JunCSG {
	protected JunSolidModel solid;

	/**
	 * Create a new instance of JunSolidCSG.
	 * 
	 * @param aJunSolid jp.co.sra.jun.solid.abstracts.JunSolid
	 */
	public JunSolidCSG(JunSolidModel aJunSolid) {
		this.setSolid_(aJunSolid);
	}

	/**
	 * Create a new instance of JunSolidCSG.
	 * 
	 * @param aJunSolid jp.co.sra.jun.solid.abstracts.JunSolid
	 * 
	 * @return jp.co.sra.jun.csg.atoms.JunSolidCSG
	 */
	public static JunSolidCSG On_(JunSolidModel aJunSolid) {
		return new JunSolidCSG(aJunSolid);
	}

	/**
	 * Answer the solid.
	 * 
	 * @return jp.co.sra.jun.solid.abstracts.JunSolid
	 */
	public JunSolidModel solid() {
		return solid;
	}

	/**
	 * Answer a value at the specified point.
	 * 
	 * @param aJun3dPoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * 
	 * @return double
	 */
	public double valueAt_(Jun3dPoint aJun3dPoint) {
		return solid.valueAt_(aJun3dPoint);
	}

	/**
	 * Set the solid.
	 * 
	 * @param aJunSolid jp.co.sra.jun.solid.abstracts.JunSolid
	 */
	protected void setSolid_(JunSolidModel aJunSolid) {
		solid = aJunSolid;
	}
}
