package jp.co.sra.jun.collections.support;

import jp.co.sra.jun.system.support.JunTestExamples;

/**
 * JunCorrelationTestExamples class
 * 
 *  @author    nisinaka
 *  @created   2001/04/10 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunCorrelationTestExamples.java,v 8.10 2008/02/20 06:30:53 nisinaka Exp $
 */
public class JunCorrelationTestExamples extends JunTestExamples {

	/**
	 * Example1:
	 * 
	 * @return DOCUMENT ME!
	 */
	public static boolean Example1() {
		int[] xCollection = new int[] { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9 };
		int[] yCollection = new int[] { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9 };
		JunCorrelation aCorrelation = new JunCorrelation(xCollection, yCollection);
		float meanX = (float) aCorrelation.meanX();
		float meanY = (float) aCorrelation.meanY();
		float varianceX = (float) aCorrelation.varianceX();
		float varianceY = (float) aCorrelation.varianceY();
		float standardDeviationX = (float) aCorrelation.standardDeviationX();
		float standardDeviationY = (float) aCorrelation.standardDeviationY();
		float covarianceOfCorrelation = (float) aCorrelation.covariance();
		float coefficientOfCorrelation = (float) aCorrelation.coefficient();

		//
		System.out.println();
		System.out.print("collection X: {");

		for (int i = 0; i < xCollection.length; i++) {
			System.out.print(" " + xCollection[i]);
		}

		System.out.println(" }");
		System.out.print("collection Y: {");

		for (int i = 0; i < yCollection.length; i++) {
			System.out.print(" " + yCollection[i]);
		}

		System.out.println(" }");
		System.out.println("mean X: " + meanX);
		System.out.println("mean Y: " + meanY);
		System.out.println("variance X: " + varianceX);
		System.out.println("variance Y: " + varianceY);
		System.out.println("standard deviation X: " + standardDeviationX);
		System.out.println("standard deviation Y: " + standardDeviationY);
		System.out.println("covariance of correlation: " + covarianceOfCorrelation);
		System.out.println("coefficient of correlation: " + coefficientOfCorrelation);

		//
		if ((meanX != 4.5) || (meanY != 4.5)) {
			return false;
		}

		if (Math.abs(varianceX - 9.166667) > JunCorrelation.ACCURACY) {
			return false;
		}

		if (Math.abs(varianceY - 9.166667) > JunCorrelation.ACCURACY) {
			return false;
		}

		if (Math.abs(standardDeviationX - 3.0276504) > JunCorrelation.ACCURACY) {
			return false;
		}

		if (Math.abs(standardDeviationY - 3.0276504) > JunCorrelation.ACCURACY) {
			return false;
		}

		if (Math.abs(covarianceOfCorrelation - 9.166667) > JunCorrelation.ACCURACY) {
			return false;
		}

		if (coefficientOfCorrelation != 1.0) {
			return false;
		}

		return true;
	}

	/**
	 * Example2:
	 * 
	 * @return DOCUMENT ME!
	 */
	public static boolean Example2() {
		int[] xCollection = new int[] { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9 };
		int[] yCollection = new int[] { 9, 8, 7, 6, 5, 4, 3, 2, 1, 0 };
		JunCorrelation aCorrelation = new JunCorrelation(xCollection, yCollection);
		float meanX = (float) aCorrelation.meanX();
		float meanY = (float) aCorrelation.meanY();
		float varianceX = (float) aCorrelation.varianceX();
		float varianceY = (float) aCorrelation.varianceY();
		float standardDeviationX = (float) aCorrelation.standardDeviationX();
		float standardDeviationY = (float) aCorrelation.standardDeviationY();
		float covarianceOfCorrelation = (float) aCorrelation.covariance();
		float coefficientOfCorrelation = (float) aCorrelation.coefficient();

		//
		System.out.println();
		System.out.print("collection X: {");

		for (int i = 0; i < xCollection.length; i++) {
			System.out.print(" " + xCollection[i]);
		}

		System.out.println(" }");
		System.out.print("collection Y: {");

		for (int i = 0; i < yCollection.length; i++) {
			System.out.print(" " + yCollection[i]);
		}

		System.out.println(" }");
		System.out.println("mean X: " + meanX);
		System.out.println("mean Y: " + meanY);
		System.out.println("variance X: " + varianceX);
		System.out.println("variance Y: " + varianceY);
		System.out.println("standard deviation X: " + standardDeviationX);
		System.out.println("standard deviation Y: " + standardDeviationY);
		System.out.println("covariance of correlation: " + covarianceOfCorrelation);
		System.out.println("coefficient of correlation: " + coefficientOfCorrelation);

		//
		if ((meanX != 4.5) || (meanY != 4.5)) {
			return false;
		}

		if (Math.abs(varianceX - 9.166667) > JunCorrelation.ACCURACY) {
			return false;
		}

		if (Math.abs(varianceY - 9.166667) > JunCorrelation.ACCURACY) {
			return false;
		}

		if (Math.abs(standardDeviationX - 3.0276504) > JunCorrelation.ACCURACY) {
			return false;
		}

		if (Math.abs(standardDeviationY - 3.0276504) > JunCorrelation.ACCURACY) {
			return false;
		}

		if (Math.abs(covarianceOfCorrelation + 9.166667) > JunCorrelation.ACCURACY) {
			return false;
		}

		if (coefficientOfCorrelation != -1.0) {
			return false;
		}

		return true;
	}

	/**
	 * Example3:
	 * 
	 * @return DOCUMENT ME!
	 */
	public static boolean Example3() {
		int[] xCollection = new int[] { 0, 9, 1, 8, 2, 7, 3, 6, 4, 5 };
		int[] yCollection = new int[] { 0, 9, 1, 8, 2, 7, 3, 6, 4, 5 };
		JunCorrelation aCorrelation = new JunCorrelation(xCollection, yCollection);
		float meanX = (float) aCorrelation.meanX();
		float meanY = (float) aCorrelation.meanY();
		float varianceX = (float) aCorrelation.varianceX();
		float varianceY = (float) aCorrelation.varianceY();
		float standardDeviationX = (float) aCorrelation.standardDeviationX();
		float standardDeviationY = (float) aCorrelation.standardDeviationY();
		float covarianceOfCorrelation = (float) aCorrelation.covariance();
		float coefficientOfCorrelation = (float) aCorrelation.coefficient();

		//
		System.out.println();
		System.out.print("collection X: {");

		for (int i = 0; i < xCollection.length; i++) {
			System.out.print(" " + xCollection[i]);
		}

		System.out.println(" }");
		System.out.print("collection Y: {");

		for (int i = 0; i < yCollection.length; i++) {
			System.out.print(" " + yCollection[i]);
		}

		System.out.println(" }");
		System.out.println("mean X: " + meanX);
		System.out.println("mean Y: " + meanY);
		System.out.println("variance X: " + varianceX);
		System.out.println("variance Y: " + varianceY);
		System.out.println("standard deviation X: " + standardDeviationX);
		System.out.println("standard deviation Y: " + standardDeviationY);
		System.out.println("covariance of correlation: " + covarianceOfCorrelation);
		System.out.println("coefficient of correlation: " + coefficientOfCorrelation);

		//
		if ((meanX != 4.5) || (meanY != 4.5)) {
			return false;
		}

		if (Math.abs(varianceX - 9.166667) > JunCorrelation.ACCURACY) {
			return false;
		}

		if (Math.abs(varianceY - 9.166667) > JunCorrelation.ACCURACY) {
			return false;
		}

		if (Math.abs(standardDeviationX - 3.0276504) > JunCorrelation.ACCURACY) {
			return false;
		}

		if (Math.abs(standardDeviationY - 3.0276504) > JunCorrelation.ACCURACY) {
			return false;
		}

		if (Math.abs(covarianceOfCorrelation - 9.166667) > JunCorrelation.ACCURACY) {
			return false;
		}

		if (coefficientOfCorrelation != 1.0) {
			return false;
		}

		return true;
	}

	/**
	 * Example4:
	 * 
	 * @return DOCUMENT ME!
	 */
	public static boolean Example4() {
		int[] xCollection = new int[] { 0, 9, 1, 8, 2, 7, 3, 6, 4, 5 };
		int[] yCollection = new int[] { 9, 0, 8, 1, 7, 2, 6, 3, 5, 4 };
		JunCorrelation aCorrelation = new JunCorrelation(xCollection, yCollection);
		float meanX = (float) aCorrelation.meanX();
		float meanY = (float) aCorrelation.meanY();
		float varianceX = (float) aCorrelation.varianceX();
		float varianceY = (float) aCorrelation.varianceY();
		float standardDeviationX = (float) aCorrelation.standardDeviationX();
		float standardDeviationY = (float) aCorrelation.standardDeviationY();
		float covarianceOfCorrelation = (float) aCorrelation.covariance();
		float coefficientOfCorrelation = (float) aCorrelation.coefficient();

		//
		System.out.println();
		System.out.print("collection X: {");

		for (int i = 0; i < xCollection.length; i++) {
			System.out.print(" " + xCollection[i]);
		}

		System.out.println(" }");
		System.out.print("collection Y: {");

		for (int i = 0; i < yCollection.length; i++) {
			System.out.print(" " + yCollection[i]);
		}

		System.out.println(" }");
		System.out.println("mean X: " + meanX);
		System.out.println("mean Y: " + meanY);
		System.out.println("variance X: " + varianceX);
		System.out.println("variance Y: " + varianceY);
		System.out.println("standard deviation X: " + standardDeviationX);
		System.out.println("standard deviation Y: " + standardDeviationY);
		System.out.println("covariance of correlation: " + covarianceOfCorrelation);
		System.out.println("coefficient of correlation: " + coefficientOfCorrelation);

		//
		if ((meanX != 4.5) || (meanY != 4.5)) {
			return false;
		}

		if (Math.abs(varianceX - 9.166667) > JunCorrelation.ACCURACY) {
			return false;
		}

		if (Math.abs(varianceY - 9.166667) > JunCorrelation.ACCURACY) {
			return false;
		}

		if (Math.abs(standardDeviationX - 3.0276504) > JunCorrelation.ACCURACY) {
			return false;
		}

		if (Math.abs(standardDeviationY - 3.0276504) > JunCorrelation.ACCURACY) {
			return false;
		}

		if (Math.abs(covarianceOfCorrelation + 9.166667) > JunCorrelation.ACCURACY) {
			return false;
		}

		if (coefficientOfCorrelation != -1.0) {
			return false;
		}

		return true;
	}

	/**
	 * Example5:
	 * 
	 * @return DOCUMENT ME!
	 */
	public static boolean Example5() {
		int[] xCollection = new int[] { 7, 9, 8, 6, 7, 9, 8, 6, 7, 10, 7, 7, 8, 6, 8, 8, 8, 7, 6, 8 };
		int[] yCollection = new int[] { 7, 8, 8, 7, 6, 10, 9, 6, 7, 9, 8, 7, 7, 6, 9, 8, 7, 7, 7, 8 };
		JunCorrelation aCorrelation = new JunCorrelation(xCollection, yCollection);
		float meanX = (float) aCorrelation.meanX();
		float meanY = (float) aCorrelation.meanY();
		float varianceX = (float) aCorrelation.varianceX();
		float varianceY = (float) aCorrelation.varianceY();
		float standardDeviationX = (float) aCorrelation.standardDeviationX();
		float standardDeviationY = (float) aCorrelation.standardDeviationY();
		float covarianceOfCorrelation = (float) aCorrelation.covariance();
		float coefficientOfCorrelation = (float) aCorrelation.coefficient();

		//
		System.out.println();
		System.out.print("collection X: {");

		for (int i = 0; i < xCollection.length; i++) {
			System.out.print(" " + xCollection[i]);
		}

		System.out.println(" }");
		System.out.print("collection Y: {");

		for (int i = 0; i < yCollection.length; i++) {
			System.out.print(" " + yCollection[i]);
		}

		System.out.println(" }");
		System.out.println("mean X: " + meanX);
		System.out.println("mean Y: " + meanY);
		System.out.println("variance X: " + varianceX);
		System.out.println("variance Y: " + varianceY);
		System.out.println("standard deviation X: " + standardDeviationX);
		System.out.println("standard deviation Y: " + standardDeviationY);
		System.out.println("covariance of correlation: " + covarianceOfCorrelation);
		System.out.println("coefficient of correlation: " + coefficientOfCorrelation);

		//
		if (Math.abs(meanX - 7.5) > JunCorrelation.ACCURACY) {
			return false;
		}

		if (Math.abs(meanY - 7.55) > JunCorrelation.ACCURACY) {
			return false;
		}

		if (Math.abs(varianceX - 1.21053) > JunCorrelation.ACCURACY) {
			return false;
		}

		if (Math.abs(varianceY - 1.20789) > JunCorrelation.ACCURACY) {
			return false;
		}

		if (Math.abs(standardDeviationX - 1.10024) > JunCorrelation.ACCURACY) {
			return false;
		}

		if (Math.abs(standardDeviationY - 1.09904) > JunCorrelation.ACCURACY) {
			return false;
		}

		if (Math.abs(covarianceOfCorrelation - 0.921053) > JunCorrelation.ACCURACY) {
			return false;
		}

		if (Math.abs(coefficientOfCorrelation - 0.761698) > JunCorrelation.ACCURACY) {
			return false;
		}

		return true;
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args an array of command-line arguments
	 */
	public static void main(java.lang.String[] args) {
		new JunCorrelationTestExamples();
	}
}
