package jp.co.sra.jun.collections.sequences;

import jp.co.sra.jun.system.support.*;

/**
 * JunDoubleMatrixTestExamples class
 * 
 *  @author    nisinaka
 *  @created   1998/10/10 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunDoubleMatrixTestExamples.java,v 8.10 2008/02/20 06:30:53 nisinaka Exp $
 */
public class JunDoubleMatrixTestExamples extends JunTestExamples {

	/**
	 * DOCUMENT ME!
	 * 
	 * @return boolean
	 */
	public static boolean Example1() {
		double[] collection = { 1, 2, 3, 4, 5, 6, 7, 8, 9 };
		JunDoubleMatrix aMatrix = new JunDoubleMatrix(3, 3, collection);
		System.out.println(aMatrix.printString());

		return true;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return boolean
	 */
	public static boolean Example2() {
		double[] collection1 = { 1, 2, 3, 4, 5, 6, 7, 8, 9 };
		double[] collection2 = { 1, 4, 7, 2, 5, 8, 3, 6, 9 };
		JunDoubleMatrix aMatrix1 = new JunDoubleMatrix(3, 3, collection1);
		JunDoubleMatrix aMatrix2 = new JunDoubleMatrix(3, 3, collection2);
		JunDoubleMatrix aMatrix = aMatrix1._plus(aMatrix2);
		System.out.println(aMatrix1.printString());
		System.out.println(aMatrix2.printString());
		System.out.println(aMatrix.printString());

		return (aMatrix._doubleValueAt(0, 0) == 2.0d)
			&& (aMatrix._doubleValueAt(0, 1) == 6.0d)
			&& (aMatrix._doubleValueAt(0, 2) == 10.0d)
			&& (aMatrix._doubleValueAt(1, 0) == 6.0d)
			&& (aMatrix._doubleValueAt(1, 1) == 10.0d)
			&& (aMatrix._doubleValueAt(1, 2) == 14.0d)
			&& (aMatrix._doubleValueAt(2, 0) == 10.0d)
			&& (aMatrix._doubleValueAt(2, 1) == 14.0d)
			&& (aMatrix._doubleValueAt(2, 2) == 18.0d);
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return boolean
	 */
	public static boolean Example3() {
		double[] collection1 = { 1, 3, 4, 2, 1, 1, 6, 4, 3, 2 };
		double[] collection2 = { 1, 2, 3, 4 };
		JunDoubleMatrix aMatrix1 = new JunDoubleMatrix(5, 2, collection1);
		JunDoubleMatrix aMatrix2 = new JunDoubleMatrix(2, 2, collection2);
		JunDoubleMatrix aMatrix = (JunDoubleMatrix) aMatrix1.product_(aMatrix2);
		System.out.println(aMatrix1.printString());
		System.out.println(aMatrix2.printString());
		System.out.println(aMatrix.printString());

		return (aMatrix._doubleValueAt(0, 0) == 10.0d)
			&& (aMatrix._doubleValueAt(0, 1) == 14.0d)
			&& (aMatrix._doubleValueAt(1, 0) == 10.0d)
			&& (aMatrix._doubleValueAt(1, 1) == 16.0d)
			&& (aMatrix._doubleValueAt(2, 0) == 4.0d)
			&& (aMatrix._doubleValueAt(2, 1) == 6.0d)
			&& (aMatrix._doubleValueAt(3, 0) == 18.0d)
			&& (aMatrix._doubleValueAt(3, 1) == 28.0d)
			&& (aMatrix._doubleValueAt(4, 0) == 9.0d)
			&& (aMatrix._doubleValueAt(4, 1) == 14.0d);
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return boolean
	 */
	public static boolean Example4() {
		double[] collection = { 1, 2, 3, 1, 3, 3, 1, 2, 4 };
		JunDoubleMatrix aMatrix = new JunDoubleMatrix(3, 3, collection);
		JunDoubleMatrix anInverse = aMatrix.inverse();
		System.out.println(aMatrix.printString());
		System.out.println(anInverse.printString());

		return (anInverse._doubleValueAt(0, 0) == 6.0d)
			&& (anInverse._doubleValueAt(0, 1) == -2.0d)
			&& (anInverse._doubleValueAt(0, 2) == -3.0d)
			&& (anInverse._doubleValueAt(1, 0) == -1.0d)
			&& (anInverse._doubleValueAt(1, 1) == 1.0d)
			&& (anInverse._doubleValueAt(1, 2) == 0.0d)
			&& (anInverse._doubleValueAt(2, 0) == -1.0d)
			&& (anInverse._doubleValueAt(2, 1) == 0.0d)
			&& (anInverse._doubleValueAt(2, 2) == 1.0d);
	}

	/**
	 * Test for the inverse calculation by LU decomposition method.
	 * 
	 * @return boolean
	 */
	public static boolean Example5() {
		double[] collection = { 1.0, -4.68708e-5, 4.85361e-15, 0.0, -1.66533e-16, -2.77556e-17, 1.0, 0.0, 1.66533e-16, -1.0, -1.94289e-16, 0.0, 6.66134e-17, 0.4, -0.4, 1.0, };
		JunDoubleMatrix aMatrix = new JunDoubleMatrix(4, 4, collection);
		JunDoubleMatrix anInverse = aMatrix.inverseByLuDecomposition();
		JunDoubleMatrix shouldBeUnit = (JunDoubleMatrix) anInverse.product_(aMatrix);
		System.out.println(shouldBeUnit);

		return (Math.abs(shouldBeUnit._doubleValueAt(0, 0)) - 1 < 0.000001d)
			&& (Math.abs(shouldBeUnit._doubleValueAt(0, 1)) < 0.000001d)
			&& (Math.abs(shouldBeUnit._doubleValueAt(0, 2)) < 0.000001d)
			&& (Math.abs(shouldBeUnit._doubleValueAt(0, 3)) < 0.000001d)
			&& (Math.abs(shouldBeUnit._doubleValueAt(1, 0)) < 0.000001d)
			&& (Math.abs(shouldBeUnit._doubleValueAt(1, 1)) - 1 < 0.000001d)
			&& (Math.abs(shouldBeUnit._doubleValueAt(1, 2)) < 0.000001d)
			&& (Math.abs(shouldBeUnit._doubleValueAt(1, 3)) < 0.000001d)
			&& (Math.abs(shouldBeUnit._doubleValueAt(2, 0)) < 0.000001d)
			&& (Math.abs(shouldBeUnit._doubleValueAt(2, 1)) < 0.000001d)
			&& (Math.abs(shouldBeUnit._doubleValueAt(2, 2)) - 1 < 0.000001d)
			&& (Math.abs(shouldBeUnit._doubleValueAt(2, 3)) < 0.000001d)
			&& (Math.abs(shouldBeUnit._doubleValueAt(3, 0)) < 0.000001d)
			&& (Math.abs(shouldBeUnit._doubleValueAt(3, 1)) < 0.000001d)
			&& (Math.abs(shouldBeUnit._doubleValueAt(3, 2)) < 0.000001d)
			&& (Math.abs(shouldBeUnit._doubleValueAt(3, 3)) - 1 < 0.000001d);
	}

	/**
	 * Test for the inverse calculation by LU decomposition method.
	 * 
	 * @return boolean
	 */
	public static boolean Example6() {
		double[] collection = { 1.0, -4.68708e-5, 4.85361e-15, 0.0, -1.66533e-16, -2.77556e-17, 1.0, 0.0, 1.66533e-16, -1.0, -1.94289e-16, 0.0, 6.66134e-17, 0.4, -0.4, 1.0, };
		JunDoubleMatrix aMatrix = new JunDoubleMatrix(4, 4, collection);
		JunDoubleMatrix.CalculateInverseByLuDecomposition();
		JunDoubleMatrix anInverse = aMatrix.inverse();
		JunDoubleMatrix shouldBeUnit = (JunDoubleMatrix) anInverse.product_(aMatrix);
		System.out.println(shouldBeUnit);

		return (Math.abs(shouldBeUnit._doubleValueAt(0, 0)) - 1 < 0.000001d)
			&& (Math.abs(shouldBeUnit._doubleValueAt(0, 1)) < 0.000001d)
			&& (Math.abs(shouldBeUnit._doubleValueAt(0, 2)) < 0.000001d)
			&& (Math.abs(shouldBeUnit._doubleValueAt(0, 3)) < 0.000001d)
			&& (Math.abs(shouldBeUnit._doubleValueAt(1, 0)) < 0.000001d)
			&& (Math.abs(shouldBeUnit._doubleValueAt(1, 1)) - 1 < 0.000001d)
			&& (Math.abs(shouldBeUnit._doubleValueAt(1, 2)) < 0.000001d)
			&& (Math.abs(shouldBeUnit._doubleValueAt(1, 3)) < 0.000001d)
			&& (Math.abs(shouldBeUnit._doubleValueAt(2, 0)) < 0.000001d)
			&& (Math.abs(shouldBeUnit._doubleValueAt(2, 1)) < 0.000001d)
			&& (Math.abs(shouldBeUnit._doubleValueAt(2, 2)) - 1 < 0.000001d)
			&& (Math.abs(shouldBeUnit._doubleValueAt(2, 3)) < 0.000001d)
			&& (Math.abs(shouldBeUnit._doubleValueAt(3, 0)) < 0.000001d)
			&& (Math.abs(shouldBeUnit._doubleValueAt(3, 1)) < 0.000001d)
			&& (Math.abs(shouldBeUnit._doubleValueAt(3, 2)) < 0.000001d)
			&& (Math.abs(shouldBeUnit._doubleValueAt(3, 3)) - 1 < 0.000001d);
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args java.lang.String[]
	 */
	public static void main(String[] args) {
		new JunDoubleMatrixTestExamples();
	}

	/**
	 * Test for the inverse calculation by LU decomposition method.
	 * 
	 * @return boolean
	 */
	protected static boolean TestLuDecompose() {
		double[] collection = { 3, 9, 4, 6, 1, 8, 2, 5, 3 };
		JunDoubleMatrix aMatrix = new JunDoubleMatrix(3, 3, collection);
		Object[] lu = aMatrix.luDecompose();
		System.out.println(lu[0]);
		return false;
	}
}
