package jp.co.sra.gl4jun;

import java.awt.*;
import java.awt.image.*;

/**
 * GLjRenderingContext class
 * 
 *  @author    MATSUDA Ryouichi
 *  @created   1999/08/19 (by MATSUDA Ryouichi)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: GLjRenderingContext.java,v 8.10 2008/02/20 06:30:52 nisinaka Exp $
 */
public class GLjRenderingContext {
	private static final int MEDIUM_IMAGE = 1;
	private static final int MEDIUM_CANVAS = 2;
	private static final int MEDIUM_JCANVAS = 3;
	//
	protected static GLjInterface OpenGLInterface;

	static {
		OpenGLInterface = GLjInterface.Current();
	}

	//
	private int mode;
	private Component heavy;
	private Object medium;
	private int medium_type;
	private int handle;
	private int[] pixels;
	private int width;
	private int height;

	/**
	 * DOCUMENT ME!
	 * 
	 * @param aCanvas jp.co.sra.gl4jun.GLjCanvas
	 */
	public GLjRenderingContext(Canvas aCanvas) {
		super();
		mode = GLjRenderingMode.DOUBLE_BUFFER;
		heavy = aCanvas;
		medium = aCanvas;
		medium_type = MEDIUM_CANVAS;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @param aGLjJCanvas jp.co.sra.gl4jun.GLjJCanvas
	 * @param aJFrame DOCUMENT ME!
	 */
	public GLjRenderingContext(Container aGLjJCanvas, Frame aJFrame) {
		super();
		mode = GLjRenderingMode.IMAGE;
		heavy = aJFrame;
		medium = aGLjJCanvas;
		medium_type = MEDIUM_JCANVAS;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @param aImageSource jp.co.sra.gl4jun.GLjImageSource
	 */
	public GLjRenderingContext(GLjImageSource aImageSource) {
		super();
		mode = GLjRenderingMode.IMAGE;
		heavy = null;
		medium = aImageSource;
		medium_type = MEDIUM_IMAGE;
	}

	/**
	 * Answer a OpenGLInterface.
	 * 
	 * @return jp.co.sra.gl4jun.GLjInterface
	 */
	public static final GLjInterface OpenGLInterface() {
		return OpenGLInterface;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return java.awt.Color
	 */
	public Color getBackground() {
		Color color;

		switch (medium_type) {
			case MEDIUM_IMAGE :
				GLjImageSource aSource = (GLjImageSource) medium;
				color = aSource.getBackground();

				break;
			case MEDIUM_CANVAS :
			case MEDIUM_JCANVAS :
				Component aComponent = (Component) medium;
				color = aComponent.getBackground();

				break;
			default :
				color = null;
				break;
		}

		return color;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return int
	 */
	public int getMode() {
		return mode;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return java.awt.Dimension
	 */
	public Dimension getSize() {
		Dimension size;

		switch (medium_type) {
			case MEDIUM_IMAGE :
				GLjImageSource source = (GLjImageSource) medium;
				size = source.getSize();

				break;
			case MEDIUM_CANVAS :
			case MEDIUM_JCANVAS :
				Component component = (Component) medium;
				size = component.getSize();

				break;
			default :
				size = null;
				break;
		}

		return size;
	}

	/**
	 * DOCUMENT ME!
	 */
	public void gljCurrent() {
		if (mode == GLjRenderingMode.NOTHING) {
			return;
		}
		synchronized (OpenGLInterface) {
			OpenGLInterface.gljMakeCurrent(handle);
		}
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @param isApplet DOCUMENT ME!
	 */
	public void gljDelete(boolean isApplet) {
		if (mode == GLjRenderingMode.NOTHING) {
			return;
		}
		synchronized (OpenGLInterface) {
			OpenGLInterface.gljDeleteContext(handle, isApplet);
		}
	}

	/**
	 * DOCUMENT ME!
	 */
	public void gljFlush() {
		if (mode == GLjRenderingMode.NOTHING) {
			return;
		}

		if (medium_type == MEDIUM_IMAGE) {
			Image anImage = this.gljImageRGB();
			GLjImageSource aSource = (GLjImageSource) medium;
			aSource.setImage(anImage);
		}
		synchronized (OpenGLInterface) {
			OpenGLInterface.gljFlushBuffer(handle);
		}
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return java.awt.Image
	 */
	public Image gljImageRGB() {
		if (mode == GLjRenderingMode.NOTHING) {
			return null;
		}
		synchronized (OpenGLInterface) {
			OpenGLInterface.gljReadImage(handle, pixels, false);
		}

		MemoryImageSource mis = new MemoryImageSource(width, height, pixels, 0, width);
		Toolkit tk = Toolkit.getDefaultToolkit();

		return tk.createImage(mis);
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return java.awt.Image
	 */
	public Image gljImageRGBA() {
		if (mode == GLjRenderingMode.NOTHING) {
			return null;
		}
		synchronized (OpenGLInterface) {
			OpenGLInterface.gljReadImage(handle, pixels, true);
		}

		MemoryImageSource mis = new MemoryImageSource(width, height, pixels, 0, width);
		Toolkit tk = Toolkit.getDefaultToolkit();

		return tk.createImage(mis);
	}

	/**
	 * DOCUMENT ME!
	 */
	public void gljInitialize() {
		if (mode == GLjRenderingMode.NOTHING) {
			return;
		}

		Dimension size = this.getSize();
		synchronized (OpenGLInterface) {
			handle = OpenGLInterface.gljCreateContext(heavy, size.width, size.height, mode);

			if (handle == 0) {
				mode = GLjRenderingMode.IMAGE;
				handle = OpenGLInterface.gljCreateContext(heavy, size.width, size.height, mode);
				System.out.println("Can't get a drawable, the rendering mode is changed to IMAGE.");
			}
		}

		if (mode == GLjRenderingMode.IMAGE) {
			width = size.width;
			height = size.height;
			pixels = new int[width * height];
		}
	}

	/**
	 * DOCUMENT ME!
	 */
	public void gljRelease() {
		if (mode == GLjRenderingMode.NOTHING) {
			return;
		}
		synchronized (OpenGLInterface) {
			OpenGLInterface.gljDeleteContext(handle, false);
		}
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @param size java.awt.Dimension
	 */
	public void gljResize(Dimension size) {
		if (mode == GLjRenderingMode.NOTHING) {
			return;
		}
		synchronized (OpenGLInterface) {
			OpenGLInterface.gljSetSize(handle, size.width, size.height);
		}

		if (mode == GLjRenderingMode.IMAGE) {
			width = size.width;
			height = size.height;
			pixels = new int[width * height];
		}
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @param location java.awt.Point
	 */
	public void gljSetLocation(Point location) {
		if (mode == GLjRenderingMode.NOTHING) {
			return;
		}
		synchronized (OpenGLInterface) {
			OpenGLInterface.gljSetLocation(handle, location.x, location.y);
		}
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @param aMode int
	 */
	public void setMode(int aMode) {
		boolean rc = true;

		switch (aMode) {
			case GLjRenderingMode.NOTHING :
			case GLjRenderingMode.IMAGE :
				break;
			case GLjRenderingMode.DIRECT :
				if (medium_type == MEDIUM_IMAGE) {
					rc = false;
				}
				break;
			case GLjRenderingMode.SINGLE_BUFFER :
			case GLjRenderingMode.DOUBLE_BUFFER :
				if ((medium_type == MEDIUM_IMAGE) || (medium_type == MEDIUM_JCANVAS)) {
					rc = false;
				}
				break;
			default :
				rc = false;
				break;
		}

		if (rc) {
			mode = aMode;
		} else {
			//throw new PropertyVetoException(
			//	"setMode() change rejected:",
			//	new PropertyChangeEvent(this, "mode", new Integer(this.mode), new Integer(mode)));
		}
	}
}
