#ifdef WIN32
	#include <windows.h>
	#include <GL\gl.h>
#else
	#include <GL/gl.h>
#endif
#include "jp_co_sra_gl4jun_GLjInterface.h"

#ifdef __MACOS__
#include <MacMemory.h>
#define malloc(size) NewPtr(size)
#define free(ptr) DisposePtr(ptr)
#define memcpy(dest, src, size) BlockMoveData(src, dest, size)
#else
#include <stdlib.h>
#endif

/**
 * procedures-gl.c:
 *
 * 	@author:	MATSUDA Ryouichi
 * 	@version:	2.0
 * 	@created:	1998/10/08 (by MATSUDA Ryouichi)
 * 	@updated:	N/A
 *
 * 	$Id: procedures-gl.c,v 2.0 2005/02/17 00:38:38 hoshi Exp $
 */

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glAccum
  (JNIEnv *env, jobject obj, jint op, jfloat value)
{
	glAccum(op, value);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glAlphaFunc
  (JNIEnv *env, jobject obj, jint func, jfloat ref)
{
	glAlphaFunc(func, ref);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glBegin
  (JNIEnv *env, jobject obj, jint mode)
{
	glBegin(mode);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glBitmap
  (JNIEnv *env, jobject obj, jint width, jint height, jfloat xorig, jfloat yorig, jfloat xmove, jfloat ymove, jbyteArray bitmap)
{
	jbyte *ptr1 = (*env)->GetByteArrayElements(env, bitmap, 0);
	glBitmap(width, height, xorig, yorig, xmove, ymove, ptr1);
	(*env)->ReleaseByteArrayElements(env, bitmap, ptr1, 0);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glBlendFunc
  (JNIEnv *env, jobject obj, jint sfactor, jint dfactor)
{
	glBlendFunc(sfactor, dfactor);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glCallList
  (JNIEnv *env, jobject obj, jint list)
{
	glCallList(list);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glCallLists
  (JNIEnv *env, jobject obj, jint n, jint type, jbyteArray lists)
{
	jbyte *ptr1 = (*env)->GetByteArrayElements(env, lists, 0);
	glCallLists (n, type, ptr1);
	(*env)->ReleaseByteArrayElements(env, lists, ptr1, 0);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glClear
  (JNIEnv *env, jobject obj, jint mask)
{
	glClear(mask);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glClearAccum
  (JNIEnv *env, jobject obj, jfloat red, jfloat green, jfloat blue, jfloat alpha)
{
	glClearAccum(red, green, blue, alpha);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glClearColor
  (JNIEnv *env, jobject obj, jfloat red, jfloat green, jfloat blue, jfloat alpha)
{
	glClearColor(red, green, blue, alpha);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glClearDepth
  (JNIEnv *env, jobject obj, jdouble depth)
{
	glClearDepth(depth);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glClearIndex
  (JNIEnv *env, jobject obj, jfloat c)
{
	glClearIndex(c);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glClearStencil
  (JNIEnv *env, jobject obj, jint s)
{
	glClearStencil(s);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glClipPlane
  (JNIEnv *env, jobject obj, jint plane, jdoubleArray equation)
{
	jdouble *ptr1 = (*env)->GetDoubleArrayElements(env, equation, 0);
	glClipPlane(plane, ptr1);
	(*env)->ReleaseDoubleArrayElements(env, equation, ptr1, 0);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glColor3b
  (JNIEnv *env, jobject obj, jbyte red, jbyte green, jbyte blue)
{
	glColor3b(red, green, blue);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glColor3bv
  (JNIEnv *env, jobject obj, jbyteArray v)
{
	jbyte *ptr1 = (*env)->GetByteArrayElements(env, v, 0);
	glColor3bv(ptr1);
	(*env)->ReleaseByteArrayElements(env, v, ptr1, 0);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glColor3d
  (JNIEnv *env, jobject obj, jdouble red, jdouble green, jdouble blue)
{
	glColor3d(red, green, blue);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glColor3dv
  (JNIEnv *env, jobject obj, jdoubleArray v)
{
	jdouble *ptr1 = (*env)->GetDoubleArrayElements(env, v, 0);
	glColor3dv(ptr1);
	(*env)->ReleaseDoubleArrayElements(env, v, ptr1, 0);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glColor3f
  (JNIEnv *env, jobject obj, jfloat red, jfloat green, jfloat blue)
{
	glColor3f(red, green, blue);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glColor3fv
  (JNIEnv *env, jobject obj, jfloatArray v)
{
	jfloat *ptr1 = (*env)->GetFloatArrayElements(env, v, 0);
	glColor3fv(ptr1);
	(*env)->ReleaseFloatArrayElements(env, v, ptr1, 0);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glColor3i
  (JNIEnv *env, jobject obj, jint red, jint green, jint blue)
{
	glColor3i(red, green, blue);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glColor3iv
  (JNIEnv *env, jobject obj, jintArray v)
{
	jint *ptr1 = (*env)->GetIntArrayElements(env, v, 0);
	glColor3iv((GLint *) ptr1);
	(*env)->ReleaseIntArrayElements(env, v, ptr1, 0);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glColor3s
  (JNIEnv *env, jobject obj, jshort red, jshort green, jshort blue)
{
	glColor3s(red, green, blue);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glColor3sv
  (JNIEnv *env, jobject obj, jshortArray v)
{
	jshort *ptr1 = (*env)->GetShortArrayElements(env, v, 0);
	glColor3sv(ptr1);
	(*env)->ReleaseShortArrayElements(env, v, ptr1, 0);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glColor3ub
  (JNIEnv *env, jobject obj, jbyte red, jbyte green, jbyte blue)
{
	glColor3ub(red, green, blue);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glColor3ubv
  (JNIEnv *env, jobject obj, jbyteArray v)
{
	jbyte *ptr1 = (*env)->GetByteArrayElements(env, v, 0);
	glColor3ubv(ptr1);
	(*env)->ReleaseByteArrayElements(env, v, ptr1, 0);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glColor3ui
  (JNIEnv *env, jobject obj, jint red, jint green, jint blue)
{
	glColor3ui(red, green, blue);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glColor3uiv
  (JNIEnv *env, jobject obj, jintArray v)
{
	jint *ptr1 = (*env)->GetIntArrayElements(env, v, 0);
	glColor3uiv((GLint *) ptr1);
	(*env)->ReleaseIntArrayElements(env, v, ptr1, 0);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glColor3us
  (JNIEnv *env, jobject obj, jshort red, jshort green, jshort blue)
{
	glColor3us(red, green, blue);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glColor3usv
  (JNIEnv *env, jobject obj, jshortArray v)
{
	jshort *ptr1 = (*env)->GetShortArrayElements(env, v, 0);
	glColor3usv(ptr1);
	(*env)->ReleaseShortArrayElements(env, v, ptr1, 0);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glColor4b
  (JNIEnv *env, jobject obj, jbyte red, jbyte green, jbyte blue, jbyte alpha)
{
	glColor4b(red, green, blue, alpha);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glColor4bv
  (JNIEnv *env, jobject obj, jbyteArray v)
{
	jbyte *ptr1 = (*env)->GetByteArrayElements(env, v, 0);
	glColor4bv(ptr1);
	(*env)->ReleaseByteArrayElements(env, v, ptr1, 0);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glColor4d
  (JNIEnv *env, jobject obj, jdouble red, jdouble green, jdouble blue, jdouble alpha)
{
	glColor4d(red, green, blue, alpha);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glColor4dv
  (JNIEnv *env, jobject obj, jdoubleArray v)
{
	jdouble *ptr1 = (*env)->GetDoubleArrayElements(env, v, 0);
	glColor4dv(ptr1);
	(*env)->ReleaseDoubleArrayElements(env, v, ptr1, 0);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glColor4f
  (JNIEnv *env, jobject obj, jfloat red, jfloat green, jfloat blue, jfloat alpha)
{
	glColor4f(red, green, blue, alpha);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glColor4fv
  (JNIEnv *env, jobject obj, jfloatArray v)
{
	jfloat *ptr1 = (*env)->GetFloatArrayElements(env, v, 0);
	glColor4fv(ptr1);
	(*env)->ReleaseFloatArrayElements(env, v, ptr1, 0);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glColor4i
  (JNIEnv *env, jobject obj, jint red, jint green, jint blue, jint alpha)
{
	glColor4i(red, green, blue, alpha);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glColor4iv
  (JNIEnv *env, jobject obj, jintArray v)
{
	jint *ptr1 = (*env)->GetIntArrayElements(env, v, 0);
	glColor4iv((GLint *) ptr1);
	(*env)->ReleaseIntArrayElements(env, v, ptr1, 0);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glColor4s
  (JNIEnv *env, jobject obj, jshort red, jshort green, jshort blue, jshort alpha)
{
	glColor4s(red, green, blue, alpha);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glColor4sv
  (JNIEnv *env, jobject obj, jshortArray v)
{
	jshort *ptr1 = (*env)->GetShortArrayElements(env, v, 0);
	glColor4sv(ptr1);
	(*env)->ReleaseShortArrayElements(env, v, ptr1, 0);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glColor4ub
  (JNIEnv *env, jobject obj, jbyte red, jbyte green, jbyte blue, jbyte alpha)
{
	glColor4ub(red, green, blue, alpha);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glColor4ubv
  (JNIEnv *env, jobject obj, jbyteArray v)
{
	jbyte *ptr1 = (*env)->GetByteArrayElements(env, v, 0);
	glColor4ubv(ptr1);
	(*env)->ReleaseByteArrayElements(env, v, ptr1, 0);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glColor4ui
  (JNIEnv *env, jobject obj, jint red, jint green, jint blue, jint alpha)
{
	glColor4ui(red, green, blue, alpha);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glColor4uiv
  (JNIEnv *env, jobject obj, jintArray v)
{
	jint *ptr1 = (*env)->GetIntArrayElements(env, v, 0);
	glColor4uiv((GLint *) ptr1);
	(*env)->ReleaseIntArrayElements(env, v, ptr1, 0);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glColor4us
  (JNIEnv *env, jobject obj, jshort red, jshort green, jshort blue, jshort alpha)
{
	glColor4us(red, green, blue, alpha);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glColor4usv
  (JNIEnv *env, jobject obj, jshortArray v)
{
	jshort *ptr1 = (*env)->GetShortArrayElements(env, v, 0);
	glColor4usv(ptr1);
	(*env)->ReleaseShortArrayElements(env, v, ptr1, 0);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glColorMask
  (JNIEnv *env, jobject obj, jboolean red, jboolean green, jboolean blue, jboolean alpha)
{
	glColorMask(red, green, blue, alpha);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glColorMaterial
  (JNIEnv *env, jobject obj, jint face, jint mode)
{
	glColorMaterial(face, mode);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glCopyPixels
  (JNIEnv *env, jobject obj, jint x, jint y, jint width, jint height, jint type)
{
	glCopyPixels(x, y, width, height, type);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glCullFace
  (JNIEnv *env, jobject obj, jint mode)
{
	glCullFace(mode);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glDeleteLists
  (JNIEnv *env, jobject obj, jint list, jint range)
{
	glDeleteLists(list, range);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glDepthFunc
  (JNIEnv *env, jobject obj, jint func)
{
	glDepthFunc(func);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glDepthMask
  (JNIEnv *env, jobject obj, jboolean flag)
{
	glDepthMask(flag);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glDepthRange
  (JNIEnv *env, jobject obj, jdouble near_val, jdouble far_val)
{
	glDepthRange(near_val, far_val);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glDisable
  (JNIEnv *env, jobject obj, jint cap)
{
	glDisable(cap);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glDrawBuffer
  (JNIEnv *env, jobject obj, jint mode)
{
	glDrawBuffer(mode);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glDrawPixels
  (JNIEnv *env, jobject obj, jint width, jint height, jint format, jint type, jbyteArray pixels)
{
	jbyte *ptr1 = (*env)->GetByteArrayElements(env, pixels, 0);
	glDrawPixels(width, height, format, type, ptr1);
	(*env)->ReleaseByteArrayElements(env, pixels, ptr1, 0);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glEdgeFlag
  (JNIEnv *env, jobject obj, jboolean flag)
{
	glEdgeFlag(flag);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glEdgeFlagv
  (JNIEnv *env, jobject obj, jbooleanArray flag)
{
	jboolean *ptr1 = (*env)->GetBooleanArrayElements(env, flag, 0);
	glEdgeFlagv(ptr1);
	(*env)->ReleaseBooleanArrayElements(env, flag, ptr1, 0);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glEnable
  (JNIEnv *env, jobject obj, jint cap)
{
	glEnable(cap);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glEnd
  (JNIEnv *env, jobject obj)
{
	glEnd();
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glEndList
  (JNIEnv *env, jobject obj)
{
	glEndList();
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glEvalCoord1d
  (JNIEnv *env, jobject obj, jdouble u)
{
	glEvalCoord1d(u);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glEvalCoord1dv
  (JNIEnv *env, jobject obj, jdoubleArray u)
{
	jdouble *ptr1 = (*env)->GetDoubleArrayElements(env, u, 0);
	glEvalCoord1dv(ptr1);
	(*env)->ReleaseDoubleArrayElements(env, u, ptr1, 0);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glEvalCoord1f
  (JNIEnv *env, jobject obj, jfloat u)
{
	glEvalCoord1f(u);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glEvalCoord1fv
  (JNIEnv *env, jobject obj, jfloatArray u)
{
	jfloat *ptr1 = (*env)->GetFloatArrayElements(env, u, 0);
	glEvalCoord1fv(ptr1);
	(*env)->ReleaseFloatArrayElements(env, u, ptr1, 0);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glEvalCoord2d
  (JNIEnv *env, jobject obj, jdouble u, jdouble v)
{
	glEvalCoord2d(u, v);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glEvalCoord2dv
  (JNIEnv *env, jobject obj, jdoubleArray u)
{
	jdouble *ptr1 = (*env)->GetDoubleArrayElements(env, u, 0);
	glEvalCoord2dv(ptr1);
	(*env)->ReleaseDoubleArrayElements(env, u, ptr1, 0);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glEvalCoord2f
  (JNIEnv *env, jobject obj, jfloat u, jfloat v)
{
	glEvalCoord2f(u, v);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glEvalCoord2fv
  (JNIEnv *env, jobject obj, jfloatArray u)
{
	jfloat *ptr1 = (*env)->GetFloatArrayElements(env, u, 0);
	glEvalCoord2fv(ptr1);
	(*env)->ReleaseFloatArrayElements(env, u, ptr1, 0);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glEvalMesh1
  (JNIEnv *env, jobject obj, jint mode, jint i1, jint i2)
{
	glEvalMesh1(mode, i1, i2);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glEvalMesh2
  (JNIEnv *env, jobject obj, jint mode, jint i1, jint i2, jint j1, jint j2)
{
	glEvalMesh2(mode, i1, i2, j1, j2);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glEvalPoint1
  (JNIEnv *env, jobject obj, jint i)
{
	glEvalPoint1(i);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glEvalPoint2
  (JNIEnv *env, jobject obj, jint i, jint j)
{
	glEvalPoint2(i, j);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glFeedbackBuffer
  (JNIEnv *env, jobject obj, jint size, jint type, jfloatArray buffer)
{
	jfloat *ptr1 = (*env)->GetFloatArrayElements(env, buffer, 0);
	glFeedbackBuffer(size, type, ptr1);
	(*env)->ReleaseFloatArrayElements(env, buffer, ptr1, 0);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glFinish
  (JNIEnv *env, jobject obj)
{
	glFinish();
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glFlush
  (JNIEnv *env, jobject obj)
{
	glFlush();
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glFogf
  (JNIEnv *env, jobject obj, jint pname, jfloat param)
{
	glFogf(pname, param);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glFogfv
  (JNIEnv *env, jobject obj, jint pname, jfloatArray params)
{
	jfloat *ptr1 = (*env)->GetFloatArrayElements(env, params, 0);
	glFogfv(pname, ptr1);
	(*env)->ReleaseFloatArrayElements(env, params, ptr1, 0);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glFogi
  (JNIEnv *env, jobject obj, jint pname, jint param)
{
	glFogi(pname, param);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glFogiv
  (JNIEnv *env, jobject obj, jint pname, jintArray params)
{
	jint *ptr1 = (*env)->GetIntArrayElements(env, params, 0);
	glFogiv(pname, (GLint *) ptr1);
	(*env)->ReleaseIntArrayElements(env, params, ptr1, 0);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glFrontFace
  (JNIEnv *env, jobject obj, jint mode)
{
	glFrontFace(mode);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glFrustum
  (JNIEnv *env, jobject obj, jdouble left, jdouble right, jdouble bottom, jdouble top, jdouble near_val, jdouble far_val)
{
	glFrustum(left, right, bottom, top, near_val, far_val);
}

JNIEXPORT jint JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glGenLists
  (JNIEnv *env, jobject obj, jint range)
{
	return glGenLists(range);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glGetBooleanv
  (JNIEnv *env, jobject obj, jint pname, jbooleanArray params)
{
	jboolean *ptr1 = (*env)->GetBooleanArrayElements(env, params, 0);
	glGetBooleanv(pname, ptr1);
	(*env)->ReleaseBooleanArrayElements(env, params, ptr1, 0);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glGetClipPlane
  (JNIEnv *env, jobject obj, jint plane, jdoubleArray equation)
{
	jdouble *ptr1 = (*env)->GetDoubleArrayElements(env, equation, 0);
	glGetClipPlane(plane, ptr1);
	(*env)->ReleaseDoubleArrayElements(env, equation, ptr1, 0);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glGetDoublev
  (JNIEnv *env, jobject obj, jint pname, jdoubleArray params)
{
	jdouble *ptr1 = (*env)->GetDoubleArrayElements(env, params, 0);
	glGetDoublev(pname, ptr1);
	(*env)->ReleaseDoubleArrayElements(env, params, ptr1, 0);
}

JNIEXPORT jint JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glGetError
  (JNIEnv *env, jobject obj)
{
	return glGetError();
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glGetFloatv
  (JNIEnv *env, jobject obj, jint pname, jfloatArray params)
{
	jfloat *ptr1 = (*env)->GetFloatArrayElements(env, params, 0);
	glGetFloatv(pname, ptr1);
	(*env)->ReleaseFloatArrayElements(env, params, ptr1, 0);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glGetIntegerv
  (JNIEnv *env, jobject obj, jint pname, jintArray params)
{
	jint *ptr1 = (*env)->GetIntArrayElements(env, params, 0);
	glGetIntegerv(pname, (GLint *) ptr1);
	(*env)->ReleaseIntArrayElements(env, params, ptr1, 0);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glGetLightfv
  (JNIEnv *env, jobject obj, jint light, jint pname, jfloatArray params)
{
	jfloat *ptr1 = (*env)->GetFloatArrayElements(env, params, 0);
	glGetLightfv(light, pname, ptr1);
	(*env)->ReleaseFloatArrayElements(env, params, ptr1, 0);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glGetLightiv
  (JNIEnv *env, jobject obj, jint light, jint pname, jintArray params)
{
	jint *ptr1 = (*env)->GetIntArrayElements(env, params, 0);
	glGetLightiv(light, pname, (GLint *) ptr1);
	(*env)->ReleaseIntArrayElements(env, params, ptr1, 0);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glGetMapdv
  (JNIEnv *env, jobject obj, jint target, jint query, jdoubleArray v)
{
	jdouble *ptr1 = (*env)->GetDoubleArrayElements(env, v, 0);
	glGetMapdv(target, query, ptr1);
	(*env)->ReleaseDoubleArrayElements(env, v, ptr1, 0);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glGetMapfv
  (JNIEnv *env, jobject obj, jint target, jint query, jfloatArray v)
{
	jfloat *ptr1 = (*env)->GetFloatArrayElements(env, v, 0);
	glGetMapfv(target, query, ptr1);
	(*env)->ReleaseFloatArrayElements(env, v, ptr1, 0);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glGetMapiv
  (JNIEnv *env, jobject obj, jint target, jint query, jintArray v)
{
	jint *ptr1 = (*env)->GetIntArrayElements(env, v, 0);
	glGetMapiv(target, query, (GLint *) ptr1);
	(*env)->ReleaseIntArrayElements(env, v, ptr1, 0);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glGetMaterialfv
  (JNIEnv *env, jobject obj, jint face, jint pname, jfloatArray params)
{
	jfloat *ptr1 = (*env)->GetFloatArrayElements(env, params, 0);
	glGetMaterialfv(face, pname, ptr1);
	(*env)->ReleaseFloatArrayElements(env, params, ptr1, 0);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glGetMaterialiv
  (JNIEnv *env, jobject obj, jint face, jint pname, jintArray params)
{
	jint *ptr1 = (*env)->GetIntArrayElements(env, params, 0);
	glGetMaterialiv(face, pname, (GLint *) ptr1);
	(*env)->ReleaseIntArrayElements(env, params, ptr1, 0);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glGetPixelMapfv
  (JNIEnv *env, jobject obj, jint map, jfloatArray values)
{
	jfloat *ptr1 = (*env)->GetFloatArrayElements(env, values, 0);
	glGetPixelMapfv(map, ptr1);
	(*env)->ReleaseFloatArrayElements(env, values, ptr1, 0);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glGetPixelMapuiv
  (JNIEnv *env, jobject obj, jint map, jintArray values)
{
	jint *ptr1 = (*env)->GetIntArrayElements(env, values, 0);
	glGetPixelMapuiv(map, (GLint *) ptr1);
	(*env)->ReleaseIntArrayElements(env, values, ptr1, 0);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glGetPixelMapusv
  (JNIEnv *env, jobject obj, jint map, jshortArray values)
{
	jshort *ptr1 = (*env)->GetShortArrayElements(env, values, 0);
	glGetPixelMapusv(map, ptr1);
	(*env)->ReleaseShortArrayElements(env, values, ptr1, 0);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glGetPolygonStipple
  (JNIEnv *env, jobject obj, jbyteArray mask)
{
	jbyte *ptr1 = (*env)->GetByteArrayElements(env, mask, 0);
	glGetPolygonStipple(ptr1);
	(*env)->ReleaseByteArrayElements(env, mask, ptr1, 0);
}

JNIEXPORT jstring JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glGetString
  (JNIEnv *env, jobject obj, jint name)
{
	return (*env)->NewStringUTF(env, glGetString(name));
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glGetTexEnvfv
  (JNIEnv *env, jobject obj, jint target, jint pname, jfloatArray params)
{
	jfloat *ptr1 = (*env)->GetFloatArrayElements(env, params, 0);
	glGetTexEnvfv(target, pname, ptr1);
	(*env)->ReleaseFloatArrayElements(env, params, ptr1, 0);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glGetTexEnviv
  (JNIEnv *env, jobject obj, jint target, jint pname, jintArray params)
{
	jint *ptr1 = (*env)->GetIntArrayElements(env, params, 0);
	glGetTexEnviv(target, pname, (GLint *) ptr1);
	(*env)->ReleaseIntArrayElements(env, params, ptr1, 0);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glGetTexGendv
  (JNIEnv *env, jobject obj, jint coord, jint pname, jdoubleArray params)
{
	jdouble *ptr1 = (*env)->GetDoubleArrayElements(env, params, 0);
	glGetTexGendv(coord, pname, ptr1);
	(*env)->ReleaseDoubleArrayElements(env, params, ptr1, 0);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glGetTexGenfv
  (JNIEnv *env, jobject obj, jint coord, jint pname, jfloatArray params)
{
	jfloat *ptr1 = (*env)->GetFloatArrayElements(env, params, 0);
	glGetTexGenfv(coord, pname, ptr1);
	(*env)->ReleaseFloatArrayElements(env, params, ptr1, 0);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glGetTexGeniv
  (JNIEnv *env, jobject obj, jint coord, jint pname, jintArray params)
{
	jint *ptr1 = (*env)->GetIntArrayElements(env, params, 0);
	glGetTexGeniv(coord, pname, (GLint *) ptr1);
	(*env)->ReleaseIntArrayElements(env, params, ptr1, 0);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glGetTexImage
  (JNIEnv *env, jobject obj, jint target, jint level, jint format, jint type, jbyteArray pixels)
{
	jbyte *ptr1 = (*env)->GetByteArrayElements(env, pixels, 0);
	glGetTexImage(target, level, format, type, ptr1);
	(*env)->ReleaseByteArrayElements(env, pixels, ptr1, 0);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glGetTexLevelParameterfv
  (JNIEnv *env, jobject obj, jint target, jint level, jint pname, jfloatArray params)
{
	jfloat *ptr1 = (*env)->GetFloatArrayElements(env, params, 0);
	glGetTexLevelParameterfv(target, level, pname, ptr1);
	(*env)->ReleaseFloatArrayElements(env, params, ptr1, 0);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glGetTexLevelParameteriv
  (JNIEnv *env, jobject obj, jint target, jint level, jint pname, jintArray params)
{
	jint *ptr1 = (*env)->GetIntArrayElements(env, params, 0);
	glGetTexLevelParameteriv(target, level, pname, (GLint *) ptr1);
	(*env)->ReleaseIntArrayElements(env, params, ptr1, 0);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glGetTexParameterfv
  (JNIEnv *env, jobject obj, jint target, jint pname, jfloatArray params)
{
	jfloat *ptr1 = (*env)->GetFloatArrayElements(env, params, 0);
	glGetTexParameterfv(target, pname, ptr1);
	(*env)->ReleaseFloatArrayElements(env, params, ptr1, 0);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glGetTexParameteriv
  (JNIEnv *env, jobject obj, jint target, jint pname, jintArray params)
{
	jint *ptr1 = (*env)->GetIntArrayElements(env, params, 0);
	glGetTexParameteriv(target, pname, (GLint *) ptr1);
	(*env)->ReleaseIntArrayElements(env, params, ptr1, 0);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glHint
  (JNIEnv *env, jobject obj, jint target, jint mode)
{
	glHint(target, mode);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glIndexd
  (JNIEnv *env, jobject obj, jdouble c)
{
	glIndexd(c);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glIndexdv
  (JNIEnv *env, jobject obj, jdoubleArray c)
{
	jdouble *ptr1 = (*env)->GetDoubleArrayElements(env, c, 0);
	glIndexdv(ptr1);
	(*env)->ReleaseDoubleArrayElements(env, c, ptr1, 0);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glIndexf
  (JNIEnv *env, jobject obj, jfloat c)
{
	glIndexf(c);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glIndexfv
  (JNIEnv *env, jobject obj, jfloatArray c)
{
	jfloat *ptr1 = (*env)->GetFloatArrayElements(env, c, 0);
	glIndexfv(ptr1);
	(*env)->ReleaseFloatArrayElements(env, c, ptr1, 0);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glIndexi
  (JNIEnv *env, jobject obj, jint c)
{
	glIndexi(c);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glIndexiv
  (JNIEnv *env, jobject obj, jintArray c)
{
	jint *ptr1 = (*env)->GetIntArrayElements(env, c, 0);
	glIndexiv((GLint *) ptr1);
	(*env)->ReleaseIntArrayElements(env, c, ptr1, 0);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glIndexMask
  (JNIEnv *env, jobject obj, jint mask)
{
	glIndexMask(mask);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glIndexs
  (JNIEnv *env, jobject obj, jshort c)
{
	glIndexs(c);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glIndexsv
  (JNIEnv *env, jobject obj, jshortArray c)
{
	jshort *ptr1 = (*env)->GetShortArrayElements(env, c, 0);
	glIndexsv(ptr1);
	(*env)->ReleaseShortArrayElements(env, c, ptr1, 0);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glInitNames
  (JNIEnv *env, jobject obj)
{
	glInitNames();
}

JNIEXPORT jboolean JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glIsEnabled
  (JNIEnv *env, jobject obj, jint cap)
{
	return glIsEnabled(cap);
}

JNIEXPORT jboolean JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glIsList
  (JNIEnv *env, jobject obj, jint list)
{
	return glIsList(list);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glLightf
  (JNIEnv *env, jobject obj, jint light, jint pname, jfloat param)
{
	glLightf(light, pname, param);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glLightfv
  (JNIEnv *env, jobject obj, jint light, jint pname, jfloatArray params)
{
	jfloat *ptr1 = (*env)->GetFloatArrayElements(env, params, 0);
	glLightfv(light, pname, ptr1);
	(*env)->ReleaseFloatArrayElements(env, params, ptr1, 0);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glLighti
  (JNIEnv *env, jobject obj, jint light, jint pname, jint param)
{
	glLighti(light, pname, param);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glLightiv
  (JNIEnv *env, jobject obj, jint light, jint pname, jintArray params)
{
	jint *ptr1 = (*env)->GetIntArrayElements(env, params, 0);
	glLightiv(light, pname, (GLint *) ptr1);
	(*env)->ReleaseIntArrayElements(env, params, ptr1, 0);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glLightModelf
  (JNIEnv *env, jobject obj, jint pname, jfloat param)
{
	glLightModelf(pname, param);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glLightModelfv
  (JNIEnv *env, jobject obj, jint pname, jfloatArray params)
{
	jfloat *ptr1 = (*env)->GetFloatArrayElements(env, params, 0);
	glLightModelfv(pname, ptr1);
	(*env)->ReleaseFloatArrayElements(env, params, ptr1, 0);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glLightModeli
  (JNIEnv *env, jobject obj, jint pname, jint param)
{
	glLightModeli(pname, param);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glLightModeliv
  (JNIEnv *env, jobject obj, jint pname, jintArray params)
{
	jint *ptr1 = (*env)->GetIntArrayElements(env, params, 0);
	glLightModeliv(pname, (GLint *) ptr1);
	(*env)->ReleaseIntArrayElements(env, params, ptr1, 0);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glLineStipple
  (JNIEnv *env, jobject obj, jint factor, jshort pattern)
{
	glLineStipple(factor, pattern);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glLineWidth
  (JNIEnv *env, jobject obj, jfloat width)
{
	glLineWidth(width);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glListBase
  (JNIEnv *env, jobject obj, jint base)
{
	glListBase(base);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glLoadIdentity
  (JNIEnv *env, jobject obj)
{
	glLoadIdentity();
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glLoadMatrixd
  (JNIEnv *env, jobject obj, jdoubleArray m)
{
	jdouble *ptr1 = (*env)->GetDoubleArrayElements(env, m, 0);
	glLoadMatrixd(ptr1);
	(*env)->ReleaseDoubleArrayElements(env, m, ptr1, 0);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glLoadMatrixf
  (JNIEnv *env, jobject obj, jfloatArray m)
{
	jfloat *ptr1 = (*env)->GetFloatArrayElements(env, m, 0);
	glLoadMatrixf(ptr1);
	(*env)->ReleaseFloatArrayElements(env, m, ptr1, 0);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glLoadName
  (JNIEnv *env, jobject obj, jint name)
{
	glLoadName(name);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glLogicOp
  (JNIEnv *env, jobject obj, jint opcode)
{
	glLogicOp(opcode);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glMap1d
  (JNIEnv *env, jobject obj, jint target, jdouble u1, jdouble u2, jint stride, jint order, jdoubleArray points)
{
	jdouble *ptr1 = (*env)->GetDoubleArrayElements(env, points, 0);
	glMap1d(target, u1, u2, stride, order, ptr1);
	(*env)->ReleaseDoubleArrayElements(env, points, ptr1, 0);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glMap1f
  (JNIEnv *env, jobject obj, jint target, jfloat u1, jfloat u2, jint stride, jint order, jfloatArray points)
{
	jfloat *ptr1 = (*env)->GetFloatArrayElements(env, points, 0);
	glMap1f(target, u1, u2, stride, order, ptr1);
	(*env)->ReleaseFloatArrayElements(env, points, ptr1, 0);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glMap2d
  (JNIEnv *env, jobject obj, jint target, jdouble u1, jdouble u2, jint ustride, jint uorder, jdouble v1, jdouble v2, jint vstride, jint vorder, jdoubleArray points)
{
	jdouble *ptr1 = (*env)->GetDoubleArrayElements(env, points, 0);
	glMap2d(target, u1, u2, ustride, uorder, v1, v2, vstride, vorder, ptr1);
	(*env)->ReleaseDoubleArrayElements(env, points, ptr1, 0);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glMap2f
  (JNIEnv *env, jobject obj, jint target, jfloat u1, jfloat u2, jint ustride, jint uorder, jfloat v1, jfloat v2, jint vstride, jint vorder, jfloatArray points)
{
	jfloat *ptr1 = (*env)->GetFloatArrayElements(env, points, 0);
	glMap2f(target, u1, u2, ustride, uorder, v1, v2, vstride, vorder, ptr1);
	(*env)->ReleaseFloatArrayElements(env, points, ptr1, 0);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glMapGrid1d
  (JNIEnv *env, jobject obj, jint un, jdouble u1, jdouble u2)
{
	glMapGrid1d(un, u1, u2);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glMapGrid1f
  (JNIEnv *env, jobject obj, jint un, jfloat u1, jfloat u2)
{
	glMapGrid1f(un, u1, u2);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glMapGrid2d
  (JNIEnv *env, jobject obj, jint un, jdouble u1, jdouble u2, jint vn, jdouble v1, jdouble v2)
{
	glMapGrid2d(un, u1, u2, vn, v1, v2);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glMapGrid2f
  (JNIEnv *env, jobject obj, jint un, jfloat u1, jfloat u2, jint vn, jfloat v1, jfloat v2)
{
	glMapGrid2f(un, u1, u2, vn, v1, v2);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glMaterialf
  (JNIEnv *env, jobject obj, jint face, jint pname, jfloat param)
{
	glMaterialf(face, pname, param);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glMaterialfv
  (JNIEnv *env, jobject obj, jint face, jint pname, jfloatArray params)
{
	jfloat *ptr1 = (*env)->GetFloatArrayElements(env, params, 0);
	glMaterialfv(face, pname, ptr1);
	(*env)->ReleaseFloatArrayElements(env, params, ptr1, 0);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glMateriali
  (JNIEnv *env, jobject obj, jint face, jint pname, jint param)
{
	glMateriali(face, pname, param);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glMaterialiv
  (JNIEnv *env, jobject obj, jint face, jint pname, jintArray params)
{
	jint *ptr1 = (*env)->GetIntArrayElements(env, params, 0);
	glMaterialiv(face, pname, (GLint *) ptr1);
	(*env)->ReleaseIntArrayElements(env, params, ptr1, 0);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glMatrixMode
  (JNIEnv *env, jobject obj, jint mode)
{
	glMatrixMode(mode);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glMultMatrixd
  (JNIEnv *env, jobject obj, jdoubleArray m)
{
	jdouble *ptr1 = (*env)->GetDoubleArrayElements(env, m, 0);
	glMultMatrixd(ptr1);
	(*env)->ReleaseDoubleArrayElements(env, m, ptr1, 0);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glMultMatrixf
  (JNIEnv *env, jobject obj, jfloatArray m)
{
	jfloat *ptr1 = (*env)->GetFloatArrayElements(env, m, 0);
	glMultMatrixf(ptr1);
	(*env)->ReleaseFloatArrayElements(env, m, ptr1, 0);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glNewList
  (JNIEnv *env, jobject obj, jint list, jint mode)
{
	glNewList(list, mode);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glNormal3b
  (JNIEnv *env, jobject obj, jbyte nx, jbyte ny, jbyte nz)
{
	glNormal3b(nx, ny, nz);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glNormal3bv
  (JNIEnv *env, jobject obj, jbyteArray v)
{
	jbyte *ptr1 = (*env)->GetByteArrayElements(env, v, 0);
	glNormal3bv(ptr1);
	(*env)->ReleaseByteArrayElements(env, v, ptr1, 0);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glNormal3d
  (JNIEnv *env, jobject obj, jdouble nx, jdouble ny, jdouble nz)
{
	glNormal3d(nx, ny, nz);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glNormal3dv
  (JNIEnv *env, jobject obj, jdoubleArray v)
{
	jdouble *ptr1 = (*env)->GetDoubleArrayElements(env, v, 0);
	glNormal3dv(ptr1);
	(*env)->ReleaseDoubleArrayElements(env, v, ptr1, 0);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glNormal3f
  (JNIEnv *env, jobject obj, jfloat nx, jfloat ny, jfloat nz)
{
	glNormal3f(nx, ny, nz);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glNormal3fv
  (JNIEnv *env, jobject obj, jfloatArray v)
{
	jfloat *ptr1 = (*env)->GetFloatArrayElements(env, v, 0);
	glNormal3fv(ptr1);
	(*env)->ReleaseFloatArrayElements(env, v, ptr1, 0);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glNormal3i
  (JNIEnv *env, jobject obj, jint nx, jint ny, jint nz)
{
	glNormal3i(nx, ny, nz);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glNormal3iv
  (JNIEnv *env, jobject obj, jintArray v)
{
	jint *ptr1 = (*env)->GetIntArrayElements(env, v, 0);
	glNormal3iv((GLint *) ptr1);
	(*env)->ReleaseIntArrayElements(env, v, ptr1, 0);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glNormal3s
  (JNIEnv *env, jobject obj, jshort nx, jshort ny, jshort nz)
{
	glNormal3s(nx, ny, nz);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glNormal3sv
  (JNIEnv *env, jobject obj, jshortArray v)
{
	jshort *ptr1 = (*env)->GetShortArrayElements(env, v, 0);
	glNormal3sv(ptr1);
	(*env)->ReleaseShortArrayElements(env, v, ptr1, 0);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glOrtho
  (JNIEnv *env, jobject obj, jdouble left, jdouble right, jdouble bottom, jdouble top, jdouble near_val, jdouble far_val)
{
	glOrtho(left, right, bottom, top, near_val, far_val);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glPassThrough
  (JNIEnv *env, jobject obj, jfloat token)
{
	glPassThrough(token);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glPixelMapfv
  (JNIEnv *env, jobject obj, jint map, jint mapsize, jfloatArray values)
{
	jfloat *ptr1 = (*env)->GetFloatArrayElements(env, values, 0);
	glPixelMapfv(map, mapsize, ptr1);
	(*env)->ReleaseFloatArrayElements(env, values, ptr1, 0);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glPixelMapuiv
  (JNIEnv *env, jobject obj, jint map, jint mapsize, jintArray values)
{
	jint *ptr1 = (*env)->GetIntArrayElements(env, values, 0);
	glPixelMapuiv(map, mapsize, (GLint *) ptr1);
	(*env)->ReleaseIntArrayElements(env, values, ptr1, 0);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glPixelMapusv
  (JNIEnv *env, jobject obj, jint map, jint mapsize, jshortArray values)
{
	jshort *ptr1 = (*env)->GetShortArrayElements(env, values, 0);
	glPixelMapusv(map, mapsize, ptr1);
	(*env)->ReleaseShortArrayElements(env, values, ptr1, 0);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glPixelStoref
  (JNIEnv *env, jobject obj, jint pname, jfloat param)
{
	glPixelStoref(pname, param);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glPixelStorei
  (JNIEnv *env, jobject obj, jint pname, jint param)
{
	glPixelStorei(pname, param);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glPixelTransferf
  (JNIEnv *env, jobject obj, jint pname, jfloat param)
{
	glPixelTransferf(pname, param);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glPixelTransferi
  (JNIEnv *env, jobject obj, jint pname, jint param)
{
	glPixelTransferi(pname, param);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glPixelZoom
  (JNIEnv *env, jobject obj, jfloat xfactor, jfloat yfactor)
{
	glPixelZoom(xfactor, yfactor);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glPointSize
  (JNIEnv *env, jobject obj, jfloat size)
{
	glPointSize(size);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glPolygonMode
  (JNIEnv *env, jobject obj, jint face, jint mode)
{
	glPolygonMode(face, mode);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glPolygonOffset
  (JNIEnv *env, jobject obj, jfloat factor, jfloat units)
{
	glPolygonOffset(factor, units);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glPolygonStipple
  (JNIEnv *env, jobject obj, jbyteArray mask)
{
	jbyte *ptr1 = (*env)->GetByteArrayElements(env, mask, 0);
	glPolygonStipple(ptr1);
	(*env)->ReleaseByteArrayElements(env, mask, ptr1, 0);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glPopAttrib
  (JNIEnv *env, jobject obj)
{
	glPopAttrib();
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glPopMatrix
  (JNIEnv *env, jobject obj)
{
	glPopMatrix();
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glPopName
  (JNIEnv *env, jobject obj)
{
	glPopName();
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glPushAttrib
  (JNIEnv *env, jobject obj, jint mask)
{
	glPushAttrib(mask);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glPushMatrix
  (JNIEnv *env, jobject obj)
{
	glPushMatrix();
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glPushName
  (JNIEnv *env, jobject obj, jint name)
{
	glPushName(name);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glRasterPos2d
  (JNIEnv *env, jobject obj, jdouble x, jdouble y)
{
	glRasterPos2d(x, y);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glRasterPos2dv
  (JNIEnv *env, jobject obj, jdoubleArray v)
{
	jdouble *ptr1 = (*env)->GetDoubleArrayElements(env, v, 0);
	glRasterPos2dv(ptr1);
	(*env)->ReleaseDoubleArrayElements(env, v, ptr1, 0);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glRasterPos2f
  (JNIEnv *env, jobject obj, jfloat x, jfloat y)
{
	glRasterPos2f(x, y);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glRasterPos2fv
  (JNIEnv *env, jobject obj, jfloatArray v)
{
	jfloat *ptr1 = (*env)->GetFloatArrayElements(env, v, 0);
	glRasterPos2fv(ptr1);
	(*env)->ReleaseFloatArrayElements(env, v, ptr1, 0);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glRasterPos2i
  (JNIEnv *env, jobject obj, jint x, jint y)
{
	glRasterPos2i(x, y);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glRasterPos2iv
  (JNIEnv *env, jobject obj, jintArray v)
{
	jint *ptr1 = (*env)->GetIntArrayElements(env, v, 0);
	glRasterPos2iv((GLint *) ptr1);
	(*env)->ReleaseIntArrayElements(env, v, ptr1, 0);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glRasterPos2s
  (JNIEnv *env, jobject obj, jshort x, jshort y)
{
	glRasterPos2s(x, y);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glRasterPos2sv
  (JNIEnv *env, jobject obj, jshortArray v)
{
	jshort *ptr1 = (*env)->GetShortArrayElements(env, v, 0);
	glRasterPos2sv(ptr1);
	(*env)->ReleaseShortArrayElements(env, v, ptr1, 0);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glRasterPos3d
  (JNIEnv *env, jobject obj, jdouble x, jdouble y, jdouble z)
{
	glRasterPos3d(x, y, z);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glRasterPos3dv
  (JNIEnv *env, jobject obj, jdoubleArray v)
{
	jdouble *ptr1 = (*env)->GetDoubleArrayElements(env, v, 0);
	glRasterPos3dv(ptr1);
	(*env)->ReleaseDoubleArrayElements(env, v, ptr1, 0);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glRasterPos3f
  (JNIEnv *env, jobject obj, jfloat x, jfloat y, jfloat z)
{
	glRasterPos3f(x, y, z);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glRasterPos3fv
  (JNIEnv *env, jobject obj, jfloatArray v)
{
	jfloat *ptr1 = (*env)->GetFloatArrayElements(env, v, 0);
	glRasterPos3fv(ptr1);
	(*env)->ReleaseFloatArrayElements(env, v, ptr1, 0);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glRasterPos3i
  (JNIEnv *env, jobject obj, jint x, jint y, jint z)
{
	glRasterPos3i(x, y, z);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glRasterPos3iv
  (JNIEnv *env, jobject obj, jintArray v)
{
	jint *ptr1 = (*env)->GetIntArrayElements(env, v, 0);
	glRasterPos3iv((GLint *) ptr1);
	(*env)->ReleaseIntArrayElements(env, v, ptr1, 0);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glRasterPos3s
  (JNIEnv *env, jobject obj, jshort x, jshort y, jshort z)
{
	glRasterPos3s(x, y, z);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glRasterPos3sv
  (JNIEnv *env, jobject obj, jshortArray v)
{
	jshort *ptr1 = (*env)->GetShortArrayElements(env, v, 0);
	glRasterPos3sv(ptr1);
	(*env)->ReleaseShortArrayElements(env, v, ptr1, 0);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glRasterPos4d
  (JNIEnv *env, jobject obj, jdouble x, jdouble y, jdouble z, jdouble w)
{
	glRasterPos4d(x, y, z, w);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glRasterPos4dv
  (JNIEnv *env, jobject obj, jdoubleArray v)
{
	jdouble *ptr1 = (*env)->GetDoubleArrayElements(env, v, 0);
	glRasterPos4dv(ptr1);
	(*env)->ReleaseDoubleArrayElements(env, v, ptr1, 0);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glRasterPos4f
  (JNIEnv *env, jobject obj, jfloat x, jfloat y, jfloat z, jfloat w)
{
	glRasterPos4f(x, y, z, w);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glRasterPos4fv
  (JNIEnv *env, jobject obj, jfloatArray v)
{
	jfloat *ptr1 = (*env)->GetFloatArrayElements(env, v, 0);
	glRasterPos4fv(ptr1);
	(*env)->ReleaseFloatArrayElements(env, v, ptr1, 0);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glRasterPos4i
  (JNIEnv *env, jobject obj, jint x, jint y, jint z, jint w)
{
	glRasterPos4i(x, y, z, w);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glRasterPos4iv
  (JNIEnv *env, jobject obj, jintArray v)
{
	jint *ptr1 = (*env)->GetIntArrayElements(env, v, 0);
	glRasterPos4iv((GLint *) ptr1);
	(*env)->ReleaseIntArrayElements(env, v, ptr1, 0);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glRasterPos4s
  (JNIEnv *env, jobject obj, jshort x, jshort y, jshort z, jshort w)
{
	glRasterPos4s(x, y, z, w);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glRasterPos4sv
  (JNIEnv *env, jobject obj, jshortArray v)
{
	jshort *ptr1 = (*env)->GetShortArrayElements(env, v, 0);
	glRasterPos4sv(ptr1);
	(*env)->ReleaseShortArrayElements(env, v, ptr1, 0);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glReadBuffer
  (JNIEnv *env, jobject obj, jint mode)
{
	glReadBuffer(mode);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glReadPixels
  (JNIEnv *env, jobject obj, jint x, jint y, jint width, jint height, jint format, jint type, jbyteArray pixels)
{
	jbyte *ptr1 = (*env)->GetByteArrayElements(env, pixels, 0);
	glReadPixels(x, y, width, height, format, type, ptr1);
	(*env)->ReleaseByteArrayElements(env, pixels, ptr1, 0);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glRectd
  (JNIEnv *env, jobject obj, jdouble x1, jdouble y1, jdouble x2, jdouble y2)
{
	glRectd(x1, y1, x2, y2);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glRectdv
  (JNIEnv *env, jobject obj, jdoubleArray v1, jdoubleArray v2)
{
	jdouble *ptr1 = (*env)->GetDoubleArrayElements(env, v1, 0);
	jdouble *ptr2 = (*env)->GetDoubleArrayElements(env, v2, 0);
	glRectdv(ptr1, ptr2);
	(*env)->ReleaseDoubleArrayElements(env, v1, ptr1, 0);
	(*env)->ReleaseDoubleArrayElements(env, v2, ptr2, 0);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glRectf
  (JNIEnv *env, jobject obj, jfloat x1, jfloat y1, jfloat x2, jfloat y2)
{
	glRectf(x1, y1, x2, y2);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glRectfv
  (JNIEnv *env, jobject obj, jfloatArray v1, jfloatArray v2)
{
	jfloat *ptr1 = (*env)->GetFloatArrayElements(env, v1, 0);
	jfloat *ptr2 = (*env)->GetFloatArrayElements(env, v2, 0);
	glRectfv(ptr1, ptr2);
	(*env)->ReleaseFloatArrayElements(env, v1, ptr1, 0);
	(*env)->ReleaseFloatArrayElements(env, v2, ptr2, 0);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glRecti
  (JNIEnv *env, jobject obj, jint x1, jint y1, jint x2, jint y2)
{
	glRecti(x1, y1, x2, y2);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glRectiv
  (JNIEnv *env, jobject obj, jintArray v1, jintArray v2)
{
	jint *ptr1 = (*env)->GetIntArrayElements(env, v1, 0);
	jint *ptr2 = (*env)->GetIntArrayElements(env, v2, 0);
	glRectiv((GLint *) ptr1, (GLint *) ptr2);
	(*env)->ReleaseIntArrayElements(env, v1, ptr1, 0);
	(*env)->ReleaseIntArrayElements(env, v2, ptr2, 0);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glRects
  (JNIEnv *env, jobject obj, jshort x1, jshort y1, jshort x2, jshort y2)
{
	glRects(x1, y1, x2, y2);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glRectsv
  (JNIEnv *env, jobject obj, jshortArray v1, jshortArray v2)
{
	jshort *ptr1 = (*env)->GetShortArrayElements(env, v1, 0);
	jshort *ptr2 = (*env)->GetShortArrayElements(env, v2, 0);
	glRectsv(ptr1, ptr2);
	(*env)->ReleaseShortArrayElements(env, v1, ptr1, 0);
	(*env)->ReleaseShortArrayElements(env, v2, ptr2, 0);
}

JNIEXPORT jint JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glRenderMode
  (JNIEnv *env, jobject obj, jint mode)
{
	return glRenderMode(mode);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glRotated
  (JNIEnv *env, jobject obj, jdouble angle, jdouble x, jdouble y, jdouble z)
{
	glRotated(angle, x, y, z);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glRotatef
  (JNIEnv *env, jobject obj, jfloat angle, jfloat x, jfloat y, jfloat z)
{
	glRotatef(angle, x, y, z);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glScaled
  (JNIEnv *env, jobject obj, jdouble x, jdouble y, jdouble z)
{
	glScaled(x, y, z);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glScalef
  (JNIEnv *env, jobject obj, jfloat x, jfloat y, jfloat z)
{
	glScalef(x, y, z);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glScissor
  (JNIEnv *env, jobject obj, jint x, jint y, jint width, jint height)
{
	glScissor(x, y, width, height);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glSelectBufferEnd
  (JNIEnv *env, jobject obj, jintArray buffer, jint pointer)
{
	jint bufferSize = (*env)->GetArrayLength(env, buffer);
	(*env)->SetIntArrayRegion(env, buffer, 0, bufferSize, (jint*)pointer);
	free((jint*)pointer);
}

JNIEXPORT jint JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glSelectBufferStart
  (JNIEnv *env, jobject obj, jintArray buffer)
{
	jint size = (*env)->GetArrayLength(env, buffer);
	jint *p = (jint*)malloc(size * sizeof(jint));
	glSelectBuffer(size, (GLuint*)p);
	return (jint)p;
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glShadeModel
  (JNIEnv *env, jobject obj, jint mode)
{
	glShadeModel(mode);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glStencilFunc
  (JNIEnv *env, jobject obj, jint func, jint ref, jint mask)
{
	glStencilFunc(func, ref, mask);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glStencilMask
  (JNIEnv *env, jobject obj, jint mask)
{
	glStencilMask(mask);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glStencilOp
  (JNIEnv *env, jobject obj, jint fail, jint zfail, jint zpass)
{
	glStencilOp(fail, zfail, zpass);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glTexCoord1d
  (JNIEnv *env, jobject obj, jdouble s)
{
	glTexCoord1d(s);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glTexCoord1dv
  (JNIEnv *env, jobject obj, jdoubleArray v)
{
	jdouble *ptr1 = (*env)->GetDoubleArrayElements(env, v, 0);
	glTexCoord1dv(ptr1);
	(*env)->ReleaseDoubleArrayElements(env, v, ptr1, 0);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glTexCoord1f
  (JNIEnv *env, jobject obj, jfloat s)
{
	glTexCoord1f(s);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glTexCoord1fv
  (JNIEnv *env, jobject obj, jfloatArray v)
{
	jfloat *ptr1 = (*env)->GetFloatArrayElements(env, v, 0);
	glTexCoord1fv(ptr1);
	(*env)->ReleaseFloatArrayElements(env, v, ptr1, 0);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glTexCoord1i
  (JNIEnv *env, jobject obj, jint s)
{
	glTexCoord1i(s);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glTexCoord1iv
  (JNIEnv *env, jobject obj, jintArray v)
{
	jint *ptr1 = (*env)->GetIntArrayElements(env, v, 0);
	glTexCoord1iv((GLint *) ptr1);
	(*env)->ReleaseIntArrayElements(env, v, ptr1, 0);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glTexCoord1s
  (JNIEnv *env, jobject obj, jshort s)
{
	glTexCoord1s(s);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glTexCoord1sv
  (JNIEnv *env, jobject obj, jshortArray v)
{
	jshort *ptr1 = (*env)->GetShortArrayElements(env, v, 0);
	glTexCoord1sv(ptr1);
	(*env)->ReleaseShortArrayElements(env, v, ptr1, 0);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glTexCoord2d
  (JNIEnv *env, jobject obj, jdouble s, jdouble t)
{
	glTexCoord2d(s, t);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glTexCoord2dv
  (JNIEnv *env, jobject obj, jdoubleArray v)
{
	jdouble *ptr1 = (*env)->GetDoubleArrayElements(env, v, 0);
	glTexCoord2dv(ptr1);
	(*env)->ReleaseDoubleArrayElements(env, v, ptr1, 0);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glTexCoord2f
  (JNIEnv *env, jobject obj, jfloat s, jfloat t)
{
	glTexCoord2f(s, t);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glTexCoord2fv
  (JNIEnv *env, jobject obj, jfloatArray v)
{
	jfloat *ptr1 = (*env)->GetFloatArrayElements(env, v, 0);
	glTexCoord2fv(ptr1);
	(*env)->ReleaseFloatArrayElements(env, v, ptr1, 0);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glTexCoord2i
  (JNIEnv *env, jobject obj, jint s, jint t)
{
	glTexCoord2i(s, t);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glTexCoord2iv
  (JNIEnv *env, jobject obj, jintArray v)
{
	jint *ptr1 = (*env)->GetIntArrayElements(env, v, 0);
	glTexCoord2iv((GLint *) ptr1);
	(*env)->ReleaseIntArrayElements(env, v, ptr1, 0);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glTexCoord2s
  (JNIEnv *env, jobject obj, jshort s, jshort t)
{
	glTexCoord2s(s, t);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glTexCoord2sv
  (JNIEnv *env, jobject obj, jshortArray v)
{
	jshort *ptr1 = (*env)->GetShortArrayElements(env, v, 0);
	glTexCoord2sv(ptr1);
	(*env)->ReleaseShortArrayElements(env, v, ptr1, 0);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glTexCoord3d
  (JNIEnv *env, jobject obj, jdouble s, jdouble t, jdouble r)
{
	glTexCoord3d(s, t, r);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glTexCoord3dv
  (JNIEnv *env, jobject obj, jdoubleArray v)
{
	jdouble *ptr1 = (*env)->GetDoubleArrayElements(env, v, 0);
	glTexCoord3dv(ptr1);
	(*env)->ReleaseDoubleArrayElements(env, v, ptr1, 0);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glTexCoord3f
  (JNIEnv *env, jobject obj, jfloat s, jfloat t, jfloat r)
{
	glTexCoord3f(s, t, r);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glTexCoord3fv
  (JNIEnv *env, jobject obj, jfloatArray v)
{
	jfloat *ptr1 = (*env)->GetFloatArrayElements(env, v, 0);
	glTexCoord3fv(ptr1);
	(*env)->ReleaseFloatArrayElements(env, v, ptr1, 0);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glTexCoord3i
  (JNIEnv *env, jobject obj, jint s, jint t, jint r)
{
	glTexCoord3i(s, t, r);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glTexCoord3iv
  (JNIEnv *env, jobject obj, jintArray v)
{
	jint *ptr1 = (*env)->GetIntArrayElements(env, v, 0);
	glTexCoord3iv((GLint *) ptr1);
	(*env)->ReleaseIntArrayElements(env, v, ptr1, 0);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glTexCoord3s
  (JNIEnv *env, jobject obj, jshort s, jshort t, jshort r)
{
	glTexCoord3s(s, t, r);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glTexCoord3sv
  (JNIEnv *env, jobject obj, jshortArray v)
{
	jshort *ptr1 = (*env)->GetShortArrayElements(env, v, 0);
	glTexCoord3sv(ptr1);
	(*env)->ReleaseShortArrayElements(env, v, ptr1, 0);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glTexCoord4d
  (JNIEnv *env, jobject obj, jdouble s, jdouble t, jdouble r, jdouble q)
{
	glTexCoord4d(s, t, r, q);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glTexCoord4dv
  (JNIEnv *env, jobject obj, jdoubleArray v)
{
	jdouble *ptr1 = (*env)->GetDoubleArrayElements(env, v, 0);
	glTexCoord4dv(ptr1);
	(*env)->ReleaseDoubleArrayElements(env, v, ptr1, 0);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glTexCoord4f
  (JNIEnv *env, jobject obj, jfloat s, jfloat t, jfloat r, jfloat q)
{
	glTexCoord4f(s, t, r, q);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glTexCoord4fv
  (JNIEnv *env, jobject obj, jfloatArray v)
{
	jfloat *ptr1 = (*env)->GetFloatArrayElements(env, v, 0);
	glTexCoord4fv(ptr1);
	(*env)->ReleaseFloatArrayElements(env, v, ptr1, 0);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glTexCoord4i
  (JNIEnv *env, jobject obj, jint s, jint t, jint r, jint q)
{
	glTexCoord4i(s, t, r, q);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glTexCoord4iv
  (JNIEnv *env, jobject obj, jintArray v)
{
	jint *ptr1 = (*env)->GetIntArrayElements(env, v, 0);
	glTexCoord4iv((GLint *) ptr1);
	(*env)->ReleaseIntArrayElements(env, v, ptr1, 0);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glTexCoord4s
  (JNIEnv *env, jobject obj, jshort s, jshort t, jshort r, jshort q)
{
	glTexCoord4s(s, t, r, q);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glTexCoord4sv
  (JNIEnv *env, jobject obj, jshortArray v)
{
	jshort *ptr1 = (*env)->GetShortArrayElements(env, v, 0);
	glTexCoord4sv(ptr1);
	(*env)->ReleaseShortArrayElements(env, v, ptr1, 0);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glTexEnvf
  (JNIEnv *env, jobject obj, jint target, jint pname, jfloat param)
{
	glTexEnvf(target, pname, param);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glTexEnvfv
  (JNIEnv *env, jobject obj, jint target, jint pname, jfloatArray params)
{
	jfloat *ptr1 = (*env)->GetFloatArrayElements(env, params, 0);
	glTexEnvfv(target, pname, ptr1);
	(*env)->ReleaseFloatArrayElements(env, params, ptr1, 0);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glTexEnvi
  (JNIEnv *env, jobject obj, jint target, jint pname, jint param)
{
	glTexEnvi(target, pname, param);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glTexEnviv
  (JNIEnv *env, jobject obj, jint target, jint pname, jintArray params)
{
	jint *ptr1 = (*env)->GetIntArrayElements(env, params, 0);
	glTexEnviv(target, pname, (GLint *) ptr1);
	(*env)->ReleaseIntArrayElements(env, params, ptr1, 0);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glTexGend
  (JNIEnv *env, jobject obj, jint coord, jint pname, jdouble param)
{
	glTexGend(coord, pname, param);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glTexGendv
  (JNIEnv *env, jobject obj, jint coord, jint pname, jdoubleArray params)
{
	jdouble *ptr1 = (*env)->GetDoubleArrayElements(env, params, 0);
	glTexGendv(coord, pname, ptr1);
	(*env)->ReleaseDoubleArrayElements(env, params, ptr1, 0);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glTexGenf
  (JNIEnv *env, jobject obj, jint coord, jint pname, jfloat param)
{
	glTexGenf(coord, pname, param);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glTexGenfv
  (JNIEnv *env, jobject obj, jint coord, jint pname, jfloatArray params)
{
	jfloat *ptr1 = (*env)->GetFloatArrayElements(env, params, 0);
	glTexGenfv(coord, pname, ptr1);
	(*env)->ReleaseFloatArrayElements(env, params, ptr1, 0);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glTexGeni
  (JNIEnv *env, jobject obj, jint coord, jint pname, jint param)
{
	glTexGeni(coord, pname, param);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glTexGeniv
  (JNIEnv *env, jobject obj, jint coord, jint pname, jintArray params)
{
	jint *ptr1 = (*env)->GetIntArrayElements(env, params, 0);
	glTexGeniv(coord, pname, (GLint *) ptr1);
	(*env)->ReleaseIntArrayElements(env, params, ptr1, 0);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glTexImage1D
  (JNIEnv *env, jobject obj, jint target, jint level, jint components, jint width, jint border, jint format, jint type, jbyteArray pixels)
{
	jbyte *ptr1 = (*env)->GetByteArrayElements(env, pixels, 0);
	glTexImage1D(target, level, components, width, border, format, type, ptr1);
	(*env)->ReleaseByteArrayElements(env, pixels, ptr1, 0);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glTexImage2D
  (JNIEnv *env, jobject obj, jint target, jint level, jint components, jint width, jint height, jint border, jint format, jint type, jbyteArray pixels)
{
	jbyte *ptr1 = (*env)->GetByteArrayElements(env, pixels, 0);
	glTexImage2D(target, level, components, width, height, border, format, type, ptr1);
	(*env)->ReleaseByteArrayElements(env, pixels, ptr1, 0);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glTexParameterf
  (JNIEnv *env, jobject obj, jint target, jint pname, jfloat param)
{
	glTexParameterf(target, pname, param);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glTexParameterfv
  (JNIEnv *env, jobject obj, jint target, jint pname, jfloatArray params)
{
	jfloat *ptr1 = (*env)->GetFloatArrayElements(env, params, 0);
	glTexParameterfv(target, pname, ptr1);
	(*env)->ReleaseFloatArrayElements(env, params, ptr1, 0);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glTexParameteri
  (JNIEnv *env, jobject obj, jint target, jint pname, jint param)
{
	glTexParameteri(target, pname, param);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glTexParameteriv
  (JNIEnv *env, jobject obj, jint target, jint pname, jintArray params)
{
	jint *ptr1 = (*env)->GetIntArrayElements(env, params, 0);
	glTexParameteriv(target, pname, (GLint *) ptr1);
	(*env)->ReleaseIntArrayElements(env, params, ptr1, 0);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glTranslated
  (JNIEnv *env, jobject obj, jdouble x, jdouble y, jdouble z)
{
	glTranslated(x, y, z);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glTranslatef
  (JNIEnv *env, jobject obj, jfloat x, jfloat y, jfloat z)
{
	glTranslatef(x, y, z);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glVertex2d
  (JNIEnv *env, jobject obj, jdouble x, jdouble y)
{
	glVertex2d(x, y);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glVertex2dv
  (JNIEnv *env, jobject obj, jdoubleArray v)
{
	jdouble *ptr1 = (*env)->GetDoubleArrayElements(env, v, 0);
	glVertex2dv(ptr1);
	(*env)->ReleaseDoubleArrayElements(env, v, ptr1, 0);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glVertex2f
  (JNIEnv *env, jobject obj, jfloat x, jfloat y)
{
	glVertex2f(x, y);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glVertex2fv
  (JNIEnv *env, jobject obj, jfloatArray v)
{
	jfloat *ptr1 = (*env)->GetFloatArrayElements(env, v, 0);
	glVertex2fv(ptr1);
	(*env)->ReleaseFloatArrayElements(env, v, ptr1, 0);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glVertex2i
  (JNIEnv *env, jobject obj, jint x, jint y)
{
	glVertex2i(x, y);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glVertex2iv
  (JNIEnv *env, jobject obj, jintArray v)
{
	jint *ptr1 = (*env)->GetIntArrayElements(env, v, 0);
	glVertex2iv((GLint *) ptr1);
	(*env)->ReleaseIntArrayElements(env, v, ptr1, 0);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glVertex2s
  (JNIEnv *env, jobject obj, jshort x, jshort y)
{
	glVertex2s(x, y);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glVertex2sv
  (JNIEnv *env, jobject obj, jshortArray v)
{
	jshort *ptr1 = (*env)->GetShortArrayElements(env, v, 0);
	glVertex2sv(ptr1);
	(*env)->ReleaseShortArrayElements(env, v, ptr1, 0);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glVertex3d
  (JNIEnv *env, jobject obj, jdouble x, jdouble y, jdouble z)
{
	glVertex3d(x, y, z);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glVertex3dv
  (JNIEnv *env, jobject obj, jdoubleArray v)
{
	jdouble *ptr1 = (*env)->GetDoubleArrayElements(env, v, 0);
	glVertex3dv(ptr1);
	(*env)->ReleaseDoubleArrayElements(env, v, ptr1, 0);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glVertex3f
  (JNIEnv *env, jobject obj, jfloat x, jfloat y, jfloat z)
{
	glVertex3f(x, y, z);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glVertex3fv
  (JNIEnv *env, jobject obj, jfloatArray v)
{
	jfloat *ptr1 = (*env)->GetFloatArrayElements(env, v, 0);
	glVertex3fv(ptr1);
	(*env)->ReleaseFloatArrayElements(env, v, ptr1, 0);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glVertex3i
  (JNIEnv *env, jobject obj, jint x, jint y, jint z)
{
	glVertex3i(x, y, z);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glVertex3iv
  (JNIEnv *env, jobject obj, jintArray v)
{
	jint *ptr1 = (*env)->GetIntArrayElements(env, v, 0);
	glVertex3iv((GLint *) ptr1);
	(*env)->ReleaseIntArrayElements(env, v, ptr1, 0);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glVertex3s
  (JNIEnv *env, jobject obj, jshort x, jshort y, jshort z)
{
	glVertex3s(x, y, z);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glVertex3sv
  (JNIEnv *env, jobject obj, jshortArray v)
{
	jshort *ptr1 = (*env)->GetShortArrayElements(env, v, 0);
	glVertex3sv(ptr1);
	(*env)->ReleaseShortArrayElements(env, v, ptr1, 0);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glVertex4d
  (JNIEnv *env, jobject obj, jdouble x, jdouble y, jdouble z, jdouble w)
{
	glVertex4d(x, y, z, w);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glVertex4dv
  (JNIEnv *env, jobject obj, jdoubleArray v)
{
	jdouble *ptr1 = (*env)->GetDoubleArrayElements(env, v, 0);
	glVertex4dv(ptr1);
	(*env)->ReleaseDoubleArrayElements(env, v, ptr1, 0);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glVertex4f
  (JNIEnv *env, jobject obj, jfloat x, jfloat y, jfloat z, jfloat w)
{
	glVertex4f(x, y, z, w);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glVertex4fv
  (JNIEnv *env, jobject obj, jfloatArray v)
{
	jfloat *ptr1 = (*env)->GetFloatArrayElements(env, v, 0);
	glVertex4fv(ptr1);
	(*env)->ReleaseFloatArrayElements(env, v, ptr1, 0);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glVertex4i
  (JNIEnv *env, jobject obj, jint x, jint y, jint z, jint w)
{
	glVertex4i(x, y, z, w);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glVertex4iv
  (JNIEnv *env, jobject obj, jintArray v)
{
	jint *ptr1 = (*env)->GetIntArrayElements(env, v, 0);
	glVertex4iv((GLint *) ptr1);
	(*env)->ReleaseIntArrayElements(env, v, ptr1, 0);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glVertex4s
  (JNIEnv *env, jobject obj, jshort x, jshort y, jshort z, jshort w)
{
	glVertex4s(x, y, z, w);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glVertex4sv
  (JNIEnv *env, jobject obj, jshortArray v)
{
	jshort *ptr1 = (*env)->GetShortArrayElements(env, v, 0);
	glVertex4sv(ptr1);
	(*env)->ReleaseShortArrayElements(env, v, ptr1, 0);
}

JNIEXPORT void JNICALL Java_jp_co_sra_gl4jun_GLjInterface_glViewport
  (JNIEnv *env, jobject obj, jint x, jint y, jint width, jint height)
{
	glViewport(x, y, width, height);
}
