/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.smalltalk.menu;

import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JMenu;
import jp.co.sra.smalltalk.StSymbol;
import jp.co.sra.smalltalk.menu.StMenu;
import jp.co.sra.smalltalk.menu.StMenuItem;
import jp.co.sra.smalltalk.menu.StMenuItemView;
import jp.co.sra.smalltalk.menu.StMenuItemViewSwing;
import jp.co.sra.smalltalk.menu.StMenuView;

public class StMenuViewSwing
extends StMenuItemViewSwing
implements StMenuView {
    protected ArrayList menuItemViews = new ArrayList();
    protected WindowListener windowListener = null;

    public StMenuViewSwing(StMenu stMenu) {
        super(stMenu);
    }

    protected void initializeWithWindow() {
        if (this.windowListener != null) {
            return;
        }
        Window window = this.getWindow();
        if (window == null) {
            return;
        }
        this.windowListener = new WindowAdapter(){

            public void windowClosed(WindowEvent windowEvent) {
                StMenuViewSwing.this.release();
            }
        };
        window.addWindowListener(this.windowListener);
    }

    public void release() {
        for (int i = 0; i < this.menuItemViews.size(); ++i) {
            ((StMenuItemViewSwing)this.menuItemViews.get(i)).release();
        }
        super.release();
    }

    public StMenu getMenu() {
        return (StMenu)this.getMenuItem();
    }

    public StMenuItemView atNameKey_(StSymbol stSymbol) {
        if (this.menuItemView == null) {
            this.menuItemView();
        }
        StMenuItemView[] stMenuItemViewArray = this.menuItemViews.toArray(new StMenuItemView[this.menuItemViews.size()]);
        for (int i = 0; i < stMenuItemViewArray.length; ++i) {
            StMenuItemView stMenuItemView;
            if (stMenuItemViewArray[i].getMenuItem() == StMenu.Separator) continue;
            if (stMenuItemViewArray[i].getMenuItem().nameKey() == stSymbol) {
                return stMenuItemViewArray[i];
            }
            if (!(stMenuItemViewArray[i] instanceof StMenuView) || (stMenuItemView = ((StMenuView)stMenuItemViewArray[i]).atNameKey_(stSymbol)) == null) continue;
            return stMenuItemView;
        }
        return null;
    }

    public JMenu toMenu() {
        return (JMenu)this.menuItemView();
    }

    protected JComponent createMenuItemView() {
        JMenu jMenu = new JMenu();
        StMenuItem[] stMenuItemArray = this.getMenu().menuItems();
        for (int i = 0; i < stMenuItemArray.length; ++i) {
            if (stMenuItemArray[i] == StMenu.Separator) {
                jMenu.addSeparator();
                continue;
            }
            StMenuItemViewSwing stMenuItemViewSwing = StMenuViewSwing._New(stMenuItemArray[i]);
            this.menuItemViews.add(stMenuItemViewSwing);
            jMenu.add(stMenuItemViewSwing.toMenuItem());
        }
        return jMenu;
    }

    public void setLightWeightPopupEnabled(boolean bl) {
        if (this.menuItemView == null) {
            this.menuItemView();
        }
        this.toMenu().getPopupMenu().setLightWeightPopupEnabled(bl);
        for (int i = 0; i < this.menuItemViews.size(); ++i) {
            StMenuItemViewSwing stMenuItemViewSwing = (StMenuItemViewSwing)this.menuItemViews.get(i);
            if (!(stMenuItemViewSwing instanceof StMenuViewSwing)) continue;
            ((StMenuViewSwing)stMenuItemViewSwing).setLightWeightPopupEnabled(bl);
        }
    }
}

