/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.smalltalk.menu;

import java.awt.Menu;
import java.awt.MenuComponent;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import jp.co.sra.smalltalk.StSymbol;
import jp.co.sra.smalltalk.menu.StMenu;
import jp.co.sra.smalltalk.menu.StMenuItem;
import jp.co.sra.smalltalk.menu.StMenuItemView;
import jp.co.sra.smalltalk.menu.StMenuItemViewAwt;
import jp.co.sra.smalltalk.menu.StMenuView;

public class StMenuViewAwt
extends StMenuItemViewAwt
implements StMenuView {
    protected ArrayList menuItemViews = new ArrayList();
    protected WindowListener windowListener = null;

    public StMenuViewAwt(StMenu stMenu) {
        super(stMenu);
    }

    protected void initializeWithWindow() {
        if (this.windowListener != null) {
            return;
        }
        Window window = this.getWindow();
        if (window == null) {
            return;
        }
        this.windowListener = new WindowAdapter(){

            public void windowClosed(WindowEvent windowEvent) {
                StMenuViewAwt.this.release();
            }
        };
        window.addWindowListener(this.windowListener);
    }

    public void release() {
        for (int i = 0; i < this.menuItemViews.size(); ++i) {
            ((StMenuItemViewAwt)this.menuItemViews.get(i)).release();
        }
        super.release();
    }

    public StMenu getMenu() {
        return (StMenu)this.getMenuItem();
    }

    public StMenuItemView atNameKey_(StSymbol stSymbol) {
        if (this.menuItemView == null) {
            this.menuItemView();
        }
        StMenuItemView[] stMenuItemViewArray = this.menuItemViews.toArray(new StMenuItemView[this.menuItemViews.size()]);
        for (int i = 0; i < stMenuItemViewArray.length; ++i) {
            StMenuItemView stMenuItemView;
            if (stMenuItemViewArray[i].getMenuItem() == StMenu.Separator) continue;
            if (stMenuItemViewArray[i].getMenuItem().nameKey() == stSymbol) {
                return stMenuItemViewArray[i];
            }
            if (!(stMenuItemViewArray[i] instanceof StMenuView) || (stMenuItemView = ((StMenuView)stMenuItemViewArray[i]).atNameKey_(stSymbol)) == null) continue;
            return stMenuItemView;
        }
        return null;
    }

    public Menu toMenu() {
        return (Menu)this.menuItemView();
    }

    protected MenuComponent createMenuItemView() {
        Menu menu = new Menu();
        StMenuItem[] stMenuItemArray = this.getMenu().menuItems();
        for (int i = 0; i < stMenuItemArray.length; ++i) {
            if (stMenuItemArray[i] == StMenu.Separator) {
                menu.addSeparator();
                continue;
            }
            StMenuItemViewAwt stMenuItemViewAwt = StMenuViewAwt._New(stMenuItemArray[i]);
            this.menuItemViews.add(stMenuItemViewAwt);
            menu.add(stMenuItemViewAwt.toMenuItem());
        }
        return menu;
    }
}

