/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.smalltalk;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.TreeMap;
import jp.co.sra.smalltalk.SmalltalkTestExamples;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StSortedCollection;

public class StSortedCollectionTestExamples
extends SmalltalkTestExamples {
    public static final boolean Example1() {
        StBlockClosure stBlockClosure = new StBlockClosure(){

            public Object value_value_(Object object, Object object2) {
                return new Boolean(((Number)object).intValue() <= ((Number)object2).intValue());
            }
        };
        StSortedCollection stSortedCollection = new StSortedCollection(stBlockClosure);
        stSortedCollection.add_(new Integer(0));
        stSortedCollection.add_(new Integer(4));
        stSortedCollection.add_(new Integer(5));
        stSortedCollection.add_(new Integer(3));
        stSortedCollection.add_(new Integer(2));
        stSortedCollection.add_(new Integer(1));
        Object[] objectArray = stSortedCollection._asArray();
        for (int i = 0; i < objectArray.length; ++i) {
            System.out.println(i);
            if (((Number)objectArray[i]).intValue() == i) continue;
            return false;
        }
        return true;
    }

    public static boolean Example2_double() {
        int n;
        int n2 = 100000;
        double[] dArray = new double[n2];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = Math.random();
        }
        long l = System.currentTimeMillis();
        StSortedCollection stSortedCollection = new StSortedCollection(new StBlockClosure(){

            public Object value_value_(Object object, Object object2) {
                return new Boolean(((Number)object).doubleValue() <= ((Number)object2).doubleValue());
            }
        });
        for (int i = 0; i < dArray.length; ++i) {
            stSortedCollection.add_(new Double(dArray[i]));
        }
        System.out.println("StSortedCollection          : elapsed " + (System.currentTimeMillis() - l));
        l = System.currentTimeMillis();
        TreeMap<Double, Object> treeMap = new TreeMap<Double, Object>(new Comparator(){

            public int compare(Object object, Object object2) {
                double d;
                double d2 = ((Number)object).doubleValue();
                return d2 == (d = ((Number)object2).doubleValue()) ? 0 : (d2 < d ? -1 : 1);
            }
        });
        for (int i = 0; i < dArray.length; ++i) {
            treeMap.put(new Double(dArray[i]), null);
        }
        System.out.println("TreeMap                     : elapsed " + (System.currentTimeMillis() - l));
        l = System.currentTimeMillis();
        ArrayList<Double> arrayList = new ArrayList<Double>();
        for (n = 0; n < dArray.length; ++n) {
            arrayList.add(new Double(dArray[n]));
        }
        Collections.sort(arrayList, new Comparator(){

            public int compare(Object object, Object object2) {
                double d;
                double d2 = ((Number)object).doubleValue();
                return d2 == (d = ((Number)object2).doubleValue()) ? 0 : (d2 < d ? -1 : 1);
            }
        });
        System.out.println("Collesions.sort() with List : elapsed " + (System.currentTimeMillis() - l));
        l = System.currentTimeMillis();
        arrayList = new ArrayList();
        for (n = 0; n < dArray.length; ++n) {
            arrayList.add(new Double(dArray[n]));
        }
        Arrays.sort(arrayList.toArray(), new Comparator(){

            public int compare(Object object, Object object2) {
                double d;
                double d2 = ((Number)object).doubleValue();
                return d2 == (d = ((Number)object2).doubleValue()) ? 0 : (d2 < d ? -1 : 1);
            }
        });
        System.out.println("Arrays.sort() with List     : elapsed " + (System.currentTimeMillis() - l));
        l = System.currentTimeMillis();
        double[] dArray2 = new double[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray2[i] = dArray[i];
        }
        Arrays.sort(dArray);
        System.out.println("Arrays.sort() with double[] : elapsed " + (System.currentTimeMillis() - l));
        return true;
    }

    public static boolean Example3_String() {
        int n;
        int n2 = 100000;
        String[] stringArray = new String[n2];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = String.valueOf(Math.random());
        }
        long l = System.currentTimeMillis();
        StSortedCollection stSortedCollection = new StSortedCollection(new StBlockClosure(){

            public Object value_value_(Object object, Object object2) {
                int n = ((String)object).compareTo((String)object2);
                return new Boolean(n <= 0);
            }
        });
        for (int i = 0; i < stringArray.length; ++i) {
            stSortedCollection.add_(stringArray[i]);
        }
        System.out.println("StSortedCollection          : elapsed " + (System.currentTimeMillis() - l));
        l = System.currentTimeMillis();
        TreeMap<String, Object> treeMap = new TreeMap<String, Object>(new Comparator(){

            public int compare(Object object, Object object2) {
                return ((String)object).compareTo((String)object2);
            }
        });
        for (int i = 0; i < stringArray.length; ++i) {
            treeMap.put(stringArray[i], null);
        }
        System.out.println("TreeMap                     : elapsed " + (System.currentTimeMillis() - l));
        l = System.currentTimeMillis();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (n = 0; n < stringArray.length; ++n) {
            arrayList.add(stringArray[n]);
        }
        Collections.sort(arrayList, new Comparator(){

            public int compare(Object object, Object object2) {
                return ((String)object).compareTo((String)object2);
            }
        });
        System.out.println("Collesions.sort() with List : elapsed " + (System.currentTimeMillis() - l));
        l = System.currentTimeMillis();
        arrayList = new ArrayList();
        for (n = 0; n < stringArray.length; ++n) {
            arrayList.add(stringArray[n]);
        }
        Arrays.sort(arrayList.toArray(), new Comparator(){

            public int compare(Object object, Object object2) {
                return ((String)object).compareTo((String)object2);
            }
        });
        System.out.println("Arrays.sort() with List     : elapsed " + (System.currentTimeMillis() - l));
        return true;
    }

    public static void main(String[] stringArray) {
        new StSortedCollectionTestExamples();
    }
}

