/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.smalltalk;

import java.util.Collection;
import java.util.Vector;
import jp.co.sra.smalltalk.SmalltalkException;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StObject;

public class StSortedCollection
extends StObject {
    protected StBlockClosure sortBlock = null;
    protected Vector _elements = new Vector();

    public StSortedCollection(StBlockClosure stBlockClosure) {
        this.sortBlock_(stBlockClosure);
    }

    public StSortedCollection(StBlockClosure stBlockClosure, Object[] objectArray) {
        this(stBlockClosure);
        for (int i = 0; i < objectArray.length; ++i) {
            this.add_(objectArray[i]);
        }
    }

    public StSortedCollection(StBlockClosure stBlockClosure, Vector vector) {
        this(stBlockClosure, vector.toArray());
    }

    private StSortedCollection() {
    }

    public void sortBlock_(StBlockClosure stBlockClosure) {
        this.sortBlock = stBlockClosure;
    }

    public Object at_(int n) {
        return this._elements.get(n);
    }

    public Object first() {
        return this._elements.firstElement();
    }

    public Object last() {
        return this._elements.lastElement();
    }

    public int size() {
        return this._elements.size();
    }

    public Object add_(Object object) {
        if (this._elements.isEmpty()) {
            this._elements.addElement(object);
        } else {
            int n = this.indexForInserting_(object);
            this._elements.insertElementAt(object, n);
        }
        return object;
    }

    public Object[] _asArray() {
        return this._elements.toArray();
    }

    public Collection _asCollection() {
        return new Vector(this._elements);
    }

    protected boolean compareElement_to_(Object object, Object object2) {
        if (this.sortBlock == null) {
            throw new SmalltalkException("No sort block.");
        }
        return (Boolean)this.sortBlock.value_value_(object, object2);
    }

    protected int indexForInserting_(Object object) {
        int n = 0;
        int n2 = this._elements.size() - 1;
        int n3 = (n2 + n) / 2;
        while (n <= n2) {
            if (this.compareElement_to_(this._elements.elementAt(n3), object)) {
                n = n3 + 1;
            } else {
                n2 = n3 - 1;
            }
            n3 = (n2 + n) / 2;
        }
        return n;
    }
}

