/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.smalltalk;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import jp.co.sra.smalltalk.SmalltalkException;
import jp.co.sra.smalltalk.StDisplayable;
import jp.co.sra.smalltalk.StImage;
import jp.co.sra.smalltalk.StObject;

public class StOpaqueImage
extends StObject
implements StDisplayable {
    protected StImage figure;
    protected StImage shape;
    protected StImage image;

    public StOpaqueImage(StImage stImage, StImage stImage2) {
        this.figure_shape_(stImage, stImage2);
    }

    public StImage figure() {
        return this.figure;
    }

    public StImage shape() {
        return this.shape;
    }

    public Dimension extent() {
        return new Dimension(this.figure().width(), this.figure().height());
    }

    protected void figure_shape_(StImage stImage, StImage stImage2) {
        if (!stImage.extent().equals(stImage2.extent())) {
            throw SmalltalkException.Error("figure and shape sizes don't match");
        }
        if (stImage2.colorModel() != StImage.MonoMaskColorModel()) {
            throw SmalltalkException.Error("shape must have MonoMaskColorModel");
        }
        this.figure = stImage;
        this.shape = stImage2;
    }

    public StImage asImage() {
        if (this.image == null) {
            int n = this.figure().width();
            int n2 = this.figure().height();
            StImage stImage = new StImage(n, n2, ColorModel.getRGBdefault());
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n; ++j) {
                    byte[] byArray = (byte[])this.shape().image().getRaster().getDataElements(j, i, null);
                    int n3 = byArray[0] > 0 ? this.figure().getPixel(j, i) : 0;
                    stImage.setPixel(j, i, n3);
                }
            }
            this.image = stImage;
        }
        return this.image;
    }

    public Rectangle bounds() {
        return this.figure().bounds();
    }

    public void displayOn_(Graphics graphics) {
        this.asImage().displayOn_(graphics);
    }

    public void displayOn_at_(Graphics graphics, Point point) {
        this.asImage().displayOn_at_(graphics, point);
    }
}

