/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.smalltalk;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.text.AttributedString;
import java.text.BreakIterator;
import java.util.ArrayList;
import jp.co.sra.smalltalk.StDisplayable;
import jp.co.sra.smalltalk.StImage;
import jp.co.sra.smalltalk.StObject;

public class StComposedText
extends StObject
implements StDisplayable {
    protected String string = null;
    protected Font font = null;
    protected int compositionWidth = -1;
    protected int compositionHeight = -1;
    protected boolean fitWidth = true;
    protected TextLayout[] layouts = null;
    protected int alignment;
    public static final int DefaultCompositionWidth = Integer.MAX_VALUE;
    public static final int LeftFlush = 0;
    public static final int RightFlush = 1;
    public static final int Centered = 2;

    public static Font DefaultFont() {
        String string = System.getProperty("default.font.name", "Dialog");
        int n = 0;
        if (System.getProperty("default.font.style") != null) {
            try {
                n = Integer.parseInt(System.getProperty("default.font.style"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        int n2 = 12;
        if (System.getProperty("default.font.size") != null) {
            try {
                n2 = Integer.parseInt(System.getProperty("default.font.size"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return new Font(string, n, n2);
    }

    public static FontRenderContext DefaultFontRenderContext() {
        return new FontRenderContext(null, false, false);
    }

    public StComposedText(String string) {
        this(string, null);
    }

    public StComposedText(String string, int n) {
        this();
        this.compositionWidth_string_font_fitWidth_(n, string, null, false);
    }

    public StComposedText(String string, Font font) {
        this();
        this.compositionWidth_string_font_fitWidth_(Integer.MAX_VALUE, string, font, true);
    }

    public StComposedText(String string, Font font, int n) {
        this();
        this.compositionWidth_string_font_fitWidth_(n, string, font, false);
    }

    protected StComposedText() {
    }

    public String string() {
        return this.string;
    }

    public void string_(String string) {
        this.string = string;
        this.composeAll();
    }

    public Font font() {
        if (this.font == null) {
            return StComposedText.DefaultFont();
        }
        return this.font;
    }

    public void font_(Font font) {
        Font font2 = this.font();
        this.font = font;
        if (!font2.equals(this.font())) {
            this.composeAll();
        }
    }

    public int numberOfLines() {
        return this.layouts().length;
    }

    protected TextLayout[] layouts() {
        if (this.layouts == null) {
            this.composeAll();
        }
        return this.layouts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int composeAll() {
        if (this.string() == null || this.string().length() == 0) {
            this.layouts = new TextLayout[0];
            this.setHeight_(0);
            return 0;
        }
        float f = this.width();
        ArrayList<TextLayout> arrayList = new ArrayList<TextLayout>();
        BufferedReader bufferedReader = null;
        try {
            String string;
            bufferedReader = new BufferedReader(new StringReader(this.string()));
            while ((string = bufferedReader.readLine()) != null) {
                int n = string.length();
                if (n == 0) {
                    string = " ";
                    n = 1;
                }
                AttributedString attributedString = new AttributedString(string);
                attributedString.addAttribute(TextAttribute.FONT, this.font());
                LineBreakMeasurer lineBreakMeasurer = new LineBreakMeasurer(attributedString.getIterator(), BreakIterator.getWordInstance(), StComposedText.DefaultFontRenderContext());
                lineBreakMeasurer.setPosition(0);
                while (lineBreakMeasurer.getPosition() < n) {
                    arrayList.add(lineBreakMeasurer.nextLayout(f));
                }
            }
        }
        catch (IOException iOException) {
            this.setHeight_(0);
            int n = 0;
            return n;
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    this.setHeight_(0);
                    return 0;
                }
            }
        }
        this.layouts = arrayList.toArray(new TextLayout[arrayList.size()]);
        float f2 = this.layouts[0].getAdvance();
        float f3 = this.layouts[0].getAscent() + this.layouts[0].getDescent();
        for (int i = 1; i < this.layouts.length; ++i) {
            f2 = Math.max(f2, this.layouts[i].getVisibleAdvance());
            f3 += this.layouts[i].getLeading() + this.layouts[i].getAscent() + this.layouts[i].getDescent();
        }
        this.setHeight_((int)f3);
        return (int)f2;
    }

    public int width() {
        return this.compositionWidth;
    }

    public int height() {
        if (this.compositionHeight < 0) {
            this.updateCompositionHeight();
        }
        return this.compositionHeight;
    }

    public Rectangle bounds() {
        return new Rectangle(0, 0, this.width(), this.height());
    }

    public Dimension extent() {
        return new Dimension(this.width(), this.height());
    }

    protected void setCompositionWidth_(int n) {
        this.compositionWidth = Math.max(n, 0);
    }

    protected void setHeight_(int n) {
        this.compositionHeight = n;
    }

    public void leftFlush() {
        this.setAlignment_(0);
    }

    public void rightFlush() {
        this.setAlignment_(1);
    }

    public void centered() {
        this.setAlignment_(2);
    }

    protected void setAlignment_(int n) {
        this.alignment = n;
    }

    public void displayOn_(Graphics graphics) {
        this.displayOn_at_(graphics, new Point(0, 0));
    }

    public void displayOn_at_(Graphics graphics, Point point) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        int n = point.x;
        int n2 = point.y;
        TextLayout[] textLayoutArray = this.layouts();
        for (int i = 0; i < textLayoutArray.length; ++i) {
            n2 = (int)((float)n2 + textLayoutArray[i].getAscent());
            float f = 0.0f;
            if (this.alignment != 0) {
                float f2 = (float)this.width() - textLayoutArray[i].getVisibleAdvance();
                if (this.alignment == 1) {
                    f = f2;
                } else if (this.alignment == 2) {
                    f = f2 / 2.0f;
                }
            }
            textLayoutArray[i].draw(graphics2D, (float)n + f, n2);
            n2 = (int)((float)n2 + (textLayoutArray[i].getDescent() + textLayoutArray[i].getLeading()));
        }
    }

    public boolean isComposed() {
        return this.layouts != null;
    }

    public StImage asImage() {
        return this.asImage(Color.black, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StImage asImage(Color color, Color color2) {
        int n = this.width();
        int n2 = this.height();
        int[] nArray = new int[n * n2];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = 0;
        }
        StImage stImage = new StImage(n, n2, nArray);
        Graphics2D graphics2D = null;
        try {
            graphics2D = (Graphics2D)stImage.image().getGraphics();
            if (color2 != null) {
                graphics2D.setColor(color2);
                graphics2D.fillRect(0, 0, n, n2);
            }
            if (color != null) {
                graphics2D.setColor(color);
            }
            this.displayOn_(graphics2D);
        }
        finally {
            if (graphics2D != null) {
                graphics2D.dispose();
                graphics2D = null;
            }
        }
        return stImage;
    }

    public Image toImage() {
        return this.asImage().image();
    }

    protected void compositionWidth_string_font_fitWidth_(int n, String string, Font font, boolean bl) {
        this.fitWidth = bl;
        this.string = string;
        this.font = font;
        this.setCompositionWidth_(n);
        if (bl) {
            this.compositionWidth = this.composeAll();
        } else {
            this.composeAll();
        }
    }

    protected void updateCompositionHeight() {
    }
}

