/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.smalltalk;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.Window;
import java.io.Serializable;
import jp.co.sra.smalltalk.DependentEvent;
import jp.co.sra.smalltalk.StApplicationModel;
import jp.co.sra.smalltalk.StApplicationWindow;
import jp.co.sra.smalltalk.StView;
import jp.co.sra.smalltalk.menu.StMenuBar;
import jp.co.sra.smalltalk.menu.StMenuBarView;
import jp.co.sra.smalltalk.menu.StMenuBarViewAwt;

public class StApplicationWindowAwt
extends Frame
implements StApplicationWindow {
    protected StApplicationModel application;
    protected StView view;
    protected StMenuBarViewAwt menuBarView;

    public StApplicationWindowAwt(StApplicationModel stApplicationModel, StView stView) {
        this.application_(stApplicationModel);
        this.view_(stView);
        this.buildWindow();
    }

    public StApplicationModel application() {
        return this.application;
    }

    public void application_(StApplicationModel stApplicationModel) {
        if (this.application != null) {
            this.application.removeDependentListener(this);
        }
        this.application = stApplicationModel;
        if (this.application != null) {
            this.application.addDependentListener(this);
        }
    }

    public StView view() {
        return this.view;
    }

    public void view_(StView stView) {
        this.view = stView;
    }

    public StMenuBarView menuBarView() {
        return this.menuBarView;
    }

    protected void menuBarView_(StMenuBarViewAwt stMenuBarViewAwt) {
        this.setMenuBar(stMenuBarViewAwt.toMenuBar());
        this.pack();
        this.menuBarView = stMenuBarViewAwt;
    }

    public Window toWindow() {
        return this;
    }

    public Frame toFrame() {
        return this;
    }

    public void update_(DependentEvent dependentEvent) {
    }

    public boolean updateWindowTitle() {
        if (this.application() == null) {
            return false;
        }
        String string = this.application().windowTitle();
        if (string == null) {
            return false;
        }
        this.setTitle(string);
        return true;
    }

    public boolean updateMenuBar() {
        if (this.application() == null) {
            return false;
        }
        StMenuBar stMenuBar = this.application()._menuBar();
        if (stMenuBar == null) {
            return false;
        }
        this.menuBarView_((StMenuBarViewAwt)this.view()._createMenuBarView(stMenuBar));
        return true;
    }

    protected void buildWindow() {
        Serializable serializable;
        if (this.application() == null) {
            return;
        }
        if (this.view() == null) {
            return;
        }
        this.updateWindowTitle();
        this.updateMenuBar();
        Component component = this.view().toComponent();
        if (this.application()._viewOnBorderedPanel()) {
            serializable = StApplicationWindowAwt._PanelWithBorder();
            serializable.setLayout(new BorderLayout());
            serializable.add(component, "Center");
            component = serializable;
        }
        this.add(component);
        this.pack();
        serializable = this.getInsets();
        Dimension dimension = this.view().toComponent().getSize();
        this.setSize(dimension.width + ((Insets)serializable).left + ((Insets)serializable).right, dimension.height + ((Insets)serializable).top + ((Insets)serializable).bottom);
        if (!this.application().windowResizable()) {
            this.setResizable(false);
        }
    }

    public static Panel _PanelWithBorder() {
        Panel panel = new Panel(){

            public Insets getInsets() {
                return new Insets(2, 2, 2, 2);
            }

            public void paint(Graphics graphics) {
                super.paint(graphics);
                Dimension dimension = this.getSize();
                graphics.setColor(Color.black);
                graphics.drawLine(1, 1, dimension.width - 3, 1);
                graphics.drawLine(1, 1, 1, dimension.height - 3);
                graphics.setColor(Color.gray);
                graphics.drawLine(0, 0, dimension.width - 2, 0);
                graphics.drawLine(0, 0, 0, dimension.height - 2);
                graphics.setColor(Color.lightGray);
                graphics.drawLine(1, dimension.height - 2, dimension.width - 2, dimension.height - 2);
                graphics.drawLine(dimension.width - 2, 1, dimension.width - 2, dimension.height - 2);
                graphics.setColor(Color.white);
                graphics.drawLine(0, dimension.height - 1, dimension.width - 1, dimension.height - 1);
                graphics.drawLine(dimension.width - 1, 0, dimension.width - 1, dimension.height - 1);
            }
        };
        return panel;
    }
}

