/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.smalltalk;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.WindowEvent;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import jp.co.sra.smalltalk.StApplicationWindow;
import jp.co.sra.smalltalk.StApplicationWindowAwt;
import jp.co.sra.smalltalk.StApplicationWindowSwing;
import jp.co.sra.smalltalk.StModel;
import jp.co.sra.smalltalk.StRectangle;
import jp.co.sra.smalltalk.StSymbol;
import jp.co.sra.smalltalk.StUIBuilder;
import jp.co.sra.smalltalk.StUserMessage;
import jp.co.sra.smalltalk.StView;
import jp.co.sra.smalltalk.SystemInterface;
import jp.co.sra.smalltalk.menu.MenuEvent;
import jp.co.sra.smalltalk.menu.MenuListener;
import jp.co.sra.smalltalk.menu.StMenu;
import jp.co.sra.smalltalk.menu.StMenuBar;
import jp.co.sra.smalltalk.menu.StPopupMenu;
import jp.co.sra.smalltalk.menu.StRadioButtonGroup;
import jp.co.sra.smalltalk.menu.StRadioButtonMenuItem;

public abstract class StApplicationModel
extends StModel {
    public static final int VIEW_AWT = 0;
    public static final int VIEW_SWING = 1;
    public static final int VIEW_SWING_ONLY = 2;
    protected static int DefaultViewMode = 1;
    public static final StMenu DefaultViewModeMenu = StApplicationModel.CreateDefaultViewModeMenu();
    protected StUIBuilder builder = null;

    public static JPanel _JPanelWithBorder() {
        return StApplicationWindowSwing._PanelWithBorder();
    }

    public static Panel _PanelWithBorder() {
        return StApplicationWindowAwt._PanelWithBorder();
    }

    public static void _ShowAtPoint(Window window, Point point) {
        Rectangle rectangle = StApplicationModel._GetScreenBoundsContainsPoint(point);
        if (rectangle != null) {
            Dimension dimension = window.getSize();
            int n = point.x - dimension.width / 2;
            if (n < rectangle.x) {
                n = rectangle.x;
            } else if (rectangle.x + rectangle.width < n + dimension.width) {
                n = rectangle.x + rectangle.width - dimension.width;
            }
            int n2 = point.y - dimension.height / 2;
            if (n2 < rectangle.y) {
                n2 = rectangle.y;
            } else if (rectangle.y + rectangle.height < n2 + dimension.height) {
                n2 = rectangle.y + rectangle.height - dimension.height;
            }
            window.setLocation(n, n2);
        }
        window.setVisible(true);
    }

    public static void _ShowAtCenterPoint(Window window) {
        Rectangle rectangle = StApplicationModel._GetScreenBoundsContainsPoint(SystemInterface._MousePoint());
        StApplicationModel._ShowAtPoint(window, new StRectangle(rectangle).center());
    }

    public static void _ShowAtMousePoint(Window window) {
        StApplicationModel._ShowAtPoint(window, SystemInterface._MousePoint());
    }

    public static Rectangle _GetScreenBoundsContainsPoint(Point point) {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] graphicsDeviceArray = graphicsEnvironment.getScreenDevices();
        for (int i = 0; i < graphicsDeviceArray.length; ++i) {
            Rectangle rectangle = graphicsDeviceArray[i].getDefaultConfiguration().getBounds();
            if (!rectangle.contains(point)) continue;
            return rectangle;
        }
        return null;
    }

    public static int GetDefaultViewMode() {
        return DefaultViewMode;
    }

    public static void SetDefaultViewMode(int n) {
        DefaultViewMode = n;
        StApplicationModel.UpdateDefaultViewModeMenu();
    }

    public static void SetDefaultViewModeAwt() {
        StApplicationModel.SetDefaultViewMode(0);
    }

    public static void SetDefaultViewModeSwing(UIManager.LookAndFeelInfo lookAndFeelInfo) {
        try {
            UIManager.setLookAndFeel(lookAndFeelInfo.getClassName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
            unsupportedLookAndFeelException.printStackTrace();
        }
        StApplicationModel.SetDefaultViewMode(1);
    }

    public static void SetDefaultViewModeSwingOnly() {
        StApplicationModel.SetDefaultViewMode(2);
    }

    public static void UpdateDefaultViewModeMenu() {
        StSymbol stSymbol = null;
        switch (StApplicationModel.GetDefaultViewMode()) {
            case 0: {
                stSymbol = StApplicationModel.$("viewAwt");
                break;
            }
            case 1: {
                stSymbol = StApplicationModel.$("viewSwing:" + UIManager.getLookAndFeel().getClass().getName());
                break;
            }
            case 2: {
                stSymbol = StApplicationModel.$("viewSwingOnly");
            }
        }
        if (stSymbol == null) {
            return;
        }
        StRadioButtonMenuItem stRadioButtonMenuItem = (StRadioButtonMenuItem)DefaultViewModeMenu.atNameKey_(stSymbol);
        if (stRadioButtonMenuItem != null && !stRadioButtonMenuItem.isSelected()) {
            stRadioButtonMenuItem.beOn();
        }
    }

    protected static StMenu CreateDefaultViewModeMenu() {
        StRadioButtonGroup stRadioButtonGroup = new StRadioButtonGroup();
        StMenu stMenu = new StMenu("Swing");
        UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
        for (int i = 0; i < lookAndFeelInfoArray.length; ++i) {
            final UIManager.LookAndFeelInfo lookAndFeelInfo = lookAndFeelInfoArray[i];
            String string = lookAndFeelInfo.getName();
            StSymbol stSymbol = StApplicationModel.$("viewSwing:" + lookAndFeelInfo.getClassName());
            stMenu.add(new StRadioButtonMenuItem((Object)string, stSymbol, stRadioButtonGroup, new MenuListener(){

                public void menuPerformed(MenuEvent menuEvent) {
                    StApplicationModel.SetDefaultViewModeSwing(lookAndFeelInfo);
                }
            }));
        }
        StMenu stMenu2 = new StMenu(new StUserMessage("Default View Mode"));
        stMenu2.add(new StRadioButtonMenuItem((Object)"AWT", StApplicationModel.$("viewAwt"), stRadioButtonGroup, new MenuListener(){

            public void menuPerformed(MenuEvent menuEvent) {
                StApplicationModel.SetDefaultViewModeAwt();
            }
        }));
        stMenu2.add(stMenu);
        return stMenu2;
    }

    public StApplicationModel() {
        this.initialize();
    }

    protected void initialize() {
    }

    public final StUIBuilder builder() {
        if (this.builder == null) {
            this.builder = new StUIBuilder(this);
        }
        return this.builder;
    }

    public abstract StView defaultView();

    protected boolean requestForWindowClose() {
        return true;
    }

    protected boolean windowResizable() {
        return true;
    }

    public Frame open() {
        return this.openView_(this.defaultView());
    }

    public Frame openView_(StView stView) {
        Frame frame = this.allButOpenView_(stView);
        StApplicationModel._ShowAtMousePoint(frame);
        return frame;
    }

    public void postOpenWith_(StView stView) {
    }

    protected Frame allButOpenView_(StView stView) {
        StApplicationWindow stApplicationWindow = this._createWindow(stView);
        this.builder().addWindow_(stApplicationWindow, stView);
        stView._setupKeyboard(stApplicationWindow.toWindow());
        return stApplicationWindow.toFrame();
    }

    protected StApplicationWindow _createWindow(StView stView) {
        Frame frame = StApplicationModel.GetDefaultViewMode() == 0 ? new StApplicationWindowAwt(this, stView) : new StApplicationWindowSwing(this, stView);
        return frame;
    }

    protected String windowTitle() {
        return this.toString();
    }

    protected boolean _viewOnBorderedPanel() {
        return false;
    }

    public void closeRequest() {
        Window window = this.builder().window();
        if (window != null) {
            window.dispatchEvent(new WindowEvent(window, 201));
        }
    }

    public void noticeOfWindowClose(WindowEvent windowEvent) {
        Window[] windowArray = this.builder().windows();
        for (int i = 0; i < windowArray.length; ++i) {
            this.builder().removeWindow_(windowArray[i]);
            windowArray[i].dispose();
        }
    }

    public void allWindowsClosed() {
        this.builder = null;
    }

    public void _windowExpandAndRaise() {
        Window[] windowArray = this.builder().windows();
        for (int i = 0; i < windowArray.length; ++i) {
            if (windowArray[i] instanceof Frame) {
                ((Frame)windowArray[i]).setState(0);
            }
            windowArray[i].setVisible(true);
        }
    }

    public void _show() {
        if (this.builder().windows().length > 0) {
            this._windowExpandAndRaise();
        } else {
            this.open();
        }
    }

    public void updateWindowTitle() {
        Window[] windowArray = this.builder().windows();
        for (int i = 0; i < windowArray.length; ++i) {
            StApplicationWindow stApplicationWindow;
            Window window = windowArray[i];
            if (!(window instanceof StApplicationWindow) || (stApplicationWindow = (StApplicationWindow)((Object)window)).application() != this) continue;
            stApplicationWindow.updateWindowTitle();
        }
    }

    public void updateMenuBar() {
        Window[] windowArray = this.builder().windows();
        for (int i = 0; i < windowArray.length; ++i) {
            Window window = windowArray[i];
            if (!(window instanceof StApplicationWindow)) continue;
            ((StApplicationWindow)((Object)window)).updateMenuBar();
        }
    }

    public StMenuBar _menuBar() {
        return null;
    }

    public StPopupMenu _popupMenu() {
        return null;
    }

    static {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            StApplicationModel.SetDefaultViewMode(1);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

