/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.qt4jun;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.WritableRaster;
import java.io.File;

public final class JunQTInterface {
    public static final String libraryName = "JunQT";
    public static final String requiredVersion = "2.0";
    public static final int requiredBuildNo = 14;
    private static JunQTInterface MovieInterface = null;
    public static final int anyCodec = 0;
    public static final int codecNormalQuality = 512;
    public static final int createMovieFileDeleteCurFile = Integer.MIN_VALUE;
    public static final int createMovieFileDontCreateResFile = 0x10000000;
    public static final int fixed1 = 65536;
    public static final int flattenAddMovieToDataFork = 1;
    public static final int kAnimationCodecType = 1919706400;
    public static final int kFullVolume = 256;
    public static final int kNoVolume = 0;
    public static final int kOffsetBinary = 1918990112;
    public static final int kQTMLNoIdleEvents = 2;
    public static final int kSyncSample = 0;
    public static final int kVideoTimeScale = 600;
    public static final int mcActionPrerollAndPlay = 55;
    public static final int mcNotVisible = 8;
    public static final int mcTopLeftMovie = 1;
    public static final int MovieFileType = 1299148630;
    public static final int movieInDataForkResID = -1;
    public static final int nextTimeStep = 16;
    public static final int noErr = 0;
    public static final int sigMoviePlayer = 1414942532;
    public static final int smSystemScript = -1;
    public static final int VideoMediaType = 1986618469;
    public static final int VisualMediaCharacteristic = 1702454643;
    public static final int _MAX_PATH = 260;

    public static JunQTInterface Interface() {
        if (MovieInterface == null) {
            JunQTInterface.InstallInterface();
        }
        return MovieInterface;
    }

    public static void InstallInterface() {
        JunQTInterface junQTInterface = new JunQTInterface();
        junQTInterface.enterMovies();
        MovieInterface = junQTInterface;
    }

    public static void UninstallInterface() {
        if (MovieInterface != null) {
            try {
                MovieInterface.exitMovies();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.err.println("Failed to uninstall " + MovieInterface.getClass().getName());
            }
        }
        MovieInterface = null;
    }

    protected JunQTInterface() {
    }

    public void enterMovies() {
        int n = this.qtInitializeQTML(0);
        if (n != 0) {
            throw new Error("InitializeQTML failed");
        }
        n = this.qtEnterMovies();
        if (n != 0) {
            throw new Error("EnterMovies failed");
        }
    }

    public void exitMovies() throws Exception {
        this.qtExitMovies();
        this.qtTerminateQTML();
    }

    public int createPortAssociation1(Component component) {
        try {
            Class<?> clazz = Class.forName("javax.swing.JComponent");
            while (clazz.isInstance(component) && component.getParent() != null) {
                component = component.getParent();
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return this.qtCreatePortAssociation1(component, 0, 2);
    }

    public int createPortAssociation2(int n) {
        return this.qtCreatePortAssociation2(n);
    }

    public void destroyPortAssociation(int n) {
        this.qtDestroyPortAssociation(n);
    }

    public void flattenMovie_filename_(int n, File file) {
        int n2 = this.qtFlattenMovieData(n, 1, file.getPath(), 1414942532, -1, -1879048192);
        if (n2 != 0) {
            this.qtDisposeMovie(n2);
        }
    }

    public boolean canGetMovieFile() {
        String string = System.getProperty("os.name");
        return string == null || !string.equals("Mac OS X");
    }

    public String getFilePreview() {
        int[] nArray = new int[]{1299148630};
        return this.qtStandardGetFilePreview(nArray);
    }

    public String getMovieFile() {
        return this.getFilePreview();
    }

    public int nextInterestingTimeOfMovie(int n, int n2, int n3) {
        int[] nArray = new int[]{1702454643};
        int[] nArray2 = this.qtGetMovieNextInterestingTime(n, 16, nArray, n2, n3);
        return nArray2[0];
    }

    public int openMovie() {
        String string = this.getMovieFile();
        if (string != null && string.length() > 0) {
            return this.openMovie(string);
        }
        return 0;
    }

    public int openMovie(File file) {
        return this.qtOpenMovie(file.getPath());
    }

    public int openMovie(String string) {
        return this.qtOpenMovie(string);
    }

    public Rectangle getMovieBox(int n) {
        int[] nArray = this.qtGetMovieBox(n);
        return new Rectangle(nArray[0], nArray[1], nArray[2], nArray[3]);
    }

    public void setMovieBox(int n, Rectangle rectangle) {
        this.qtSetMovieBox(n, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public Point getMovieOffsetAwt(Component component) {
        String string;
        String string2 = System.getProperty("os.name");
        if (string2 != null && string2.equals("Mac OS X") && (string = System.getProperty("java.version")) != null && string.equals("1.4.1_01")) {
            Point point = new Point(0, 0);
            while (component != null && !(component instanceof Window)) {
                Point point2 = component.getLocation();
                point.translate(point2.x, point2.y);
                component = component.getParent();
            }
            return point;
        }
        return new Point(0, 0);
    }

    public Point getMovieOffsetSwing(Component component) {
        String string;
        String string2 = System.getProperty("os.name");
        if (string2 != null && string2.equals("Mac OS X") && (string = System.getProperty("java.version")) != null && !string.equals("1.3.1")) {
            while (component != null) {
                if (component.getParent() instanceof Window) {
                    return component.getLocation();
                }
                component = component.getParent();
            }
        }
        return new Point(0, 0);
    }

    public boolean isMovieDone(int n) {
        return this.qtIsMovieDone(n);
    }

    public Image getMovieImageAt(int n, int n2, Dimension dimension) {
        int n3 = dimension.width;
        int n4 = dimension.height;
        int[] nArray = this.qtDrawMovieFrame(n, n2, n3, n4);
        if (nArray != null) {
            ColorModel colorModel = ColorModel.getRGBdefault();
            WritableRaster writableRaster = colorModel.createCompatibleWritableRaster(n3, n4);
            BufferedImage bufferedImage = new BufferedImage(colorModel, writableRaster, false, null);
            bufferedImage.setRGB(0, 0, n3, n4, nArray, 0, n3);
            return bufferedImage;
        }
        return null;
    }

    public byte[] convertMovieToSoundData(int n, int n2, int n3) {
        return this.qtConvertMovieToSoundData(n, n2, n3, 1918990112, 1, 8, 0);
    }

    public int[][] compactSoundData(byte[] byArray, int n) {
        int[][] nArray = new int[2][n];
        for (int i = 0; i < n; ++i) {
            int n2 = i * byArray.length / n;
            int n3 = (i + 1) * byArray.length / n;
            int n4 = 128;
            int n5 = 128;
            for (int j = n2; j < n3; ++j) {
                int n6 = byArray[j] & 0xFF;
                if (n6 > n4) {
                    n4 = n6;
                }
                if (n6 >= n5) continue;
                n5 = n6;
            }
            nArray[0][i] = n4;
            nArray[1][i] = n5;
        }
        return nArray;
    }

    public static native String GetVersion();

    public native int qtInitializeQTML(int var1);

    public native void qtTerminateQTML();

    public native int qtCreatePortAssociation1(Component var1, int var2, int var3);

    public native int qtCreatePortAssociation2(int var1);

    public native void qtDestroyPortAssociation(int var1);

    public native int qtEnterMovies();

    public native void qtExitMovies();

    public native void qtMoviesTask(int var1, int var2);

    public native void qtPrerollMovie(int var1, int var2, int var3);

    public native void qtSetMovieActive(int var1, boolean var2);

    public native boolean qtGetMovieActive(int var1);

    public native void qtStartMovie(int var1);

    public native void qtStopMovie(int var1);

    public native void qtGoToBeginningOfMovie(int var1);

    public native void qtGoToEndOfMovie(int var1);

    public native boolean qtIsMovieDone(int var1);

    public native void qtShowMoviePoster(int var1);

    public native int[] qtGetMovieGWorld(int var1);

    public native void qtSetMovieGWorld(int var1, int var2, int var3);

    public native int qtUpdateMovie(int var1);

    public native int[] qtGetMovieBox(int var1);

    public native void qtSetMovieBox(int var1, int var2, int var3, int var4, int var5);

    public native void qtDisposeMovie(int var1);

    public native int qtGetMovieTimeScale(int var1);

    public native int qtGetMovieDuration(int var1);

    public native int qtGetMovieRate(int var1);

    public native void qtSetMovieRate(int var1, int var2);

    public native int qtGetMoviePreferredRate(int var1);

    public native int qtGetMoviePreferredVolume(int var1);

    public native int qtGetMovieVolume(int var1);

    public native void qtSetMovieVolume(int var1, int var2);

    public native int qtGetMovieTimeValue(int var1);

    public native void qtSetMovieTimeValue(int var1, int var2);

    public native int qtOpenMovie(String var1);

    public native String qtStandardGetFilePreview(int[] var1);

    public native int[] qtDrawMovieFrame(int var1, int var2, int var3, int var4);

    public native int[] qtCreateMovieFile(String var1, int var2, int var3, int var4);

    public native int qtAddMovieResource(int var1, int var2, int var3, String var4);

    public native int qtCloseMovieFile(int var1);

    public native int qtNewMovieTrack(int var1, int var2, int var3, int var4);

    public native int qtInsertMediaIntoTrack(int var1, int var2, int var3, int var4, int var5);

    public native int qtNewTrackMedia(int var1, int var2, int var3, int var4, int var5);

    public native int qtBeginMediaEdits(int var1);

    public native int qtEndMediaEdits(int var1);

    public native int qtGetMediaDuration(int var1);

    public native int qtAddMediaSampleImage(int var1, int[] var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9);

    public native int qtGetMoviesError();

    public native int qtFixRatio(int var1, int var2);

    public native int[] qtGetMovieSelection(int var1);

    public native void qtSetMovieSelection(int var1, int var2, int var3);

    public native int qtCopyMovieSelection(int var1);

    public native int qtNewMovie(int var1);

    public native int qtInsertMovieSegment(int var1, int var2, int var3, int var4, int var5);

    public native int qtFlattenMovieData(int var1, int var2, String var3, int var4, int var5, int var6);

    public native byte[] qtConvertMovieToSoundData(int var1, int var2, int var3, int var4, int var5, int var6, int var7);

    public native int qtNewMovieFromURL(String var1);

    public native int[] qtGetMovieNextInterestingTime(int var1, int var2, int[] var3, int var4, int var5);

    public native int qtNewMovieController(int var1, int var2, int var3, int var4, int var5, int var6);

    public native void qtDisposeMovieController(int var1);

    public native int qtMCDoAction(int var1, int var2, int var3);

    public native int qtMCIdle(int var1);

    public native int qtMCMovieChanged(int var1, int var2);

    static {
        try {
            int n;
            System.loadLibrary(libraryName);
            String string = JunQTInterface.GetVersion();
            String string2 = "2.0 build ";
            try {
                n = Integer.parseInt(string.substring(string2.length()));
            }
            catch (NumberFormatException numberFormatException) {
                n = 0;
            }
            if (!string.startsWith(string2) || n < 14) {
                System.err.println("JNI library 'JunQT' version error.");
                System.err.println("Found library is version " + string);
                System.err.println("Required library is version 2.0, build 14 or later");
                throw new Error("JNI library 'JunQT' version error");
            }
            System.out.println("JNI library 'JunQT' version " + string);
            JunQTInterface.InstallInterface();
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            System.err.println("Can't find JNI library 'JunQT'.");
            throw unsatisfiedLinkError;
        }
    }
}

