/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.vrml.support;

import java.awt.Color;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.curves.JunNurbsCurve;
import jp.co.sra.jun.geometry.surfaces.JunNurbsSurface;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dCompoundObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dNurbsCurve;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dNurbsSurface;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dPolygon;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dPolyline;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dPolylineLoop;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dVertex;
import jp.co.sra.jun.opengl.projection.JunOpenGLProjection;
import jp.co.sra.smalltalk.StObject;
import jp.co.sra.smalltalk.StSymbol;

public class JunVrmlRenderingContext
extends StObject {
    public static StSymbol VERSION10 = JunVrmlRenderingContext.$((String)"vrml10");
    public static StSymbol VERSION20 = JunVrmlRenderingContext.$((String)"vrml20");
    protected StSymbol vrmlVersion;
    protected JunOpenGL3dCompoundObject vrmlObject = new JunOpenGL3dCompoundObject();
    protected StSymbol presentation;
    protected JunOpenGLProjection projection;

    public JunVrmlRenderingContext() {
        this.setVrml20();
        this.solidPresentation();
    }

    public final float alpha() {
        return this.vrmlObject.alpha();
    }

    public final void alpha_(float f) {
        this.vrmlObject.alpha_(f);
    }

    public void displayLine_(Jun3dPoint[] jun3dPointArray) {
        if (jun3dPointArray.length <= 2) {
            this.vrmlObject.add_(new JunOpenGL3dPolyline(jun3dPointArray));
        } else {
            Jun3dPoint[] jun3dPointArray2 = new Jun3dPoint[]{jun3dPointArray[0], jun3dPointArray[jun3dPointArray.length]};
            this.vrmlObject.add_(new JunOpenGL3dPolyline(jun3dPointArray2));
        }
    }

    public void displayLineLoop_(Jun3dPoint[] jun3dPointArray) {
        this.vrmlObject.add_(new JunOpenGL3dPolylineLoop(jun3dPointArray));
    }

    public void displayLines_(Jun3dPoint[] jun3dPointArray) {
        this.vrmlObject.add_(new JunOpenGL3dPolyline(jun3dPointArray));
    }

    public void displayNurbsCurve_(JunNurbsCurve junNurbsCurve) {
        this.vrmlObject.add_(new JunOpenGL3dNurbsCurve(junNurbsCurve.controlPoints(), junNurbsCurve.weights(), junNurbsCurve.knotVector()));
    }

    public void displayNurbsSurface_(JunNurbsSurface junNurbsSurface) {
        this.vrmlObject.add_(new JunOpenGL3dNurbsSurface(junNurbsSurface.controlPoints(), junNurbsSurface.weights(), junNurbsSurface.uKnotVector(), junNurbsSurface.vKnotVector()));
    }

    public void displayObject_(JunOpenGL3dObject junOpenGL3dObject) {
        this.vrmlObject.add_(junOpenGL3dObject);
    }

    public void displayPoint_(Jun3dPoint jun3dPoint) {
        this.vrmlObject.add_(JunOpenGL3dVertex.Point_(jun3dPoint));
    }

    public void displayPolygon_(Jun3dPoint[] jun3dPointArray) {
        this.vrmlObject.add_(new JunOpenGL3dPolygon(jun3dPointArray));
    }

    public final Color paint() {
        return this.vrmlObject.paint();
    }

    public final void paint_(Color color) {
        this.vrmlObject.paint_(color);
    }

    public StSymbol presentation() {
        if (this.presentation == null) {
            this.presentation = JunVrmlRenderingContext.$((String)"solid");
        }
        return this.presentation;
    }

    public void presentation_(StSymbol stSymbol) {
        if (stSymbol == JunVrmlRenderingContext.$((String)"solid") || stSymbol == JunVrmlRenderingContext.$((String)"wireframe")) {
            this.presentation = stSymbol;
        }
    }

    public JunOpenGLProjection projection() {
        return this.projection;
    }

    public void projection_(JunOpenGLProjection junOpenGLProjection) {
        this.projection = junOpenGLProjection;
    }

    public void setVrml10() {
        this.vrmlVersion = VERSION10;
    }

    public void setVrml20() {
        this.vrmlVersion = VERSION20;
    }

    public void solidPresentation() {
        this.presentation_(JunVrmlRenderingContext.$((String)"solid"));
    }

    public String vrml10String() {
        return this.vrmlObject.vrml10String();
    }

    public String vrml20String() {
        return this.vrmlObject.vrml20String();
    }

    public String vrmlString() {
        if (this.vrmlVersion == VERSION10) {
            return this.vrml10String();
        }
        if (this.vrmlVersion == VERSION20) {
            return this.vrml20String();
        }
        return null;
    }

    public final StSymbol vrmlVersion() {
        return this.vrmlVersion;
    }

    public void wireframePresentation() {
        this.presentation_(JunVrmlRenderingContext.$((String)"wireframe"));
    }
}

