/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.voronoi.twoD.diagram;

import java.awt.Point;
import java.io.IOException;
import java.io.Writer;
import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.voronoi.twoD.diagram.JunVoronoi2dDot;
import jp.co.sra.jun.voronoi.twoD.diagram.JunVoronoi2dSide;

public class JunVoronoi2dPoint
extends JunVoronoi2dDot {
    protected JunVoronoi2dSide side1;
    protected JunVoronoi2dSide side2;
    protected JunVoronoi2dSide side3;

    public JunVoronoi2dPoint(double d, double d2) {
        super(d, d2);
    }

    public JunVoronoi2dPoint(Jun2dPoint jun2dPoint) {
        this(jun2dPoint.x(), jun2dPoint.y());
    }

    public JunVoronoi2dPoint(Point point) {
        this(point.x, point.y);
    }

    protected void initialize() {
        super.initialize();
        this.side1 = null;
        this.side2 = null;
        this.side3 = null;
    }

    public JunVoronoi2dSide side1() {
        return this.side1;
    }

    public void side1_(JunVoronoi2dSide junVoronoi2dSide) {
        this.side1 = junVoronoi2dSide;
    }

    public JunVoronoi2dSide side2() {
        return this.side2;
    }

    public void side2_(JunVoronoi2dSide junVoronoi2dSide) {
        this.side2 = junVoronoi2dSide;
    }

    public JunVoronoi2dSide side3() {
        return this.side3;
    }

    public void side3_(JunVoronoi2dSide junVoronoi2dSide) {
        this.side3 = junVoronoi2dSide;
    }

    public boolean isValid() {
        if (Double.isNaN(this.x)) {
            return false;
        }
        if (Double.isNaN(this.y)) {
            return false;
        }
        if (this.side1 == null || !this.side1.isValid2()) {
            return false;
        }
        if (this.side2 == null || !this.side2.isValid2()) {
            return false;
        }
        return this.side3 != null && this.side3.isValid2();
    }

    public boolean isInvalid() {
        return !this.isValid();
    }

    public void printOn_(Writer writer) throws IOException {
        writer.write("point ( ");
        writer.write(String.valueOf(this.x));
        writer.write(" , ");
        writer.write(String.valueOf(this.y));
        writer.write(" )");
    }
}

