/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.voronoi.twoD.diagram;

import java.awt.Point;
import java.io.IOException;
import java.io.Writer;
import jp.co.sra.jun.voronoi.twoD.diagram.JunVoronoi2dDot;
import jp.co.sra.jun.voronoi.twoD.diagram.JunVoronoi2dObject;
import jp.co.sra.jun.voronoi.twoD.diagram.JunVoronoi2dPoint;
import jp.co.sra.smalltalk.SmalltalkException;

public class JunVoronoi2dLine
extends JunVoronoi2dObject {
    protected double a;
    protected double b;
    protected double c;

    public JunVoronoi2dLine(double d, double d2, double d3) {
        this.a_(d);
        this.b_(d2);
        this.c_(d3);
    }

    public JunVoronoi2dLine(JunVoronoi2dDot junVoronoi2dDot, JunVoronoi2dDot junVoronoi2dDot2) {
        double d = junVoronoi2dDot.x();
        double d2 = junVoronoi2dDot.y();
        double d3 = junVoronoi2dDot2.x();
        double d4 = junVoronoi2dDot2.y();
        double d5 = d2 - d4;
        double d6 = d3 - d;
        double d7 = d * d4 - d3 * d2;
        if (Math.abs(d5) < this.accuracy() && Math.abs(d6) < this.accuracy()) {
            throw SmalltalkException.Error((String)"two points are the same.");
        }
        this.a_(d5);
        this.b_(d6);
        this.c_(d7);
    }

    public JunVoronoi2dLine(Point point, Point point2) {
        this(new JunVoronoi2dDot(point), new JunVoronoi2dDot(point2));
    }

    protected void initialize() {
        super.initialize();
        this.a = Double.NaN;
        this.b = Double.NaN;
        this.c = Double.NaN;
    }

    public double a() {
        return this.a;
    }

    public void a_(double d) {
        this.a = d;
    }

    public double b() {
        return this.b;
    }

    public void b_(double d) {
        this.b = d;
    }

    public double c() {
        return this.c;
    }

    public void c_(double d) {
        this.c = d;
    }

    public JunVoronoi2dPoint pointAtX_(double d) {
        double d2 = (-this.c - this.a * d) / this.b;
        return new JunVoronoi2dPoint(d, d2);
    }

    public JunVoronoi2dPoint pointAtY_(double d) {
        double d2 = (-this.c - this.b * d) / this.a;
        return new JunVoronoi2dPoint(d2, d);
    }

    public JunVoronoi2dPoint intersectingPointWithLine_(JunVoronoi2dLine junVoronoi2dLine) {
        double d = this.a();
        double d2 = this.b();
        double d3 = this.c();
        double d4 = junVoronoi2dLine.a();
        double d5 = junVoronoi2dLine.b();
        double d6 = junVoronoi2dLine.c();
        double d7 = d * d5 - d4 * d2;
        if (Math.abs(d7) < this.accuracy()) {
            throw SmalltalkException.Error((String)"two lines are parallel.");
        }
        double d8 = 1.0 / d7;
        double d9 = (d2 * d6 - d5 * d3) * d8;
        double d10 = (d4 * d3 - d * d6) * d8;
        return new JunVoronoi2dPoint(d9, d10);
    }

    public boolean isHorizontal() {
        return Math.abs(this.a) < this.accuracy();
    }

    public boolean isVertical() {
        return Math.abs(this.b) < this.accuracy();
    }

    public void printOn_(Writer writer) throws IOException {
        writer.write("line ( ");
        writer.write(String.valueOf(this.a));
        writer.write(" , ");
        writer.write(String.valueOf(this.b));
        writer.write(" , ");
        writer.write(String.valueOf(this.c));
        writer.write(" )");
    }
}

