/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.topology.grapher;

import java.awt.BasicStroke;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.system.framework.JunAbstractViewJPanel;
import jp.co.sra.jun.topology.graph.JunElementalNode;
import jp.co.sra.jun.topology.grapher.JunGrapher;
import jp.co.sra.jun.topology.grapher.JunGrapherController;
import jp.co.sra.jun.topology.grapher.JunGrapherView;
import jp.co.sra.smalltalk.StController;
import jp.co.sra.smalltalk.StRectangle;

public class JunGrapherViewSwing
extends JunAbstractViewJPanel
implements JunGrapherView {
    protected Point scrollAmount;
    protected Jun2dPoint _scaleFactor;

    public JunGrapherViewSwing(JunGrapher junGrapher) {
        super(junGrapher);
    }

    protected void initialize() {
        super.initialize();
        this.scrollAmount = new Point(0, 0);
        this._flushScaleFactor();
    }

    protected void buildComponent() {
        this.setPreferredSize(DefaultBounds.getSize());
        this.setBackground(DefaultBackgroundColor);
    }

    public JunGrapher getGrapher() {
        return (JunGrapher)this.model();
    }

    protected StController defaultController() {
        return new JunGrapherController();
    }

    public Jun2dPoint _scaleFactor() {
        if (this._scaleFactor == null) {
            Rectangle rectangle = this.getBounds();
            StRectangle stRectangle = this.getGrapher().boundingBox();
            double d = (double)rectangle.width / (double)stRectangle.width();
            double d2 = (double)rectangle.height / (double)stRectangle.height();
            this._scaleFactor = new Jun2dPoint(d, d2);
        }
        return this._scaleFactor;
    }

    public void _flushScaleFactor() {
        this._scaleFactor = null;
    }

    public void displayOn_(Graphics graphics) {
        this.displayOn_at_(graphics, new Point(0, 0));
    }

    public void displayOn_at_(Graphics graphics, Point point) {
        if (this._scaleFactor == null) {
            this.getGrapher().displayOn_at_(graphics, this.convertModelPointToViewPoint_(point));
        } else {
            Graphics2D graphics2D = (Graphics2D)graphics;
            StRectangle stRectangle = this.getGrapher().boundingBox();
            int n = stRectangle.originX();
            int n2 = stRectangle.originY();
            this.getGrapher().displayOn_at_scaledBy_(graphics2D, new Point(-n, -n2), this._scaleFactor);
            Point point2 = this.scrollAmount();
            int n3 = 0 - n - point2.x;
            int n4 = 0 - n2 - point2.y;
            StRectangle stRectangle2 = new StRectangle(this.getBounds());
            stRectangle2 = stRectangle2.translatedBy_(n3, n4).scaledBy_(this._scaleFactor.x(), this._scaleFactor.y());
            graphics2D.setColor(this.getGrapher().selectionBorderColor());
            graphics2D.setStroke(new BasicStroke(this.getGrapher().selectionBorderWidth()));
            graphics2D.drawRect(stRectangle2.x(), stRectangle2.y(), stRectangle2.width(), stRectangle2.height());
        }
    }

    public void redisplay() {
        if (this.isVisible()) {
            this.paintImmediately(0, 0, this.getWidth(), this.getHeight());
        }
    }

    public Point scrollAmount() {
        return this.scrollAmount;
    }

    public void scrollAmount_(Point point) {
        this.scrollAmount = point;
    }

    public void scrollTo_(Point point) {
        this.scrollAmount_(point);
        this.redisplay();
    }

    public void scrollBy_(Point point) {
        this.scrollAmount.translate(point.x, point.y);
        this.redisplay();
    }

    public void scrollFor_(JunElementalNode junElementalNode) {
        Point point = new StRectangle(this.getBounds()).center();
        Point point2 = junElementalNode.center();
        this.scrollAmount_(new Point(point.x - point2.x, point.y - point2.y));
        this.redisplay();
    }

    public Point convertModelPointToViewPoint_(Point point) {
        int n = point.x + this.scrollAmount().x;
        int n2 = point.y + this.scrollAmount().y;
        return new Point(n, n2);
    }

    public Point convertViewPointToModelPoint_(Point point) {
        int n = point.x - this.scrollAmount().x;
        int n2 = point.y - this.scrollAmount().y;
        return new Point(n, n2);
    }

    public void _showPopupMenu(int n, int n2) {
        Point point = this.convertViewPointToModelPoint_(new Point(n, n2));
        this.popupMenu_(this.getGrapher()._popupMenuAt(point));
        super._showPopupMenu(n, n2);
    }
}

