/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.topology.grapher;

import java.awt.Point;
import jp.co.sra.jun.goodies.utilities.JunStringUtility;
import jp.co.sra.jun.system.support.JunTestExamples;
import jp.co.sra.jun.topology.graph.JunElementalGraph;
import jp.co.sra.jun.topology.graph.JunElementalNode;
import jp.co.sra.jun.topology.grapher.JunGrapher;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StRectangle;

public class JunGrapherTestExamples
extends JunTestExamples {
    public static boolean Example00_Simple() {
        JunGrapher junGrapher = JunGrapherTestExamples.ExampleSimple();
        junGrapher.open();
        return true;
    }

    public static boolean Example01_Tree() {
        JunGrapher junGrapher = JunGrapherTestExamples.ExampleTree();
        junGrapher.open();
        return true;
    }

    public static boolean Example02_Forest() {
        JunGrapher junGrapher = JunGrapherTestExamples.ExampleForest();
        junGrapher.open();
        return true;
    }

    public static boolean Example04_Tokyo() {
        JunGrapher junGrapher = JunGrapherTestExamples.ExampleTokyo();
        junGrapher.open();
        return true;
    }

    public static boolean Example05_Tokyo() {
        JunGrapher junGrapher = JunGrapherTestExamples.ExampleTokyo();
        JunElementalGraph junElementalGraph = junGrapher.graph();
        junElementalGraph.arrangeFormat_(JunGrapherTestExamples.$((String)"concentric"));
        junElementalGraph.arrangeAttributeSymbol_(JunGrapherTestExamples.$((String)"cost"));
        junElementalGraph.arrangeConcentricRadius_(350);
        junElementalGraph.arrangeConcentricSpiral_(2.0f);
        junElementalGraph.arrange();
        junGrapher.open();
        return true;
    }

    public static boolean Example06_Tokyo() {
        JunGrapher junGrapher = JunGrapherTestExamples.ExampleTokyo();
        JunElementalGraph junElementalGraph = junGrapher.graph();
        junElementalGraph.arrangeFormat_(JunGrapherTestExamples.$((String)"concentric"));
        junElementalGraph.arrangeAttributeSymbol_(JunGrapherTestExamples.$((String)"distance"));
        junElementalGraph.arrangeConcentricRadius_(400);
        junElementalGraph.arrangeConcentricSpiral_(3.0f);
        junElementalGraph.arrangeConcentricGradation_(Boolean.FALSE);
        junElementalGraph.arrange();
        junGrapher.open();
        return true;
    }

    public static boolean Example07_Tokyo() {
        JunGrapher junGrapher = JunGrapherTestExamples.ExampleTokyo();
        JunElementalGraph junElementalGraph = junGrapher.graph();
        junElementalGraph.arrangeFormat_(JunGrapherTestExamples.$((String)"concentric"));
        junElementalGraph.arrangeAttributeSymbol_(JunGrapherTestExamples.$((String)"neededTime"));
        junElementalGraph.arrangeConcentricRadius_(350);
        junElementalGraph.arrangeConcentricSpiral_(12.0f);
        junElementalGraph.arrange();
        junGrapher.open();
        return true;
    }

    protected static JunGrapher ExampleSimple() {
        JunElementalGraph junElementalGraph = JunElementalGraph.ExampleSimple();
        junElementalGraph.arrangeFormat_(JunGrapherTestExamples.$((String)"tree"));
        junElementalGraph.arrange();
        return JunGrapher.DefaultNewGrapher(junElementalGraph);
    }

    protected static JunGrapher ExampleTree() {
        JunElementalGraph junElementalGraph = JunElementalGraph.ExampleTree();
        junElementalGraph.arrangeFormat_(JunGrapherTestExamples.$((String)"tree"));
        junElementalGraph.arrange();
        return JunGrapher.DefaultNewGrapher(junElementalGraph);
    }

    protected static JunGrapher ExampleForest() {
        JunElementalGraph junElementalGraph = JunElementalGraph.ExampleForest();
        junElementalGraph.arrangeFormat_(JunGrapherTestExamples.$((String)"forest"));
        junElementalGraph.arrange();
        return JunGrapher.DefaultNewGrapher(junElementalGraph);
    }

    protected static JunGrapher ExampleTokyo() {
        JunElementalGraph junElementalGraph = JunElementalGraph.ExampleTokyo();
        StBlockClosure stBlockClosure = new StBlockClosure(){

            public Object value_(Object object) {
                String[] stringArray = JunStringUtility.Separate_dividers_((String)object, new char[]{'/'});
                double d = Double.parseDouble(stringArray[1]);
                d += Double.parseDouble(stringArray[2]) / 60.0;
                d += Double.parseDouble(stringArray[3]) / 3600.0;
                if ("W".equals(stringArray[0]) || "S".equals(stringArray[0])) {
                    d *= -1.0;
                }
                return new Double(d);
            }
        };
        double d = ((Number)stBlockClosure.value_((Object)"E/139/44/40.9")).doubleValue();
        double d2 = ((Number)stBlockClosure.value_((Object)"N/35/39/16.0")).doubleValue();
        JunElementalNode[] junElementalNodeArray = junElementalGraph.nodes();
        for (int i = 0; i < junElementalNodeArray.length; ++i) {
            double d3 = ((Number)stBlockClosure.value_(junElementalNodeArray[i].attributeAt_(JunGrapherTestExamples.$((String)"longitude")))).doubleValue();
            double d4 = ((Number)stBlockClosure.value_(junElementalNodeArray[i].attributeAt_(JunGrapherTestExamples.$((String)"latitude")))).doubleValue();
            double d5 = 7000.0;
            int n = (int)Math.round((d3 - d) * d5);
            int n2 = (int)Math.round((d4 - d2) * d5);
            junElementalNodeArray[i].center_(new Point(n, -n2));
        }
        junElementalGraph.flushBoundingBox();
        StRectangle stRectangle = junElementalGraph.boundingBox();
        for (int i = 0; i < junElementalNodeArray.length; ++i) {
            Point point = junElementalNodeArray[i].origin();
            junElementalNodeArray[i].origin_(new Point(point.x - stRectangle.originX(), point.y - stRectangle.originY()));
        }
        junElementalGraph.flushBoundingBox();
        return JunGrapher.DefaultNewGrapher(junElementalGraph);
    }

    public static void main(String[] stringArray) {
        new JunGrapherTestExamples();
    }
}

