/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.topology.grapher;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.SwingUtilities;
import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.goodies.cursors.JunCursors;
import jp.co.sra.jun.system.framework.JunAbstractController;
import jp.co.sra.jun.topology.graph.JunElementalNode;
import jp.co.sra.jun.topology.grapher.JunGrapher;
import jp.co.sra.jun.topology.grapher.JunGrapherView;
import jp.co.sra.smalltalk.StObject;
import jp.co.sra.smalltalk.StRectangle;
import jp.co.sra.smalltalk.StSymbol;
import jp.co.sra.smalltalk.StView;

public class JunGrapherController
extends JunAbstractController {
    protected boolean freehandState;
    protected Thread _waitThread;
    protected StSymbol _activity;
    protected Point _previousPoint;
    protected JunElementalNode[] _movingNodes;
    protected ArrayList _freehandPoints;
    protected boolean _altDown;

    public void initialize() {
        super.initialize();
        this.freehandState = false;
        this._waitThread = null;
        this._activity = null;
        this._previousPoint = null;
        this._movingNodes = null;
        this._freehandPoints = null;
        this._altDown = false;
    }

    public void release() {
        this.breakDependents();
        this.view().toComponent().removeKeyListener((KeyListener)((Object)this));
        this.view().toComponent().removeMouseListener((MouseListener)((Object)this));
        this.view().toComponent().removeMouseMotionListener((MouseMotionListener)((Object)this));
    }

    protected void buildListener(StView stView) {
        this.view().toComponent().addKeyListener((KeyListener)((Object)this));
        this.view().toComponent().addMouseListener((MouseListener)((Object)this));
        this.view().toComponent().addMouseMotionListener((MouseMotionListener)((Object)this));
    }

    public boolean freehandState() {
        return this.freehandState;
    }

    public void freehandState_(boolean bl) {
        this.freehandState = bl;
    }

    public JunGrapher getGrapher() {
        return this.getGrapherView().getGrapher();
    }

    public JunGrapherView getGrapherView() {
        return (JunGrapherView)this.view();
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (this._activity == JunGrapherController.$((String)"grab") && !this._altDown && keyEvent.isAltDown()) {
            this._setBirdViewVisible(true);
        }
        this._altDown = keyEvent.isAltDown();
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (this._activity == JunGrapherController.$((String)"grab") && this._altDown && !keyEvent.isAltDown()) {
            this._setBirdViewVisible(false);
        }
        this._altDown = keyEvent.isAltDown();
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this._activity(null);
        this.view().toComponent().requestFocus();
        if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
            this._previousPoint = mouseEvent.getPoint();
            this._waitThread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    JunGrapherController junGrapherController = JunGrapherController.this;
                    synchronized (junGrapherController) {
                        try {
                            ((Object)((Object)JunGrapherController.this)).wait(250L);
                        }
                        catch (InterruptedException interruptedException) {
                            interruptedException.printStackTrace();
                        }
                        if (JunGrapherController.this._waitThread != null && JunGrapherController.this._activity == null) {
                            Point point = JunGrapherController.this.getGrapherView().convertViewPointToModelPoint_(JunGrapherController.this._previousPoint);
                            JunElementalNode junElementalNode = JunGrapherController.this.getGrapher().whichAt_(point);
                            if (junElementalNode == null) {
                                JunGrapherController.this._activity(StObject.$((String)"grab"));
                                if (JunGrapherController.this._altDown) {
                                    JunGrapherController.this._setBirdViewVisible(true);
                                }
                            } else {
                                JunGrapherController.this._activity(StObject.$((String)"moveNodes"));
                                Collection collection = JunGrapherController.this.getGrapher().selections();
                                JunGrapherController.this._movingNodes = collection.contains((Object)junElementalNode) ? collection.toArray(new JunElementalNode[collection.size()]) : new JunElementalNode[]{junElementalNode};
                            }
                            JunGrapherController.this._waitThread = null;
                        }
                    }
                }
            };
            this._waitThread.start();
        } else if (SwingUtilities.isRightMouseButton(mouseEvent) && mouseEvent.isAltDown()) {
            this._activity(JunGrapherController.$((String)"freehand"));
            this._freehandDragged(mouseEvent);
        } else {
            super.mousePressed(mouseEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mouseReleased(MouseEvent mouseEvent) {
        if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
            Object object = this;
            synchronized (object) {
                if (this._waitThread != null && this._waitThread.isAlive()) {
                    this._waitThread = null;
                    ((Object)((Object)this)).notify();
                    switch (mouseEvent.getClickCount()) {
                        case 1: {
                            this._activity(JunGrapherController.$((String)"singleClick"));
                            break;
                        }
                        case 2: {
                            this._activity(JunGrapherController.$((String)"doubleClick"));
                        }
                    }
                }
            }
            if (this._activity == JunGrapherController.$((String)"singleClick")) {
                object = this.getGrapherView().convertViewPointToModelPoint_(mouseEvent.getPoint());
                JunElementalNode junElementalNode = this.getGrapher().whichAt_((Point)object);
                if (junElementalNode == null) {
                    this.getGrapher().selections_(null);
                } else if (mouseEvent.isShiftDown()) {
                    ArrayList<JunElementalNode> arrayList = new ArrayList<JunElementalNode>(this.getGrapher().selections());
                    if (arrayList.contains((Object)junElementalNode)) {
                        arrayList.remove((Object)junElementalNode);
                    } else {
                        arrayList.add(junElementalNode);
                    }
                    this.getGrapher().selections_(arrayList);
                } else {
                    this.getGrapher().selection_(junElementalNode);
                }
            } else if (this._activity == JunGrapherController.$((String)"doubleClick")) {
                object = this.getGrapherView().convertViewPointToModelPoint_(mouseEvent.getPoint());
                JunElementalNode junElementalNode = this.getGrapher().whichAt_((Point)object);
                if (junElementalNode != null) {
                    this.getGrapher().selectAndArrangeAndScrollFor_(junElementalNode);
                }
            } else if (this._activity == JunGrapherController.$((String)"grab")) {
                this._grabReleased(mouseEvent);
            } else if (this._activity == JunGrapherController.$((String)"moveNodes")) {
                this.getGrapher().flushBoundingBox();
            }
        } else if (this._activity == JunGrapherController.$((String)"freehand")) {
            this._freehandReleased(mouseEvent);
        } else {
            super.mouseReleased(mouseEvent);
        }
        this._activity(null);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this._activity == null) {
            this._activity(JunGrapherController.$((String)"none"));
        }
        if (this._activity == JunGrapherController.$((String)"grab")) {
            this._grabDragged(mouseEvent);
        } else if (this._activity == JunGrapherController.$((String)"moveNodes")) {
            this._moveNodesDragged(mouseEvent);
        } else if (this._activity == JunGrapherController.$((String)"freehand")) {
            this._freehandDragged(mouseEvent);
        }
    }

    protected void _grabReleased(MouseEvent mouseEvent) {
        if (this._altDown) {
            this._setBirdViewVisible(false);
        }
    }

    protected void _grabDragged(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        if (point.equals(this._previousPoint)) {
            return;
        }
        int n = point.x - this._previousPoint.x;
        int n2 = point.y - this._previousPoint.y;
        if (mouseEvent.isAltDown()) {
            this._birdViewDragged(mouseEvent);
        } else {
            this.getGrapherView()._flushScaleFactor();
            this.getGrapherView().scrollBy_(new Point(n, n2));
        }
        this._previousPoint = point;
    }

    protected void _moveNodesDragged(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        if (point.equals(this._previousPoint)) {
            return;
        }
        int n = point.x - this._previousPoint.x;
        int n2 = point.y - this._previousPoint.y;
        for (int i = 0; i < this._movingNodes.length; ++i) {
            Point point2 = this._movingNodes[i].locationPoint();
            this._movingNodes[i].locationPoint_(new Point(point2.x + n, point2.y + n2));
            if (this.getGrapher().nodeSettings().stuff() != this._movingNodes[i]) continue;
            this.getGrapher().nodeSettingsFor_(this._movingNodes[i]);
        }
        this.getGrapher().changed_(JunGrapherController.$((String)"graph"));
        this._previousPoint = point;
    }

    protected void _freehandReleased(MouseEvent mouseEvent) {
        if (this._freehandPoints == null || this._freehandPoints.size() < 2 || !mouseEvent.isAltDown()) {
            this.getGrapherView().redisplay();
            return;
        }
        Point[] pointArray = new Point[this._freehandPoints.size()];
        for (int i = 0; i < pointArray.length; ++i) {
            pointArray[i] = this.getGrapherView().convertViewPointToModelPoint_((Point)this._freehandPoints.get(i));
        }
        JunElementalNode junElementalNode = this.getGrapher().whichAt_(pointArray[0]);
        JunElementalNode junElementalNode2 = this.getGrapher().whichAt_(pointArray[pointArray.length - 1]);
        if (junElementalNode != null && junElementalNode2 != null) {
            this.getGrapher().freehandConnect_with_(junElementalNode, junElementalNode2);
        } else {
            this.getGrapher().freehandPoints_(pointArray, mouseEvent);
        }
        this._freehandPoints = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _freehandDragged(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        if (point.equals(this._previousPoint)) {
            return;
        }
        if (this._freehandPoints == null) {
            this._freehandPoints = new ArrayList();
        }
        this._freehandPoints.add(point);
        if (this._freehandPoints.size() > 1) {
            Graphics2D graphics2D = null;
            try {
                graphics2D = (Graphics2D)this.getGrapherView().toComponent().getGraphics();
                graphics2D.setColor(Color.red);
                graphics2D.setStroke(new BasicStroke(1.0f));
                for (int i = 1; i < this._freehandPoints.size(); ++i) {
                    Point point2 = (Point)this._freehandPoints.get(i - 1);
                    Point point3 = (Point)this._freehandPoints.get(i);
                    graphics2D.drawLine(point2.x, point2.y, point3.x, point3.y);
                }
            }
            finally {
                if (graphics2D != null) {
                    graphics2D.dispose();
                }
            }
        }
        this._previousPoint = point;
    }

    protected synchronized void _birdViewDragged(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        if (point.equals(this._previousPoint)) {
            return;
        }
        Jun2dPoint jun2dPoint = this.getGrapherView()._scaleFactor();
        Point point2 = this.getGrapherView().scrollAmount();
        int n = point2.x - (int)Math.round((double)(point.x - this._previousPoint.x) / jun2dPoint.x());
        int n2 = point2.y - (int)Math.round((double)(point.y - this._previousPoint.y) / jun2dPoint.y());
        this.getGrapherView().scrollAmount_(new Point(n, n2));
        this.getGrapherView().redisplay();
        this._previousPoint = point;
    }

    protected synchronized void _setBirdViewVisible(boolean bl) {
        Point point = this.getGrapherView().scrollAmount();
        StRectangle stRectangle = this.getGrapher().boundingBox();
        Jun2dPoint jun2dPoint = this.getGrapherView()._scaleFactor();
        if (bl) {
            Point point2 = this.cursorPoint();
            int n = (int)Math.round((double)(point2.x - point.x - stRectangle.originX()) * jun2dPoint.x());
            int n2 = (int)Math.round((double)(point2.y - point.y - stRectangle.originY()) * jun2dPoint.y());
            point2 = new Point(n, n2);
            this.cursorPoint_(point2);
            this._previousPoint = point2;
        } else {
            Point point3 = this.cursorPoint();
            int n = (int)Math.round((double)point3.x / jun2dPoint.x()) + point.x + stRectangle.originX();
            int n3 = (int)Math.round((double)point3.y / jun2dPoint.y()) + point.y + stRectangle.originY();
            point3 = new Point(n, n3);
            this.cursorPoint_(point3);
            this._previousPoint = point3;
            this.getGrapherView()._flushScaleFactor();
        }
        this.getGrapherView().redisplay();
    }

    protected void _activity(StSymbol stSymbol) {
        if (this._activity == stSymbol) {
            return;
        }
        this._activity = stSymbol;
        if (this._activity == JunGrapherController.$((String)"singleClick")) {
            this.getGrapherView().toComponent().setCursor(JunCursors.CrossCursor());
        } else if (this._activity == JunGrapherController.$((String)"grab")) {
            this.getGrapherView().toComponent().setCursor(JunCursors.Quarters2Cursor());
        } else if (this._activity == JunGrapherController.$((String)"moveNodes")) {
            this.getGrapherView().toComponent().setCursor(JunCursors.QuartersCursor());
        } else if (this._activity == JunGrapherController.$((String)"freehand")) {
            this.getGrapherView().toComponent().setCursor(JunCursors.PencilCursor());
        } else {
            this.getGrapherView().toComponent().setCursor(null);
        }
    }
}

