/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.topology.graph;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.goodies.calendar.JunCalendarModel;
import jp.co.sra.jun.goodies.tables.JunAttributeTable;
import jp.co.sra.jun.topology.graph.JunElementalNode;
import jp.co.sra.jun.topology.graph.JunElementalStuff;
import jp.co.sra.smalltalk.StColorValue;
import jp.co.sra.smalltalk.StRectangle;
import jp.co.sra.smalltalk.StSymbol;

public class JunElementalArc
extends JunElementalStuff {
    protected static JunAttributeTable DefaultAttributes = new JunAttributeTable();
    protected static StSymbol[] AttributeSymbolsToReset = new StSymbol[]{JunElementalArc.$((String)"lineColor"), JunElementalArc.$((String)"lineWidth"), JunElementalArc.$((String)"firstBoxColor"), JunElementalArc.$((String)"lastBoxColor"), JunElementalArc.$((String)"firstPointAlignment"), JunElementalArc.$((String)"lastPointAlignment")};
    protected JunElementalNode firstNode;
    protected JunElementalNode lastNode;

    protected static int DefaultLineWidth() {
        return 1;
    }

    protected static Color DefaultLineColor() {
        return StColorValue.Gray;
    }

    protected static StSymbol DefaultFirstPointAlignment() {
        return JunElementalArc.$((String)"center");
    }

    protected static Color DefaultFirstBoxColor() {
        return StColorValue.VeryDarkGray;
    }

    protected static Color DefaultLastBoxColor() {
        return StColorValue.VeryDarkGray;
    }

    protected static StSymbol DefaultLastPointAlignment() {
        return JunElementalArc.$((String)"center");
    }

    public JunElementalArc() {
        this(null, null, null);
    }

    public JunElementalArc(JunElementalNode junElementalNode, JunElementalNode junElementalNode2) {
        this(junElementalNode, junElementalNode2, null);
    }

    public JunElementalArc(JunElementalNode junElementalNode, JunElementalNode junElementalNode2, JunAttributeTable junAttributeTable) {
        this.initialize();
        this.from_to_attributes_(junElementalNode, junElementalNode2, junAttributeTable);
    }

    protected void initialize() {
        this.firstNode = null;
        this.lastNode = null;
        this.myAttributes = new JunAttributeTable();
        String string = JunCalendarModel.StringFromDateAndTime();
        this.myAttributes.at_put_(JunElementalArc.$((String)"creationDate"), string);
        this.myAttributes.at_put_(JunElementalArc.$((String)"modificationDate"), string);
    }

    public JunElementalNode firstNode() {
        return this.firstNode;
    }

    public Point firstPoint() {
        if (this.firstNode() == null) {
            return new Point(0, 0);
        }
        StRectangle stRectangle = this.firstNode().boundingBox();
        try {
            return (Point)stRectangle.perform_(this.firstPointAlignment().toString());
        }
        catch (Exception exception) {
            return new Point(0, 0);
        }
    }

    public StRectangle firstBox() {
        StRectangle stRectangle = StRectangle.Origin_extent_((Point)this.firstPoint(), (Point)new Point(0, 0));
        return stRectangle.expandedBy_(this.lineWidth());
    }

    public JunElementalNode lastNode() {
        return this.lastNode;
    }

    public Point lastPoint() {
        if (this.lastNode() == null) {
            return new Point(0, 0);
        }
        StRectangle stRectangle = this.lastNode().boundingBox();
        try {
            return (Point)stRectangle.perform_(this.lastPointAlignment().toString());
        }
        catch (Exception exception) {
            return new Point(0, 0);
        }
    }

    public StRectangle lastBox() {
        StRectangle stRectangle = StRectangle.Origin_extent_((Point)this.lastPoint(), (Point)new Point(0, 0));
        return stRectangle.expandedBy_(this.lineWidth());
    }

    public StRectangle boundingBox() {
        return this.firstBox().merge_(this.lastBox());
    }

    protected JunAttributeTable arcAttributes() {
        return this.myAttributes;
    }

    public void addAttribute_(Object object, Object object2) {
        this.myAttributes.at_put_(object, object2);
        this.updateModificationDate();
    }

    public int lineWidth() {
        Number number = (Number)this.myAttributes.at_(JunElementalArc.$((String)"lineWidth"));
        if (number == null) {
            number = new Integer(this.defaultLineWidth());
            this.myAttributes.at_put_(JunElementalArc.$((String)"lineWidth"), number);
        }
        return number.intValue();
    }

    public void lineWidth_(int n) {
        this.myAttributes.at_put_(JunElementalArc.$((String)"lineWidth"), new Integer(n));
        this.updateModificationDate();
    }

    public Color lineColor() {
        Color color = (Color)this.myAttributes.at_(JunElementalArc.$((String)"lineColor"));
        if (color == null) {
            color = this.defaultLineColor();
            this.myAttributes.at_put_(JunElementalArc.$((String)"lineColor"), color);
        }
        return color;
    }

    public void lineColor_(Color color) {
        this.myAttributes.at_put_(JunElementalArc.$((String)"lineColor"), color);
        this.updateModificationDate();
    }

    public StSymbol firstPointAlignment() {
        StSymbol stSymbol = (StSymbol)this.myAttributes.at_(JunElementalArc.$((String)"firstPointAlignment"));
        if (stSymbol == null) {
            stSymbol = this.defaultFirstPointAlignment();
            this.myAttributes.at_put_(JunElementalArc.$((String)"firstPointAlignment"), stSymbol);
        }
        return stSymbol;
    }

    public void firstPointAlignment_(StSymbol stSymbol) {
        this.myAttributes.at_put_(JunElementalArc.$((String)"firstPointAlignment"), stSymbol);
        this.updateModificationDate();
    }

    public Color firstBoxColor() {
        Color color = (Color)this.myAttributes.at_(JunElementalArc.$((String)"firstBoxColor"));
        if (color == null) {
            color = this.defaultFirstBoxColor();
            this.myAttributes.at_put_(JunElementalArc.$((String)"firstBoxColor"), color);
        }
        return color;
    }

    public void firstBoxColor_(Color color) {
        this.myAttributes.at_put_(JunElementalArc.$((String)"firstBoxColor"), color);
        this.updateModificationDate();
    }

    public StSymbol lastPointAlignment() {
        StSymbol stSymbol = (StSymbol)this.myAttributes.at_(JunElementalArc.$((String)"lastPointAlignment"));
        if (stSymbol == null) {
            stSymbol = this.defaultLastPointAlignment();
            this.myAttributes.at_put_(JunElementalArc.$((String)"lastPointAlignment"), stSymbol);
        }
        return stSymbol;
    }

    public void lastPointAlignment_(StSymbol stSymbol) {
        this.myAttributes.at_put_(JunElementalArc.$((String)"lastPointAlignment"), stSymbol);
        this.updateModificationDate();
    }

    public Color lastBoxColor() {
        Color color = (Color)this.myAttributes.at_(JunElementalArc.$((String)"lastBoxColor"));
        if (color == null) {
            color = this.defaultLastBoxColor();
            this.myAttributes.at_put_(JunElementalArc.$((String)"lastBoxColor"), color);
        }
        return color;
    }

    public void lastBoxColor_(Color color) {
        this.myAttributes.at_put_(JunElementalArc.$((String)"lastBoxColor"), color);
        this.updateModificationDate();
    }

    protected StSymbol[] attributeSymbolsToReset() {
        return AttributeSymbolsToReset;
    }

    protected JunAttributeTable defaultAttributes() {
        return DefaultAttributes;
    }

    protected int defaultLineWidth() {
        Number number = (Number)this.defaultAttributes().at_(JunElementalArc.$((String)"lineWidth"));
        if (number == null) {
            number = new Integer(JunElementalArc.DefaultLineWidth());
            this.defaultAttributes().at_put_(JunElementalArc.$((String)"lineWidth"), number);
        }
        return number.intValue();
    }

    protected Color defaultLineColor() {
        Color color = (Color)this.defaultAttributes().at_(JunElementalArc.$((String)"lineColor"));
        if (color == null) {
            color = JunElementalArc.DefaultLineColor();
            this.defaultAttributes().at_put_(JunElementalArc.$((String)"lineColor"), color);
        }
        return color;
    }

    protected StSymbol defaultFirstPointAlignment() {
        StSymbol stSymbol = (StSymbol)this.defaultAttributes().at_(JunElementalArc.$((String)"firstPointAlignment"));
        if (stSymbol == null) {
            stSymbol = JunElementalArc.DefaultFirstPointAlignment();
            this.defaultAttributes().at_put_(JunElementalArc.$((String)"firstPointAlignment"), stSymbol);
        }
        return stSymbol;
    }

    protected Color defaultFirstBoxColor() {
        Color color = (Color)this.defaultAttributes().at_(JunElementalArc.$((String)"firstBoxColor"));
        if (color == null) {
            color = JunElementalArc.DefaultFirstBoxColor();
            this.defaultAttributes().at_put_(JunElementalArc.$((String)"firstBoxColor"), color);
        }
        return color;
    }

    protected StSymbol defaultLastPointAlignment() {
        StSymbol stSymbol = (StSymbol)this.defaultAttributes().at_(JunElementalArc.$((String)"lastPointAlignment"));
        if (stSymbol == null) {
            stSymbol = JunElementalArc.DefaultLastPointAlignment();
            this.defaultAttributes().at_put_(JunElementalArc.$((String)"lastPointAlignment"), stSymbol);
        }
        return stSymbol;
    }

    protected Color defaultLastBoxColor() {
        Color color = (Color)this.defaultAttributes().at_(JunElementalArc.$((String)"lastBoxColor"));
        if (color == null) {
            color = JunElementalArc.DefaultLastBoxColor();
            this.defaultAttributes().at_put_(JunElementalArc.$((String)"lastBoxColor"), color);
        }
        return color;
    }

    public void printOn_(Writer writer) throws IOException {
        writer.write("arc(");
        if (this.firstNode != null) {
            this.firstNode.printOn_(writer);
        }
        writer.write("=>");
        if (this.lastNode != null) {
            this.lastNode.printOn_(writer);
        }
        writer.write(41);
    }

    public void displayOn_at_(Graphics graphics, Point point) {
        if (this.firstNode() == null || this.lastNode() == null) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        StRectangle stRectangle = this.boundingBox().translatedBy_(point.x, point.y);
        Rectangle rectangle = graphics.getClipBounds();
        if (rectangle == null || stRectangle.toRectangle().intersects(rectangle)) {
            StRectangle stRectangle2;
            StRectangle stRectangle3;
            Point point2 = this.firstPoint();
            point2.translate(point.x, point.y);
            Point point3 = this.lastPoint();
            point3.translate(point.x, point.y);
            int n = this.lineWidth();
            if (n > 0) {
                graphics2D.setStroke(new BasicStroke(n));
                graphics2D.setColor(this.lineColor());
                graphics2D.drawLine(point2.x, point2.y, point3.x, point3.y);
            }
            if ((stRectangle3 = this.firstBox().translatedBy_(point.x, point.y)).area() > 0) {
                graphics2D.setColor(this.firstBoxColor());
                graphics2D.fillRect(stRectangle3.x(), stRectangle3.y(), stRectangle3.width(), stRectangle3.height());
            }
            if ((stRectangle2 = this.lastBox().translatedBy_(point.x, point.y)).area() > 0) {
                graphics2D.setColor(this.lastBoxColor());
                graphics2D.fillRect(stRectangle2.x(), stRectangle2.y(), stRectangle2.width(), stRectangle2.height());
            }
        }
    }

    public void displayOn_at_scaledBy_(Graphics graphics, Point point, Jun2dPoint jun2dPoint) {
        if (this.firstNode() == null || this.lastNode() == null) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        StRectangle stRectangle = this.boundingBox().translatedBy_(point.x, point.y);
        stRectangle = stRectangle.scaledBy_(jun2dPoint.x(), jun2dPoint.y());
        stRectangle = stRectangle.expandedBy_(this.lineWidth());
        Rectangle rectangle = graphics.getClipBounds();
        if (rectangle == null || stRectangle.toRectangle().intersects(rectangle)) {
            StRectangle stRectangle2;
            StRectangle stRectangle3;
            Point point2 = this.firstPoint();
            int n = (int)Math.round((double)(point2.x + point.x) * jun2dPoint.x());
            int n2 = (int)Math.round((double)(point2.y + point.y) * jun2dPoint.y());
            Point point3 = this.lastPoint();
            int n3 = (int)Math.round((double)(point3.x + point.x) * jun2dPoint.x());
            int n4 = (int)Math.round((double)(point3.y + point.y) * jun2dPoint.y());
            int n5 = this.lineWidth();
            if (n5 > 0) {
                graphics2D.setStroke(new BasicStroke(n5));
                graphics2D.setColor(this.lineColor());
                graphics2D.drawLine(n, n2, n3, n4);
            }
            if ((stRectangle3 = this.firstBox().translatedBy_(point.x, point.y).scaledBy_(jun2dPoint.x(), jun2dPoint.y())).area() > 0) {
                graphics2D.setColor(this.firstBoxColor());
                graphics2D.fillRect(stRectangle3.x(), stRectangle3.y(), stRectangle3.width(), stRectangle3.height());
            }
            if ((stRectangle2 = this.lastBox().translatedBy_(point.x, point.y).scaledBy_(jun2dPoint.x(), jun2dPoint.y())).area() > 0) {
                graphics2D.setColor(this.lastBoxColor());
                graphics2D.fillRect(stRectangle2.x(), stRectangle2.y(), stRectangle2.width(), stRectangle2.height());
            }
        }
    }

    private void from_to_attributes_(JunElementalNode junElementalNode, JunElementalNode junElementalNode2, JunAttributeTable junAttributeTable) {
        this.firstNode = junElementalNode;
        this.lastNode = junElementalNode2;
        if (junAttributeTable != null) {
            Set set = this.myAttributes.entries();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                if (junAttributeTable.at_(entry.getKey()) != null) continue;
                junAttributeTable.at_put_(entry.getKey(), entry.getValue());
            }
            this.setMyAttributes_(junAttributeTable);
        }
    }
}

