/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.terrain.editor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.geometry.curves.Jun2dLine;
import jp.co.sra.jun.goodies.cursors.JunCursors;
import jp.co.sra.jun.system.framework.JunAbstractController;
import jp.co.sra.jun.terrain.editor.JunTerrainEditModel;
import jp.co.sra.jun.terrain.editor.JunTerrainEditView;
import jp.co.sra.smalltalk.StSymbol;
import jp.co.sra.smalltalk.StView;

public class JunTerrainEditController
extends JunAbstractController
implements MouseListener,
MouseMotionListener {
    protected Jun2dPoint _currentPoint;
    protected Jun2dPoint _previousPoint;
    protected Cursor _savedCursor;
    protected Point _startPoint;
    protected Point _mousePointOnScreen;
    protected Point[] _lineSegment;

    public void initialize() {
        super.initialize();
        this._currentPoint = null;
        this._previousPoint = null;
        this._savedCursor = null;
        this._startPoint = null;
        this._mousePointOnScreen = null;
        this._lineSegment = null;
    }

    public void release() {
        Component component = this.getTerrainEditView().getOpenGLDrawable().toComponent();
        component.removeMouseListener(this);
        component.removeMouseMotionListener(this);
        super.release();
    }

    protected void buildListener(StView stView) {
        Component component = this.getTerrainEditView().getOpenGLDrawable().toComponent();
        component.addMouseListener(this);
        component.addMouseMotionListener(this);
    }

    protected JunTerrainEditModel getTerrainEditModel() {
        return (JunTerrainEditModel)this.model();
    }

    protected JunTerrainEditView getTerrainEditView() {
        return (JunTerrainEditView)this.view();
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        JunTerrainEditModel junTerrainEditModel = (JunTerrainEditModel)this.model();
        StSymbol stSymbol = junTerrainEditModel.buttonState();
        if (stSymbol == null) {
            return;
        }
        Component component = this.getTerrainEditView().getOpenGLDrawable().toComponent();
        this._savedCursor = component.getCursor();
        if (stSymbol == JunTerrainEditController.$((String)"peak")) {
            component.setCursor(JunCursors.CrossCursor());
        } else if (stSymbol == JunTerrainEditController.$((String)"drag")) {
            component.setCursor(JunCursors.QuartersCursor());
        } else if (stSymbol == JunTerrainEditController.$((String)"show")) {
            component.setCursor(JunCursors.ReadCursor());
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.getTerrainEditView().getOpenGLDrawable().toComponent().setCursor(this._savedCursor);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this._startPoint = mouseEvent.getPoint();
        this._mousePointOnScreen = mouseEvent.getComponent().getLocationOnScreen();
        this._mousePointOnScreen.translate(this._startPoint.x, this._startPoint.y);
        this._previousPoint = this._currentPoint = this.regularizePoint_(this._startPoint);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        JunTerrainEditModel junTerrainEditModel = (JunTerrainEditModel)this.model();
        StSymbol stSymbol = junTerrainEditModel.buttonState();
        if (stSymbol == JunTerrainEditController.$((String)"peak")) {
            junTerrainEditModel.plotPeak_(this);
        } else if (stSymbol == JunTerrainEditController.$((String)"show")) {
            this._drawLineSegment();
            junTerrainEditModel.showTerrain_(this);
            this._lineSegment = null;
        }
        this._startPoint = null;
        this._mousePointOnScreen = null;
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        JunTerrainEditModel junTerrainEditModel = (JunTerrainEditModel)this.model();
        StSymbol stSymbol = junTerrainEditModel.buttonState();
        if (stSymbol == JunTerrainEditController.$((String)"drag")) {
            this._currentPoint = this.regularizePoint_(mouseEvent.getPoint());
            if (!this._currentPoint.equals((Object)this._previousPoint)) {
                junTerrainEditModel.drag_xy_(this._previousPoint, this._currentPoint);
                this._previousPoint = this._currentPoint;
            }
        } else if (stSymbol == JunTerrainEditController.$((String)"show") && this._startPoint != null) {
            this._drawLineSegment();
            this._lineSegment = new Point[]{this._startPoint, mouseEvent.getPoint()};
            this._drawLineSegment();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _drawLineSegment() {
        if (this._lineSegment == null) {
            return;
        }
        Graphics graphics = this.getTerrainEditView().getOpenGLDrawable().toComponent().getGraphics();
        try {
            graphics.setColor(Color.white);
            graphics.setXORMode(Color.black);
            graphics.drawLine(this._lineSegment[0].x, this._lineSegment[0].y, this._lineSegment[1].x, this._lineSegment[1].y);
        }
        finally {
            graphics.dispose();
        }
    }

    protected Jun2dLine mouse2dLineSegment() {
        if (this._lineSegment == null) {
            return null;
        }
        return new Jun2dLine(this.regularizePoint_(this._lineSegment[0]), this.regularizePoint_(this._lineSegment[1]));
    }

    protected Jun2dPoint mouse2dPoint() {
        return this._currentPoint;
    }

    protected Jun2dPoint regularizePoint_(Point point) {
        return this.getTerrainEditModel().regularizePoint_in_(point, this.getTerrainEditView().boundsOfCanvas());
    }
}

