/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.system.support;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Rectangle;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.TreeMap;
import jp.co.sra.gl4jun.GLjInterface;
import jp.co.sra.qt4jun.JunQTInterface;
import jp.co.sra.smalltalk.DependentListener;
import jp.co.sra.smalltalk.StComposedText;
import jp.co.sra.smalltalk.StImage;
import jp.co.sra.smalltalk.StMessageCatalog;
import jp.co.sra.smalltalk.StModel;
import jp.co.sra.smalltalk.StObject;
import jp.co.sra.smalltalk.StSymbol;
import jp.co.sra.smalltalk.StUserMessage;
import jp.co.sra.smalltalk.StValueHolder;
import jp.co.sra.smalltalk.SystemInterface;
import jp.co.sra.smalltalk.SystemResourceSupport;
import jp.co.sra.smalltalk.menu.MenuEvent;
import jp.co.sra.smalltalk.menu.MenuListener;
import jp.co.sra.smalltalk.menu.StMenu;
import jp.co.sra.smalltalk.menu.StMenuItem;
import jp.co.sra.smalltalk.menu.StRadioButtonGroup;
import jp.co.sra.smalltalk.menu.StRadioButtonMenuItem;

public class JunSystem
extends StModel {
    public static final String _System = "Jun";
    public static final String _Version = "699";
    public static final String _Date = "2008/02/20";
    public static final StMenu DefaultRenderingModeMenu;
    public static final StMenu DefaultLanguageModeMenu;
    protected static final String _MessageCatalogName = "jp.co.sra.jun.system.support.MessageCatalog";
    protected static final StValueHolder DefaultLanguageModeHolder;
    protected static int DefaultRenderingMode;
    protected static long _UniqueNumberGenerationTime;

    public static long GenerateUniqueNumber() {
        long l;
        while (_UniqueNumberGenerationTime >= (l = System.currentTimeMillis())) {
        }
        _UniqueNumberGenerationTime = l;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        return Long.parseLong(simpleDateFormat.format(new Date(_UniqueNumberGenerationTime))) * 100L;
    }

    public static String PlatformName() {
        return System.getProperty("os.name");
    }

    public static boolean IsMacOSX() {
        return JunSystem.PlatformName().toLowerCase().matches(".*mac.*os.*x.*");
    }

    public static final String System() {
        return JunSystem.$String((String)_System);
    }

    public static final String Version() {
        return _Version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String Copyright() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(stringWriter);
            printWriter.println("\"Jun for Java\" package is being published as open source software under the terms of \"The modified BSD license\".");
            printWriter.println();
            printWriter.println(JunSystem.CopyrightSRA());
            printWriter.println(JunSystem.CopyrightIPA());
            printWriter.println(JunSystem.CopyrightKTL());
            printWriter.println();
            printWriter.println("All rights reserved.");
            printWriter.println();
            printWriter.println(JunSystem.JavaTM());
        }
        finally {
            if (printWriter != null) {
                printWriter.flush();
                printWriter.close();
            }
        }
        return stringWriter.toString();
    }

    public static final String CopyrightIPA() {
        return "Copyright (C) 1999-2005 Information-technology Promotion Agency, Japan (IPA)";
    }

    public static final String CopyrightKTL() {
        int n = Calendar.getInstance().get(1);
        return "Copyright (C) 2001-" + n + " SRA/KTL (SRA Key Technology Laboratory, Inc.)";
    }

    public static final String CopyrightSRA() {
        int n = Calendar.getInstance().get(1);
        return "Copyright (C) 1999-" + n + " SRA (Software Research Associates, Inc.)";
    }

    public static final String Date() {
        return _Date;
    }

    public static String DefaultBaseName() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        return simpleDateFormat.format(new Date());
    }

    public static String DefaultFontName() {
        String string = System.getProperty("default.font.name");
        return string != null ? string : "Dialog";
    }

    public static String DefaultTextExtension() {
        return "txt";
    }

    public static String[] DefaultTextExtensions() {
        return new String[]{"txt", "java", "html", "htm", "bat"};
    }

    public static String[] DefaultTextExtensionPatterns() {
        return JunSystem.DefaultExtensionPatterns(JunSystem.DefaultTextExtensions());
    }

    public static String DefaultImageExtension() {
        return "jpg";
    }

    public static String[] DefaultImageExtensions() {
        return new String[]{"jpg", "jpeg", "png", "bmp", "gif"};
    }

    public static String[] DefaultImageExtensionPatterns() {
        return JunSystem.DefaultExtensionPatterns(JunSystem.DefaultImageExtensions());
    }

    public static String DefaultMovieExtension() {
        return "mov";
    }

    public static String[] DefaultMovieExtensions() {
        return new String[]{"mov", "mp4", "avi", "mpg", "mpeg"};
    }

    public static String[] DefaultMovieExtensionPatterns() {
        return JunSystem.DefaultExtensionPatterns(JunSystem.DefaultMovieExtensions());
    }

    public static String DefaultSoundExtension() {
        return "mov";
    }

    public static String[] DefaultSoundExtensions() {
        return new String[]{"mp3", "wav"};
    }

    public static String[] DefaultSoundExtensionPatterns() {
        return JunSystem.DefaultExtensionPatterns(JunSystem.DefaultSoundExtensions());
    }

    public static String DefaultBodyExtension() {
        return "lst";
    }

    public static String[] DefaultBodyExtensions() {
        return new String[]{"lst", "wrl"};
    }

    public static String[] DefaultBodyExtensionPatterns() {
        return JunSystem.DefaultExtensionPatterns(JunSystem.DefaultBodyExtensions());
    }

    public static String[] DefaultExtraExtensions() {
        return new String[]{"pdf", "doc", "xls", "ppt"};
    }

    public static String[] DefaultExtraExtensionPatterns() {
        return JunSystem.DefaultExtensionPatterns(JunSystem.DefaultExtraExtensions());
    }

    protected static String[] DefaultExtensionPatterns(String[] stringArray) {
        int n = stringArray.length;
        String[] stringArray2 = new String[n * 2];
        for (int i = 0; i < n; ++i) {
            stringArray2[i] = "*." + stringArray[i].toLowerCase();
            stringArray2[i + n] = "*." + stringArray[i].toUpperCase();
        }
        return stringArray2;
    }

    public static String FullName() {
        return JunSystem.System() + " for Java (" + JunSystem.Version() + " with " + StObject.System() + StObject.Version() + ")";
    }

    public static final String getJniVersion() {
        return GLjInterface.getVersion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String Information() {
        String string = "    ";
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        try {
            int n;
            Object object;
            printWriter.println("Versions");
            printWriter.println(string + JunSystem.System() + " : " + JunSystem.Version() + " (" + JunSystem.Date() + ")");
            printWriter.println(string + StObject.System() + " : " + StObject.Version() + " (" + StObject.Date() + ")");
            printWriter.println();
            printWriter.println("JNI library versions");
            try {
                GLjInterface.Current();
                printWriter.println(string + "JunGL" + " : " + JunSystem.getJniVersion());
            }
            catch (Throwable throwable) {
                printWriter.println(string + "JunGL" + " : can not find");
            }
            try {
                JunQTInterface.Interface();
                printWriter.println(string + "JunQT" + " : " + JunQTInterface.GetVersion());
            }
            catch (Throwable throwable) {
                printWriter.println(string + "JunQT" + " : can not find");
            }
            try {
                SystemInterface.Current();
                printWriter.println(string + "StPL" + " : " + SystemInterface.getVersion());
            }
            catch (Throwable throwable) {
                printWriter.println(string + "StPL" + " : can not find");
            }
            printWriter.println();
            printWriter.println("Java Properties");
            TreeMap<Object, Object> treeMap = new TreeMap<Object, Object>();
            treeMap.putAll(System.getProperties());
            String string2 = (String)treeMap.get("line.separator");
            if (string2 != null && string2.length() > 0) {
                object = "";
                block14: for (n = 0; n < string2.length(); ++n) {
                    char c = string2.charAt(n);
                    switch (c) {
                        case '\n': {
                            object = (String)object + "\\n";
                            continue block14;
                        }
                        case '\r': {
                            object = (String)object + "\\r";
                            continue block14;
                        }
                        case '\f': {
                            object = (String)object + "\\f";
                            continue block14;
                        }
                        default: {
                            object = (String)object + String.valueOf(c);
                        }
                    }
                }
                treeMap.put("line.separator", object);
            }
            object = treeMap.keySet().toArray();
            for (n = 0; n < ((Object[])object).length; ++n) {
                printWriter.println(string + object[n].toString() + " : " + treeMap.get(object[n]).toString());
            }
        }
        finally {
            printWriter.flush();
            printWriter.close();
        }
        return stringWriter.toString();
    }

    public static final String JavaTM() {
        return "Java and all Java-based trademarks and logos are trademarks or registered trademarks of Sun Microsystems, Inc. in the U.S. or other countries, and are used under license. ";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String License() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(stringWriter);
            printWriter.println(JunSystem.CopyrightSRA());
            printWriter.println(JunSystem.CopyrightIPA());
            printWriter.println(JunSystem.CopyrightKTL());
            printWriter.println("All rights reserved.");
            printWriter.println();
            printWriter.println("Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:");
            printWriter.println();
            printWriter.println("1. Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer. ");
            printWriter.println();
            printWriter.println("2. Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution. ");
            printWriter.println();
            printWriter.println("3. The name of the author may not be used to endorse or promote products derived from this software without specific prior written permission. ");
            printWriter.println();
            printWriter.println("THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.");
            printWriter.println();
            printWriter.println(JunSystem.JavaTM());
        }
        finally {
            if (printWriter != null) {
                printWriter.flush();
                printWriter.close();
            }
        }
        return stringWriter.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final StImage Logo() {
        Font font = new Font(JunSystem.DefaultFontName(), 1, 12);
        StComposedText stComposedText = new StComposedText(JunSystem.FullName(), font);
        StComposedText stComposedText2 = new StComposedText(JunSystem.Date(), font);
        StImage stImage = new StImage(JunSystem.LogoImage());
        int n = 20;
        int n2 = 6;
        int n3 = stImage.width() + n * 2;
        int n4 = stImage.height() + stComposedText.height() + stComposedText2.height() + n2 * 2;
        StImage stImage2 = new StImage(n3, n4);
        Graphics graphics = null;
        try {
            graphics = stImage2.image().getGraphics();
            graphics.setColor(Color.white);
            graphics.fillRect(0, 0, stImage2.width(), stImage2.height());
            graphics.drawImage(stComposedText.toImage(), n, n2, null);
            graphics.drawImage(stImage.image(), n, n2 + stComposedText.height(), null);
            graphics.drawImage(stComposedText2.toImage(), stImage2.width() - stComposedText2.width() - n, n2 + stComposedText.height() + stImage.height(), null);
            stImage2.image().flush();
        }
        finally {
            if (graphics != null) {
                graphics.dispose();
                graphics = null;
            }
        }
        return stImage2;
    }

    public static final Image LogoImage() {
        return SystemResourceSupport.createImage((String)"/jp/co/sra/jun/system/support/LogoImage.jpg");
    }

    public static final String ProjectNameString() {
        return JunSystem.System() + " for Java Project";
    }

    public static Rectangle ScreenBoundingBox() {
        Rectangle[] rectangleArray = JunSystem.ScreenBounds();
        return rectangleArray == null || rectangleArray.length == 0 ? null : rectangleArray[0];
    }

    public static Rectangle[] ScreenBounds() {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] graphicsDeviceArray = graphicsEnvironment.getScreenDevices();
        if (graphicsDeviceArray == null) {
            return null;
        }
        Rectangle[] rectangleArray = new Rectangle[graphicsDeviceArray.length];
        for (int i = 0; i < graphicsDeviceArray.length; ++i) {
            rectangleArray[i] = graphicsDeviceArray[i].getDefaultConfiguration().getBounds();
        }
        return rectangleArray;
    }

    public static StMessageCatalog GetMessageCatalog() {
        if (JunSystem.GetDefaultLanguageMode() == null) {
            return StMessageCatalog.DefaultMessageCatalog;
        }
        return StMessageCatalog.With((String)_MessageCatalogName, (Locale)JunSystem.GetDefaultLanguageMode());
    }

    private static StMessageCatalog GetMessageCatalogFor(Locale locale) {
        if (locale == null) {
            return StMessageCatalog.DefaultMessageCatalog;
        }
        try {
            return StMessageCatalog.With((String)_MessageCatalogName, (Locale)locale);
        }
        catch (MissingResourceException missingResourceException) {
            System.err.println(missingResourceException.getMessage());
            if (!Locale.getDefault().equals(locale)) {
                try {
                    locale = Locale.getDefault();
                    StMessageCatalog stMessageCatalog = StMessageCatalog.With((String)_MessageCatalogName, (Locale)locale);
                    System.err.println("Use the message catalog with the default locale " + locale);
                    return stMessageCatalog;
                }
                catch (MissingResourceException missingResourceException2) {
                    System.err.println(missingResourceException2.getMessage());
                }
            }
            System.err.println("Use the default message catalog.");
            return StMessageCatalog.DefaultMessageCatalog;
        }
    }

    public static int GetDefaultRenderingMode() {
        return DefaultRenderingMode;
    }

    public static int getDefaultRenderingMode() {
        return JunSystem.GetDefaultRenderingMode();
    }

    public static void SetDefaultRenderingMode(int n) {
        DefaultRenderingMode = n;
        JunSystem.UpdateDefaultRenderingModeMenu();
    }

    public static void setDefaultRenderingMode(int n) {
        JunSystem.SetDefaultRenderingMode(n);
    }

    public static void UpdateDefaultRenderingModeMenu() {
        StSymbol stSymbol = null;
        switch (JunSystem.GetDefaultRenderingMode()) {
            case 0: {
                stSymbol = JunSystem.$((String)"renderNothing");
                break;
            }
            case 1: {
                stSymbol = JunSystem.$((String)"renderSingleBuffer");
                break;
            }
            case 2: {
                stSymbol = JunSystem.$((String)"renderImage");
                break;
            }
            case 3: {
                stSymbol = JunSystem.$((String)"renderDirect");
                break;
            }
            case 4: {
                stSymbol = JunSystem.$((String)"renderDoubleBuffer");
            }
        }
        if (stSymbol == null) {
            return;
        }
        StRadioButtonMenuItem stRadioButtonMenuItem = (StRadioButtonMenuItem)DefaultRenderingModeMenu.atNameKey_(stSymbol);
        if (stRadioButtonMenuItem != null && !stRadioButtonMenuItem.isSelected()) {
            stRadioButtonMenuItem.beOn();
        }
    }

    protected static StMenu CreateDefaultRenderingModeMenu() {
        StRadioButtonGroup stRadioButtonGroup = new StRadioButtonGroup();
        StMenu stMenu = new StMenu((Object)new StUserMessage("Default Rendering Mode"));
        stMenu.add((StMenuItem)new StRadioButtonMenuItem((Object)new StUserMessage("Nothing"), JunSystem.$((String)"renderNothing"), stRadioButtonGroup, new MenuListener(){

            public void menuPerformed(MenuEvent menuEvent) {
                JunSystem.setDefaultRenderingMode(0);
            }
        }));
        stMenu.add((StMenuItem)new StRadioButtonMenuItem((Object)new StUserMessage("Single Buffer"), JunSystem.$((String)"renderSingleBuffer"), stRadioButtonGroup, new MenuListener(){

            public void menuPerformed(MenuEvent menuEvent) {
                JunSystem.setDefaultRenderingMode(1);
            }
        }));
        stMenu.add((StMenuItem)new StRadioButtonMenuItem((Object)new StUserMessage("Image"), JunSystem.$((String)"renderImage"), stRadioButtonGroup, new MenuListener(){

            public void menuPerformed(MenuEvent menuEvent) {
                JunSystem.setDefaultRenderingMode(2);
            }
        }));
        stMenu.add((StMenuItem)new StRadioButtonMenuItem((Object)new StUserMessage("Direct"), JunSystem.$((String)"renderDirect"), stRadioButtonGroup, new MenuListener(){

            public void menuPerformed(MenuEvent menuEvent) {
                JunSystem.setDefaultRenderingMode(3);
            }
        }));
        stMenu.add((StMenuItem)new StRadioButtonMenuItem((Object)new StUserMessage("Double Buffer"), JunSystem.$((String)"renderDoubleBuffer"), stRadioButtonGroup, new MenuListener(){

            public void menuPerformed(MenuEvent menuEvent) {
                JunSystem.setDefaultRenderingMode(4);
            }
        }));
        return stMenu;
    }

    public static Locale GetDefaultLanguageMode() {
        return (Locale)DefaultLanguageModeHolder.value();
    }

    public static void SetDefaultLanguageMode(Locale locale) {
        if (JunSystem.GetDefaultLanguageMode() == locale) {
            return;
        }
        StMessageCatalog stMessageCatalog = JunSystem.GetMessageCatalogFor(locale);
        StMessageCatalog.GivePriorityTo((StMessageCatalog)stMessageCatalog);
        DefaultLanguageModeHolder.setValue_((Object)stMessageCatalog.getLocale());
        JunSystem.UpdateDefaultLanguageModeMenu();
        DefaultLanguageModeHolder.changed_(JunSystem.$((String)"value"));
    }

    public static void AddDependentListenerOnDefaultLanguageMode(DependentListener dependentListener) {
        DefaultLanguageModeHolder.addDependentListener(dependentListener);
    }

    public static void SetLocale(Locale locale) {
        JunSystem.SetDefaultLanguageMode(locale);
    }

    public static boolean IsDefaultLanguageMode(Locale locale) {
        if (JunSystem.GetDefaultLanguageMode() == locale) {
            return true;
        }
        if (JunSystem.GetDefaultLanguageMode() == null || locale == null) {
            return false;
        }
        return JunSystem.GetDefaultLanguageMode().getLanguage().equals(locale.getLanguage());
    }

    public static void UpdateDefaultLanguageModeMenu() {
        StSymbol stSymbol = null;
        stSymbol = JunSystem.IsDefaultLanguageMode(Locale.JAPAN) ? JunSystem.$((String)"languageJapanese") : JunSystem.$((String)"languageEnglish");
        StRadioButtonMenuItem stRadioButtonMenuItem = (StRadioButtonMenuItem)DefaultLanguageModeMenu.atNameKey_(stSymbol);
        if (stRadioButtonMenuItem != null && !stRadioButtonMenuItem.isSelected()) {
            stRadioButtonMenuItem.beOn();
        }
    }

    protected static StMenu CreateDefaultLanguageModeMenu() {
        StRadioButtonGroup stRadioButtonGroup = new StRadioButtonGroup();
        StMenu stMenu = new StMenu((Object)new StUserMessage("Default Language Mode"));
        stMenu.add((StMenuItem)new StRadioButtonMenuItem((Object)new StUserMessage("Japanese"), JunSystem.$((String)"languageJapanese"), stRadioButtonGroup, new MenuListener(){

            public void menuPerformed(MenuEvent menuEvent) {
                JunSystem.SetDefaultLanguageMode(Locale.JAPAN);
            }
        }));
        stMenu.add((StMenuItem)new StRadioButtonMenuItem((Object)new StUserMessage("English"), JunSystem.$((String)"languageEnglish"), stRadioButtonGroup, new MenuListener(){

            public void menuPerformed(MenuEvent menuEvent) {
                JunSystem.SetDefaultLanguageMode(null);
            }
        }));
        return stMenu;
    }

    static {
        DefaultLanguageModeHolder = new StValueHolder();
        _UniqueNumberGenerationTime = Long.MIN_VALUE;
        DefaultRenderingModeMenu = JunSystem.CreateDefaultRenderingModeMenu();
        JunSystem.SetDefaultRenderingMode(4);
        DefaultLanguageModeMenu = JunSystem.CreateDefaultLanguageModeMenu();
        JunSystem.SetDefaultLanguageMode(Locale.getDefault());
    }
}

