/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.system.support;

import java.awt.Color;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.util.Vector;
import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.system.support.JunSmallTypeTable;
import jp.co.sra.smalltalk.SmalltalkException;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StByteArray;
import jp.co.sra.smalltalk.StColorValue;
import jp.co.sra.smalltalk.StImage;
import jp.co.sra.smalltalk.StNumber;
import jp.co.sra.smalltalk.StObject;
import jp.co.sra.smalltalk.StReadStream;
import jp.co.sra.smalltalk.StSymbol;

public class JunSmallCompiler
extends StObject {
    protected StReadStream source;
    protected int mark;
    protected int prevEnd;
    protected char hereChar;
    protected Object token;
    protected StSymbol tokenType;
    protected boolean saveComments;
    protected Vector currentComment;
    protected StringBuffer buffer;
    protected JunSmallTypeTable typeTable;
    protected Object parseNode;

    public JunSmallCompiler() {
        this.initScanner();
    }

    public static Object Evaluate_(String string) {
        return JunSmallCompiler.Evaluate_for_logged_(string, null, false);
    }

    public static Object Evaluate_for_logged_(String string, Object object, boolean bl) {
        return JunSmallCompiler.Evaluate_for_notifying_logged_(string, object, null, bl);
    }

    public static Object Evaluate_for_notifying_logged_(String string, Object object, Object object2, boolean bl) {
        return new JunSmallCompiler().evaluate_in_receiver_notifying_ifFail_(string, null, object, object2, new StBlockClosure());
    }

    public static Object Evaluate_logged_(String string, boolean bl) {
        return JunSmallCompiler.Evaluate_for_logged_(string, null, bl);
    }

    public static Object Evaluate_notifying_logged_(String string, Object object, boolean bl) {
        return JunSmallCompiler.Evaluate_for_notifying_logged_(string, null, object, bl);
    }

    public Object evaluate_in_receiver_notifying_ifFail_(String string, Object object, Object object2, Object object3, StBlockClosure stBlockClosure) {
        return this.compile_(string);
    }

    public Object evaluate_in_to_notifying_ifFail_(String string, Object object, Object object2, Object object3, StBlockClosure stBlockClosure) {
        Object object4 = null;
        object4 = this.evaluate_in_receiver_notifying_ifFail_(string, object, object2, object3, stBlockClosure);
        return object4;
    }

    public void on_(StReadStream stReadStream) {
        this.source = stReadStream;
        this.hereChar = this.source.next();
        this.prevEnd = 0;
    }

    public void scan_(StReadStream stReadStream) {
        this.on_(stReadStream);
        this.scanToken();
    }

    public Object[] scanFieldNames_(String string) {
        if (string.length() == 0) {
            return new Object[0];
        }
        this.scan_(new StReadStream(string));
        Vector<Object> vector = new Vector<Object>(10);
        while (this.tokenType != JunSmallCompiler.$((String)"doIt")) {
            if (this.tokenType == JunSmallCompiler.$((String)"word")) {
                vector.addElement(this.token);
            }
            this.scanToken();
        }
        Object[] objectArray = new Object[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public int[] scanPositionsFor_inString_(StSymbol stSymbol, String string) {
        this.scan_(new StReadStream(string));
        String string2 = stSymbol.toString();
        Vector<Integer> vector = new Vector<Integer>(16);
        while (this.tokenType != JunSmallCompiler.$((String)"doIt")) {
            if (this.tokenType == JunSmallCompiler.$((String)"word") && string2.equals(this.token)) {
                vector.addElement(new Integer(this.mark));
            }
            this.scanToken();
        }
        int[] nArray = new int[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            nArray[i] = (Integer)vector.elementAt(i);
        }
        return nArray;
    }

    public Object[] scanTokens_(String string) {
        this.scan_(new StReadStream(string));
        Vector<Object> vector = new Vector<Object>(16);
        while (this.tokenType != JunSmallCompiler.$((String)"doIt")) {
            this.arrayLiteralElement();
            vector.addElement(this.parseNode);
        }
        Object[] objectArray = new Object[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public void xBinary() {
        this.tokenType = JunSmallCompiler.$((String)"binary");
        char c = this.hereChar;
        this.hereChar = this.source.next();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(c);
        if (this.hereChar != '\u0000' && this.typeTable.at_(this.hereChar) == JunSmallCompiler.$((String)"xBinary") && this.hereChar != '-') {
            stringBuffer.append(this.step());
        }
        this.token = JunSmallCompiler.$((String)stringBuffer.toString());
    }

    public void xDefault() {
        this.notify_("unknown character");
    }

    public void xDelimiter() {
        this.scanToken();
    }

    public void xDigit() {
        this.tokenType = JunSmallCompiler.$((String)"number");
        if (this.hereChar != '\u0000') {
            this.source.skip_(-1);
        }
        this.token = StNumber.ReadFrom_((StReadStream)this.source);
        this.hereChar = this.source.next();
    }

    public void xDollar() {
        this.token = new Character(this.source.next());
        this.hereChar = this.source.next();
        this.tokenType = JunSmallCompiler.$((String)"character");
    }

    public void xDoubleQuote() {
        int n = this.prevEnd;
        if (!this.saveComments) {
            char c;
            while ((c = this.source.next()) != '\"') {
                if (c != '\u0000') continue;
                this.offEnd_("unmatched comment quote");
            }
        } else {
            char c;
            this.buffer.setLength(0);
            while ((c = this.source.next()) != '\"') {
                if (c == '\u0000') {
                    this.offEnd_("unmatched comment quote");
                }
                this.buffer.append(c);
            }
            if (this.currentComment == null) {
                this.currentComment = new Vector();
            }
            this.currentComment.addElement(this.buffer.toString());
            if (this.buffer.length() > 200) {
                this.buffer = new StringBuffer(40);
            }
        }
        this.hereChar = this.source.next();
        this.scanToken();
        this.prevEnd = n;
    }

    public void xLetter() {
        this.buffer.setLength(0);
        this.buffer.append(this.hereChar);
        char c = '\u0000';
        StSymbol stSymbol = null;
        while ((c = this.source.next()) != '\u0000' && ((stSymbol = this.typeTable.at_(c)) == JunSmallCompiler.$((String)"xLetter") || stSymbol == JunSmallCompiler.$((String)"xDigit"))) {
            this.buffer.append(c);
        }
        if (stSymbol == JunSmallCompiler.$((String)"colon")) {
            this.buffer.append(c);
            c = this.source.next();
            this.tokenType = JunSmallCompiler.$((String)"keyword");
        } else {
            this.tokenType = JunSmallCompiler.$((String)"word");
        }
        this.hereChar = c;
        this.token = this.buffer.toString();
    }

    public void xLitQuote() {
        this.step();
        this.scanToken();
        if (this.tokenType == JunSmallCompiler.$((String)"leftParenthesis")) {
            int n = this.mark;
            this.scanToken();
            this.scanLitVec();
            if (this.tokenType == JunSmallCompiler.$((String)"doIt")) {
                this.mark = n;
                this.offEnd_("unmatched parenthesis");
            }
        } else if (this.tokenType == JunSmallCompiler.$((String)"word")) {
            this.token = JunSmallCompiler.$((String)this.token.toString());
        } else if (this.tokenType == JunSmallCompiler.$((String)"keyword")) {
            this.scanLitKeywords();
        }
        this.tokenType = JunSmallCompiler.$((String)"literal");
    }

    public void xSingleQuote() {
        char c = this.source.next();
        if (c == '\u0000') {
            this.offEnd_("unmatched string quote");
            return;
        }
        this.buffer = new StringBuffer(32);
        while (c != '\'' || (c = this.source.next()) == '\'') {
            this.buffer.append(c);
            c = this.source.next();
        }
        this.hereChar = c;
        this.token = this.buffer.toString();
        this.tokenType = JunSmallCompiler.$((String)"string");
    }

    protected void arrayLiteral() {
        Vector<Object> vector = new Vector<Object>(16);
        while (this.tokenType != JunSmallCompiler.$((String)"rightParenthesis")) {
            if (this.tokenType == JunSmallCompiler.$((String)"doIt")) {
                this.notify_("array element or right  parenthesis");
                return;
            }
            this.arrayLiteralElement();
            vector.addElement(this.parseNode);
        }
        Object[] objectArray = new Object[vector.size()];
        vector.copyInto(objectArray);
        this.parseNode = objectArray;
        this.scanToken();
    }

    protected void arrayLiteralElement() {
        if (this.constant()) {
            return;
        }
        if (this.tokenType == JunSmallCompiler.$((String)"leftParenthesis")) {
            this.scanToken();
            this.arrayLiteral();
            return;
        }
        if (this.tokenType == JunSmallCompiler.$((String)"leftBracket")) {
            this.scanToken();
            this.byteArrayLiteral();
            return;
        }
        this.scanLitToken();
        this.parseNode = this.token;
        this.scanToken();
    }

    protected void byteArrayLiteral() {
        StringBuffer stringBuffer = new StringBuffer(16);
        int n = 0;
        while (this.tokenType != JunSmallCompiler.$((String)"rightBracket")) {
            int n2;
            if (this.tokenType != JunSmallCompiler.$((String)"number") || !(this.token instanceof Integer) || (n2 = ((Integer)this.token).intValue()) < 0 || n2 > 255) {
                this.notify_("8-bit integer or right bracket");
                return;
            }
            stringBuffer.append((char)n2);
            ++n;
            this.scanToken();
        }
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray[i] = (byte)stringBuffer.charAt(i);
        }
        this.parseNode = byArray;
        this.scanToken();
    }

    protected Object compile_(String string) {
        Object[] objectArray = this.scanTokens_(string);
        return this.translate_(objectArray);
    }

    protected boolean constant() {
        if (this.tokenType == JunSmallCompiler.$((String)"word")) {
            String string = (String)this.token;
            int n = string.length();
            if (n == 5) {
                if (string.equals("false")) {
                    this.scanToken();
                    this.parseNode = Boolean.FALSE;
                    return true;
                }
            } else if (n == 4) {
                if (string.equals("true")) {
                    this.scanToken();
                    this.parseNode = Boolean.TRUE;
                    return true;
                }
            } else if (n == 3 && string.equals("nil")) {
                this.scanToken();
                this.parseNode = null;
                return true;
            }
            return false;
        }
        if (this.tokenType == JunSmallCompiler.$((String)"string") || this.tokenType == JunSmallCompiler.$((String)"number") || this.tokenType == JunSmallCompiler.$((String)"character")) {
            this.parseNode = this.token;
            this.scanToken();
            return true;
        }
        if (this.token == JunSmallCompiler.$((String)"-") && this.hereChar != '\u0000' && Character.isDigit(this.hereChar)) {
            this.scanToken();
            this.parseNode = StNumber._Negate((Number)((Number)this.token));
            this.scanToken();
            return true;
        }
        if (this.tokenType != JunSmallCompiler.$((String)"literalQuote")) {
            return false;
        }
        this.scanToken();
        if (this.tokenType == JunSmallCompiler.$((String)"word") || this.tokenType == JunSmallCompiler.$((String)"binary") || this.tokenType == JunSmallCompiler.$((String)"verticalBar") || this.tokenType == JunSmallCompiler.$((String)"string")) {
            this.parseNode = JunSmallCompiler.$((String)this.token.toString());
            this.scanToken();
            return true;
        }
        if (this.tokenType == JunSmallCompiler.$((String)"keyword")) {
            this.scanLitKeywords();
            this.parseNode = JunSmallCompiler.$((String)this.token.toString());
            this.scanToken();
            return true;
        }
        if (this.tokenType == JunSmallCompiler.$((String)"leftParenthesis")) {
            this.scanToken();
            this.arrayLiteral();
            return true;
        }
        if (this.tokenType == JunSmallCompiler.$((String)"leftBracket")) {
            this.scanToken();
            this.byteArrayLiteral();
            return true;
        }
        this.notify_("word,binary,keyword,(,or [");
        return false;
    }

    protected void initScanner() {
        this.buffer = new StringBuffer(32);
        this.saveComments = true;
        this.typeTable = JunSmallTypeTable.TypeTable();
    }

    protected void notify_(String string) {
        throw SmalltalkException.Error((String)string);
    }

    protected void offEnd_(String string) {
        this.notify_(string);
    }

    protected void scanLitKeywords() {
        boolean bl = true;
        while (bl && this.hereChar != '\u0000' && this.typeTable.at_(this.hereChar) == JunSmallCompiler.$((String)"xLetter")) {
            Object object = this.token;
            int n = this.source.position();
            char c = this.hereChar;
            this.xLetter();
            if (this.tokenType == JunSmallCompiler.$((String)"keyword")) {
                this.token = object.toString() + this.token;
                continue;
            }
            bl = false;
            this.token = object;
            this.hereChar = c;
            this.source.position_(n);
            this.tokenType = JunSmallCompiler.$((String)"keyword");
        }
        this.token = JunSmallCompiler.$((String)this.token.toString());
    }

    protected void scanLitToken() {
        if (this.tokenType == JunSmallCompiler.$((String)"leftParenthesis")) {
            this.scanToken();
            this.scanLitVec();
        } else if (this.tokenType == JunSmallCompiler.$((String)"word")) {
            this.token = JunSmallCompiler.$((String)this.token.toString());
        } else if (this.tokenType == JunSmallCompiler.$((String)"keyword")) {
            this.scanLitKeywords();
        } else if (this.token == JunSmallCompiler.$((String)"-") && this.hereChar != '\u0000' && this.typeTable.at_(this.hereChar) == JunSmallCompiler.$((String)"xDigit")) {
            this.scanToken();
            this.token = StNumber._Negate((Number)((Number)this.token));
        } else if (this.token instanceof Character && this.tokenType != JunSmallCompiler.$((String)"character")) {
            this.token = JunSmallCompiler.$((String)this.token.toString());
        }
    }

    protected void scanLitVec() {
        Vector<Object> vector = new Vector<Object>(16);
        while (this.tokenType != JunSmallCompiler.$((String)"rightParenthesis") && this.tokenType != JunSmallCompiler.$((String)"doIt")) {
            this.scanLitToken();
            vector.addElement(this.token);
            this.scanToken();
        }
        Object[] objectArray = new Object[vector.size()];
        vector.copyInto(objectArray);
        this.token = objectArray;
    }

    protected void scanToken() {
        if (this.hereChar == '\u0000') {
            this.prevEnd = this.source.position();
            this.mark = this.prevEnd + 1;
            this.tokenType = JunSmallCompiler.$((String)"doIt");
            this.token = null;
            return;
        }
        int n = 0;
        while ((this.tokenType = this.typeTable.at_(this.hereChar)) == JunSmallCompiler.$((String)"xDelimiter")) {
            ++n;
            this.hereChar = this.source.next();
            if (this.hereChar != '\u0000') continue;
            this.prevEnd = this.source.position();
            this.mark = this.prevEnd + 1;
            this.tokenType = JunSmallCompiler.$((String)"doIt");
            this.token = null;
            return;
        }
        this.mark = this.source.position();
        this.prevEnd = this.mark - n - 1;
        if (this.tokenType == JunSmallCompiler.$((String)"xLetter")) {
            this.xLetter();
        } else {
            String string = this.tokenType.toString();
            if (string.charAt(0) == 'x') {
                try {
                    this.perform_(string);
                }
                catch (Exception exception) {
                    throw new SmalltalkException(exception);
                }
            } else {
                this.token = new Character(this.hereChar);
                this.hereChar = this.source.next();
            }
        }
    }

    protected String separators() {
        StringBuffer stringBuffer = new StringBuffer(4);
        stringBuffer.append(' ');
        stringBuffer.append('\t');
        stringBuffer.append('\r');
        stringBuffer.append('\n');
        return stringBuffer.toString();
    }

    protected char step() {
        char c = this.hereChar;
        this.hereChar = this.source.next();
        return c;
    }

    protected boolean stringMatch_and_(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer(20);
        stringBuffer.append(string);
        stringBuffer.append('\u0000');
        StringBuffer stringBuffer2 = new StringBuffer(20);
        stringBuffer2.append(string);
        stringBuffer2.append('\u0000');
        return this.stringMatch_sIndex_and_pIndex_(stringBuffer.toString(), 0, stringBuffer2.toString(), 0);
    }

    protected boolean stringMatch_sIndex_and_pIndex_(String string, int n, String string2, int n2) {
        int n3 = n;
        int n4 = n2;
        int n5 = string.length();
        int n6 = string2.length();
        char c = n3 <= n5 ? string.charAt(n3) : (char)'\u0000';
        ++n3;
        char c2 = n4 <= n6 ? string2.charAt(n4) : (char)'\u0000';
        ++n4;
        if (c2 == '[') {
            boolean bl = false;
            char c3 = '\u00ff';
            while (n4 <= n6) {
                c2 = string2.charAt(n4);
                ++n4;
                if (c2 == '\u0000') break;
                if (c2 == ']') {
                    if (bl) {
                        return this.stringMatch_sIndex_and_pIndex_(string, n3, string2, n4);
                    }
                    return false;
                }
                if (c2 == '-') {
                    if (c3 <= c && c <= string2.charAt(n4)) {
                        bl = true;
                    }
                    ++n4;
                    continue;
                }
                c3 = c2;
                if (c != c2) continue;
                bl = true;
            }
            c2 = '\u0000';
        }
        if (c2 == '?') {
            if (c != '\u0000') {
                return this.stringMatch_sIndex_and_pIndex_(string, n3, string2, n4);
            }
            return false;
        }
        if (c2 == '*') {
            if (string2.charAt(n4) == '\u0000') {
                return true;
            }
            --n3;
            while (string.charAt(n3) != '\u0000') {
                if (this.stringMatch_sIndex_and_pIndex_(string, n3, string2, n4)) {
                    return true;
                }
                ++n3;
            }
            return false;
        }
        if (c2 == '\u0000') {
            return c == '\u0000';
        }
        if (c != c2) {
            return false;
        }
        if (c != '\u0000') {
            return this.stringMatch_sIndex_and_pIndex_(string, n3, string2, n4);
        }
        return false;
    }

    protected Object translate_(Object[] objectArray) {
        if (objectArray.length == 0) {
            return null;
        }
        if (objectArray.length == 1 && objectArray[0] instanceof Object[]) {
            return this.translate_((Object[])objectArray[0]);
        }
        if (objectArray.length == 1) {
            return objectArray[0];
        }
        Object object = objectArray[0];
        Object object2 = objectArray[1];
        if (object instanceof Number && (object2 == JunSmallCompiler.$((String)"@") || object2 == JunSmallCompiler.$((String)","))) {
            return this.translateToPoint_(objectArray);
        }
        if (object == JunSmallCompiler.$((String)"Text") && object2 == JunSmallCompiler.$((String)"string:")) {
            return this.translateToText_(objectArray);
        }
        if (object2 == JunSmallCompiler.$((String)"x:") && (object == JunSmallCompiler.$((String)"Point") || object == JunSmallCompiler.$((String)"Jun3dPoint") || object == JunSmallCompiler.$((String)"Jun2dPoint"))) {
            return this.translateToPoint_(objectArray);
        }
        if (object == JunSmallCompiler.$((String)"ByteArray") && object2 == JunSmallCompiler.$((String)"fromPackedString:")) {
            return this.translateToByteArray_(objectArray);
        }
        if (object == JunSmallCompiler.$((String)"Image") && object2 == JunSmallCompiler.$((String)"extent:")) {
            return this.translateToImage_(objectArray);
        }
        if (object == JunSmallCompiler.$((String)"ColorValue")) {
            return this.translateToColor_(objectArray);
        }
        return null;
    }

    protected byte[] translateToByteArray_(Object object) {
        if (object instanceof byte[]) {
            return (byte[])object;
        }
        Object[] objectArray = (Object[])object;
        Object object2 = objectArray[0];
        if (object2 != JunSmallCompiler.$((String)"ByteArray") && object2 != JunSmallCompiler.$((String)"fromPackedString:")) {
            throw SmalltalkException.Error((String)"unexpected error");
        }
        return StByteArray.FromPackedString_((String)((String)objectArray[2]))._asBytes();
    }

    protected Object translateToColor_(Object[] objectArray) {
        Object object = objectArray[0];
        if (object != JunSmallCompiler.$((String)"ColorValue") && objectArray.length >= 2) {
            this.notify_("unexpected error");
            return null;
        }
        Object object2 = objectArray[1];
        if (StColorValue.ConstantNames().contains(object2)) {
            return StColorValue._GetColorByName_((String)object2.toString());
        }
        if (object2 == JunSmallCompiler.$((String)"hue:")) {
            return new Color(Color.HSBtoRGB(((Number)objectArray[2]).floatValue(), ((Number)objectArray[4]).floatValue(), ((Number)objectArray[6]).floatValue()));
        }
        if (object2 == JunSmallCompiler.$((String)"red:")) {
            return new Color(((Number)objectArray[2]).floatValue(), ((Number)objectArray[4]).floatValue(), ((Number)objectArray[6]).floatValue());
        }
        if (object2 == JunSmallCompiler.$((String)"scaledRed:")) {
            return StColorValue.ScaledRed_ScaledGreen_ScaledBlue_((int)((Number)objectArray[2]).intValue(), (int)((Number)objectArray[4]).intValue(), (int)((Number)objectArray[6]).intValue());
        }
        if (object2 == JunSmallCompiler.$((String)"brightness:")) {
            return StColorValue.Brightness_((double)((Number)objectArray[2]).doubleValue());
        }
        this.notify_("unexpected error");
        return null;
    }

    protected StImage translateToImage_(Object[] objectArray) {
        byte[] byArray;
        ColorModel colorModel;
        int n;
        int n2;
        Object object = objectArray[0];
        if (object != JunSmallCompiler.$((String)"Image") && object != JunSmallCompiler.$((String)"OpaqueImage") && object != JunSmallCompiler.$((String)"CachedImage")) {
            throw SmalltalkException.Error((String)"unexpected error");
        }
        StImage stImage = null;
        if (object == JunSmallCompiler.$((String)"Image")) {
            n2 = ((Number)objectArray[2]).intValue();
            n = ((Number)objectArray[4]).intValue();
            int n3 = ((Number)objectArray[8]).intValue();
            Object object2 = objectArray[10];
            colorModel = null;
            byArray = null;
            if (object2 instanceof Object[]) {
                colorModel = this.translateToPalette_((Object[])objectArray[10], n3);
                byArray = this.translateToByteArray_(objectArray[12]);
            } else {
                colorModel = this.translateToPalette_(new Object[]{objectArray[10], objectArray[11]}, n3);
                byArray = this.translateToByteArray_(objectArray[13]);
            }
        } else {
            throw SmalltalkException.Error((String)("The image [" + object + "] is not supported yet."));
        }
        stImage = new StImage(n2, n, byArray, colorModel);
        return stImage;
    }

    protected ColorModel translateToPalette_(Object[] objectArray, int n) {
        Object object;
        int n2 = 0;
        if (objectArray[0] == JunSmallCompiler.$((String)"Graphics") && objectArray[1] == JunSmallCompiler.$((String)".")) {
            n2 += 2;
        }
        if ((object = objectArray[n2]) != JunSmallCompiler.$((String)"CoveragePalette") && object != JunSmallCompiler.$((String)"FixedPalette") && object != JunSmallCompiler.$((String)"MappedPalette") && object != JunSmallCompiler.$((String)"MonoMappedPalette")) {
            throw SmalltalkException.Error((String)"unepxected error");
        }
        ColorModel colorModel = null;
        if (object == JunSmallCompiler.$((String)"FixedPalette")) {
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            int n8 = 0;
            for (int i = n2 + 1; i < objectArray.length; i += 2) {
                Object object2 = objectArray[i];
                int n9 = ((Number)objectArray[i + 1]).intValue();
                if (object2 == JunSmallCompiler.$((String)"redShift:")) {
                    n3 = n9;
                    continue;
                }
                if (object2 == JunSmallCompiler.$((String)"redMask:")) {
                    n4 = n9;
                    continue;
                }
                if (object2 == JunSmallCompiler.$((String)"greenShift:")) {
                    n5 = n9;
                    continue;
                }
                if (object2 == JunSmallCompiler.$((String)"greenMask:")) {
                    n6 = n9;
                    continue;
                }
                if (object2 == JunSmallCompiler.$((String)"blueShift:")) {
                    n7 = n9;
                    continue;
                }
                if (object2 != JunSmallCompiler.$((String)"blueMask:")) continue;
                n8 = n9;
            }
            colorModel = n == 32 ? new DirectColorModel(n, n4 << n3, n6 << n5, n8 << n7, -16777216) : new DirectColorModel(n, n4 << n3, n6 << n5, n8 << n7);
        } else if (object == JunSmallCompiler.$((String)"MappedPalette") || object == JunSmallCompiler.$((String)"MonoMappedPalette")) {
            int n10 = 0;
            byte[] byArray = null;
            byte[] byArray2 = null;
            byte[] byArray3 = null;
            byte[] byArray4 = null;
            StSymbol stSymbol = (StSymbol)objectArray[1];
            if (stSymbol == JunSmallCompiler.$((String)"blackWhite")) {
                n10 = 2;
                byArray3 = new byte[]{0, -1};
                byArray2 = byArray3;
                byArray = byArray3;
            } else if (stSymbol == JunSmallCompiler.$((String)"whiteBlack")) {
                n10 = 2;
                byArray3 = new byte[]{-1, 0};
                byArray2 = byArray3;
                byArray = byArray3;
            } else {
                throw SmalltalkException.Error((String)("The palette [" + object + "] in general form is not supported yet."));
            }
            colorModel = new IndexColorModel(n, n10, byArray, byArray2, byArray3, byArray4);
        } else {
            throw SmalltalkException.Error((String)("The palette [" + object + "] is not supported yet."));
        }
        return colorModel;
    }

    protected Object translateToPoint_(Object[] objectArray) {
        Object object = objectArray[0];
        if (object instanceof Number) {
            if (objectArray.length == 3) {
                return new Jun2dPoint(((Number)objectArray[0]).doubleValue(), ((Number)objectArray[2]).doubleValue());
            }
            if (objectArray.length == 5) {
                return new Jun3dPoint(((Number)objectArray[0]).doubleValue(), ((Number)objectArray[2]).doubleValue(), ((Number)objectArray[4]).doubleValue());
            }
            if (objectArray.length == 7) {
                return new Rectangle(((Number)objectArray[0]).intValue(), ((Number)objectArray[2]).intValue(), ((Number)objectArray[4]).intValue(), ((Number)objectArray[6]).intValue());
            }
            this.notify_("unexpected error");
            return null;
        }
        if (object == JunSmallCompiler.$((String)"Point") || object == JunSmallCompiler.$((String)"Jun2dPoint")) {
            return new Jun2dPoint(((Number)objectArray[2]).doubleValue(), ((Number)objectArray[4]).doubleValue());
        }
        if (object == JunSmallCompiler.$((String)"Jun3dPoint")) {
            return new Jun3dPoint(((Number)objectArray[2]).doubleValue(), ((Number)objectArray[4]).doubleValue(), ((Number)objectArray[6]).doubleValue());
        }
        this.notify_("unexpected error");
        return null;
    }

    protected Object translateToText_(Object[] objectArray) {
        Object object = objectArray[0];
        Object object2 = objectArray[1];
        Object object3 = objectArray[3];
        if (object != JunSmallCompiler.$((String)"Text") || object2 != JunSmallCompiler.$((String)"string:") || object3 != JunSmallCompiler.$((String)"runs:") || objectArray.length != 5) {
            throw SmalltalkException.Error((String)"unexpected error");
        }
        return (String)objectArray[2];
    }
}

