/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.opengl.roughsketch;

import java.awt.BasicStroke;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.goodies.cursors.JunCursors;
import jp.co.sra.jun.opengl.display.JunOpenGLDisplayController;
import jp.co.sra.jun.opengl.roughsketch.JunOpenGLRoughSketch;

public class JunOpenGLRoughSketchController
extends JunOpenGLDisplayController {
    protected ArrayList points;

    public JunOpenGLRoughSketch getRoughSketch() {
        return (JunOpenGLRoughSketch)this.model();
    }

    public Point[] getPoints() {
        return this.points().toArray(new Point[this.points().size()]);
    }

    public void addPoint(Point point) {
        Point point2;
        if (this.points().size() > 0 && JunOpenGLRoughSketchController.Distance(point2 = (Point)this.points().get(this.points().size() - 1), point) <= 4.0) {
            return;
        }
        this.points().add(point);
        this.drawPolyline();
    }

    protected ArrayList points() {
        if (this.points == null) {
            this.points = new ArrayList();
        }
        return this.points;
    }

    protected void flushPoints() {
        this.points = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drawPolyline() {
        Graphics2D graphics2D = null;
        try {
            graphics2D = (Graphics2D)this.getOpenGLDrawable().toComponent().getGraphics();
            graphics2D.setColor(JunOpenGLRoughSketch.NibColor);
            graphics2D.setStroke(new BasicStroke(1.0f));
            Point[] pointArray = this.getPoints();
            for (int i = 1; i < pointArray.length; ++i) {
                graphics2D.drawLine(pointArray[i - 1].x, pointArray[i - 1].y, pointArray[i].x, pointArray[i].y);
            }
        }
        finally {
            if (graphics2D != null) {
                graphics2D.dispose();
            }
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.getRoughSketch().buttonState() != JunOpenGLRoughSketchController.$((String)"pencil")) {
            super.mousePressed(mouseEvent);
            return;
        }
        this.flushPoints();
        this.addPoint(mouseEvent.getPoint());
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.getRoughSketch().buttonState() != JunOpenGLRoughSketchController.$((String)"pencil")) {
            super.mouseReleased(mouseEvent);
            return;
        }
        Point[] pointArray = this.getPoints();
        Dimension dimension = this.getOpenGLDrawable().toComponent().getSize();
        if (JunOpenGLRoughSketchController.Distance(pointArray[0], pointArray[pointArray.length - 1]) > (double)(Math.max(dimension.width, dimension.height) / 2)) {
            this.getRoughSketch().pencilOpenedPoints(pointArray, this);
        } else {
            this.getRoughSketch().pencilClosedPoints(pointArray, this);
        }
        this.flushPoints();
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.getRoughSketch().buttonState() != JunOpenGLRoughSketchController.$((String)"pencil")) {
            super.mouseDragged(mouseEvent);
            return;
        }
        this.addPoint(mouseEvent.getPoint());
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        super.mouseEntered(mouseEvent);
        if (this.getRoughSketch().buttonState() == JunOpenGLRoughSketchController.$((String)"pencil")) {
            this.getOpenGLDrawable().toComponent().setCursor(JunCursors.PencilCursor());
        }
    }

    protected Jun2dPoint regularizePoint_(Point point) {
        return super.regularizePoint_(point);
    }

    protected static double Distance(Point point, Point point2) {
        int n = point.x - point2.x;
        int n2 = point.y - point2.y;
        return Math.sqrt(n * n + n2 * n2);
    }
}

